/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.stats.annotation;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Date;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.Timestamp;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.AbstractMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.CommonJoinOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewJoinOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.UDTFOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.signature.OpTreeSignature;
import org.apache.hadoop.hive.ql.optimizer.stats.annotation.AnnotateStatsProcCtx;
import org.apache.hadoop.hive.ql.parse.ColumnStatsList;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ColStatistics;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicListDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDynamicValueDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.Statistics;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.mapper.PlanMapper;
import org.apache.hadoop.hive.ql.plan.mapper.StatsSource;
import org.apache.hadoop.hive.ql.stats.OperatorStats;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCount;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMax;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMin;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFSum;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBetween;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIn;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInBloomFilter;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPAnd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNot;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotEqual;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPOr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFStruct;
import org.apache.hadoop.hive.serde2.io.DateWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsRulesProcFactory {
    private static final Logger LOG = LoggerFactory.getLogger((String)StatsRulesProcFactory.class.getName());

    public static SemanticNodeProcessor getTableScanRule() {
        return new TableScanStatsRule();
    }

    public static SemanticNodeProcessor getSelectRule() {
        return new SelectStatsRule();
    }

    public static SemanticNodeProcessor getFilterRule() {
        return new FilterStatsRule();
    }

    public static SemanticNodeProcessor getGroupByRule() {
        return new GroupByStatsRule();
    }

    public static SemanticNodeProcessor getJoinRule() {
        return new JoinStatsRule();
    }

    public static SemanticNodeProcessor getLimitRule() {
        return new LimitStatsRule();
    }

    public static SemanticNodeProcessor getReduceSinkRule() {
        return new ReduceSinkStatsRule();
    }

    public static SemanticNodeProcessor getUDTFRule() {
        return new UDTFStatsRule();
    }

    public static SemanticNodeProcessor getLateralViewJoinRule() {
        return new LateralViewJoinStatsRule();
    }

    public static SemanticNodeProcessor getDefaultRule() {
        return new DefaultStatsRule();
    }

    static boolean satisfyPrecondition(Statistics stats) {
        return stats != null && stats.getBasicStatsState().equals((Object)Statistics.State.COMPLETE) && !stats.getColumnStatsState().equals((Object)Statistics.State.NONE);
    }

    private static boolean isAllParentsContainStatistics(Operator<? extends OperatorDesc> op) {
        for (Operator<OperatorDesc> parent : op.getParentOperators()) {
            if (parent.getStatistics() != null) continue;
            return false;
        }
        return true;
    }

    private static Statistics applyRuntimeStats(Context context, Statistics stats, Operator<?> op) {
        if (!((HiveConf)context.getConf()).getBoolVar(HiveConf.ConfVars.HIVE_QUERY_REEXECUTION_ENABLED)) {
            return stats;
        }
        PlanMapper pm = context.getPlanMapper();
        OpTreeSignature treeSig = pm.getSignatureOf(op);
        pm.link(op, treeSig);
        StatsSource statsSource = context.getStatsSource();
        if (!statsSource.canProvideStatsFor(op.getClass())) {
            return stats;
        }
        Optional<OperatorStats> os = statsSource.lookup(treeSig);
        if (!os.isPresent()) {
            return stats;
        }
        LOG.debug("using runtime stats for {}; {}", op, (Object)os.get());
        Statistics outStats = stats.clone();
        outStats = outStats.scaleToRowCount(os.get().getOutputRecords(), false);
        outStats.setRuntimeStats(true);
        return outStats;
    }

    public static class DefaultStatsRule
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Statistics stats;
            Operator op = (Operator)nd;
            Object conf = op.getConf();
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            HiveConf hconf = aspCtx.getConf();
            if (conf != null && (stats = conf.getStatistics()) == null && op.getParentOperators() != null && StatsRulesProcFactory.isAllParentsContainStatistics(op)) {
                for (Operator<OperatorDesc> parent : op.getParentOperators()) {
                    Statistics parentStats = parent.getStatistics();
                    if (stats == null) {
                        stats = parentStats.clone();
                    } else {
                        stats.addBasicStats(parentStats);
                    }
                    stats.updateColumnStatsState(parentStats.getColumnStatsState());
                    List<ColStatistics> colStats = StatsUtils.getColStatisticsFromExprMap(hconf, parentStats, op.getColumnExprMap(), op.getSchema());
                    stats.addToColumnStats(colStats);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug("[0] STATS-" + op.toString() + ": " + stats.extendedToString());
                }
                stats = StatsRulesProcFactory.applyRuntimeStats(aspCtx.getParseContext().getContext(), stats, op);
                op.getConf().setStatistics(stats);
            }
            return null;
        }
    }

    public static class LateralViewJoinStatsRule
    extends DefaultStatsRule
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LateralViewJoinOperator lop = (LateralViewJoinOperator)nd;
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            HiveConf conf = aspCtx.getConf();
            if (!StatsRulesProcFactory.isAllParentsContainStatistics(lop)) {
                return null;
            }
            List<Operator<OperatorDesc>> parents = lop.getParentOperators();
            if (parents.size() != 2) {
                LOG.warn("LateralViewJoinOperator should have just two parents but actually has " + parents.size() + " parents.");
                return null;
            }
            Statistics selectStats = parents.get(0).getStatistics();
            Statistics udtfStats = parents.get(1).getStatistics();
            long udtfNumRows = Math.max(udtfStats.getNumRows(), 1L);
            double factor = (double)udtfNumRows / (double)Math.max(selectStats.getNumRows(), 1L);
            long selectDataSize = StatsUtils.safeMult(selectStats.getDataSize(), factor);
            long dataSize = StatsUtils.safeAdd(selectDataSize, udtfStats.getDataSize());
            Statistics joinedStats = new Statistics(udtfNumRows, dataSize, 0L, 0L);
            if (StatsRulesProcFactory.satisfyPrecondition(selectStats) && StatsRulesProcFactory.satisfyPrecondition(udtfStats)) {
                Map<String, ExprNodeDesc> columnExprMap = lop.getColumnExprMap();
                RowSchema schema = lop.getSchema();
                joinedStats.updateColumnStatsState(selectStats.getColumnStatsState());
                List<ColStatistics> selectColStats = StatsUtils.getColStatisticsFromExprMap(conf, selectStats, columnExprMap, schema);
                StatsUtils.scaleColStatistics(selectColStats, factor);
                joinedStats.addToColumnStats(selectColStats);
                joinedStats.updateColumnStatsState(udtfStats.getColumnStatsState());
                List<ColStatistics> udtfColStats = StatsUtils.getColStatisticsFromExprMap(conf, udtfStats, columnExprMap, schema);
                joinedStats.addToColumnStats(udtfColStats);
            }
            joinedStats = StatsRulesProcFactory.applyRuntimeStats(aspCtx.getParseContext().getContext(), joinedStats, lop);
            lop.setStatistics(joinedStats);
            if (LOG.isDebugEnabled()) {
                LOG.debug("[0] STATS-" + lop.toString() + ": " + joinedStats.extendedToString());
            }
            return null;
        }
    }

    public static class UDTFStatsRule
    extends DefaultStatsRule
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            UDTFOperator uop = (UDTFOperator)nd;
            Operator<OperatorDesc> parent = uop.getParentOperators().get(0);
            Statistics parentStats = parent.getStatistics();
            if (parentStats != null) {
                Statistics st = parentStats.clone();
                float udtfFactor = HiveConf.getFloatVar((Configuration)aspCtx.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_UDTF_FACTOR);
                long numRows = (long)((float)parentStats.getNumRows() * udtfFactor);
                long dataSize = StatsUtils.safeMult(parentStats.getDataSize(), (double)udtfFactor);
                st.setNumRows(numRows);
                st.setDataSize(dataSize);
                List<ColStatistics> colStatsList = st.getColumnStats();
                if (colStatsList != null) {
                    for (ColStatistics colStats : colStatsList) {
                        colStats.setNumFalses((long)((float)colStats.getNumFalses() * udtfFactor));
                        colStats.setNumTrues((long)((float)colStats.getNumTrues() * udtfFactor));
                        colStats.setNumNulls((long)((float)colStats.getNumNulls() * udtfFactor));
                    }
                    st.setColumnStats(colStatsList);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[0] STATS-" + uop.toString() + ": " + st.extendedToString());
                }
                uop.setStatistics(st);
            }
            return null;
        }
    }

    public static class ReduceSinkStatsRule
    extends DefaultStatsRule
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ReduceSinkOperator rop = (ReduceSinkOperator)nd;
            Operator<OperatorDesc> parent = rop.getParentOperators().get(0);
            Statistics parentStats = parent.getStatistics();
            if (parentStats != null) {
                AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
                HiveConf conf = aspCtx.getConf();
                List<String> outKeyColNames = ((ReduceSinkDesc)rop.getConf()).getOutputKeyColumnNames();
                List<String> outValueColNames = ((ReduceSinkDesc)rop.getConf()).getOutputValueColumnNames();
                Map<String, ExprNodeDesc> colExprMap = rop.getColumnExprMap();
                Statistics outStats = parentStats.clone();
                if (StatsRulesProcFactory.satisfyPrecondition(parentStats)) {
                    ColStatistics cs;
                    ExprNodeDesc end;
                    ArrayList colStats = Lists.newArrayList();
                    for (String key : outKeyColNames) {
                        String prefixedKey = Utilities.ReduceField.KEY.toString() + "." + key;
                        end = colExprMap.get(prefixedKey);
                        if (end == null || (cs = StatsUtils.getColStatisticsFromExpression(conf, parentStats, end)) == null) continue;
                        cs.setColumnName(prefixedKey);
                        colStats.add(cs);
                    }
                    for (String val : outValueColNames) {
                        String prefixedVal = Utilities.ReduceField.VALUE.toString() + "." + val;
                        end = colExprMap.get(prefixedVal);
                        if (end == null || (cs = StatsUtils.getColStatisticsFromExpression(conf, parentStats, end)) == null) continue;
                        cs.setColumnName(prefixedVal);
                        colStats.add(cs);
                    }
                    outStats.setColumnStats(colStats);
                }
                outStats = StatsRulesProcFactory.applyRuntimeStats(aspCtx.getParseContext().getContext(), outStats, rop);
                rop.setStatistics(outStats);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[0] STATS-" + rop.toString() + ": " + outStats.extendedToString());
                }
            }
            return null;
        }
    }

    public static class LimitStatsRule
    extends DefaultStatsRule
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            LimitOperator lop = (LimitOperator)nd;
            Operator<OperatorDesc> parent = lop.getParentOperators().get(0);
            Statistics parentStats = parent.getStatistics();
            long limit = -1L;
            limit = ((LimitDesc)lop.getConf()).getLimit();
            if (StatsRulesProcFactory.satisfyPrecondition(parentStats)) {
                Statistics stats = parentStats.clone();
                List<ColStatistics> colStats = StatsUtils.getColStatisticsUpdatingTableAlias(parentStats, lop.getSchema());
                stats.setColumnStats(colStats);
                if (limit <= parentStats.getNumRows()) {
                    StatsUtils.updateStats(stats, limit, true, lop);
                }
                stats = StatsRulesProcFactory.applyRuntimeStats(aspCtx.getParseContext().getContext(), stats, lop);
                lop.setStatistics(stats);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[0] STATS-" + lop.toString() + ": " + stats.extendedToString());
                }
            } else if (parentStats != null) {
                limit = StatsUtils.getMaxIfOverflow(limit);
                Statistics wcStats = parentStats.scaleToRowCount(limit, true);
                wcStats = StatsRulesProcFactory.applyRuntimeStats(aspCtx.getParseContext().getContext(), wcStats, lop);
                lop.setStatistics(wcStats);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[1] STATS-" + lop.toString() + ": " + wcStats.extendedToString());
                }
            }
            return null;
        }
    }

    public static class JoinStatsRule
    extends FilterStatsRule
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            long newNumRows = 0L;
            CommonJoinOperator jop = (CommonJoinOperator)nd;
            List<Operator<? extends OperatorDesc>> parents = jop.getParentOperators();
            int numAttr = 1;
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            HiveConf conf = aspCtx.getConf();
            boolean allSatisfyPreCondition = true;
            if (!StatsRulesProcFactory.isAllParentsContainStatistics(jop)) {
                return null;
            }
            for (Operator<OperatorDesc> operator : parents) {
                if (StatsRulesProcFactory.satisfyPrecondition(operator.getStatistics())) continue;
                allSatisfyPreCondition = false;
                break;
            }
            if (allSatisfyPreCondition) {
                for (int pos = 0; pos < parents.size(); ++pos) {
                    if (jop.getParentOperators().get(pos) instanceof ReduceSinkOperator) continue;
                    allSatisfyPreCondition = false;
                    break;
                }
            }
            if (allSatisfyPreCondition) {
                ExprNodeDesc pred;
                long joinRowCount;
                int pos;
                Statistics stats = new Statistics();
                int n = parents.size();
                HashMap rowCountParents = Maps.newHashMap();
                HashMap joinStats = Maps.newHashMap();
                HashMap joinKeys = Maps.newHashMap();
                ArrayList rowCounts = Lists.newArrayList();
                ReduceSinkOperator rsOp = (ReduceSinkOperator)jop.getParentOperators().get(0);
                List<String> keyExprs = StatsUtils.getQualifedReducerKeyNames(((ReduceSinkDesc)rsOp.getConf()).getOutputKeyColumnNames());
                numAttr = keyExprs.size();
                long inferredRowCount = this.inferPKFKRelationship(numAttr, parents, jop);
                for (pos = 0; pos < parents.size(); ++pos) {
                    ReduceSinkOperator parent = (ReduceSinkOperator)jop.getParentOperators().get(pos);
                    Statistics statistics = parent.getStatistics().clone();
                    keyExprs = StatsUtils.getQualifedReducerKeyNames(((ReduceSinkDesc)parent.getConf()).getOutputKeyColumnNames());
                    rowCountParents.put(pos, statistics.getNumRows());
                    rowCounts.add(statistics.getNumRows());
                    joinKeys.put(pos, keyExprs);
                    joinStats.put(pos, statistics);
                    stats.updateColumnStatsState(statistics.getColumnStatsState());
                }
                if (numAttr == 0) {
                    inferredRowCount = 1L;
                    for (pos = 0; pos < parents.size(); ++pos) {
                        inferredRowCount = StatsUtils.safeMult(((Statistics)joinStats.get(pos)).getNumRows(), inferredRowCount);
                    }
                }
                ArrayList distinctVals = Lists.newArrayList();
                ArrayList ndvsUnmatched = Lists.newArrayList();
                long l = 1L;
                long distinctUnmatched = 1L;
                if (inferredRowCount == -1L) {
                    ArrayList perAttrDVs = Lists.newArrayList();
                    for (int idx = 0; idx < numAttr; ++idx) {
                        for (Object i : joinKeys.keySet()) {
                            String col = (String)((List)joinKeys.get(i)).get(idx);
                            ColStatistics cs = ((Statistics)joinStats.get(i)).getColumnStatisticsFromColName(col);
                            if (cs == null) continue;
                            perAttrDVs.add(cs.getCountDistint());
                        }
                        distinctVals.add(this.getDenominator(perAttrDVs));
                        ndvsUnmatched.add(this.getDenominatorForUnmatchedRows(perAttrDVs));
                        perAttrDVs.clear();
                    }
                    if (numAttr > 1 && conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_CORRELATED_MULTI_KEY_JOINS)) {
                        l = (Long)Collections.max(distinctVals);
                        distinctUnmatched = l - (Long)ndvsUnmatched.get(distinctVals.indexOf(l));
                    } else {
                        l = StatsUtils.addWithExpDecay(distinctVals);
                        distinctUnmatched = l - StatsUtils.addWithExpDecay(ndvsUnmatched);
                    }
                }
                this.updateJoinColumnsNDV(joinKeys, joinStats, numAttr);
                Map<String, ExprNodeDesc> colExprMap = jop.getColumnExprMap();
                RowSchema rs = jop.getSchema();
                ArrayList outColStats = Lists.newArrayList();
                for (ColumnInfo ci : rs.getSignature()) {
                    String key = ci.getInternalName();
                    ExprNodeDesc end = colExprMap.get(key);
                    if (!(end instanceof ExprNodeColumnDesc)) continue;
                    aspCtx.addAffectedColumn((ExprNodeColumnDesc)end);
                    String colName = ((ExprNodeColumnDesc)end).getColumn();
                    byte pos2 = ((JoinDesc)jop.getConf()).getReversedExprs().get(key);
                    ColStatistics cs = ((Statistics)joinStats.get(pos2)).getColumnStatisticsFromColName(colName);
                    String outColName = key;
                    if (cs != null) {
                        cs.setColumnName(outColName);
                    }
                    outColStats.add(cs);
                }
                stats.setColumnStats(outColStats);
                long leftUnmatchedRows = 0L;
                long rightUnmatchedRows = 0L;
                if (inferredRowCount != -1L) {
                    joinRowCount = inferredRowCount;
                } else {
                    long innerJoinRowCount = this.computeRowCountAssumingInnerJoin(rowCounts, l, jop);
                    if (((JoinDesc)jop.getConf()).getConds().length == 1) {
                        JoinCondDesc joinCond = ((JoinDesc)jop.getConf()).getConds()[0];
                        if (joinCond.getType() == 1) {
                            leftUnmatchedRows = this.calculateUnmatchedRowsForOuter(conf, (Long)rowCountParents.get(0), (List)joinKeys.get(0), (Statistics)joinStats.get(0), distinctUnmatched);
                        } else if (joinCond.getType() == 2) {
                            rightUnmatchedRows = this.calculateUnmatchedRowsForOuter(conf, (Long)rowCountParents.get(1), (List)joinKeys.get(1), (Statistics)joinStats.get(1), distinctUnmatched);
                        } else if (joinCond.getType() == 3) {
                            leftUnmatchedRows = this.calculateUnmatchedRowsForOuter(conf, (Long)rowCountParents.get(0), (List)joinKeys.get(0), (Statistics)joinStats.get(0), distinctUnmatched);
                            rightUnmatchedRows = this.calculateUnmatchedRowsForOuter(conf, (Long)rowCountParents.get(1), (List)joinKeys.get(1), (Statistics)joinStats.get(1), distinctUnmatched);
                        }
                    }
                    joinRowCount = this.computeFinalRowCount(rowCounts, StatsUtils.safeAdd(innerJoinRowCount, StatsUtils.safeAdd(leftUnmatchedRows, rightUnmatchedRows)), jop);
                }
                this.updateColStats(conf, stats, leftUnmatchedRows, rightUnmatchedRows, joinRowCount, jop, rowCountParents);
                if (joinRowCount != -1L && ((JoinDesc)jop.getConf()).getNoOuterJoin() && ((JoinDesc)jop.getConf()).getResidualFilterExprs() != null && !((JoinDesc)jop.getConf()).getResidualFilterExprs().isEmpty() && (newNumRows = this.evaluateExpression(stats, pred = ((JoinDesc)jop.getConf()).getResidualFilterExprs().size() > 1 ? new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getGenericUDFForAnd(), ((JoinDesc)jop.getConf()).getResidualFilterExprs()) : ((JoinDesc)jop.getConf()).getResidualFilterExprs().get(0), aspCtx, jop.getSchema().getColumnNames(), jop, stats.getNumRows())) <= joinRowCount) {
                    StatsUtils.updateStats(stats, newNumRows, true, jop);
                }
                stats = StatsRulesProcFactory.applyRuntimeStats(aspCtx.getParseContext().getContext(), stats, jop);
                jop.setStatistics(stats);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[0] STATS-" + jop.toString() + ": " + stats.extendedToString());
                }
            } else {
                long newDataSize;
                List<Object> keyExprs;
                float joinFactor = HiveConf.getFloatVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_JOIN_FACTOR);
                int n = parents.size();
                long crossRowCount = 1L;
                long crossDataSize = 1L;
                long maxRowCount = 0L;
                long maxDataSize = 0L;
                Statistics.State statsState = Statistics.State.NONE;
                for (Operator<OperatorDesc> operator : parents) {
                    Statistics ps = operator.getStatistics();
                    statsState = Statistics.inferColumnStatsState(statsState, ps.getBasicStatsState());
                    long rowCount = ps.getNumRows();
                    long dataSize = ps.getDataSize();
                    long newCrossRowCount = StatsUtils.safeMult(crossRowCount, rowCount);
                    long newCrossDataSize = StatsUtils.safeAdd(StatsUtils.safeMult(crossDataSize, rowCount), StatsUtils.safeMult(dataSize, crossRowCount));
                    crossRowCount = newCrossRowCount;
                    crossDataSize = newCrossDataSize;
                    if (rowCount <= maxRowCount) continue;
                    maxRowCount = rowCount;
                    maxDataSize = dataSize;
                }
                boolean cartesianProduct = false;
                if (jop.getParentOperators().get(0) instanceof ReduceSinkOperator) {
                    ReduceSinkOperator rsOp = (ReduceSinkOperator)jop.getParentOperators().get(0);
                    keyExprs = StatsUtils.getQualifedReducerKeyNames(((ReduceSinkDesc)rsOp.getConf()).getOutputKeyColumnNames());
                    cartesianProduct = keyExprs.size() == 0;
                } else if (jop instanceof AbstractMapJoinOperator) {
                    AbstractMapJoinOperator mjop = (AbstractMapJoinOperator)jop;
                    keyExprs = ((MapJoinDesc)mjop.getConf()).getKeys().values().iterator().next();
                    boolean bl = cartesianProduct = keyExprs.size() == 0;
                }
                if (cartesianProduct) {
                    newNumRows = crossRowCount;
                    newDataSize = crossDataSize;
                } else if (n > 1) {
                    newNumRows = StatsUtils.safeMult(StatsUtils.safeMult(maxRowCount, n - 1), (double)joinFactor);
                    newDataSize = StatsUtils.safeMult(StatsUtils.safeMult(maxDataSize, n - 1), (double)joinFactor);
                } else {
                    newNumRows = StatsUtils.safeMult(maxRowCount, (double)joinFactor);
                    newDataSize = StatsUtils.safeMult(maxDataSize, (double)joinFactor);
                }
                Statistics wcStats = new Statistics(newNumRows, newDataSize, 0L, 0L);
                wcStats.setBasicStatsState(statsState);
                if (((JoinDesc)jop.getConf()).getNoOuterJoin() && ((JoinDesc)jop.getConf()).getResidualFilterExprs() != null && !((JoinDesc)jop.getConf()).getResidualFilterExprs().isEmpty()) {
                    long joinRowCount = newNumRows;
                    ExprNodeDesc pred = ((JoinDesc)jop.getConf()).getResidualFilterExprs().size() > 1 ? new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, FunctionRegistry.getGenericUDFForAnd(), ((JoinDesc)jop.getConf()).getResidualFilterExprs()) : ((JoinDesc)jop.getConf()).getResidualFilterExprs().get(0);
                    newNumRows = this.evaluateExpression(wcStats, pred, aspCtx, jop.getSchema().getColumnNames(), jop, wcStats.getNumRows());
                    if (newNumRows <= joinRowCount) {
                        StatsUtils.updateStats(wcStats, newNumRows, false, jop);
                    }
                }
                wcStats = StatsRulesProcFactory.applyRuntimeStats(aspCtx.getParseContext().getContext(), wcStats, jop);
                jop.setStatistics(wcStats);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[1] STATS-" + jop.toString() + ": " + wcStats.extendedToString());
                }
            }
            return null;
        }

        private long calculateUnmatchedRowsForOuter(HiveConf conf, long inputRowCount, List<String> joinKeys, Statistics statistics, long distinctUnmatched) {
            ArrayList<Long> distinctVals = new ArrayList<Long>();
            for (String col : joinKeys) {
                ColStatistics cs = statistics.getColumnStatisticsFromColName(col);
                if (cs == null) continue;
                distinctVals.add(cs.getCountDistint());
            }
            long distinctVal = distinctVals.isEmpty() ? 2L : (joinKeys.size() > 1 && conf.getBoolVar(HiveConf.ConfVars.HIVE_STATS_CORRELATED_MULTI_KEY_JOINS) ? Collections.max(distinctVals).longValue() : StatsUtils.addWithExpDecay(distinctVals).longValue());
            if (distinctUnmatched >= distinctVal) {
                return inputRowCount;
            }
            return StatsUtils.safeMult(inputRowCount / distinctVal, distinctUnmatched);
        }

        private long inferPKFKRelationship(int numAttr, List<Operator<? extends OperatorDesc>> parents, CommonJoinOperator<? extends JoinDesc> jop) {
            long newNumRows = -1L;
            if (numAttr != 1) {
                return newNumRows;
            }
            Map<Integer, ColStatistics> parentsWithPK = this.getPrimaryKeyCandidates(parents);
            if (parentsWithPK.size() != 1) {
                LOG.debug("STATS-" + jop.toString() + ": detects none/multiple PK parents.");
                return newNumRows;
            }
            Integer pkPos = parentsWithPK.keySet().iterator().next();
            ColStatistics csPK = parentsWithPK.values().iterator().next();
            Map<Integer, ColStatistics> csFKs = this.getForeignKeyCandidates(parents, csPK);
            if (csFKs.size() + 1 == parents.size()) {
                newNumRows = this.getCardinality(parents, pkPos, csPK, csFKs, jop);
                if (LOG.isDebugEnabled()) {
                    ArrayList parentIds = Lists.newArrayList();
                    for (Integer i : parentsWithPK.keySet()) {
                        parentIds.add(parents.get(i).toString());
                    }
                    LOG.debug("STATS-" + jop.toString() + ": PK parent id(s) - " + parentIds);
                    parentIds.clear();
                    for (Integer i : csFKs.keySet()) {
                        parentIds.add(parents.get(i).toString());
                    }
                    LOG.debug("STATS-" + jop.toString() + ": FK parent id(s) - " + parentIds);
                }
            }
            return newNumRows;
        }

        private long getCardinality(List<Operator<? extends OperatorDesc>> ops, Integer pkPos, ColStatistics csPK, Map<Integer, ColStatistics> csFKs, CommonJoinOperator<? extends JoinDesc> jop) {
            long newNumRows;
            double pkfkSelectivity = Double.MAX_VALUE;
            int fkInd = -1;
            boolean isFKIndependentFromPK = false;
            for (Map.Entry<Integer, ColStatistics> entry : csFKs.entrySet()) {
                boolean independent;
                int pos = entry.getKey();
                Operator<? extends OperatorDesc> opWithPK = ops.get(pkPos);
                Operator<OperatorDesc> opWithFK = jop.getParentOperators().get(pos);
                double selectivity = this.getSelectivitySimpleTree(opWithPK);
                double selectivityAdjustment = StatsUtils.getScaledSelectivity(csPK, entry.getValue());
                selectivity = selectivityAdjustment * selectivity > 1.0 ? selectivity : selectivityAdjustment * selectivity;
                boolean bl = independent = !entry.getValue().isFilteredColumn() && OperatorUtils.treesWithIndependentInputs(opWithFK, opWithPK);
                if (fkInd >= 0 && (!independent || !(selectivity < pkfkSelectivity))) continue;
                pkfkSelectivity = selectivity;
                fkInd = pos;
                isFKIndependentFromPK = independent;
            }
            long newrows = 1L;
            ArrayList rowCounts = Lists.newArrayList();
            ArrayList distinctVals = Lists.newArrayList();
            for (Map.Entry<Integer, ColStatistics> entry : csFKs.entrySet()) {
                int pos = entry.getKey();
                ColStatistics csFK = entry.getValue();
                ReduceSinkOperator parent = (ReduceSinkOperator)jop.getParentOperators().get(pos);
                Statistics parentStats = parent.getStatistics();
                if (fkInd == pos) {
                    newrows = !isFKIndependentFromPK ? parentStats.getNumRows() : (long)Math.ceil((double)parentStats.getNumRows() * pkfkSelectivity);
                    rowCounts.add(newrows);
                    distinctVals.add(Math.min(csFK.getCountDistint(), csPK.getCountDistint()));
                    continue;
                }
                rowCounts.add(parentStats.getNumRows());
                distinctVals.add(csFK.getCountDistint());
            }
            if (csFKs.size() == 1) {
                newNumRows = newrows;
            } else {
                newNumRows = this.computeRowCountAssumingInnerJoin(rowCounts, this.getDenominator(distinctVals), jop);
                newNumRows = this.computeFinalRowCount(rowCounts, newNumRows, jop);
            }
            return newNumRows;
        }

        private float getSelectivitySimpleTree(Operator<? extends OperatorDesc> op) {
            TableScanOperator tsOp = OperatorUtils.findSingleOperatorUpstream(op, TableScanOperator.class);
            if (tsOp == null) {
                return this.getSelectivityComplexTree(op);
            }
            long inputRow = tsOp.getStatistics().getNumRows();
            long outputRow = op.getStatistics().getNumRows();
            return (float)outputRow / (float)inputRow;
        }

        private float getSelectivityComplexTree(Operator<? extends OperatorDesc> op) {
            Object jop;
            Operator<? extends OperatorDesc> multiParentOp = null;
            Operator<? extends OperatorDesc> currentOp = op;
            while (multiParentOp == null) {
                if (op.getParentOperators().size() > 1) {
                    multiParentOp = op;
                    continue;
                }
                op = op.getParentOperators().get(0);
            }
            float selMultiParent = 1.0f;
            boolean isSelComputed = false;
            if (multiParentOp instanceof JoinOperator && ((JoinDesc)((Operator)(jop = (JoinOperator)multiParentOp)).getConf()).getConds().length == 1) {
                float selMultiParentRight;
                float selMultiParentLeft;
                isSelComputed = true;
                int n = ((JoinDesc)((Operator)jop).getConf()).getCondsList().get(0).getType();
                if (((JoinDesc)((Operator)jop).getConf()).getJoinKeys()[0].length == 0 || n == 3) {
                    selMultiParentLeft = this.getSelectivitySimpleTree(multiParentOp.getParentOperators().get(0));
                    selMultiParentRight = this.getSelectivitySimpleTree(multiParentOp.getParentOperators().get(1));
                    selMultiParent = Math.max(selMultiParentLeft, selMultiParentRight);
                } else {
                    switch (n) {
                        case 1: {
                            selMultiParent = this.getSelectivitySimpleTree(multiParentOp.getParentOperators().get(0));
                            break;
                        }
                        case 2: {
                            selMultiParent = this.getSelectivitySimpleTree(multiParentOp.getParentOperators().get(1));
                            break;
                        }
                        default: {
                            selMultiParentLeft = this.getSelectivitySimpleTree(multiParentOp.getParentOperators().get(0));
                            selMultiParentRight = this.getSelectivitySimpleTree(multiParentOp.getParentOperators().get(1));
                            selMultiParent = Math.min(selMultiParentLeft, selMultiParentRight);
                        }
                    }
                }
            }
            if (!isSelComputed) {
                for (Operator operator : multiParentOp.getParentOperators()) {
                    selMultiParent *= this.getSelectivitySimpleTree(operator);
                }
            }
            float selCurrOp = (float)currentOp.getStatistics().getNumRows() / (float)multiParentOp.getStatistics().getNumRows() * selMultiParent;
            return selCurrOp;
        }

        private Map<Integer, ColStatistics> getForeignKeyCandidates(List<Operator<? extends OperatorDesc>> ops, ColStatistics csPK) {
            HashMap<Integer, ColStatistics> result = new HashMap<Integer, ColStatistics>();
            if (csPK == null || ops == null) {
                return result;
            }
            for (int i = 0; i < ops.size(); ++i) {
                ColStatistics cs;
                ReduceSinkOperator rsOp;
                List<String> keys;
                Operator<? extends OperatorDesc> op = ops.get(i);
                if (op == null || !(op instanceof ReduceSinkOperator) || (keys = StatsUtils.getQualifedReducerKeyNames(((ReduceSinkDesc)(rsOp = (ReduceSinkOperator)op).getConf()).getOutputKeyColumnNames())).size() != 1) continue;
                String joinCol = keys.get(0);
                if (rsOp.getStatistics() == null || (cs = rsOp.getStatistics().getColumnStatisticsFromColName(joinCol)) == null || cs.isPrimaryKey() || !StatsUtils.inferForeignKey(csPK, cs)) continue;
                result.put(i, cs);
            }
            return result;
        }

        private Map<Integer, ColStatistics> getPrimaryKeyCandidates(List<Operator<? extends OperatorDesc>> ops) {
            HashMap<Integer, ColStatistics> result = new HashMap<Integer, ColStatistics>();
            if (ops != null && !ops.isEmpty()) {
                for (int i = 0; i < ops.size(); ++i) {
                    ColStatistics cs;
                    ReduceSinkOperator rsOp;
                    List<String> keys;
                    Operator<? extends OperatorDesc> op = ops.get(i);
                    if (!(op instanceof ReduceSinkOperator) || (keys = StatsUtils.getQualifedReducerKeyNames(((ReduceSinkDesc)(rsOp = (ReduceSinkOperator)op).getConf()).getOutputKeyColumnNames())).size() != 1) continue;
                    String joinCol = keys.get(0);
                    if (rsOp.getStatistics() == null || (cs = rsOp.getStatistics().getColumnStatisticsFromColName(joinCol)) == null || !cs.isPrimaryKey()) continue;
                    result.put(i, cs);
                }
            }
            return result;
        }

        private boolean isJoinKey(String columnName, ExprNodeDesc[][] joinKeys) {
            for (int i = 0; i < joinKeys.length; ++i) {
                for (ExprNodeDesc expr : Arrays.asList(joinKeys[i])) {
                    if (!(expr instanceof ExprNodeColumnDesc) || !((ExprNodeColumnDesc)expr).getColumn().equals(columnName)) continue;
                    return true;
                }
            }
            return false;
        }

        private void updateNumNulls(ColStatistics colStats, long leftUnmatchedRows, long rightUnmatchedRows, long newNumRows, long pos, CommonJoinOperator<? extends JoinDesc> jop) {
            if (((JoinDesc)jop.getConf()).getConds().length != 1) {
                return;
            }
            long oldNumNulls = colStats.getNumNulls();
            long newNumNulls = Math.min(newNumRows, oldNumNulls);
            JoinCondDesc joinCond = ((JoinDesc)jop.getConf()).getConds()[0];
            switch (joinCond.getType()) {
                case 1: {
                    if (pos != (long)joinCond.getRight()) break;
                    if (this.isJoinKey(colStats.getColumnName(), ((JoinDesc)jop.getConf()).getJoinKeys())) {
                        newNumNulls = Math.min(newNumRows, leftUnmatchedRows);
                        break;
                    }
                    newNumNulls = Math.min(newNumRows, oldNumNulls + leftUnmatchedRows);
                    break;
                }
                case 2: {
                    if (pos != (long)joinCond.getLeft()) break;
                    if (this.isJoinKey(colStats.getColumnName(), ((JoinDesc)jop.getConf()).getJoinKeys())) {
                        newNumNulls = Math.min(newNumRows, rightUnmatchedRows);
                        break;
                    }
                    newNumNulls = Math.min(newNumRows, oldNumNulls + rightUnmatchedRows);
                    break;
                }
                case 3: {
                    if (this.isJoinKey(colStats.getColumnName(), ((JoinDesc)jop.getConf()).getJoinKeys())) {
                        newNumNulls = Math.min(newNumRows, leftUnmatchedRows + rightUnmatchedRows);
                        break;
                    }
                    newNumNulls = Math.min(newNumRows, oldNumNulls + leftUnmatchedRows + rightUnmatchedRows);
                    break;
                }
            }
            colStats.setNumNulls(newNumNulls);
        }

        private void updateColStats(HiveConf conf, Statistics stats, long leftUnmatchedRows, long rightUnmatchedRows, long newNumRows, CommonJoinOperator<? extends JoinDesc> jop, Map<Integer, Long> rowCountParents) {
            if (newNumRows < 0L) {
                LOG.debug("STATS-" + jop.toString() + ": Overflow in number of rows. " + newNumRows + " rows will be set to Long.MAX_VALUE");
            }
            if (newNumRows == 0L) {
                LOG.debug("STATS-" + jop.toString() + ": Equals 0 in number of rows. " + newNumRows + " rows will be set to 1");
                newNumRows = 1L;
            }
            newNumRows = StatsUtils.getMaxIfOverflow(newNumRows);
            stats.setNumRows(newNumRows);
            List<ColStatistics> colStats = stats.getColumnStats();
            HashSet<String> colNameStatsAvailable = new HashSet<String>();
            for (ColStatistics cs : colStats) {
                colNameStatsAvailable.add(cs.getColumnName());
                byte pos = ((JoinDesc)jop.getConf()).getReversedExprs().get(cs.getColumnName());
                long oldDV = cs.getCountDistint();
                boolean useCalciteForNdvReadjustment = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_JOIN_NDV_READJUSTMENT);
                long newDV = oldDV;
                if (useCalciteForNdvReadjustment) {
                    Double approxNdv = RelMdUtil.numDistinctVals((Double)((double)oldDV * 1.0), (Double)((double)newNumRows * 1.0));
                    Preconditions.checkNotNull((Object)approxNdv, (Object)"approximate NDV is null");
                    newDV = approxNdv.longValue();
                } else {
                    long oldRowCount = rowCountParents.get(pos);
                    double ratio = (double)newNumRows / (double)oldRowCount;
                    if (ratio <= 1.0) {
                        newDV = (long)Math.ceil(ratio * (double)oldDV);
                    }
                }
                cs.setCountDistint(newDV);
                this.updateNumNulls(cs, leftUnmatchedRows, rightUnmatchedRows, newNumRows, pos, jop);
            }
            stats.setColumnStats(colStats);
            long newDataSize = StatsUtils.getDataSizeFromColumnStats(newNumRows, colStats);
            ArrayList<String> neededColumns = new ArrayList<String>();
            for (String colName : jop.getSchema().getColumnNames()) {
                if (colNameStatsAvailable.contains(colName)) continue;
                neededColumns.add(colName);
            }
            if (neededColumns.size() != 0) {
                long restColumnsDefaultSize = StatsUtils.estimateRowSizeFromSchema(conf, jop.getSchema().getSignature(), neededColumns);
                newDataSize = StatsUtils.safeAdd(newDataSize, StatsUtils.safeMult(restColumnsDefaultSize, newNumRows));
            }
            stats.setDataSize(StatsUtils.getMaxIfOverflow(newDataSize));
            stats.setBasicStatsState(Statistics.State.COMPLETE);
        }

        private long computeFinalRowCount(List<Long> rowCountParents, long interimRowCount, CommonJoinOperator<? extends JoinDesc> join) {
            long result = interimRowCount;
            if (((JoinDesc)join.getConf()).getConds().length == 1) {
                JoinCondDesc joinCond = ((JoinDesc)join.getConf()).getConds()[0];
                switch (joinCond.getType()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        result = Math.max(rowCountParents.get(joinCond.getLeft()), result);
                        break;
                    }
                    case 2: {
                        result = Math.max(rowCountParents.get(joinCond.getRight()), result);
                        break;
                    }
                    case 3: {
                        result = Math.max(StatsUtils.safeAdd(rowCountParents.get(joinCond.getRight()), rowCountParents.get(joinCond.getLeft())), result);
                        break;
                    }
                    case 5: {
                        result = Math.min(rowCountParents.get(joinCond.getLeft()), result);
                        break;
                    }
                    case 6: {
                        long leftRowCount = rowCountParents.get(joinCond.getLeft());
                        if (leftRowCount < result) {
                            result = leftRowCount;
                            break;
                        }
                        result = leftRowCount - result;
                        break;
                    }
                    default: {
                        LOG.debug("Unhandled join type in stats estimation: " + joinCond.getType());
                    }
                }
            }
            return result;
        }

        private long computeRowCountAssumingInnerJoin(List<Long> rowCountParents, long denom, CommonJoinOperator<? extends JoinDesc> join) {
            int i;
            double factor = 0.0;
            long result = 1L;
            long max = rowCountParents.get(0);
            long maxIdx = 0L;
            for (i = 1; i < rowCountParents.size(); ++i) {
                if (rowCountParents.get(i) <= max) continue;
                max = rowCountParents.get(i);
                maxIdx = i;
            }
            denom = denom == 0L ? 1L : denom;
            factor = (double)max / (double)denom;
            for (i = 0; i < rowCountParents.size(); ++i) {
                if ((long)i == maxIdx) continue;
                result = StatsUtils.safeMult(result, rowCountParents.get(i));
            }
            result = (long)((double)result * factor);
            return result;
        }

        private void updateJoinColumnsNDV(Map<Integer, List<String>> joinKeys, Map<Integer, Statistics> joinStats, int numAttr) {
            int joinColIdx = 0;
            while (numAttr > 0) {
                ColStatistics cs;
                String key;
                int pos;
                long minNDV = Long.MAX_VALUE;
                for (Map.Entry<Integer, List<String>> entry : joinKeys.entrySet()) {
                    pos = entry.getKey();
                    key = entry.getValue().get(joinColIdx);
                    cs = joinStats.get(pos).getColumnStatisticsFromColName(key);
                    if (cs == null || cs.getCountDistint() >= minNDV) continue;
                    minNDV = cs.getCountDistint();
                }
                if (minNDV != Long.MAX_VALUE) {
                    for (Map.Entry<Integer, List<String>> entry : joinKeys.entrySet()) {
                        pos = entry.getKey();
                        key = entry.getValue().get(joinColIdx);
                        cs = joinStats.get(pos).getColumnStatisticsFromColName(key);
                        if (cs == null) continue;
                        cs.setCountDistint(minNDV);
                    }
                }
                ++joinColIdx;
                --numAttr;
            }
        }

        private long getDenominatorForUnmatchedRows(List<Long> distinctVals) {
            if (distinctVals.isEmpty()) {
                return 2L;
            }
            if (distinctVals.size() <= 2) {
                return Collections.min(distinctVals);
            }
            long maxNDV = distinctVals.get(0);
            int maxIdx = 0;
            for (int i = 1; i < distinctVals.size(); ++i) {
                if (distinctVals.get(i) <= maxNDV) continue;
                maxNDV = distinctVals.get(i);
                maxIdx = i;
            }
            long denom = 1L;
            for (int i = 0; i < distinctVals.size(); ++i) {
                if (i == maxIdx) continue;
                denom = StatsUtils.safeMult(denom, distinctVals.get(i));
            }
            return denom;
        }

        private long getDenominator(List<Long> distinctVals) {
            if (distinctVals.isEmpty()) {
                return 2L;
            }
            if (distinctVals.size() <= 2) {
                return Collections.max(distinctVals);
            }
            long minNDV = distinctVals.get(0);
            int minIdx = 0;
            for (int i = 1; i < distinctVals.size(); ++i) {
                if (distinctVals.get(i) >= minNDV) continue;
                minNDV = distinctVals.get(i);
                minIdx = i;
            }
            long denom = 1L;
            for (int i = 0; i < distinctVals.size(); ++i) {
                if (i == minIdx) continue;
                denom = StatsUtils.safeMult(denom, distinctVals.get(i));
            }
            return denom;
        }
    }

    public static class GroupByStatsRule
    extends DefaultStatsRule
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            long cardinality;
            long sizeOfGroupingSet;
            GroupByOperator gop = (GroupByOperator)nd;
            Operator<OperatorDesc> parent = gop.getParentOperators().get(0);
            Statistics parentStats = parent.getStatistics();
            if (parentStats == null) {
                return null;
            }
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            HiveConf conf = aspCtx.getConf();
            long maxSplitSize = HiveConf.getLongVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.MAPREDMAXSPLITSIZE);
            List<AggregationDesc> aggDesc = ((GroupByDesc)gop.getConf()).getAggregators();
            Map<String, ExprNodeDesc> colExprMap = gop.getColumnExprMap();
            RowSchema rs = gop.getSchema();
            Statistics stats = null;
            List<ColStatistics> colStats = StatsUtils.getColStatisticsFromExprMap(conf, parentStats, colExprMap, rs);
            long parallelism = 1L;
            boolean interReduction = false;
            boolean hashAgg = false;
            long inputSize = 1L;
            boolean containsGroupingSet = ((GroupByDesc)gop.getConf()).isGroupingSetsPresent();
            long l = sizeOfGroupingSet = containsGroupingSet ? (long)((GroupByDesc)gop.getConf()).getListGroupingSets().size() : 1L;
            if (!(((GroupByDesc)gop.getConf()).getMode().equals((Object)GroupByDesc.Mode.MERGEPARTIAL) || ((GroupByDesc)gop.getConf()).getMode().equals((Object)GroupByDesc.Mode.COMPLETE) || ((GroupByDesc)gop.getConf()).getMode().equals((Object)GroupByDesc.Mode.FINAL))) {
                interReduction = true;
                TableScanOperator top = OperatorUtils.findSingleOperatorUpstream(gop, TableScanOperator.class);
                if (top == null) {
                    inputSize = parentStats.getDataSize();
                    maxSplitSize = HiveConf.getLongVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.BYTESPERREDUCER);
                } else {
                    inputSize = ((TableScanDesc)top.getConf()).getStatistics().getDataSize();
                }
                parallelism = (int)Math.ceil((double)inputSize / (double)maxSplitSize);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("STATS-" + gop.toString() + ": inputSize: " + inputSize + " maxSplitSize: " + maxSplitSize + " parallelism: " + parallelism + " containsGroupingSet: " + containsGroupingSet + " sizeOfGroupingSet: " + sizeOfGroupingSet);
            }
            if (StatsRulesProcFactory.satisfyPrecondition(parentStats)) {
                hashAgg = this.checkMapSideAggregation(gop, colStats, conf);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("STATS-" + gop.toString() + " hashAgg: " + hashAgg);
                }
                stats = parentStats.clone();
                stats.setColumnStats(colStats);
                long parentNumRows = stats.getNumRows();
                long ndvProduct = StatsUtils.computeNDVGroupingColumns(colStats, parentStats, false);
                if (ndvProduct == 0L) {
                    ndvProduct = parentNumRows / 2L;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("STATS-" + gop.toString() + ": ndvProduct became 0 as some column does not have stats. ndvProduct changed to: " + ndvProduct);
                    }
                }
                long maxColumnNDV = colStats.stream().filter(Objects::nonNull).mapToLong(ColStatistics::getCountDistint).max().orElse(-1L);
                if (interReduction) {
                    if (hashAgg) {
                        if (containsGroupingSet) {
                            cardinality = Math.min(StatsUtils.safeMult(parentNumRows, sizeOfGroupingSet) / 2L, StatsUtils.safeMult(StatsUtils.safeMult(ndvProduct, parallelism), sizeOfGroupingSet));
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("[Case 4] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                            }
                        } else {
                            cardinality = Math.min(parentNumRows / 2L, StatsUtils.safeMult(ndvProduct, parallelism));
                            cardinality = Math.max(cardinality, maxColumnNDV);
                            long orgParentNumRows = StatsUtils.safeMult(this.getParentNumRows(gop, ((GroupByDesc)gop.getConf()).getKeys(), conf), parallelism);
                            cardinality = Math.min(cardinality, orgParentNumRows);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug("[Case 3] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                            }
                        }
                    } else if (containsGroupingSet) {
                        cardinality = StatsUtils.safeMult(parentNumRows, sizeOfGroupingSet);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("[Case 6] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                        }
                    } else {
                        cardinality = Math.min(parentNumRows, this.getParentNumRows(gop, ((GroupByDesc)gop.getConf()).getKeys(), conf));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("[Case 5] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                        }
                    }
                } else {
                    GroupByOperator mGop = OperatorUtils.findMapSideGb(gop);
                    if (mGop != null) {
                        containsGroupingSet = ((GroupByDesc)mGop.getConf()).isGroupingSetsPresent();
                    }
                    if (containsGroupingSet) {
                        sizeOfGroupingSet = ((GroupByDesc)mGop.getConf()).getListGroupingSets().size();
                        cardinality = Math.min(parentNumRows, StatsUtils.safeMult(ndvProduct, sizeOfGroupingSet));
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("[Case 8] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                        }
                    } else {
                        cardinality = Math.min(parentNumRows, ndvProduct);
                        cardinality = Math.max(cardinality, maxColumnNDV);
                        GroupByOperator gOpStats = mGop;
                        if (gOpStats == null) {
                            gOpStats = gop;
                        }
                        long orgParentNumRows = this.getParentNumRows(gOpStats, ((GroupByDesc)gOpStats.getConf()).getKeys(), conf);
                        cardinality = Math.min(orgParentNumRows, cardinality);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("[Case 9] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                        }
                    }
                }
                StatsUtils.updateStats(stats, cardinality, true, gop);
            } else if (parentStats != null) {
                stats = parentStats.clone();
                long parentNumRows = stats.getNumRows();
                if (interReduction) {
                    if (containsGroupingSet) {
                        cardinality = StatsUtils.safeMult(parentNumRows, sizeOfGroupingSet);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("[Case 2] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                        }
                    } else {
                        cardinality = parentNumRows;
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("[Case 1] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                        }
                    }
                } else {
                    cardinality = parentNumRows / 2L;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[Case 7] STATS-" + gop.toString() + ": cardinality: " + cardinality);
                    }
                }
                StatsUtils.updateStats(stats, cardinality, false, gop);
            }
            if (!aggDesc.isEmpty() && stats != null) {
                ArrayList aggColStats = Lists.newArrayList();
                int idx = 0;
                for (ColumnInfo ci : rs.getSignature()) {
                    if (colExprMap.containsKey(ci.getInternalName())) continue;
                    String colName = ci.getInternalName();
                    String colType = ci.getTypeName();
                    ColStatistics cs = new ColStatistics(colName, colType);
                    cs.setCountDistint(stats.getNumRows());
                    cs.setNumNulls(0L);
                    cs.setAvgColLen(StatsUtils.getAvgColLenOf(conf, ci.getObjectInspector(), colType));
                    GroupByStatsRule.computeAggregateColumnMinMax(cs, conf, aggDesc.get(idx++), colType, parentStats);
                    aggColStats.add(cs);
                }
                if (aggColStats.size() > 0) {
                    stats.addToColumnStats(aggColStats);
                    if (!stats.getColumnStatsState().equals((Object)Statistics.State.NONE)) {
                        StatsUtils.updateStats(stats, stats.getNumRows(), true, gop);
                    }
                }
                if (colExprMap.isEmpty()) {
                    StatsUtils.updateStats(stats, 1L, true, gop);
                }
            }
            stats = StatsRulesProcFactory.applyRuntimeStats(aspCtx.getParseContext().getContext(), stats, gop);
            gop.setStatistics(stats);
            if (LOG.isDebugEnabled() && stats != null) {
                LOG.debug("[0] STATS-" + gop.toString() + ": " + stats.extendedToString());
            }
            return null;
        }

        private static void computeAggregateColumnMinMax(ColStatistics cs, HiveConf conf, AggregationDesc agg, String aggType, Statistics parentStats) throws SemanticException {
            ColStatistics parentCS;
            if (agg.getParameters() != null && agg.getParameters().size() == 1 && (parentCS = StatsUtils.getColStatisticsFromExpression(conf, parentStats, agg.getParameters().get(0))) != null && parentCS.getRange() != null && parentCS.getRange().minValue != null && parentCS.getRange().maxValue != null) {
                long valuesCount = agg.getDistinct() ? parentCS.getCountDistint() : parentStats.getNumRows() - parentCS.getNumNulls();
                ColStatistics.Range range = parentCS.getRange();
                GenericUDAFResolver udaf = FunctionRegistry.getGenericUDAFResolver(agg.getGenericUDAFName());
                if (udaf instanceof GenericUDAFCount) {
                    cs.setRange(new ColStatistics.Range(0, valuesCount));
                } else if (udaf instanceof GenericUDAFMax || udaf instanceof GenericUDAFMin) {
                    cs.setRange(new ColStatistics.Range(range.minValue, range.maxValue));
                } else if (udaf instanceof GenericUDAFSum) {
                    switch (aggType) {
                        case "tinyint": 
                        case "smallint": 
                        case "date": 
                        case "int": 
                        case "bigint": 
                        case "timestamp": {
                            long maxValueLong = range.maxValue.longValue();
                            long minValueLong = range.minValue.longValue();
                            if (minValueLong > maxValueLong || minValueLong < 0L) break;
                            cs.setRange(new ColStatistics.Range(minValueLong, StatsUtils.safeMult(StatsUtils.safeMult(StatsUtils.safeAdd(minValueLong, maxValueLong), 0.5), valuesCount)));
                            break;
                        }
                        case "float": 
                        case "double": {
                            double maxValueDouble = range.maxValue.doubleValue();
                            double minValueDouble = range.minValue.doubleValue();
                            if (!(minValueDouble <= maxValueDouble) || !(minValueDouble >= 0.0)) break;
                            cs.setRange(new ColStatistics.Range(minValueDouble, (minValueDouble + maxValueDouble) * 0.5 * (double)valuesCount));
                            break;
                        }
                        default: {
                            if (!aggType.startsWith("decimal")) break;
                            BigDecimal maxValueBD = new BigDecimal(range.maxValue.toString());
                            BigDecimal minValueBD = new BigDecimal(range.minValue.toString());
                            if (minValueBD.compareTo(maxValueBD) > 0 || minValueBD.compareTo(BigDecimal.ZERO) < 0) break;
                            cs.setRange(new ColStatistics.Range(minValueBD, minValueBD.add(maxValueBD).multiply(new BigDecimal(0.5)).multiply(new BigDecimal(valuesCount))));
                        }
                    }
                }
            }
        }

        private long getParentNumRows(GroupByOperator op, List<ExprNodeDesc> gbyKeys, HiveConf conf) {
            if (gbyKeys == null || gbyKeys.isEmpty()) {
                return op.getParentOperators().get(0).getStatistics().getNumRows();
            }
            Operator<? extends OperatorDesc> parent = OperatorUtils.findSourceRS(op, gbyKeys);
            if (parent != null) {
                return parent.getStatistics().getNumRows();
            }
            return op.getParentOperators().get(0).getStatistics().getNumRows();
        }

        private boolean checkMapSideAggregation(GroupByOperator gop, List<ColStatistics> colStats, HiveConf conf) {
            List<AggregationDesc> aggDesc = ((GroupByDesc)gop.getConf()).getAggregators();
            GroupByDesc desc = (GroupByDesc)gop.getConf();
            GroupByDesc.Mode mode = desc.getMode();
            if (mode.equals((Object)GroupByDesc.Mode.HASH)) {
                Object agg;
                int i;
                float hashAggMem = conf.getFloatVar(HiveConf.ConfVars.HIVEMAPAGGRHASHMEMORY);
                float hashAggMaxThreshold = conf.getFloatVar(HiveConf.ConfVars.HIVEMAPAGGRMEMORYTHRESHOLD);
                long totalMemory = StatsUtils.getAvailableMemory((Configuration)conf) * 1000L * 1000L;
                long maxMemHashAgg = Math.round((float)totalMemory * hashAggMem * hashAggMaxThreshold);
                long numEstimatedRows = 1L;
                long avgKeySize = 0L;
                for (ColStatistics cs : colStats) {
                    if (cs == null) continue;
                    numEstimatedRows = StatsUtils.safeMult(numEstimatedRows, cs.getCountDistint());
                    avgKeySize = (long)((double)avgKeySize + Math.ceil(cs.getAvgColLen()));
                }
                long avgValSize = 0L;
                GenericUDAFEvaluator[] aggregationEvaluators = new GenericUDAFEvaluator[aggDesc.size()];
                for (i = 0; i < aggregationEvaluators.length; ++i) {
                    agg = aggDesc.get(i);
                    aggregationEvaluators[i] = ((AggregationDesc)agg).getGenericUDAFEvaluator();
                }
                for (i = 0; i < aggregationEvaluators.length; ++i) {
                    Field[] fArr;
                    avgValSize += 64L;
                    agg = null;
                    int evaluatorEstimate = aggregationEvaluators[i].estimate();
                    if (evaluatorEstimate > 0) {
                        avgValSize += (long)evaluatorEstimate;
                        continue;
                    }
                    try {
                        agg = aggregationEvaluators[i].getNewAggregationBuffer();
                    }
                    catch (HiveException e) {
                        avgValSize += 256L;
                    }
                    if (agg == null) continue;
                    if (GenericUDAFEvaluator.isEstimable((GenericUDAFEvaluator.AggregationBuffer)agg)) {
                        avgValSize += (long)((GenericUDAFEvaluator.AbstractAggregationBuffer)agg).estimate();
                        continue;
                    }
                    for (Field f : fArr = ObjectInspectorUtils.getDeclaredNonStaticFields(agg.getClass())) {
                        long avgSize = StatsUtils.getAvgColLenOfFixedLengthTypes(f.getType().getName());
                        avgValSize += avgSize == 0L ? 256L : avgSize;
                    }
                }
                long hashEntrySize = 64L + avgKeySize + avgValSize;
                long estHashTableSize = StatsUtils.safeMult(numEstimatedRows, hashEntrySize);
                if (estHashTableSize < maxMemHashAgg) {
                    return true;
                }
            }
            return false;
        }
    }

    public static class FilterStatsRule
    extends DefaultStatsRule
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            FilterOperator fop = (FilterOperator)nd;
            Operator<OperatorDesc> parent = fop.getParentOperators().get(0);
            Statistics parentStats = parent.getStatistics();
            List<String> neededCols = null;
            if (parent instanceof TableScanOperator) {
                TableScanOperator tsop = (TableScanOperator)parent;
                neededCols = tsop.getNeededColumns();
            }
            if (parentStats != null) {
                ExprNodeDesc pred = ((FilterDesc)fop.getConf()).getPredicate();
                aspCtx.clearAffectedColumns();
                long newNumRows = this.evaluateExpression(parentStats, pred, aspCtx, neededCols, fop, parentStats.getNumRows());
                Statistics st = parentStats.clone();
                if (StatsRulesProcFactory.satisfyPrecondition(parentStats)) {
                    if (newNumRows <= parentStats.getNumRows()) {
                        StatsUtils.updateStats(st, newNumRows, true, fop, aspCtx.getAffectedColumns());
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[0] STATS-" + fop.toString() + ": " + st.extendedToString());
                    }
                } else {
                    if (newNumRows <= parentStats.getNumRows()) {
                        StatsUtils.updateStats(st, newNumRows, false, fop);
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("[1] STATS-" + fop.toString() + ": " + st.extendedToString());
                    }
                }
                st = StatsRulesProcFactory.applyRuntimeStats(aspCtx.getParseContext().getContext(), st, fop);
                fop.setStatistics(st);
                aspCtx.setAndExprStats(null);
            }
            return null;
        }

        protected long evaluateExpression(Statistics stats, ExprNodeDesc pred, AnnotateStatsProcCtx aspCtx, List<String> neededCols, Operator<?> op, long currNumRows) throws SemanticException {
            long newNumRows = 0L;
            Statistics andStats = null;
            if (currNumRows <= 1L || stats.getDataSize() <= 0L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Estimating row count for " + pred + " Original num rows: " + currNumRows + " Original data size: " + stats.getDataSize() + " New num rows: 1");
                }
                return 1L;
            }
            if (pred instanceof ExprNodeGenericFuncDesc) {
                ExprNodeGenericFuncDesc genFunc = (ExprNodeGenericFuncDesc)pred;
                GenericUDF udf = genFunc.getGenericUDF();
                if (udf instanceof GenericUDFOPAnd) {
                    HashSet<String> affectedColumns = new HashSet<String>();
                    andStats = stats.clone();
                    aspCtx.setAndExprStats(andStats);
                    aspCtx.clearAffectedColumns();
                    long evaluatedRowCount = currNumRows;
                    for (ExprNodeDesc child : genFunc.getChildren()) {
                        newNumRows = evaluatedRowCount = this.evaluateChildExpr(aspCtx.getAndExprStats(), child, aspCtx, neededCols, op, evaluatedRowCount);
                        if (StatsRulesProcFactory.satisfyPrecondition(aspCtx.getAndExprStats())) {
                            StatsUtils.updateStats(aspCtx.getAndExprStats(), newNumRows, true, op, aspCtx.getAffectedColumns());
                        } else {
                            StatsUtils.updateStats(aspCtx.getAndExprStats(), newNumRows, false, op);
                        }
                        affectedColumns.addAll(aspCtx.getAffectedColumns());
                        aspCtx.clearAffectedColumns();
                    }
                    aspCtx.addAffectedColumns(affectedColumns);
                } else if (udf instanceof GenericUDFOPOr) {
                    for (ExprNodeDesc child : genFunc.getChildren()) {
                        newNumRows = StatsUtils.safeAdd(this.evaluateChildExpr(stats, child, aspCtx, neededCols, op, currNumRows), newNumRows);
                    }
                    aspCtx.clearAffectedColumns();
                    if (newNumRows > currNumRows) {
                        newNumRows = currNumRows;
                    }
                } else if (udf instanceof GenericUDFIn) {
                    newNumRows = this.evaluateInExpr(stats, pred, currNumRows, aspCtx, neededCols, op);
                } else if (udf instanceof GenericUDFBetween) {
                    newNumRows = this.evaluateBetweenExpr(stats, pred, currNumRows, aspCtx, neededCols, op);
                } else if (udf instanceof GenericUDFOPNot) {
                    newNumRows = this.evaluateNotExpr(stats, pred, currNumRows, aspCtx, neededCols, op);
                } else {
                    if (udf instanceof GenericUDFOPNotNull) {
                        return this.evaluateNotNullExpr(stats, aspCtx, genFunc, currNumRows);
                    }
                    newNumRows = this.evaluateChildExpr(stats, pred, aspCtx, neededCols, op, currNumRows);
                }
            } else if (pred instanceof ExprNodeColumnDesc) {
                ColStatistics cs;
                ExprNodeColumnDesc encd = (ExprNodeColumnDesc)pred;
                aspCtx.addAffectedColumn(encd);
                String colName = encd.getColumn();
                String colType = encd.getTypeString();
                newNumRows = colType.equalsIgnoreCase("boolean") ? ((cs = stats.getColumnStatisticsFromColName(colName)) != null ? cs.getNumTrues() : stats.getNumRows() / 2L) : stats.getNumRows() / 2L;
            } else if (pred instanceof ExprNodeConstantDesc) {
                ExprNodeConstantDesc encd = (ExprNodeConstantDesc)pred;
                newNumRows = Boolean.FALSE.equals(encd.getValue()) ? 0L : stats.getNumRows();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Estimating row count for " + pred + " Original num rows: " + stats.getNumRows() + " New num rows: " + newNumRows);
            }
            return newNumRows;
        }

        private long evaluateInExpr(Statistics stats, ExprNodeDesc pred, long currNumRows, AnnotateStatsProcCtx aspCtx, List<String> neededCols, Operator<?> op) throws SemanticException {
            boolean multiColumn;
            long numRows = currNumRows;
            ExprNodeGenericFuncDesc fd = (ExprNodeGenericFuncDesc)pred;
            List<ExprNodeDesc> children = fd.getChildren();
            ArrayList columns = Lists.newArrayList();
            ArrayList columnStats = Lists.newArrayList();
            ArrayList values = Lists.newArrayList();
            ExprNodeDesc columnsChild = children.get(0);
            if (columnsChild instanceof ExprNodeGenericFuncDesc && ((ExprNodeGenericFuncDesc)columnsChild).getGenericUDF() instanceof GenericUDFStruct) {
                for (int j = 0; j < columnsChild.getChildren().size(); ++j) {
                    ExprNodeDesc columnChild = columnsChild.getChildren().get(j);
                    if (!(columnChild instanceof ExprNodeColumnDesc)) {
                        return numRows / 2L;
                    }
                    columns.add(columnChild);
                    String columnName = ((ExprNodeColumnDesc)columnChild).getColumn();
                    if (neededCols != null && !neededCols.contains(columnName)) {
                        return numRows / 2L;
                    }
                    columnStats.add(stats.getColumnStatisticsFromColName(columnName));
                    values.add(Sets.newHashSet());
                }
                multiColumn = true;
            } else {
                if (!(columnsChild instanceof ExprNodeColumnDesc)) {
                    return numRows / 2L;
                }
                columns.add(columnsChild);
                aspCtx.addAffectedColumn((ExprNodeColumnDesc)columnsChild);
                String columnName = ((ExprNodeColumnDesc)columnsChild).getColumn();
                if (neededCols != null && !neededCols.contains(columnName)) {
                    return numRows / 2L;
                }
                columnStats.add(stats.getColumnStatisticsFromColName(columnName));
                values.add(Sets.newHashSet());
                multiColumn = false;
            }
            for (int i = 1; i < children.size(); ++i) {
                ExprNodeDesc child = children.get(i);
                if (!(child instanceof ExprNodeConstantDesc)) {
                    return numRows / 2L;
                }
                if (multiColumn) {
                    ExprNodeConstantDesc constantChild = (ExprNodeConstantDesc)child;
                    List items = (List)constantChild.getWritableObjectInspector().getWritableConstantValue();
                    List structTypes = ((StructTypeInfo)constantChild.getTypeInfo()).getAllStructFieldTypeInfos();
                    for (int j = 0; j < structTypes.size(); ++j) {
                        ExprNodeConstantDesc constant = new ExprNodeConstantDesc((TypeInfo)structTypes.get(j), items.get(j));
                        ((Set)values.get(j)).add(new ExprNodeDesc.ExprNodeDescEqualityWrapper(constant));
                    }
                    continue;
                }
                ((Set)values.get(0)).add(new ExprNodeDesc.ExprNodeDescEqualityWrapper(child));
            }
            boolean allColsFilteredByStats = true;
            for (int i = 0; i < columnStats.size(); ++i) {
                ValuePruner vp = new ValuePruner((ColStatistics)columnStats.get(i));
                allColsFilteredByStats &= vp.isValid();
                HashSet newValues = Sets.newHashSet();
                for (ExprNodeDesc.ExprNodeDescEqualityWrapper v : (Set)values.get(i)) {
                    if (!vp.accept(v)) continue;
                    newValues.add(v);
                }
                values.set(i, newValues);
            }
            double factor = 1.0;
            if (multiColumn) {
                factor *= (double)(children.size() - 1);
            }
            for (int i = 0; i < columnStats.size(); ++i) {
                double columnFactor;
                long dvs = columnStats.get(i) == null ? 0L : ((ColStatistics)columnStats.get(i)).getCountDistint();
                double d = columnFactor = dvs == 0L ? 0.5 : 1.0 / (double)dvs;
                if (!multiColumn) {
                    columnFactor *= (double)((Set)values.get(0)).size();
                }
                factor *= columnFactor > 1.0 ? 1.0 : columnFactor;
            }
            factor = Double.min(factor, 1.0);
            if (!allColsFilteredByStats) {
                factor = Double.max(factor, HiveConf.getFloatVar((Configuration)aspCtx.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_IN_MIN_RATIO));
            }
            float inFactor = HiveConf.getFloatVar((Configuration)aspCtx.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_STATS_IN_CLAUSE_FACTOR);
            return Math.round((double)numRows * factor * (double)inFactor);
        }

        private ExprNodeDesc rewriteBetweenToIn(ExprNodeDesc comparisonExpression, ExprNodeDesc leftExpression, ExprNodeDesc rightExpression, boolean invert) {
            int REWRITE_THRESHOLD = 100;
            boolean shouldRewrite = false;
            long startVal = 0L;
            long endVal = 0L;
            if (ExprNodeDescUtils.isIntegerType(comparisonExpression) && leftExpression instanceof ExprNodeConstantDesc && rightExpression instanceof ExprNodeConstantDesc) {
                Object leftValue = ((ExprNodeConstantDesc)leftExpression).getValue();
                Object rightValue = ((ExprNodeConstantDesc)rightExpression).getValue();
                startVal = ((Number)leftValue).longValue();
                if (startVal > (endVal = ((Number)rightValue).longValue())) {
                    Long tmpVal = startVal;
                    startVal = endVal;
                    endVal = tmpVal;
                }
                if (endVal - startVal <= 100L) {
                    shouldRewrite = true;
                }
            }
            if (shouldRewrite) {
                ArrayList<ExprNodeDesc> constantExprs = new ArrayList<ExprNodeDesc>();
                constantExprs.add(comparisonExpression);
                for (long i = startVal; i <= endVal; ++i) {
                    ExprNodeConstantDesc constExpr = new ExprNodeConstantDesc(comparisonExpression.getTypeInfo(), i);
                    constantExprs.add(constExpr);
                }
                ExprNodeGenericFuncDesc newExpression = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (GenericUDF)new GenericUDFIn(), constantExprs);
                return newExpression;
            }
            ExprNodeGenericFuncDesc leftComparator = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (GenericUDF)new GenericUDFOPEqualOrGreaterThan(), (List<ExprNodeDesc>)Lists.newArrayList((Object[])new ExprNodeDesc[]{comparisonExpression, leftExpression}));
            ExprNodeGenericFuncDesc rightComparator = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (GenericUDF)new GenericUDFOPEqualOrLessThan(), (List<ExprNodeDesc>)Lists.newArrayList((Object[])new ExprNodeDesc[]{comparisonExpression, rightExpression}));
            ExprNodeGenericFuncDesc newExpression = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (GenericUDF)new GenericUDFOPAnd(), (List<ExprNodeDesc>)Lists.newArrayList((Object[])new ExprNodeDesc[]{leftComparator, rightComparator}));
            if (invert) {
                newExpression = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.booleanTypeInfo, (GenericUDF)new GenericUDFOPNot(), (List<ExprNodeDesc>)Lists.newArrayList((Object[])new ExprNodeDesc[]{newExpression}));
            }
            return newExpression;
        }

        private long evaluateBetweenExpr(Statistics stats, ExprNodeDesc pred, long currNumRows, AnnotateStatsProcCtx aspCtx, List<String> neededCols, Operator<?> op) throws SemanticException {
            ExprNodeGenericFuncDesc fd = (ExprNodeGenericFuncDesc)pred;
            boolean invert = Boolean.TRUE.equals(((ExprNodeConstantDesc)fd.getChildren().get(0)).getValue());
            ExprNodeDesc comparisonExpression = fd.getChildren().get(1);
            ExprNodeDesc leftExpression = fd.getChildren().get(2);
            ExprNodeDesc rightExpression = fd.getChildren().get(3);
            if (leftExpression instanceof ExprNodeDynamicValueDesc) {
                return currNumRows;
            }
            ExprNodeDesc newExpression = this.rewriteBetweenToIn(comparisonExpression, leftExpression, rightExpression, invert);
            return this.evaluateExpression(stats, newExpression, aspCtx, neededCols, op, currNumRows);
        }

        private long evaluateNotExpr(Statistics stats, ExprNodeDesc pred, long currNumRows, AnnotateStatsProcCtx aspCtx, List<String> neededCols, Operator<?> op) throws SemanticException {
            long numRows = currNumRows;
            if (pred instanceof ExprNodeGenericFuncDesc) {
                ExprNodeGenericFuncDesc genFunc = (ExprNodeGenericFuncDesc)pred;
                for (ExprNodeDesc leaf : genFunc.getChildren()) {
                    ColStatistics cs;
                    if (leaf instanceof ExprNodeGenericFuncDesc) {
                        long newNumRows = 0L;
                        for (ExprNodeDesc child : genFunc.getChildren()) {
                            newNumRows = this.evaluateChildExpr(stats, child, aspCtx, neededCols, op, numRows);
                        }
                        return numRows - newNumRows;
                    }
                    if (leaf instanceof ExprNodeConstantDesc) {
                        ExprNodeConstantDesc encd = (ExprNodeConstantDesc)leaf;
                        if (Boolean.TRUE.equals(encd.getValue())) {
                            return 0L;
                        }
                        return numRows;
                    }
                    if (!(leaf instanceof ExprNodeColumnDesc)) continue;
                    ExprNodeColumnDesc encd = (ExprNodeColumnDesc)leaf;
                    aspCtx.addAffectedColumn(encd);
                    String colName = encd.getColumn();
                    String colType = encd.getTypeString();
                    if (colType.equalsIgnoreCase("boolean") && (cs = stats.getColumnStatisticsFromColName(colName)) != null) {
                        return cs.getNumFalses();
                    }
                    return numRows / 2L;
                }
            }
            return numRows / 2L;
        }

        private long evaluateColEqualsNullExpr(Statistics stats, AnnotateStatsProcCtx aspCtx, ExprNodeDesc pred, long currNumRows) {
            long numRows = currNumRows;
            if (pred instanceof ExprNodeGenericFuncDesc) {
                ExprNodeGenericFuncDesc genFunc = (ExprNodeGenericFuncDesc)pred;
                for (ExprNodeDesc leaf : genFunc.getChildren()) {
                    if (!(leaf instanceof ExprNodeColumnDesc)) continue;
                    ExprNodeColumnDesc colDesc = (ExprNodeColumnDesc)leaf;
                    aspCtx.addAffectedColumn(colDesc);
                    String colName = colDesc.getColumn();
                    ColStatistics cs = stats.getColumnStatisticsFromColName(colName);
                    if (cs == null) continue;
                    return cs.getNumNulls();
                }
            }
            return numRows / 2L;
        }

        private long evaluateNotNullExpr(Statistics parentStats, AnnotateStatsProcCtx aspCtx, ExprNodeGenericFuncDesc pred, long currNumRows) {
            long parentCardinality;
            long noOfNulls = this.getMaxNulls(parentStats, aspCtx, pred);
            long newPredCardinality = parentCardinality = currNumRows;
            if (parentCardinality > noOfNulls) {
                newPredCardinality = parentCardinality - noOfNulls;
            } else {
                LOG.error("Invalid column stats: No of nulls > cardinality");
            }
            return newPredCardinality;
        }

        private long getMaxNulls(Statistics stats, AnnotateStatsProcCtx aspCtx, ExprNodeDesc pred) {
            long tmpNoNulls = 0L;
            long maxNoNulls = 0L;
            if (pred instanceof ExprNodeColumnDesc) {
                ExprNodeColumnDesc encd = (ExprNodeColumnDesc)pred;
                ColStatistics cs = stats.getColumnStatisticsFromColName(encd.getColumn());
                if (cs != null) {
                    tmpNoNulls = cs.getNumNulls();
                }
            } else if (pred instanceof ExprNodeGenericFuncDesc || pred instanceof ExprNodeColumnListDesc) {
                long noNullsOfChild = 0L;
                for (ExprNodeDesc childExpr : pred.getChildren()) {
                    noNullsOfChild = this.getMaxNulls(stats, aspCtx, childExpr);
                    if (noNullsOfChild <= tmpNoNulls) continue;
                    tmpNoNulls = noNullsOfChild;
                }
            } else if (pred instanceof ExprNodeConstantDesc) {
                tmpNoNulls = ExprNodeDescUtils.isNullConstant(pred) ? stats.getNumRows() : 0L;
            } else if (pred instanceof ExprNodeDynamicListDesc) {
                tmpNoNulls = 0L;
            } else if (pred instanceof ExprNodeFieldDesc) {
                tmpNoNulls = this.getMaxNulls(stats, aspCtx, ((ExprNodeFieldDesc)pred).getDesc());
            }
            if (tmpNoNulls > maxNoNulls) {
                maxNoNulls = tmpNoNulls;
            }
            return maxNoNulls;
        }

        private long evaluateComparator(Statistics stats, AnnotateStatsProcCtx aspCtx, ExprNodeGenericFuncDesc genFunc, long currNumRows) {
            boolean closedBound;
            boolean upperBound;
            ExprNodeColumnDesc columnDesc;
            long numRows = currNumRows;
            GenericUDF udf = genFunc.getGenericUDF();
            String boundValue = null;
            if (genFunc.getChildren().get(0) instanceof ExprNodeColumnDesc && genFunc.getChildren().get(1) instanceof ExprNodeConstantDesc) {
                columnDesc = (ExprNodeColumnDesc)genFunc.getChildren().get(0);
                ExprNodeConstantDesc constantDesc = (ExprNodeConstantDesc)genFunc.getChildren().get(1);
                aspCtx.addAffectedColumn(columnDesc);
                if (constantDesc.getValue() == null) {
                    return 0L;
                }
                boundValue = constantDesc.getValue().toString();
                upperBound = udf instanceof GenericUDFOPEqualOrLessThan || udf instanceof GenericUDFOPLessThan;
                closedBound = this.isClosedBound(udf);
            } else if (genFunc.getChildren().get(1) instanceof ExprNodeColumnDesc && genFunc.getChildren().get(0) instanceof ExprNodeConstantDesc) {
                columnDesc = (ExprNodeColumnDesc)genFunc.getChildren().get(1);
                ExprNodeConstantDesc constantDesc = (ExprNodeConstantDesc)genFunc.getChildren().get(0);
                aspCtx.addAffectedColumn(columnDesc);
                if (constantDesc.getValue() == null) {
                    return 0L;
                }
                boundValue = constantDesc.getValue().toString();
                upperBound = udf instanceof GenericUDFOPEqualOrGreaterThan || udf instanceof GenericUDFOPGreaterThan;
                closedBound = this.isClosedBound(udf);
            } else {
                return numRows / 3L;
            }
            ColStatistics cs = stats.getColumnStatisticsFromColName(columnDesc.getColumn());
            if (cs != null && cs.getRange() != null && cs.getRange().maxValue != null && cs.getRange().minValue != null) {
                String colTypeLowerCase = columnDesc.getTypeString().toLowerCase();
                try {
                    if (colTypeLowerCase.equals("tinyint")) {
                        byte value = Byte.parseByte(boundValue);
                        byte maxValue = cs.getRange().maxValue.byteValue();
                        byte minValue = cs.getRange().minValue.byteValue();
                        if (upperBound) {
                            if (maxValue < value || maxValue == value && closedBound) {
                                return numRows;
                            }
                            if (minValue > value || minValue == value && !closedBound) {
                                return 0L;
                            }
                            if (aspCtx.isUniformWithinRange()) {
                                return Math.round((double)(value - minValue) / (double)(maxValue - minValue) * (double)numRows);
                            }
                        } else {
                            if (minValue > value || minValue == value && closedBound) {
                                return numRows;
                            }
                            if (maxValue < value || maxValue == value && !closedBound) {
                                return 0L;
                            }
                            if (aspCtx.isUniformWithinRange()) {
                                return Math.round((double)(maxValue - value) / (double)(maxValue - minValue) * (double)numRows);
                            }
                        }
                    } else if (colTypeLowerCase.equals("smallint")) {
                        short value = Short.parseShort(boundValue);
                        short maxValue = cs.getRange().maxValue.shortValue();
                        short minValue = cs.getRange().minValue.shortValue();
                        if (upperBound) {
                            if (maxValue < value || maxValue == value && closedBound) {
                                return numRows;
                            }
                            if (minValue > value || minValue == value && !closedBound) {
                                return 0L;
                            }
                            if (aspCtx.isUniformWithinRange()) {
                                return Math.round((double)(value - minValue) / (double)(maxValue - minValue) * (double)numRows);
                            }
                        } else {
                            if (minValue > value || minValue == value && closedBound) {
                                return numRows;
                            }
                            if (maxValue < value || maxValue == value && !closedBound) {
                                return 0L;
                            }
                            if (aspCtx.isUniformWithinRange()) {
                                return Math.round((double)(maxValue - value) / (double)(maxValue - minValue) * (double)numRows);
                            }
                        }
                    } else if (colTypeLowerCase.equals("int") || colTypeLowerCase.equals("date")) {
                        int value;
                        if (colTypeLowerCase.equals("date")) {
                            DateWritable writableVal = new DateWritable(Date.valueOf(boundValue));
                            value = writableVal.getDays();
                        } else {
                            value = Integer.parseInt(boundValue);
                        }
                        int maxValue = cs.getRange().maxValue.intValue();
                        int minValue = cs.getRange().minValue.intValue();
                        if (upperBound) {
                            if (maxValue < value || maxValue == value && closedBound) {
                                return numRows;
                            }
                            if (minValue > value || minValue == value && !closedBound) {
                                return 0L;
                            }
                            if (aspCtx.isUniformWithinRange()) {
                                return Math.round((double)(value - minValue) / (double)(maxValue - minValue) * (double)numRows);
                            }
                        } else {
                            if (minValue > value || minValue == value && closedBound) {
                                return numRows;
                            }
                            if (maxValue < value || maxValue == value && !closedBound) {
                                return 0L;
                            }
                            if (aspCtx.isUniformWithinRange()) {
                                return Math.round((double)(maxValue - value) / (double)(maxValue - minValue) * (double)numRows);
                            }
                        }
                    } else if (colTypeLowerCase.equals("bigint") || colTypeLowerCase.equals("timestamp")) {
                        long value;
                        if (colTypeLowerCase.equals("timestamp")) {
                            TimestampWritableV2 timestampWritable = new TimestampWritableV2(Timestamp.valueOf((String)boundValue));
                            value = timestampWritable.getTimestamp().toEpochSecond();
                        } else {
                            value = Long.parseLong(boundValue);
                        }
                        long maxValue = cs.getRange().maxValue.longValue();
                        long minValue = cs.getRange().minValue.longValue();
                        if (upperBound) {
                            if (maxValue < value || maxValue == value && closedBound) {
                                return numRows;
                            }
                            if (minValue > value || minValue == value && !closedBound) {
                                return 0L;
                            }
                            if (aspCtx.isUniformWithinRange()) {
                                return Math.round((double)(value - minValue) / (double)(maxValue - minValue) * (double)numRows);
                            }
                        } else {
                            if (minValue > value || minValue == value && closedBound) {
                                return numRows;
                            }
                            if (maxValue < value || maxValue == value && !closedBound) {
                                return 0L;
                            }
                            if (aspCtx.isUniformWithinRange()) {
                                return Math.round((double)(maxValue - value) / (double)(maxValue - minValue) * (double)numRows);
                            }
                        }
                    } else if (colTypeLowerCase.equals("float")) {
                        float value = Float.parseFloat(boundValue);
                        float maxValue = cs.getRange().maxValue.floatValue();
                        float minValue = cs.getRange().minValue.floatValue();
                        if (upperBound) {
                            if (maxValue < value || maxValue == value && closedBound) {
                                return numRows;
                            }
                            if (minValue > value || minValue == value && !closedBound) {
                                return 0L;
                            }
                            if (aspCtx.isUniformWithinRange()) {
                                return Math.round((double)(value - minValue) / (double)(maxValue - minValue) * (double)numRows);
                            }
                        } else {
                            if (minValue > value || minValue == value && closedBound) {
                                return numRows;
                            }
                            if (maxValue < value || maxValue == value && !closedBound) {
                                return 0L;
                            }
                            if (aspCtx.isUniformWithinRange()) {
                                return Math.round((double)(maxValue - value) / (double)(maxValue - minValue) * (double)numRows);
                            }
                        }
                    } else if (colTypeLowerCase.equals("double")) {
                        double value = Double.parseDouble(boundValue);
                        double maxValue = cs.getRange().maxValue.doubleValue();
                        double minValue = cs.getRange().minValue.doubleValue();
                        if (upperBound) {
                            if (maxValue < value || maxValue == value && closedBound) {
                                return numRows;
                            }
                            if (minValue > value || minValue == value && !closedBound) {
                                return 0L;
                            }
                            if (aspCtx.isUniformWithinRange()) {
                                return Math.round((value - minValue) / (maxValue - minValue) * (double)numRows);
                            }
                        } else {
                            if (minValue > value || minValue == value && closedBound) {
                                return numRows;
                            }
                            if (maxValue < value || maxValue == value && !closedBound) {
                                return 0L;
                            }
                            if (aspCtx.isUniformWithinRange()) {
                                return Math.round((maxValue - value) / (maxValue - minValue) * (double)numRows);
                            }
                        }
                    } else if (colTypeLowerCase.startsWith("decimal")) {
                        BigDecimal value = new BigDecimal(boundValue);
                        BigDecimal maxValue = new BigDecimal(cs.getRange().maxValue.toString());
                        BigDecimal minValue = new BigDecimal(cs.getRange().minValue.toString());
                        int minComparison = value.compareTo(minValue);
                        int maxComparison = value.compareTo(maxValue);
                        if (upperBound) {
                            if (maxComparison > 0 || maxComparison == 0 && closedBound) {
                                return numRows;
                            }
                            if (minComparison < 0 || minComparison == 0 && !closedBound) {
                                return 0L;
                            }
                            if (aspCtx.isUniformWithinRange()) {
                                return Math.round(value.subtract(minValue).divide(maxValue.subtract(minValue), RoundingMode.UP).multiply(BigDecimal.valueOf(numRows)).doubleValue());
                            }
                        } else {
                            if (minComparison < 0 || minComparison == 0 && closedBound) {
                                return numRows;
                            }
                            if (maxComparison > 0 || maxComparison == 0 && !closedBound) {
                                return 0L;
                            }
                            if (aspCtx.isUniformWithinRange()) {
                                return Math.round(maxValue.subtract(value).divide(maxValue.subtract(minValue), RoundingMode.UP).multiply(BigDecimal.valueOf(numRows)).doubleValue());
                            }
                        }
                    }
                }
                catch (NumberFormatException nfe) {
                    return numRows / 3L;
                }
            }
            return numRows / 3L;
        }

        private boolean isClosedBound(GenericUDF udf) {
            return udf instanceof GenericUDFOPEqualOrGreaterThan || udf instanceof GenericUDFOPEqualOrLessThan;
        }

        private long evaluateChildExpr(Statistics stats, ExprNodeDesc child, AnnotateStatsProcCtx aspCtx, List<String> neededCols, Operator<?> op, long currNumRows) throws SemanticException {
            long numRows = currNumRows;
            if (child instanceof ExprNodeGenericFuncDesc) {
                ExprNodeGenericFuncDesc genFunc = (ExprNodeGenericFuncDesc)child;
                GenericUDF udf = genFunc.getGenericUDF();
                if (udf instanceof GenericUDFOPEqual) {
                    String colName = null;
                    boolean isConst = false;
                    Object prevConst = null;
                    for (ExprNodeDesc leaf : genFunc.getChildren()) {
                        if (leaf instanceof ExprNodeConstantDesc) {
                            if (isConst) {
                                if (prevConst != null && !prevConst.equals(((ExprNodeConstantDesc)leaf).getValue())) {
                                    return 0L;
                                }
                                return numRows;
                            }
                            if (colName == null) {
                                isConst = true;
                                prevConst = ((ExprNodeConstantDesc)leaf).getValue();
                                continue;
                            }
                            if (neededCols != null && !neededCols.contains(colName)) {
                                return numRows;
                            }
                            ColStatistics cs = stats.getColumnStatisticsFromColName(colName);
                            if (cs == null) continue;
                            long dvs = cs.getCountDistint();
                            numRows = dvs == 0L ? numRows / 2L : Math.round((double)numRows / (double)dvs);
                            return numRows;
                        }
                        if (!(leaf instanceof ExprNodeColumnDesc)) continue;
                        ExprNodeColumnDesc colDesc = (ExprNodeColumnDesc)leaf;
                        aspCtx.addAffectedColumn(colDesc);
                        colName = colDesc.getColumn();
                        if (!isConst) continue;
                        if (neededCols != null && neededCols.indexOf(colName) == -1) {
                            return numRows;
                        }
                        ColStatistics cs = stats.getColumnStatisticsFromColName(colName);
                        if (cs == null) continue;
                        long dvs = cs.getCountDistint();
                        numRows = dvs == 0L ? numRows / 2L : Math.round((double)numRows / (double)dvs);
                        return numRows;
                    }
                } else {
                    if (udf instanceof GenericUDFOPNotEqual) {
                        return numRows;
                    }
                    if (udf instanceof GenericUDFOPEqualOrGreaterThan || udf instanceof GenericUDFOPEqualOrLessThan || udf instanceof GenericUDFOPGreaterThan || udf instanceof GenericUDFOPLessThan) {
                        return this.evaluateComparator(stats, aspCtx, genFunc, numRows);
                    }
                    if (udf instanceof GenericUDFOPNotNull) {
                        return this.evaluateNotNullExpr(stats, aspCtx, genFunc, numRows);
                    }
                    if (udf instanceof GenericUDFOPNull) {
                        return this.evaluateColEqualsNullExpr(stats, aspCtx, genFunc, numRows);
                    }
                    if (udf instanceof GenericUDFOPAnd || udf instanceof GenericUDFOPOr || udf instanceof GenericUDFIn || udf instanceof GenericUDFBetween || udf instanceof GenericUDFOPNot) {
                        return this.evaluateExpression(stats, genFunc, aspCtx, neededCols, op, numRows);
                    }
                    if (udf instanceof GenericUDFInBloomFilter && genFunc.getChildren().get(1) instanceof ExprNodeDynamicValueDesc) {
                        return numRows;
                    }
                }
            } else if (child instanceof ExprNodeConstantDesc) {
                if (Boolean.FALSE.equals(((ExprNodeConstantDesc)child).getValue())) {
                    return 0L;
                }
                return numRows;
            }
            return numRows / 2L;
        }

        private static class ValuePruner {
            private boolean valid;
            private RangeOps colRange;

            ValuePruner(ColStatistics colStatistics) {
                if (colStatistics == null) {
                    this.valid = false;
                    return;
                }
                this.colRange = RangeOps.build(colStatistics.getColumnType(), colStatistics.getRange());
                if (this.colRange == null) {
                    this.valid = false;
                    return;
                }
                this.valid = true;
            }

            public boolean isValid() {
                return this.valid;
            }

            public boolean accept(ExprNodeDesc.ExprNodeDescEqualityWrapper e) {
                return !this.valid || this.colRange.contains(e.getExprNodeDesc());
            }
        }

        static class RangeOps {
            private String colType;
            private ColStatistics.Range range;

            public RangeOps(String colType, ColStatistics.Range range) {
                this.colType = colType;
                this.range = range;
            }

            public static RangeOps build(String colType, ColStatistics.Range range) {
                if (range == null || range.minValue == null || range.maxValue == null) {
                    return null;
                }
                return new RangeOps(colType, range);
            }

            public boolean contains(ExprNodeDesc exprNode) {
                RangeResult intersection = this.intersect(exprNode);
                return intersection != RangeResult.ABOVE && intersection != RangeResult.BELOW;
            }

            public RangeResult intersect(ExprNodeDesc exprNode) {
                if (!(exprNode instanceof ExprNodeConstantDesc)) {
                    return null;
                }
                try {
                    String stringVal;
                    ExprNodeConstantDesc constantDesc = (ExprNodeConstantDesc)exprNode;
                    String boundValue = stringVal = constantDesc.getValue().toString();
                    switch (this.colType) {
                        case "tinyint": {
                            byte value = Byte.parseByte(stringVal);
                            byte maxValue = this.range.maxValue.byteValue();
                            byte minValue = this.range.minValue.byteValue();
                            return RangeResult.of(value < minValue, value < maxValue, value == minValue, value == maxValue);
                        }
                        case "smallint": {
                            short value = Short.parseShort(boundValue);
                            short maxValue = this.range.maxValue.shortValue();
                            short minValue = this.range.minValue.shortValue();
                            return RangeResult.of(value < minValue, value < maxValue, value == minValue, value == maxValue);
                        }
                        case "date": {
                            DateWritable dateWriteable = new DateWritable(Date.valueOf(boundValue));
                            int value = dateWriteable.getDays();
                            int maxValue = this.range.maxValue.intValue();
                            int minValue = this.range.minValue.intValue();
                            return RangeResult.of(value < minValue, value < maxValue, value == minValue, value == maxValue);
                        }
                        case "int": {
                            int value = Integer.parseInt(boundValue);
                            int maxValue = this.range.maxValue.intValue();
                            int minValue = this.range.minValue.intValue();
                            return RangeResult.of(value < minValue, value < maxValue, value == minValue, value == maxValue);
                        }
                        case "timestamp": {
                            TimestampWritableV2 timestampWritable = new TimestampWritableV2(Timestamp.valueOf((String)boundValue));
                            long value = timestampWritable.getTimestamp().toEpochSecond();
                            long maxValue = this.range.maxValue.longValue();
                            long minValue = this.range.minValue.longValue();
                            return RangeResult.of(value < minValue, value < maxValue, value == minValue, value == maxValue);
                        }
                        case "bigint": {
                            long value = Long.parseLong(boundValue);
                            long maxValue = this.range.maxValue.longValue();
                            long minValue = this.range.minValue.longValue();
                            return RangeResult.of(value < minValue, value < maxValue, value == minValue, value == maxValue);
                        }
                        case "float": {
                            float value = Float.parseFloat(boundValue);
                            float maxValue = this.range.maxValue.floatValue();
                            float minValue = this.range.minValue.floatValue();
                            return RangeResult.of(value < minValue, value < maxValue, value == minValue, value == maxValue);
                        }
                        case "double": {
                            double value = Double.parseDouble(boundValue);
                            double maxValue = this.range.maxValue.doubleValue();
                            double minValue = this.range.minValue.doubleValue();
                            return RangeResult.of(value < minValue, value < maxValue, value == minValue, value == maxValue);
                        }
                    }
                    if (this.colType.startsWith("decimal")) {
                        BigDecimal value = new BigDecimal(boundValue);
                        BigDecimal maxValue = new BigDecimal(this.range.maxValue.toString());
                        BigDecimal minValue = new BigDecimal(this.range.minValue.toString());
                        int minComparison = value.compareTo(minValue);
                        int maxComparison = value.compareTo(maxValue);
                        return RangeResult.of(minComparison < 0, maxComparison < 0, minComparison == 0, maxComparison == 0);
                    }
                    return null;
                }
                catch (Exception e) {
                    return null;
                }
            }

            static enum RangeResult {
                BELOW,
                AT_MIN,
                BETWEEN,
                AT_MAX,
                ABOVE;


                public static RangeResult of(boolean ltMin, boolean ltMax, boolean eqMin, boolean eqMax) {
                    if (ltMin) {
                        return BELOW;
                    }
                    if (eqMin) {
                        return AT_MIN;
                    }
                    if (ltMax) {
                        return BETWEEN;
                    }
                    if (eqMax) {
                        return AT_MAX;
                    }
                    return ABOVE;
                }
            }
        }
    }

    public static class SelectStatsRule
    extends DefaultStatsRule
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            SelectOperator sop = (SelectOperator)nd;
            Operator<OperatorDesc> parent = sop.getParentOperators().get(0);
            Statistics parentStats = parent.getStatistics();
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            HiveConf conf = aspCtx.getConf();
            Statistics stats = null;
            if (parentStats != null) {
                stats = parentStats.clone();
            }
            if (StatsRulesProcFactory.satisfyPrecondition(parentStats)) {
                List<ColStatistics> colStats = StatsUtils.getColStatisticsFromExprMap(conf, parentStats, sop.getColumnExprMap(), sop.getSchema());
                stats.setColumnStats(colStats);
                if (!((SelectDesc)sop.getConf()).isSelectStar() && !((SelectDesc)sop.getConf()).isSelStarNoCompute()) {
                    long dataSize = StatsUtils.getDataSizeFromColumnStats(stats.getNumRows(), colStats);
                    stats.setDataSize(dataSize);
                }
                stats = StatsRulesProcFactory.applyRuntimeStats(aspCtx.getParseContext().getContext(), stats, sop);
                sop.setStatistics(stats);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[0] STATS-" + sop.toString() + ": " + stats.extendedToString());
                }
            } else if (parentStats != null) {
                stats = StatsRulesProcFactory.applyRuntimeStats(aspCtx.getParseContext().getContext(), stats, sop);
                sop.setStatistics(stats);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[1] STATS-" + sop.toString() + ": " + parentStats.extendedToString());
                }
            }
            return null;
        }
    }

    public static class TableScanStatsRule
    extends DefaultStatsRule
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            TableScanOperator tsop = (TableScanOperator)nd;
            AnnotateStatsProcCtx aspCtx = (AnnotateStatsProcCtx)procCtx;
            PrunedPartitionList partList = aspCtx.getParseContext().getPrunedPartitions(tsop);
            ColumnStatsList colStatsCached = aspCtx.getParseContext().getColStatsCached(partList);
            Table table = ((TableScanDesc)tsop.getConf()).getTableMetadata();
            try {
                Statistics stats = StatsUtils.collectStatistics(aspCtx.getConf(), partList, colStatsCached, table, tsop);
                stats = StatsRulesProcFactory.applyRuntimeStats(aspCtx.getParseContext().getContext(), stats, tsop);
                tsop.setStatistics(stats);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("[0] STATS-" + tsop.toString() + " (" + table.getTableName() + "): " + stats.extendedToString());
                }
            }
            catch (HiveException e) {
                LOG.debug("Failed to retrieve stats ", (Throwable)e);
                throw new SemanticException((Throwable)e);
            }
            return null;
        }
    }
}

