/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.spark;

import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.optimizer.AbstractSMBJoinProc;
import org.apache.hadoop.hive.ql.optimizer.SortBucketJoinProcCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.spark.OptimizeSparkProcContext;

public class SparkSortMergeJoinOptimizer
extends AbstractSMBJoinProc
implements SemanticNodeProcessor {
    public SparkSortMergeJoinOptimizer(ParseContext pctx) {
        super(pctx);
    }

    public SparkSortMergeJoinOptimizer() {
    }

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
        JoinOperator joinOp = (JoinOperator)nd;
        HiveConf conf = ((OptimizeSparkProcContext)procCtx).getParseContext().getConf();
        if (!conf.getBoolVar(HiveConf.ConfVars.HIVE_AUTO_SORTMERGE_JOIN)) {
            return null;
        }
        SortBucketJoinProcCtx smbJoinContext = new SortBucketJoinProcCtx(conf);
        boolean convert = this.canConvertJoinToSMBJoin(joinOp, smbJoinContext, this.pGraphContext, stack);
        if (convert) {
            return this.convertJoinToSMBJoinAndReturn(joinOp, smbJoinContext);
        }
        return null;
    }

    protected boolean canConvertJoinToSMBJoin(JoinOperator joinOperator, SortBucketJoinProcCtx smbJoinContext, ParseContext pGraphContext, Stack<Node> stack) throws SemanticException {
        if (!this.supportBucketMapJoin(stack)) {
            return false;
        }
        return this.canConvertJoinToSMBJoin(joinOperator, smbJoinContext);
    }

    private boolean supportBucketMapJoin(Stack<Node> stack) {
        int size = stack.size();
        if (!(stack.get(size - 1) instanceof JoinOperator) || !(stack.get(size - 2) instanceof ReduceSinkOperator)) {
            return false;
        }
        for (int pos = size - 3; pos >= 0; --pos) {
            Operator op = (Operator)stack.get(pos);
            if (op.supportAutomaticSortMergeJoin()) continue;
            return false;
        }
        return true;
    }

    protected SMBMapJoinOperator convertJoinToSMBJoinAndReturn(JoinOperator joinOp, SortBucketJoinProcCtx smbJoinContext) throws SemanticException {
        MapJoinOperator mapJoinOp = this.convertJoinToBucketMapJoin(joinOp, smbJoinContext);
        SMBMapJoinOperator smbMapJoinOp = this.convertBucketMapJoinToSMBJoin(mapJoinOp, smbJoinContext);
        smbMapJoinOp.setConvertedAutomaticallySMBJoin(true);
        return smbMapJoinOp;
    }
}

