/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.spark;

import com.clearspring.analytics.util.Preconditions;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.optimizer.AbstractSMBJoinProc;
import org.apache.hadoop.hive.ql.optimizer.SortBucketJoinProcCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;

public class SparkSMBJoinHintOptimizer
extends AbstractSMBJoinProc
implements SemanticNodeProcessor {
    public SparkSMBJoinHintOptimizer(ParseContext pctx) {
        super(pctx);
    }

    public SparkSMBJoinHintOptimizer() {
    }

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
        MapJoinOperator mapJoinOp = (MapJoinOperator)nd;
        SortBucketJoinProcCtx smbJoinContext = (SortBucketJoinProcCtx)procCtx;
        boolean convert = this.canConvertBucketMapJoinToSMBJoin(mapJoinOp, stack, smbJoinContext, nodeOutputs);
        if (!convert && this.pGraphContext.getConf().getBoolVar(HiveConf.ConfVars.HIVEENFORCESORTMERGEBUCKETMAPJOIN)) {
            throw new SemanticException(ErrorMsg.SORTMERGE_MAPJOIN_FAILED.getMsg());
        }
        if (convert) {
            this.removeSmallTableReduceSink(mapJoinOp);
            this.convertBucketMapJoinToSMBJoin(mapJoinOp, smbJoinContext);
        }
        return null;
    }

    private void removeSmallTableReduceSink(MapJoinOperator mapJoinOp) {
        SMBJoinDesc smbJoinDesc = new SMBJoinDesc((MapJoinDesc)mapJoinOp.getConf());
        List<Operator<OperatorDesc>> parentOperators = mapJoinOp.getParentOperators();
        for (int i = 0; i < parentOperators.size(); ++i) {
            Operator<OperatorDesc> par = parentOperators.get(i);
            if (i == smbJoinDesc.getPosBigTable() || !(par instanceof ReduceSinkOperator)) continue;
            List<Operator<OperatorDesc>> grandParents = par.getParentOperators();
            Preconditions.checkArgument((grandParents.size() == 1 ? 1 : 0) != 0, (String)("AssertionError: expect # of parents to be 1, but was " + grandParents.size()), (Object[])new Object[0]);
            Operator<OperatorDesc> grandParent = grandParents.get(0);
            grandParent.removeChild(par);
            grandParent.setChildOperators(Utilities.makeList(mapJoinOp));
            mapJoinOp.getParentOperators().set(i, grandParent);
        }
    }
}

