/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.spark;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.spark.SparkUtilities;
import org.apache.hadoop.hive.ql.optimizer.signature.Signature;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.Explain;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;

@Explain(displayName="Spark Partition Pruning Sink Operator")
public class SparkPartitionPruningSinkDesc
extends AbstractOperatorDesc {
    private List<DPPTargetInfo> targetInfos = new ArrayList<DPPTargetInfo>();
    private TableDesc table;
    private Path path;

    public List<DPPTargetInfo> getTargetInfos() {
        return this.targetInfos;
    }

    public void addTarget(String colName, String colType, ExprNodeDesc partKey, MapWork mapWork, TableScanOperator tableScan) {
        this.targetInfos.add(new DPPTargetInfo(colName, colType, partKey, mapWork, tableScan));
    }

    public Path getTmpPathOfTargetWork() {
        return this.targetInfos.isEmpty() ? null : this.targetInfos.get((int)0).work.getTmpPathForPartitionPruning();
    }

    @Explain(displayName="tmp Path", explainLevels={Explain.Level.EXTENDED})
    public Path getPath() {
        return this.path;
    }

    public void setPath(Path path) {
        this.path = path;
    }

    public String getTargetWorks() {
        return Arrays.toString(this.targetInfos.stream().map(info -> info.work.getName()).toArray());
    }

    public String getTableScanNames() {
        return Arrays.toString(this.targetInfos.stream().map(info -> info.tableScan.getName()).toArray());
    }

    @Signature
    public TableDesc getTable() {
        return this.table;
    }

    public void setTable(TableDesc table) {
        this.table = table;
    }

    @Explain(displayName="Target Columns")
    public String displayTargetColumns() {
        TreeMap<String, List> map = new TreeMap<String, List>();
        for (DPPTargetInfo info : this.targetInfos) {
            List columns = map.computeIfAbsent(info.work.getName(), v -> new ArrayList());
            String name = info.columnName.substring(info.columnName.indexOf(58) + 1);
            columns.add(name + ":" + info.columnType + " (" + info.partKey.getExprString() + ")");
        }
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        for (String work : map.keySet()) {
            if (builder.length() > 1) {
                builder.append(", ");
            }
            builder.append(work).append(" -> ").append(map.get(work));
        }
        builder.append("]");
        return builder.toString();
    }

    @Override
    public boolean isSame(OperatorDesc other) {
        if (this.getClass().getName().equals(other.getClass().getName())) {
            SparkPartitionPruningSinkDesc otherDesc = (SparkPartitionPruningSinkDesc)other;
            return this.getTable().equals(otherDesc.getTable());
        }
        return false;
    }

    public void removeTarget(String name) {
        ArrayList<DPPTargetInfo> toRemove = new ArrayList<DPPTargetInfo>();
        for (DPPTargetInfo targetInfo : this.targetInfos) {
            if (!targetInfo.work.getName().equals(name)) continue;
            toRemove.add(targetInfo);
        }
        this.targetInfos.removeAll(toRemove);
    }

    public static String colNameWithTargetId(MapWork target, String colName) {
        return SparkUtilities.getWorkId(target) + ":" + colName;
    }

    public static String stripOffTargetId(String name) {
        int idx = name.indexOf(":");
        if (idx != -1) {
            return name.substring(idx + 1);
        }
        return name;
    }

    public static class DPPTargetInfo {
        public String columnName;
        public String columnType;
        public ExprNodeDesc partKey;
        public MapWork work;
        public transient TableScanOperator tableScan;

        DPPTargetInfo(String columnName, String columnType, ExprNodeDesc partKey, MapWork work, TableScanOperator tableScan) {
            this.columnName = columnName;
            this.columnType = columnType;
            this.partKey = partKey;
            this.work = work;
            this.tableScan = tableScan;
        }
    }
}

