/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.spark;

import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.optimizer.spark.SparkMapJoinOptimizer;
import org.apache.hadoop.hive.ql.optimizer.spark.SparkSortMergeJoinOptimizer;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.spark.OptimizeSparkProcContext;

public class SparkJoinOptimizer
implements SemanticNodeProcessor {
    private SparkSortMergeJoinOptimizer smbJoinOptimizer;
    private SparkMapJoinOptimizer mapJoinOptimizer;

    public SparkJoinOptimizer(ParseContext procCtx) {
        this.smbJoinOptimizer = new SparkSortMergeJoinOptimizer(procCtx);
        this.mapJoinOptimizer = new SparkMapJoinOptimizer();
    }

    @Override
    public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
        OptimizeSparkProcContext context = (OptimizeSparkProcContext)procCtx;
        HiveConf conf = context.getConf();
        if (conf.getBoolVar(HiveConf.ConfVars.HIVE_AUTO_SORTMERGE_JOIN_TOMAPJOIN)) {
            Object mapJoinOp = this.mapJoinOptimizer.process(nd, stack, procCtx, nodeOutputs);
            if (mapJoinOp == null) {
                this.smbJoinOptimizer.process(nd, stack, procCtx, nodeOutputs);
            }
        } else {
            Object sortMergeJoinOp = this.smbJoinOptimizer.process(nd, stack, procCtx, nodeOutputs);
            if (sortMergeJoinOp == null) {
                this.mapJoinOptimizer.process(nd, stack, procCtx, nodeOutputs);
            }
        }
        return null;
    }
}

