/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.optimizer.physical.MetadataOnlyOptimizer;
import org.apache.hadoop.hive.ql.optimizer.physical.NullScanTaskDispatcher;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NullScanOptimizer
implements PhysicalPlanResolver {
    private static final Logger LOG = LoggerFactory.getLogger(NullScanOptimizer.class);

    @Override
    public PhysicalContext resolve(PhysicalContext pctx) throws SemanticException {
        LinkedHashMap<SemanticRule, SemanticNodeProcessor> opRules = new LinkedHashMap<SemanticRule, SemanticNodeProcessor>();
        opRules.put(new RuleRegExp("R1", TableScanOperator.getOperatorName() + "%.*" + FilterOperator.getOperatorName() + "%"), new WhereFalseProcessor());
        NullScanTaskDispatcher disp = new NullScanTaskDispatcher(pctx, opRules);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>(pctx.getRootTasks());
        ogw.startWalking(topNodes, null);
        opRules.clear();
        opRules.put(new RuleRegExp("R1", TableScanOperator.getOperatorName() + "%"), new TSMarker());
        opRules.put(new RuleRegExp("R2", LimitOperator.getOperatorName() + "%"), new Limit0Processor());
        disp = new NullScanTaskDispatcher(pctx, opRules);
        ogw = new DefaultGraphWalker(disp);
        topNodes = new ArrayList(pctx.getRootTasks());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    private static boolean isNullOpPresentInAllBranches(TableScanOperator ts, Node causeOfNullNode) {
        ArrayDeque<Node> middleNodes = new ArrayDeque<Node>();
        middleNodes.add(ts);
        while (!middleNodes.isEmpty()) {
            Node curNode = (Node)middleNodes.remove();
            List curChd = curNode.getChildren();
            for (Node chd : curChd) {
                List children = chd.getChildren();
                if (CollectionUtils.isEmpty((Collection)children) || chd == causeOfNullNode) {
                    if (chd == causeOfNullNode) continue;
                    return false;
                }
                middleNodes.add(chd);
            }
        }
        return true;
    }

    private static class TSMarker
    implements SemanticNodeProcessor {
        private TSMarker() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ((MetadataOnlyOptimizer.WalkerCtx)procCtx).setMayBeMetadataOnly((TableScanOperator)nd);
            return null;
        }
    }

    private static class Limit0Processor
    implements SemanticNodeProcessor {
        private Limit0Processor() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            LimitOperator limitOp = (LimitOperator)nd;
            if (((LimitDesc)limitOp.getConf()).getLimit() != 0) {
                return null;
            }
            HashSet<TableScanOperator> tsOps = ((MetadataOnlyOptimizer.WalkerCtx)procCtx).getMayBeMetadataOnlyTableScans();
            if (tsOps != null) {
                Iterator tsOp = tsOps.iterator();
                while (tsOp.hasNext()) {
                    if (NullScanOptimizer.isNullOpPresentInAllBranches((TableScanOperator)tsOp.next(), limitOp)) continue;
                    tsOp.remove();
                }
            }
            LOG.debug("Found Limit 0 TableScan. {}", (Object)nd);
            ((MetadataOnlyOptimizer.WalkerCtx)procCtx).convertMetadataOnly();
            return null;
        }
    }

    private static class WhereFalseProcessor
    implements SemanticNodeProcessor {
        private WhereFalseProcessor() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            FilterOperator filter = (FilterOperator)nd;
            ExprNodeDesc condition = ((FilterDesc)filter.getConf()).getPredicate();
            if (!(condition instanceof ExprNodeConstantDesc)) {
                return null;
            }
            ExprNodeConstantDesc c = (ExprNodeConstantDesc)condition;
            if (!Boolean.FALSE.equals(c.getValue())) {
                return null;
            }
            MetadataOnlyOptimizer.WalkerCtx ctx = (MetadataOnlyOptimizer.WalkerCtx)procCtx;
            for (Node op : stack) {
                if (!(op instanceof TableScanOperator) || !NullScanOptimizer.isNullOpPresentInAllBranches((TableScanOperator)op, filter)) continue;
                ctx.setMayBeMetadataOnly((TableScanOperator)op);
                LOG.debug("Found where false TableScan. {}", (Object)op);
            }
            ctx.convertMetadataOnly();
            return null;
        }
    }
}

