/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.MapredLocalTask;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.SemanticDispatcher;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.lib.TaskGraphWalker;
import org.apache.hadoop.hive.ql.optimizer.physical.LocalMapJoinProcFactory;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalPlanResolver;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ConditionalResolver;
import org.apache.hadoop.hive.ql.plan.ConditionalResolverCommonJoin;
import org.apache.hadoop.hive.ql.plan.ConditionalResolverSkewJoin;
import org.apache.hadoop.hive.ql.plan.ConditionalWork;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class MapJoinResolver
implements PhysicalPlanResolver {
    @Override
    public PhysicalContext resolve(PhysicalContext pctx) throws SemanticException {
        LocalMapJoinTaskDispatcher disp = new LocalMapJoinTaskDispatcher(pctx);
        TaskGraphWalker ogw = new TaskGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getRootTasks());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    public static class LocalMapJoinProcCtx
    implements NodeProcessorCtx {
        private Task<?> currentTask;
        private ParseContext parseCtx;
        private List<Operator<? extends OperatorDesc>> dummyParentOp = null;
        private boolean isFollowedByGroupBy;
        private Map<MapJoinOperator, List<Operator<? extends OperatorDesc>>> directWorks;

        public LocalMapJoinProcCtx(Task<?> task, ParseContext parseCtx) {
            this.currentTask = task;
            this.parseCtx = parseCtx;
            this.dummyParentOp = new ArrayList<Operator<? extends OperatorDesc>>();
            this.directWorks = new HashMap<MapJoinOperator, List<Operator<? extends OperatorDesc>>>();
            this.isFollowedByGroupBy = false;
        }

        public Task<?> getCurrentTask() {
            return this.currentTask;
        }

        public void setCurrentTask(Task<?> currentTask) {
            this.currentTask = currentTask;
        }

        public boolean isFollowedByGroupBy() {
            return this.isFollowedByGroupBy;
        }

        public void setFollowedByGroupBy(boolean isFollowedByGroupBy) {
            this.isFollowedByGroupBy = isFollowedByGroupBy;
        }

        public ParseContext getParseCtx() {
            return this.parseCtx;
        }

        public void setParseCtx(ParseContext parseCtx) {
            this.parseCtx = parseCtx;
        }

        public void setDummyParentOp(List<Operator<? extends OperatorDesc>> op) {
            this.dummyParentOp = op;
        }

        public List<Operator<? extends OperatorDesc>> getDummyParentOp() {
            return this.dummyParentOp;
        }

        public void addDummyParentOp(Operator<? extends OperatorDesc> op) {
            this.dummyParentOp.add(op);
        }

        public void setDirectWorks(Map<MapJoinOperator, List<Operator<? extends OperatorDesc>>> directWorks) {
            this.directWorks = directWorks;
        }

        public Map<MapJoinOperator, List<Operator<? extends OperatorDesc>>> getDirectWorks() {
            return this.directWorks;
        }

        public void addDirectWorks(MapJoinOperator mapJoinOp, List<Operator<? extends OperatorDesc>> directOperators) {
            this.directWorks.put(mapJoinOp, directOperators);
        }
    }

    class LocalMapJoinTaskDispatcher
    implements SemanticDispatcher {
        private PhysicalContext physicalContext;

        public LocalMapJoinTaskDispatcher(PhysicalContext context) {
            this.physicalContext = context;
        }

        private void processCurrentTask(Task<?> currTask, ConditionalTask conditionalTask) throws SemanticException {
            MapredWork mapredWork = (MapredWork)currTask.getWork();
            MapredLocalWork localwork = mapredWork.getMapWork().getMapRedLocalWork();
            if (localwork != null) {
                Context ctx = this.physicalContext.getContext();
                Path tmpPath = Utilities.generateTmpPath(ctx.getLocalTmpPath(), currTask.getId());
                localwork.setTmpPath(tmpPath);
                mapredWork.getMapWork().setTmpHDFSPath(Utilities.generateTmpPath(ctx.getMRTmpPath(), currTask.getId()));
                MapredLocalTask localTask = (MapredLocalTask)TaskFactory.get(localwork);
                localTask.setBackupTask(currTask.getBackupTask());
                localTask.setBackupChildrenTasks(currTask.getBackupChildrenTasks());
                currTask.setBackupChildrenTasks(null);
                currTask.setBackupTask(null);
                if (currTask.getTaskTag() == 4) {
                    localTask.setTaskTag(5);
                } else {
                    localTask.setTaskTag(3);
                    currTask.setTaskTag(2);
                }
                LocalMapJoinProcCtx localMapJoinProcCtx = this.adjustLocalTask(localTask);
                List<Operator<? extends OperatorDesc>> dummyOps = localMapJoinProcCtx.getDummyParentOp();
                MapredLocalWork newLocalWork = localwork.extractDirectWorks(localMapJoinProcCtx.getDirectWorks());
                newLocalWork.setDummyParentOp(dummyOps);
                mapredWork.getMapWork().setMapRedLocalWork(newLocalWork);
                if (localwork.getAliasToFetchWork().isEmpty()) {
                    newLocalWork.setHasStagedAlias(false);
                    currTask.setBackupTask(localTask.getBackupTask());
                    currTask.setBackupChildrenTasks(localTask.getBackupChildrenTasks());
                    return;
                }
                newLocalWork.setHasStagedAlias(true);
                List<Task<?>> parentTasks = currTask.getParentTasks();
                currTask.setParentTasks(null);
                if (parentTasks != null) {
                    for (Task<MapredLocalWork> task : parentTasks) {
                        task.addDependentTask(localTask);
                        task.removeDependentTask(currTask);
                    }
                } else if (conditionalTask == null) {
                    this.physicalContext.addToRootTask(localTask);
                    this.physicalContext.removeFromRootTask(currTask);
                } else {
                    List<Task<?>> listTask = conditionalTask.getListTasks();
                    ConditionalWork conditionalWork = (ConditionalWork)conditionalTask.getWork();
                    int index = listTask.indexOf(currTask);
                    listTask.set(index, localTask);
                    List<? extends Serializable> listWork = conditionalWork.getListWorks();
                    index = listWork.indexOf(mapredWork);
                    listWork.set(index, localwork);
                    conditionalWork.setListWorks(listWork);
                    ConditionalResolver resolver = conditionalTask.getResolver();
                    if (resolver instanceof ConditionalResolverSkewJoin) {
                        ConditionalResolverSkewJoin.ConditionalResolverSkewJoinCtx context = (ConditionalResolverSkewJoin.ConditionalResolverSkewJoinCtx)conditionalTask.getResolverCtx();
                        HashMap<Path, Task<?>> bigKeysDirToTaskMap = context.getDirToTaskMap();
                        HashMap newbigKeysDirToTaskMap = new HashMap();
                        for (Map.Entry<Path, Task<?>> entry : bigKeysDirToTaskMap.entrySet()) {
                            Task<?> task = entry.getValue();
                            Path key = entry.getKey();
                            if (task.equals(currTask)) {
                                newbigKeysDirToTaskMap.put(key, localTask);
                                continue;
                            }
                            newbigKeysDirToTaskMap.put(key, task);
                        }
                        context.setDirToTaskMap(newbigKeysDirToTaskMap);
                        conditionalTask.setResolverCtx(context);
                    } else if (resolver instanceof ConditionalResolverCommonJoin) {
                        ConditionalResolverCommonJoin.ConditionalResolverCommonJoinCtx context = (ConditionalResolverCommonJoin.ConditionalResolverCommonJoinCtx)conditionalTask.getResolverCtx();
                        HashMap<Task<?>, Set<String>> taskToAliases = context.getTaskToAliases();
                        LinkedHashMap newTaskToAliases = new LinkedHashMap();
                        for (Map.Entry<Task<?>, Set<String>> entry : taskToAliases.entrySet()) {
                            Task<?> task = entry.getKey();
                            HashSet key = new HashSet(entry.getValue());
                            if (task.equals(currTask)) {
                                newTaskToAliases.put(localTask, key);
                                continue;
                            }
                            newTaskToAliases.put(task, key);
                        }
                        context.setTaskToAliases(newTaskToAliases);
                        conditionalTask.setResolverCtx(context);
                    }
                }
                localTask.addDependentTask(currTask);
            }
        }

        @Override
        public Object dispatch(Node nd, Stack<Node> stack, Object ... nodeOutputs) throws SemanticException {
            Task currTask = (Task)nd;
            if (currTask.isMapRedTask()) {
                if (currTask instanceof ConditionalTask) {
                    List<Task<?>> taskList = ((ConditionalTask)currTask).getListTasks();
                    for (Task<?> tsk : taskList) {
                        if (!tsk.isMapRedTask()) continue;
                        this.processCurrentTask(tsk, (ConditionalTask)currTask);
                    }
                } else {
                    this.processCurrentTask(currTask, null);
                }
            }
            return null;
        }

        private LocalMapJoinProcCtx adjustLocalTask(MapredLocalTask task) throws SemanticException {
            LocalMapJoinProcCtx localMapJoinProcCtx = new LocalMapJoinProcCtx(task, this.physicalContext.getParseContext());
            LinkedHashMap<SemanticRule, SemanticNodeProcessor> opRules = new LinkedHashMap<SemanticRule, SemanticNodeProcessor>();
            opRules.put(new RuleRegExp("R1", MapJoinOperator.getOperatorName() + "%"), LocalMapJoinProcFactory.getJoinProc());
            DefaultRuleDispatcher disp = new DefaultRuleDispatcher(LocalMapJoinProcFactory.getDefaultProc(), opRules, localMapJoinProcCtx);
            DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
            ArrayList<Node> topNodes = new ArrayList<Node>();
            topNodes.addAll(((MapredLocalWork)task.getWork()).getAliasToWork().values());
            ogw.startWalking(topNodes, null);
            return localMapJoinProcCtx;
        }

        public PhysicalContext getPhysicalContext() {
            return this.physicalContext;
        }

        public void setPhysicalContext(PhysicalContext physicalContext) {
            this.physicalContext = physicalContext;
        }
    }
}

