/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.physical;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.Context;
import org.apache.hadoop.hive.ql.exec.ConditionalTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewForwardOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorUtils;
import org.apache.hadoop.hive.ql.exec.SerializationUtilities;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.MapRedTask;
import org.apache.hadoop.hive.ql.lib.SemanticDispatcher;
import org.apache.hadoop.hive.ql.optimizer.GenMapRedUtils;
import org.apache.hadoop.hive.ql.optimizer.MapJoinProcessor;
import org.apache.hadoop.hive.ql.optimizer.physical.AbstractJoinTaskDispatcher;
import org.apache.hadoop.hive.ql.optimizer.physical.PhysicalContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ConditionalResolverCommonJoin;
import org.apache.hadoop.hive.ql.plan.ConditionalWork;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredLocalWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonJoinTaskDispatcher
extends AbstractJoinTaskDispatcher
implements SemanticDispatcher {
    protected final Logger LOG = LoggerFactory.getLogger(CommonJoinTaskDispatcher.class);
    HashMap<String, Long> aliasToSize = null;

    public CommonJoinTaskDispatcher(PhysicalContext context) {
        super(context);
    }

    private long calculateLocalTableTotalSize(MapredLocalWork localWork) {
        long localTableTotalSize = 0L;
        if (localWork == null) {
            return localTableTotalSize;
        }
        for (String alias : localWork.getAliasToWork().keySet()) {
            Long tabSize = this.aliasToSize.get(alias);
            if (tabSize == null) {
                return -1L;
            }
            localTableTotalSize += tabSize.longValue();
        }
        return localTableTotalSize;
    }

    private boolean isLocalTableTotalSizeUnderLimitAfterMerge(Configuration conf, MapredLocalWork ... localWorks) {
        long localTableTotalSizeLimit = HiveConf.getLongVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASKTHRESHOLD);
        long localTableTotalSize = 0L;
        for (int i = 0; i < localWorks.length; ++i) {
            long localWorkTableTotalSize = this.calculateLocalTableTotalSize(localWorks[i]);
            if (localWorkTableTotalSize < 0L) {
                return false;
            }
            localTableTotalSize += localWorkTableTotalSize;
        }
        return localTableTotalSize <= localTableTotalSizeLimit;
    }

    private MapRedTask convertTaskToMapJoinTask(MapredWork newWork, int bigTablePosition) throws SemanticException {
        MapRedTask newTask = (MapRedTask)TaskFactory.get(newWork);
        JoinOperator newJoinOp = this.getJoinOp(newTask);
        MapJoinProcessor.genMapJoinOpAndLocalWork(this.physicalContext.getParseContext().getConf(), newWork, newJoinOp, bigTablePosition);
        return newTask;
    }

    private void mergeMapJoinTaskIntoItsChildMapRedTask(MapRedTask mapJoinTask, Configuration conf) throws SemanticException {
        if (mapJoinTask.getChildTasks() == null || mapJoinTask.getChildTasks().size() > 1) {
            return;
        }
        Task<?> childTask = mapJoinTask.getChildTasks().get(0);
        if (!(childTask instanceof MapRedTask)) {
            return;
        }
        MapRedTask childMapRedTask = (MapRedTask)childTask;
        MapWork mapJoinMapWork = ((MapredWork)mapJoinTask.getWork()).getMapWork();
        MapWork childMapWork = ((MapredWork)childMapRedTask.getWork()).getMapWork();
        Map<String, Operator<? extends OperatorDesc>> mapJoinAliasToWork = mapJoinMapWork.getAliasToWork();
        if (mapJoinAliasToWork.size() > 1) {
            return;
        }
        Map.Entry<String, Operator<? extends OperatorDesc>> mapJoinAliasToWorkEntry = mapJoinAliasToWork.entrySet().iterator().next();
        String mapJoinAlias = mapJoinAliasToWorkEntry.getKey();
        TableScanOperator mapJoinTaskTableScanOperator = OperatorUtils.findSingleOperator(mapJoinAliasToWorkEntry.getValue(), TableScanOperator.class);
        if (mapJoinTaskTableScanOperator == null) {
            throw new SemanticException("Expected a " + TableScanOperator.getOperatorName() + " operator as the work associated with alias " + mapJoinAlias + ". Found a " + mapJoinAliasToWork.get(mapJoinAlias).getName() + " operator.");
        }
        Set<FileSinkOperator> mapJoinTaskFileSinkOperators = OperatorUtils.findOperators(mapJoinTaskTableScanOperator, FileSinkOperator.class);
        if (mapJoinTaskFileSinkOperators.isEmpty()) {
            throw new SemanticException("Cannot find the " + FileSinkOperator.getOperatorName() + " operator at the last operator of the MapJoin Task.");
        }
        if (mapJoinTaskFileSinkOperators.size() > 1) {
            this.LOG.warn("Multiple " + FileSinkOperator.getOperatorName() + " operators found at the last operator of the MapJoin Task.");
            return;
        }
        FileSinkOperator mapJoinTaskFileSinkOperator = mapJoinTaskFileSinkOperators.iterator().next();
        Path childMRPath = ((FileSinkDesc)mapJoinTaskFileSinkOperator.getConf()).getDirName();
        List<String> childMRAliases = childMapWork.getPathToAliases().get(childMRPath);
        if (childMRAliases == null || childMRAliases.size() != 1) {
            return;
        }
        String childMRAlias = childMRAliases.get(0);
        for (Map.Entry<Path, List<String>> entry : childMapWork.getPathToAliases().entrySet()) {
            Path path = entry.getKey();
            List<String> aliases = entry.getValue();
            if (path.equals((Object)childMRPath) || !aliases.contains(mapJoinAlias)) continue;
            return;
        }
        MapredLocalWork mapJoinLocalWork = mapJoinMapWork.getMapRedLocalWork();
        MapredLocalWork childLocalWork = childMapWork.getMapRedLocalWork();
        if (mapJoinLocalWork != null && mapJoinLocalWork.getBucketMapjoinContext() != null || childLocalWork != null && childLocalWork.getBucketMapjoinContext() != null) {
            return;
        }
        if (!this.isLocalTableTotalSizeUnderLimitAfterMerge(conf, mapJoinLocalWork, childLocalWork)) {
            return;
        }
        TableScanOperator childMRTaskTableScanOperator = OperatorUtils.findSingleOperator(childMapWork.getAliasToWork().get(childMRAlias.toString()), TableScanOperator.class);
        if (childMRTaskTableScanOperator == null) {
            throw new SemanticException("Expected a " + TableScanOperator.getOperatorName() + " operator as the work associated with alias " + childMRAlias + ". Found a " + childMapWork.getAliasToWork().get(childMRAlias).getName() + " operator.");
        }
        List<Operator<OperatorDesc>> parentsInMapJoinTask = mapJoinTaskFileSinkOperator.getParentOperators();
        List<Operator<OperatorDesc>> childrenInChildMRTask = childMRTaskTableScanOperator.getChildOperators();
        if (parentsInMapJoinTask.size() > 1 || childrenInChildMRTask.size() > 1) {
            return;
        }
        Operator<OperatorDesc> parentInMapJoinTask = parentsInMapJoinTask.get(0);
        Operator<OperatorDesc> childInChildMRTask = childrenInChildMRTask.get(0);
        parentInMapJoinTask.replaceChild(mapJoinTaskFileSinkOperator, childInChildMRTask);
        childInChildMRTask.replaceParent(childMRTaskTableScanOperator, parentInMapJoinTask);
        GenMapRedUtils.replaceMapWork(mapJoinAlias, childMRAlias.toString(), mapJoinMapWork, childMapWork);
        if (mapJoinLocalWork != null) {
            if (childLocalWork == null) {
                childMapWork.setMapRedLocalWork(mapJoinLocalWork);
            } else {
                childLocalWork.getAliasToFetchWork().putAll(mapJoinLocalWork.getAliasToFetchWork());
                childLocalWork.getAliasToWork().putAll(mapJoinLocalWork.getAliasToWork());
            }
        }
        List<Task<?>> parentTasks = mapJoinTask.getParentTasks();
        mapJoinTask.setParentTasks(null);
        mapJoinTask.setChildTasks(null);
        childMapRedTask.getParentTasks().remove(mapJoinTask);
        if (parentTasks != null) {
            childMapRedTask.getParentTasks().addAll(parentTasks);
            for (Task<?> parentTask : parentTasks) {
                parentTask.getChildTasks().remove(mapJoinTask);
                if (parentTask.getChildTasks().contains(childMapRedTask)) continue;
                parentTask.getChildTasks().add(childMapRedTask);
            }
        } else if (this.physicalContext.getRootTasks().contains(mapJoinTask)) {
            this.physicalContext.removeFromRootTask(mapJoinTask);
            if (childMapRedTask.getParentTasks() != null && childMapRedTask.getParentTasks().size() == 0 && !this.physicalContext.getRootTasks().contains(childMapRedTask)) {
                this.physicalContext.addToRootTask(childMapRedTask);
            }
        }
        if (childMapRedTask.getParentTasks().size() == 0) {
            childMapRedTask.setParentTasks(null);
        }
    }

    public static boolean cannotConvert(long aliasKnownSize, long aliasTotalKnownInputSize, long ThresholdOfSmallTblSizeSum) {
        return aliasKnownSize > 0L && aliasTotalKnownInputSize - aliasKnownSize > ThresholdOfSmallTblSizeSum;
    }

    @Override
    public Task<?> processCurrentTask(MapRedTask currTask, ConditionalTask conditionalTask, Context context) throws SemanticException {
        JoinOperator joinOp = this.getJoinOp(currTask);
        if (joinOp == null || ((JoinDesc)joinOp.getConf()).isFixedAsSorted()) {
            return null;
        }
        currTask.setTaskTag(1);
        MapWork currWork = ((MapredWork)currTask.getWork()).getMapWork();
        ArrayList listWorks = new ArrayList();
        ArrayList listTasks = new ArrayList();
        LinkedHashMap taskToAliases = new LinkedHashMap();
        Map<Path, List<String>> pathToAliases = currWork.getPathToAliases();
        Map<String, Operator<? extends OperatorDesc>> aliasToWork = currWork.getAliasToWork();
        JoinDesc joinDesc = (JoinDesc)joinOp.getConf();
        if (this.aliasToSize == null) {
            this.aliasToSize = new HashMap();
        }
        try {
            long aliasTotalKnownInputSize = this.getTotalKnownInputSize(context, currWork, pathToAliases, this.aliasToSize);
            Set<Integer> bigTableCandidates = MapJoinProcessor.getBigTableCandidates(joinDesc.getConds());
            if (bigTableCandidates.isEmpty()) {
                return null;
            }
            bigTableCandidates = this.multiInsertBigTableCheck(joinOp, bigTableCandidates);
            Configuration conf = context.getConf();
            boolean convertJoinMapJoin = HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASK);
            int bigTablePosition = -1;
            if (convertJoinMapJoin) {
                long mapJoinSize = HiveConf.getLongVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVECONVERTJOINNOCONDITIONALTASKTHRESHOLD);
                Long bigTableSize = null;
                Set<String> aliases = aliasToWork.keySet();
                for (int tablePosition : bigTableCandidates) {
                    Operator<OperatorDesc> parent = joinOp.getParentOperators().get(tablePosition);
                    Set<String> participants = GenMapRedUtils.findAliases(currWork, parent);
                    long sumOfOthers = Utilities.sumOfExcept(this.aliasToSize, aliases, participants);
                    if (sumOfOthers < 0L || sumOfOthers > mapJoinSize || bigTableSize == null && bigTablePosition >= 0 && tablePosition < bigTablePosition) continue;
                    long aliasSize = Utilities.sumOf(this.aliasToSize, participants);
                    if (bigTableSize != null && bigTableSize >= 0L && (aliasSize < 0L || aliasSize < bigTableSize)) continue;
                    bigTablePosition = tablePosition;
                    bigTableSize = aliasSize;
                }
            }
            currWork.setLeftInputJoin(((JoinDesc)joinOp.getConf()).isLeftInputJoin());
            currWork.setBaseSrc(((JoinDesc)joinOp.getConf()).getBaseSrc());
            currWork.setMapAliases(((JoinDesc)joinOp.getConf()).getMapAliases());
            if (bigTablePosition >= 0) {
                MapRedTask newTask = this.convertTaskToMapJoinTask((MapredWork)currTask.getWork(), bigTablePosition);
                newTask.setTaskTag(7);
                newTask.setFetchSource(currTask.isFetchSource());
                this.replaceTask(currTask, newTask);
                if (newTask.getChildTasks() != null && newTask.getChildTasks().size() == 1) {
                    this.mergeMapJoinTaskIntoItsChildMapRedTask(newTask, conf);
                }
                return newTask;
            }
            long ThresholdOfSmallTblSizeSum = HiveConf.getLongVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVESMALLTABLESFILESIZE);
            for (int pos = 0; pos < joinOp.getNumParent(); ++pos) {
                Operator<OperatorDesc> startOp;
                Set<String> aliases;
                long aliasKnownSize;
                if (!bigTableCandidates.contains(pos) || CommonJoinTaskDispatcher.cannotConvert(aliasKnownSize = Utilities.sumOf(this.aliasToSize, aliases = GenMapRedUtils.findAliases(currWork, startOp = joinOp.getParentOperators().get(pos))), aliasTotalKnownInputSize, ThresholdOfSmallTblSizeSum)) continue;
                MapredWork newWork = SerializationUtilities.clonePlan((MapredWork)currTask.getWork());
                MapRedTask newTask = this.convertTaskToMapJoinTask(newWork, pos);
                listWorks.add(newTask.getWork());
                listTasks.add(newTask);
                newTask.setTaskTag(4);
                newTask.setFetchSource(currTask.isFetchSource());
                newTask.setBackupTask(currTask);
                newTask.setBackupChildrenTasks(currTask.getChildTasks());
                taskToAliases.put(newTask, aliases);
            }
        }
        catch (Exception e) {
            throw new SemanticException("Generate Map Join Task Error: " + e.getMessage(), (Throwable)e);
        }
        if (listTasks.isEmpty()) {
            return currTask;
        }
        listWorks.add(currTask.getWork());
        listTasks.add(currTask);
        currWork.setLeftInputJoin(false);
        currWork.setBaseSrc(null);
        currWork.setMapAliases(null);
        ConditionalWork cndWork = new ConditionalWork(listWorks);
        ConditionalTask cndTsk = (ConditionalTask)TaskFactory.get(cndWork);
        cndTsk.setListTasks(listTasks);
        cndTsk.setResolver(new ConditionalResolverCommonJoin());
        ConditionalResolverCommonJoin.ConditionalResolverCommonJoinCtx resolverCtx = new ConditionalResolverCommonJoin.ConditionalResolverCommonJoinCtx();
        resolverCtx.setPathToAliases(pathToAliases);
        resolverCtx.setAliasToKnownSize(this.aliasToSize);
        resolverCtx.setTaskToAliases(taskToAliases);
        resolverCtx.setCommonJoinTask(currTask);
        resolverCtx.setLocalTmpDir(context.getLocalScratchDir(false));
        resolverCtx.setHdfsTmpDir(context.getMRScratchDir());
        cndTsk.setResolverCtx(resolverCtx);
        this.replaceTaskWithConditionalTask(currTask, cndTsk);
        return cndTsk;
    }

    private boolean checkOperatorOKMapJoinConversion(Operator<? extends OperatorDesc> op) {
        if (!op.opAllowedConvertMapJoin()) {
            return false;
        }
        for (Operator<OperatorDesc> childOp : op.getChildOperators()) {
            if (this.checkOperatorOKMapJoinConversion(childOp)) continue;
            return false;
        }
        return true;
    }

    private JoinOperator getJoinOp(MapRedTask task) throws SemanticException {
        MapWork mWork = ((MapredWork)task.getWork()).getMapWork();
        ReduceWork rWork = ((MapredWork)task.getWork()).getReduceWork();
        if (rWork == null) {
            return null;
        }
        Operator<?> reducerOp = rWork.getReducer();
        if (reducerOp instanceof JoinOperator) {
            Map<String, Operator<? extends OperatorDesc>> aliasToWork = mWork.getAliasToWork();
            for (Operator<? extends OperatorDesc> op : aliasToWork.values()) {
                if (this.checkOperatorOKMapJoinConversion(op)) continue;
                return null;
            }
            return (JoinOperator)reducerOp;
        }
        return null;
    }

    private Set<Integer> multiInsertBigTableCheck(JoinOperator joinOp, Set<Integer> bigTableCandidates) {
        int multiChildrenSource = -1;
        Integer[] integerArray = bigTableCandidates.toArray(new Integer[0]);
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int tablePosition = integerArray[i];
            Operator<OperatorDesc> parent = joinOp.getParentOperators().get(tablePosition);
            while (parent != null) {
                if (parent.getNumChild() > 1 && !(parent instanceof LateralViewForwardOperator)) {
                    if (multiChildrenSource >= 0) {
                        return Collections.emptySet();
                    }
                    multiChildrenSource = tablePosition;
                }
                parent = parent.getNumParent() > 0 ? parent.getParentOperators().get(0) : null;
            }
        }
        return multiChildrenSource < 0 ? bigTableCandidates : new HashSet<Integer>(Arrays.asList(multiChildrenSource));
    }
}

