/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.lineage;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.hooks.LineageInfo;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.lineage.ExprProcCtx;
import org.apache.hadoop.hive.ql.optimizer.lineage.LineageCtx;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprDynamicParamDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeFieldDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

public class ExprProcFactory {
    private static final String exprNodeColDescRegExp = ExprNodeColumnDesc.class.getName() + "%";
    private static final String exprNodeFieldDescRegExp = ExprNodeFieldDesc.class.getName() + "%";
    private static final String exprNodeGenFuncDescRegExp = ExprNodeGenericFuncDesc.class.getName() + "%";
    private static final Map<SemanticRule, SemanticNodeProcessor> exprRules = new LinkedHashMap<SemanticRule, SemanticNodeProcessor>();

    public static SemanticNodeProcessor getDefaultExprProcessor() {
        return new DefaultExprProcessor();
    }

    public static SemanticNodeProcessor getGenericFuncProcessor() {
        return new GenericExprProcessor();
    }

    public static SemanticNodeProcessor getFieldProcessor() {
        return new GenericExprProcessor();
    }

    public static SemanticNodeProcessor getColumnProcessor() {
        return new ColumnExprProcessor();
    }

    private static boolean findSourceColumn(LineageCtx lctx, LineageInfo.Predicate cond, String tabAlias, String alias) {
        for (Map.Entry<String, TableScanOperator> topOpMap : lctx.getParseCtx().getTopOps().entrySet()) {
            TableScanOperator tableScanOp = topOpMap.getValue();
            Table tbl = ((TableScanDesc)tableScanOp.getConf()).getTableMetadata();
            if (!tbl.getTableName().equals(tabAlias) && !tabAlias.equals(((TableScanDesc)tableScanOp.getConf()).getAlias())) continue;
            for (FieldSchema column : tbl.getCols()) {
                if (!column.getName().equals(alias)) continue;
                LineageInfo.TableAliasInfo table = new LineageInfo.TableAliasInfo();
                table.setTable(tbl.getTTable());
                table.setAlias(tabAlias);
                LineageInfo.BaseColumnInfo colInfo = new LineageInfo.BaseColumnInfo();
                colInfo.setColumn(column);
                colInfo.setTabAlias(table);
                cond.getBaseCols().add(colInfo);
                return true;
            }
        }
        return false;
    }

    public static String getExprString(RowSchema rs, ExprNodeDesc expr, LineageCtx lctx, Operator<? extends OperatorDesc> inpOp, LineageInfo.Predicate cond) {
        if (expr instanceof ExprNodeColumnDesc) {
            Set<LineageInfo.BaseColumnInfo> baseCols;
            String internalName;
            ExprNodeColumnDesc col = (ExprNodeColumnDesc)expr;
            String alias = internalName = col.getColumn();
            String tabAlias = col.getTabAlias();
            ColumnInfo ci = rs.getColumnInfo(internalName);
            if (ci != null) {
                if (ci.getAlias() != null) {
                    alias = ci.getAlias();
                }
                if (ci.getTabAlias() != null) {
                    tabAlias = ci.getTabAlias();
                }
            }
            LineageInfo.Dependency dep = lctx.getIndex().getDependency(inpOp, internalName);
            if ((tabAlias == null || tabAlias.startsWith("_") || tabAlias.startsWith("$")) && dep != null && dep.getType() == LineageInfo.DependencyType.SIMPLE && (baseCols = dep.getBaseCols()) != null && !baseCols.isEmpty()) {
                LineageInfo.BaseColumnInfo baseCol = baseCols.iterator().next();
                tabAlias = baseCol.getTabAlias().getAlias();
                alias = baseCol.getColumn().getName();
            }
            if (tabAlias != null && tabAlias.length() > 0 && !tabAlias.startsWith("_") && !tabAlias.startsWith("$")) {
                if (cond != null && !ExprProcFactory.findSourceColumn(lctx, cond, tabAlias, alias) && dep != null) {
                    cond.getBaseCols().addAll(dep.getBaseCols());
                }
                return tabAlias + "." + alias;
            }
            if (dep != null) {
                if (cond != null) {
                    cond.getBaseCols().addAll(dep.getBaseCols());
                }
                if (dep.getExpr() != null) {
                    return dep.getExpr();
                }
            }
            if (alias.startsWith("_") && (ci = inpOp.getSchema().getColumnInfo(internalName)) != null && ci.getAlias() != null) {
                alias = ci.getAlias();
            }
            return alias;
        }
        if (expr instanceof ExprNodeGenericFuncDesc) {
            ExprNodeGenericFuncDesc func = (ExprNodeGenericFuncDesc)expr;
            List<ExprNodeDesc> children = func.getChildren();
            String[] childrenExprStrings = new String[children.size()];
            for (int i = 0; i < childrenExprStrings.length; ++i) {
                childrenExprStrings[i] = ExprProcFactory.getExprString(rs, children.get(i), lctx, inpOp, cond);
            }
            return func.getGenericUDF().getDisplayString(childrenExprStrings);
        }
        return expr.getExprString();
    }

    public static LineageInfo.Dependency getExprDependency(LineageCtx lctx, Operator<? extends OperatorDesc> inpOp, ExprNodeDesc expr) throws SemanticException {
        return ExprProcFactory.getExprDependency(lctx, inpOp, expr, new HashMap<Node, Object>());
    }

    public static LineageInfo.Dependency getExprDependency(LineageCtx lctx, Operator<? extends OperatorDesc> inpOp, ExprNodeDesc expr, HashMap<Node, Object> outputMap) throws SemanticException {
        outputMap.clear();
        ExprProcCtx exprCtx = new ExprProcCtx(lctx, inpOp);
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(ExprProcFactory.getDefaultExprProcessor(), exprRules, exprCtx);
        DefaultGraphWalker egw = new DefaultGraphWalker(disp);
        List<Node> startNodes = Collections.singletonList(expr);
        egw.startWalking(startNodes, outputMap);
        return (LineageInfo.Dependency)outputMap.get(expr);
    }

    static {
        exprRules.put(new RuleRegExp("R1", exprNodeColDescRegExp), ExprProcFactory.getColumnProcessor());
        exprRules.put(new RuleRegExp("R2", exprNodeFieldDescRegExp), ExprProcFactory.getFieldProcessor());
        exprRules.put(new RuleRegExp("R3", exprNodeGenFuncDescRegExp), ExprProcFactory.getGenericFuncProcessor());
    }

    public static class DefaultExprProcessor
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            assert (nd instanceof ExprNodeConstantDesc || nd instanceof ExprDynamicParamDesc);
            LineageInfo.Dependency dep = new LineageInfo.Dependency();
            dep.setType(LineageInfo.DependencyType.SIMPLE);
            dep.setBaseCols(new LinkedHashSet<LineageInfo.BaseColumnInfo>());
            return dep;
        }
    }

    public static class GenericExprProcessor
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            assert (nd instanceof ExprNodeGenericFuncDesc || nd instanceof ExprNodeFieldDesc);
            LineageInfo.Dependency dep = new LineageInfo.Dependency();
            LinkedHashSet<LineageInfo.BaseColumnInfo> bci_set = new LinkedHashSet<LineageInfo.BaseColumnInfo>();
            LineageInfo.DependencyType new_type = LineageInfo.DependencyType.EXPRESSION;
            for (Object child : nodeOutputs) {
                if (child == null) continue;
                LineageInfo.Dependency child_dep = (LineageInfo.Dependency)child;
                new_type = LineageCtx.getNewDependencyType(child_dep.getType(), new_type);
                bci_set.addAll(child_dep.getBaseCols());
            }
            dep.setBaseCols(bci_set);
            dep.setType(new_type);
            return dep;
        }
    }

    public static class ColumnExprProcessor
    implements SemanticNodeProcessor {
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ExprNodeColumnDesc cd = (ExprNodeColumnDesc)nd;
            ExprProcCtx epc = (ExprProcCtx)procCtx;
            Operator<? extends OperatorDesc> operator = epc.getInputOperator();
            assert (operator != null);
            RowSchema schema = epc.getSchema();
            ColumnInfo ci = schema.getColumnInfo(cd.getColumn());
            if (ci == null && operator instanceof ReduceSinkOperator) {
                ci = schema.getColumnInfo(Utilities.removeValueTag(cd.getColumn()));
            }
            LineageCtx lc = epc.getLineageCtx();
            LineageInfo.Dependency dep = lc.getIndex().getDependency(operator, ci);
            return dep;
        }
    }
}

