/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.graph;

import com.google.common.collect.Sets;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.AppMasterEventOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.optimizer.graph.DagGraph;
import org.apache.hadoop.hive.ql.optimizer.graph.DotExporter;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemiJoinBranchInfo;
import org.apache.hadoop.hive.ql.plan.DynamicPruningEventDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;

public class OperatorGraph {
    DagGraph<Operator<?>, OpEdge> g;
    Map<Operator<?>, Cluster> nodeCluster = new HashMap();

    public OperatorGraph(ParseContext pctx) {
        this.g = new DagGraph();
        Set visited = Sets.newIdentityHashSet();
        Set seen = Sets.newIdentityHashSet();
        seen.addAll(pctx.getTopOps().values());
        while (!seen.isEmpty()) {
            Operator curr = (Operator)seen.iterator().next();
            seen.remove(curr);
            if (visited.contains(curr)) continue;
            visited.add(curr);
            Cluster currentCluster = this.nodeCluster.get(curr);
            if (currentCluster == null) {
                currentCluster = new Cluster();
                currentCluster.add(curr);
            }
            List<Operator<OperatorDesc>> parents = curr.getParentOperators();
            for (int i = 0; i < parents.size(); ++i) {
                Operator<OperatorDesc> p = parents.get(i);
                if (curr instanceof MapJoinOperator && p instanceof ReduceSinkOperator) {
                    this.g.putEdgeValue(p, curr, new OpEdge(EdgeType.BROADCAST, i));
                } else {
                    this.g.putEdgeValue(p, curr, new OpEdge(EdgeType.FLOW, i));
                }
                if (p instanceof ReduceSinkOperator) continue;
                Cluster cluster = this.nodeCluster.get(p);
                if (cluster != null) {
                    currentCluster.merge(cluster);
                    continue;
                }
                currentCluster.add(p);
            }
            SemiJoinBranchInfo sji = pctx.getRsToSemiJoinBranchInfo().get(curr);
            if (sji != null) {
                this.g.putEdgeValue(curr, sji.getTsOp(), new OpEdge(EdgeType.SEMIJOIN));
                seen.add(sji.getTsOp());
            }
            if (curr instanceof AppMasterEventOperator) {
                DynamicPruningEventDesc dped = (DynamicPruningEventDesc)curr.getConf();
                TableScanOperator ts = dped.getTableScan();
                this.g.putEdgeValue(curr, ts, new OpEdge(EdgeType.DPP));
                seen.add(ts);
            }
            List<Operator<OperatorDesc>> ccc = curr.getChildOperators();
            for (Operator<OperatorDesc> operator : ccc) {
                seen.add(operator);
            }
        }
    }

    public void toDot(File outFile) throws Exception {
        new DotExporter(this).write(outFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean mayMerge(Operator<?> opA, Operator<?> opB) {
        try {
            this.g.putEdgeValue(opA, opB, new OpEdge(EdgeType.TEST));
            this.g.removeEdge(opA, opB);
            this.g.putEdgeValue(opB, opA, new OpEdge(EdgeType.TEST));
            this.g.removeEdge(opB, opA);
            boolean bl = true;
            return bl;
        }
        catch (IllegalArgumentException iae) {
            boolean bl = false;
            return bl;
        }
        finally {
            this.g.removeEdge(opA, opB);
            this.g.removeEdge(opB, opA);
        }
    }

    public int getDepth(Operator<?> o1) {
        return this.g.getDepth(o1);
    }

    public OperatorGraph implode() {
        HashSet nodes = new HashSet(this.g.nodes());
        for (Operator n : nodes) {
            if (n instanceof TableScanOperator || this.g.degree(n) != 2 || this.g.inDegree(n) != 1) continue;
            this.g.impode(n, new OpEdge(EdgeType.FLOW, -1));
        }
        this.nodeCluster.clear();
        return this;
    }

    public Cluster clusterOf(Operator<?> op1) {
        return this.nodeCluster.get(op1);
    }

    public Set<Cluster> getClusters() {
        return new HashSet<Cluster>(this.nodeCluster.values());
    }

    public class Cluster {
        Set<Operator<?>> members = new LinkedHashSet();

        protected void merge(Cluster o) {
            if (o == this) {
                return;
            }
            for (Operator<?> node : o.members) {
                this.add(node);
            }
            o.members.clear();
        }

        protected void add(Operator<?> curr) {
            OperatorGraph.this.nodeCluster.put(curr, this);
            this.members.add(curr);
        }

        public Set<Cluster> parentClusters(OperatorEdgePredicate traverseEdge) {
            HashSet<Cluster> ret = new HashSet<Cluster>();
            for (Operator<?> operator : this.members) {
                for (Operator<OperatorDesc> p : operator.getParentOperators()) {
                    Optional e;
                    if (this.members.contains(p) || !traverseEdge.accept(p, operator, (OpEdge)(e = OperatorGraph.this.g.getEdge(p, operator)).get())) continue;
                    ret.add(OperatorGraph.this.nodeCluster.get(p));
                }
            }
            return ret;
        }

        public Set<Cluster> childClusters(OperatorEdgePredicate traverseEdge) {
            HashSet<Cluster> ret = new HashSet<Cluster>();
            for (Operator<?> operator : this.members) {
                for (Operator<OperatorDesc> p : operator.getChildOperators()) {
                    Optional e;
                    if (this.members.contains(p) || !traverseEdge.accept(operator, p, (OpEdge)(e = OperatorGraph.this.g.getEdge(operator, p)).get())) continue;
                    ret.add(OperatorGraph.this.nodeCluster.get(p));
                }
            }
            return ret;
        }

        public Set<Operator<?>> getMembers() {
            return Collections.unmodifiableSet(this.members);
        }
    }

    public static interface OperatorEdgePredicate {
        public boolean accept(Operator<?> var1, Operator<?> var2, OpEdge var3);
    }

    public static class OpEdge {
        private final EdgeType et;
        private final int index;

        public OpEdge(EdgeType et) {
            this(et, 0);
        }

        public OpEdge(EdgeType et, int index) {
            this.et = et;
            this.index = index;
        }

        public EdgeType getEdgeType() {
            return this.et;
        }
    }

    public static enum EdgeType {
        FLOW,
        SEMIJOIN,
        DPP,
        TEST,
        BROADCAST;

    }
}

