/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.graph;

import com.google.common.base.Joiner;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.optimizer.graph.DagGraph;
import org.apache.hadoop.hive.ql.optimizer.graph.OperatorGraph;
import org.apache.hadoop.hive.ql.plan.AbstractOperatorDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;

public class DotExporter {
    private OperatorGraph operatorGraph;

    public DotExporter(OperatorGraph operatorGraph) {
        this.operatorGraph = operatorGraph;
    }

    public void write(File outFile) throws Exception {
        Map<Operator<?>, OperatorGraph.Cluster> nodeCluster = this.operatorGraph.nodeCluster;
        DagGraph<Operator<?>, OperatorGraph.OpEdge> g = this.operatorGraph.g;
        PrintWriter writer = new PrintWriter(outFile);
        writer.println("digraph G");
        writer.println("{\n");
        HashSet<OperatorGraph.Cluster> clusters = new HashSet<OperatorGraph.Cluster>(nodeCluster.values());
        int idx = 0;
        for (OperatorGraph.Cluster cluster : clusters) {
            writer.printf("subgraph cluster_%d {\n", ++idx);
            for (Operator<?> member : cluster.members) {
                writer.printf("%s;\n", this.nodeName(member));
            }
            writer.printf("label = \"cluster %d\";\n", idx);
            writer.printf("}\n", new Object[0]);
        }
        Set nodes = g.nodes();
        for (Operator n : nodes) {
            writer.printf("%s[shape=record,label=\"%s\",%s];\n", this.nodeName(n), this.nodeLabel(n), this.style(n));
            Set<Operator> succ = g.successors(n);
            for (Operator s : succ) {
                Optional e = g.getEdge(n, s);
                String style = "";
                switch (((OperatorGraph.OpEdge)e.get()).getEdgeType()) {
                    case BROADCAST: {
                        style = "[color=blue,label=\"BROADCAST\"]";
                        break;
                    }
                    case DPP: {
                        style = "[color=green,label=\"DPP\"]";
                        break;
                    }
                    case SEMIJOIN: {
                        style = "[color=red,label=\"SEMIJOIN\"]";
                    }
                }
                writer.printf("%s->%s%s;\n", this.nodeName(n), this.nodeName(s), style);
            }
        }
        writer.println("}\n");
        writer.close();
    }

    private String style(Operator<?> n) {
        String fillColor = "white";
        Object c = n.getConf();
        if (n instanceof TableScanOperator) {
            fillColor = "#ccffcc";
        }
        if (c instanceof JoinDesc) {
            fillColor = "#ffcccc";
        }
        return String.format("style=filled,fillcolor=\"%s\"", fillColor);
    }

    private String nodeLabel(Operator<?> n) {
        AbstractOperatorDesc conf;
        ArrayList<String> rows = new ArrayList<String>();
        rows.add(this.nodeName0(n));
        if (n instanceof TableScanOperator) {
            TableScanOperator ts = (TableScanOperator)n;
            conf = (TableScanDesc)ts.getConf();
            rows.add(this.vBox(((TableScanDesc)conf).getTableName(), ((TableScanDesc)conf).getAlias()));
        }
        if (n instanceof FilterOperator) {
            FilterOperator fil = (FilterOperator)n;
            conf = (FilterDesc)fil.getConf();
            rows.add(this.vBox("filter:", this.escape(((FilterDesc)conf).getPredicateString())));
        }
        return this.vBox(rows);
    }

    private String escape(String str) {
        StringWriter writer = new StringWriter(str.length() * 2);
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '<': 
                case '>': 
                case '\\': 
                case '|': {
                    writer.write("\\");
                }
            }
            writer.write(c);
        }
        return writer.toString();
    }

    private String hBox(List<String> rows) {
        return "" + Joiner.on((String)"|").join(rows) + "";
    }

    private String hBox(String ... rows) {
        return "" + Joiner.on((String)"|").join((Object[])rows) + "";
    }

    private String vBox(List<String> rows) {
        return "{ " + this.hBox(rows) + "}";
    }

    private String vBox(String ... strings) {
        return "{ " + this.hBox(strings) + "}";
    }

    private String nodeName(Operator<?> member) {
        return String.format("\"%s\"", member);
    }

    private String nodeName0(Operator<?> member) {
        return member.toString();
    }
}

