/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.views;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.plan.RelOptAbstractTable;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptSchema;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelShuttleImpl;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;

public class HiveMaterializedViewBoxing {
    public static final HiveMaterializedViewUnboxingRule INSTANCE_UNBOXING = new HiveMaterializedViewUnboxingRule();
    private static final AtomicInteger UNIQUE_IDENTIFIER = new AtomicInteger(0);

    public static RelNode boxPlan(RelNode plan) {
        return plan.accept((RelShuttle)new BoxingRelShuttle());
    }

    private static final class HiveMaterializedViewUnboxingRule
    extends RelOptRule {
        private HiveMaterializedViewUnboxingRule() {
            super(HiveMaterializedViewUnboxingRule.operand(Box.class, (RelOptRuleOperandChildren)HiveMaterializedViewUnboxingRule.any()), HiveRelFactories.HIVE_BUILDER, "HiveMaterializedViewUnboxingRule");
        }

        public void onMatch(RelOptRuleCall call) {
            Box box = (Box)call.rel(0);
            call.transformTo(box.eqRelNode);
        }
    }

    protected static final class Box
    extends TableScan
    implements HiveRelNode {
        private final RelNode eqRelNode;

        private Box(RelOptCluster cluster, String name, RelNode eqRelNode) {
            super(cluster, TraitsUtil.getDefaultTraitSet(cluster), (RelOptTable)new BoxRelOptTable(null, name, eqRelNode.getRowType()));
            this.eqRelNode = eqRelNode;
        }

        public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
            return planner.getCostFactory().makeInfiniteCost();
        }

        @Override
        public void implement(HiveRelNode.Implementor implementor) {
        }

        private static final class BoxRelOptTable
        extends RelOptAbstractTable {
            private BoxRelOptTable(RelOptSchema schema, String name, RelDataType rowType) {
                super(schema, name, rowType);
            }
        }
    }

    private static final class BoxingRelShuttle
    extends HiveRelShuttleImpl {
        private BoxingRelShuttle() {
        }

        @Override
        public RelNode visit(HiveJoin join) {
            boolean rightValid;
            HiveJoin newJoin = (HiveJoin)this.visitChildren(join);
            if (newJoin.getJoinType() != JoinRelType.INNER && !newJoin.isSemiJoin()) {
                return newJoin;
            }
            RelMetadataQuery mq = newJoin.getCluster().getMetadataQuery();
            boolean leftValid = BoxingRelShuttle.isValidRelNodePlan(newJoin.getLeft(), mq);
            if (leftValid == (rightValid = BoxingRelShuttle.isValidRelNodePlan(newJoin.getRight(), mq))) {
                return newJoin;
            }
            RelNode leftInput = newJoin.getLeft();
            RelNode rightInput = newJoin.getRight();
            if (!leftValid) {
                leftInput = BoxingRelShuttle.createBoxOperator(newJoin.getCluster(), leftInput);
            } else {
                rightInput = BoxingRelShuttle.createBoxOperator(newJoin.getCluster(), rightInput);
            }
            return newJoin.copy(newJoin.getTraitSet(), (List)ImmutableList.of((Object)leftInput, (Object)rightInput));
        }

        private static RelNode createBoxOperator(RelOptCluster cluster, RelNode eqRelNode) {
            String name = ".$box" + UNIQUE_IDENTIFIER.getAndIncrement();
            return new Box(cluster, name, eqRelNode);
        }

        private static boolean isValidRelNodePlan(RelNode rel, RelMetadataQuery mq) {
            Multimap m = mq.getNodeTypes(rel);
            for (Map.Entry e : m.asMap().entrySet()) {
                Class c = (Class)e.getKey();
                if (!(TableScan.class.isAssignableFrom(c) || Project.class.isAssignableFrom(c) || Filter.class.isAssignableFrom(c) || Join.class.isAssignableFrom(c))) {
                    return false;
                }
                if (!Join.class.isAssignableFrom(c)) continue;
                for (RelNode n : (Collection)e.getValue()) {
                    Join join = (Join)n;
                    if (join.getJoinType() == JoinRelType.INNER || join.isSemiJoin()) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

