/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules.jdbc;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.adapter.jdbc.JdbcImplementor;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.JoinConditionType;
import org.apache.calcite.sql.JoinType;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlJoin;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;

public class HiveJdbcImplementor
extends JdbcImplementor {
    public HiveJdbcImplementor(SqlDialect dialect, JavaTypeFactory typeFactory) {
        super(dialect, typeFactory);
    }

    public SqlImplementor.Result visit(Project e) {
        SqlImplementor.Result x = this.visitChild(0, e.getInput());
        this.parseCorrelTable((RelNode)e, x);
        SqlImplementor.Builder builder = x.builder((RelNode)e, new SqlImplementor.Clause[]{SqlImplementor.Clause.SELECT});
        ArrayList selectList = new ArrayList();
        for (RexNode ref : e.getChildExps()) {
            SqlNode sqlExpr = builder.context.toSql(null, ref);
            this.addSelect(selectList, sqlExpr, e.getRowType());
        }
        builder.setSelect(new SqlNodeList(selectList, POS));
        return builder.result();
    }

    public SqlImplementor.Result visit(Sort e) {
        SqlImplementor.Result x = this.visitChild(0, e.getInput());
        SqlImplementor.Builder builder = x.builder((RelNode)e, new SqlImplementor.Clause[]{SqlImplementor.Clause.ORDER_BY});
        Expressions.FluentList orderByList = Expressions.list();
        for (RelFieldCollation field : e.getCollation().getFieldCollations()) {
            builder.addOrderItem((List)orderByList, field);
        }
        ArrayList selectList = new ArrayList();
        for (int i = 0; i < e.getRowType().getFieldCount(); ++i) {
            RexInputRef ref = RexInputRef.of((int)i, (RelDataType)e.getRowType());
            SqlNode sqlExpr = builder.context.toSql(null, (RexNode)ref);
            this.addSelect(selectList, sqlExpr, e.getRowType());
        }
        builder.setSelect(new SqlNodeList(selectList, POS));
        if (!orderByList.isEmpty()) {
            builder.setOrderBy(new SqlNodeList((Collection)orderByList, POS));
            x = builder.result();
        }
        if (e.fetch != null) {
            builder = x.builder((RelNode)e, new SqlImplementor.Clause[]{SqlImplementor.Clause.FETCH});
            builder.setFetch(builder.context.toSql(null, e.fetch));
            x = builder.result();
        }
        if (e.offset != null) {
            builder = x.builder((RelNode)e, new SqlImplementor.Clause[]{SqlImplementor.Clause.OFFSET});
            builder.setOffset(builder.context.toSql(null, e.offset));
            x = builder.result();
        }
        return x;
    }

    public SqlImplementor.Result visit(Join e) {
        SqlImplementor.Result leftResult = this.visitChild(0, e.getLeft()).resetAlias();
        SqlImplementor.Result rightResult = this.visitChild(1, e.getRight()).resetAlias();
        SqlImplementor.Context leftContext = leftResult.qualifiedContext();
        SqlImplementor.Context rightContext = rightResult.qualifiedContext();
        SqlNode sqlCondition = null;
        SqlLiteral condType = JoinConditionType.ON.symbol(POS);
        JoinType joinType = HiveJdbcImplementor.joinType((JoinRelType)e.getJoinType());
        if (e.getJoinType() == JoinRelType.INNER && e.getCondition().isAlwaysTrue()) {
            joinType = JoinType.COMMA;
            condType = JoinConditionType.NONE.symbol(POS);
        } else {
            sqlCondition = HiveJdbcImplementor.convertConditionToSqlNode(e.getCondition(), leftContext, rightContext, e.getLeft().getRowType().getFieldCount());
        }
        SqlJoin join = new SqlJoin(POS, leftResult.asFrom(), SqlLiteral.createBoolean((boolean)false, (SqlParserPos)POS), joinType.symbol(POS), rightResult.asFrom(), condType, sqlCondition);
        return this.result((SqlNode)join, leftResult, rightResult);
    }

    public static SqlNode convertConditionToSqlNode(RexNode node, SqlImplementor.Context leftContext, SqlImplementor.Context rightContext, int leftFieldCount) {
        if (node.isAlwaysTrue()) {
            return SqlLiteral.createBoolean((boolean)true, (SqlParserPos)POS);
        }
        if (node.isAlwaysFalse()) {
            return SqlLiteral.createBoolean((boolean)false, (SqlParserPos)POS);
        }
        if (node instanceof RexInputRef) {
            SqlImplementor.Context joinContext = leftContext.implementor().joinContext(leftContext, rightContext);
            return joinContext.toSql(null, node);
        }
        if (!(node instanceof RexCall)) {
            throw new AssertionError(node);
        }
        switch (node.getKind()) {
            case AND: 
            case OR: {
                List operands = ((RexCall)node).getOperands();
                SqlOperator op = ((RexCall)node).getOperator();
                SqlNode sqlCondition = null;
                for (RexNode operand : operands) {
                    SqlNode x = HiveJdbcImplementor.convertConditionToSqlNode(operand, leftContext, rightContext, leftFieldCount);
                    if (sqlCondition == null) {
                        sqlCondition = x;
                        continue;
                    }
                    sqlCondition = op.createCall(POS, new SqlNode[]{sqlCondition, x});
                }
                return sqlCondition;
            }
            case EQUALS: 
            case IS_NOT_DISTINCT_FROM: 
            case NOT_EQUALS: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                node = HiveJdbcImplementor.stripCastFromString(node);
                List operands = ((RexCall)node).getOperands();
                SqlOperator op = ((RexCall)node).getOperator();
                if (operands.size() == 2 && operands.get(0) instanceof RexInputRef && operands.get(1) instanceof RexInputRef) {
                    RexInputRef op0 = (RexInputRef)operands.get(0);
                    RexInputRef op1 = (RexInputRef)operands.get(1);
                    if (op0.getIndex() < leftFieldCount && op1.getIndex() >= leftFieldCount) {
                        return op.createCall(POS, new SqlNode[]{leftContext.field(op0.getIndex()), rightContext.field(op1.getIndex() - leftFieldCount)});
                    }
                    if (op1.getIndex() < leftFieldCount && op0.getIndex() >= leftFieldCount) {
                        return HiveJdbcImplementor.reverseOperatorDirection(op).createCall(POS, new SqlNode[]{leftContext.field(op1.getIndex()), rightContext.field(op0.getIndex() - leftFieldCount)});
                    }
                }
                SqlImplementor.Context joinContext = leftContext.implementor().joinContext(leftContext, rightContext);
                return joinContext.toSql(null, node);
            }
            case IS_NULL: 
            case IS_NOT_NULL: {
                List operands = ((RexCall)node).getOperands();
                if (operands.size() == 1 && operands.get(0) instanceof RexInputRef) {
                    SqlOperator op = ((RexCall)node).getOperator();
                    RexInputRef op0 = (RexInputRef)operands.get(0);
                    if (op0.getIndex() < leftFieldCount) {
                        return op.createCall(POS, new SqlNode[]{leftContext.field(op0.getIndex())});
                    }
                    return op.createCall(POS, new SqlNode[]{rightContext.field(op0.getIndex() - leftFieldCount)});
                }
                SqlImplementor.Context joinContext = leftContext.implementor().joinContext(leftContext, rightContext);
                return joinContext.toSql(null, node);
            }
        }
        SqlImplementor.Context joinContext = leftContext.implementor().joinContext(leftContext, rightContext);
        return joinContext.toSql(null, node);
    }

    private static RexNode stripCastFromString(RexNode node) {
        switch (node.getKind()) {
            case EQUALS: 
            case IS_NOT_DISTINCT_FROM: 
            case NOT_EQUALS: 
            case GREATER_THAN: 
            case GREATER_THAN_OR_EQUAL: 
            case LESS_THAN: 
            case LESS_THAN_OR_EQUAL: {
                RexCall call = (RexCall)node;
                RexNode o0 = (RexNode)call.operands.get(0);
                RexNode o1 = (RexNode)call.operands.get(1);
                if (o0.getKind() == SqlKind.CAST && o1.getKind() != SqlKind.CAST) {
                    RexNode o0b = (RexNode)((RexCall)o0).getOperands().get(0);
                    switch (o0b.getType().getSqlTypeName()) {
                        case CHAR: 
                        case VARCHAR: {
                            return call.clone(call.getType(), (List)ImmutableList.of((Object)o0b, (Object)o1));
                        }
                    }
                }
                if (o1.getKind() != SqlKind.CAST || o0.getKind() == SqlKind.CAST) break;
                RexNode o1b = (RexNode)((RexCall)o1).getOperands().get(0);
                switch (o1b.getType().getSqlTypeName()) {
                    case CHAR: 
                    case VARCHAR: {
                        return call.clone(call.getType(), (List)ImmutableList.of((Object)o0, (Object)o1b));
                    }
                }
            }
        }
        return node;
    }

    private static SqlOperator reverseOperatorDirection(SqlOperator op) {
        switch (op.kind) {
            case GREATER_THAN: {
                return SqlStdOperatorTable.LESS_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return SqlStdOperatorTable.LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return SqlStdOperatorTable.GREATER_THAN;
            }
            case LESS_THAN_OR_EQUAL: {
                return SqlStdOperatorTable.GREATER_THAN_OR_EQUAL;
            }
            case EQUALS: 
            case IS_NOT_DISTINCT_FROM: 
            case NOT_EQUALS: {
                return op;
            }
        }
        throw new AssertionError(op);
    }

    private void parseCorrelTable(RelNode relNode, SqlImplementor.Result x) {
        for (CorrelationId id : relNode.getVariablesSet()) {
            this.correlTableMap.put(id, x.qualifiedContext());
        }
    }

    public SqlImplementor.Result implement(RelNode node) {
        return this.dispatch(node);
    }
}

