/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalTableFunctionScan;
import org.apache.calcite.rel.logical.LogicalTableModify;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCorrelVariable;
import org.apache.calcite.rex.RexDynamicParam;
import org.apache.calcite.rex.RexFieldAccess;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexPermuteInputsShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql2rel.CorrelationReferenceFinder;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.ReflectUtil;
import org.apache.calcite.util.ReflectiveVisitor;
import org.apache.calcite.util.Util;
import org.apache.calcite.util.mapping.IntPair;
import org.apache.calcite.util.mapping.Mapping;
import org.apache.calcite.util.mapping.MappingType;
import org.apache.calcite.util.mapping.Mappings;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveReflectUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelFieldTrimmer
implements ReflectiveVisitor {
    private static final Logger LOG = LoggerFactory.getLogger(RelFieldTrimmer.class);
    protected static final ThreadLocal<RelBuilder> REL_BUILDER = new ThreadLocal();
    protected final HiveReflectUtil.ClassMethodDispatcher<TrimResult, RelNode> trimFieldsDispatcher;

    protected RelFieldTrimmer(boolean useLMFBasedDispatcher) {
        this.trimFieldsDispatcher = useLMFBasedDispatcher ? HiveReflectUtil.createMethodDispatcher(TrimResult.class, this, "trimFields", RelNode.class, ImmutableBitSet.class, Set.class) : HiveReflectUtil.createCalciteMethodDispatcherWrapper(ReflectUtil.createMethodDispatcher(TrimResult.class, (ReflectiveVisitor)this, (String)"trimFields", RelNode.class, (Class[])new Class[]{ImmutableBitSet.class, Set.class}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RelNode trim(RelBuilder relBuilder, RelNode root) {
        try {
            REL_BUILDER.set(relBuilder);
            int fieldCount = root.getRowType().getFieldCount();
            ImmutableBitSet fieldsUsed = ImmutableBitSet.range((int)fieldCount);
            Set<RelDataTypeField> extraFields = Collections.emptySet();
            TrimResult trimResult = this.dispatchTrimFields(root, fieldsUsed, extraFields);
            if (!((Mapping)trimResult.right).isIdentity()) {
                throw new IllegalArgumentException();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(RelOptUtil.dumpPlan((String)"Plan after trimming unused fields", (RelNode)((RelNode)trimResult.left), (SqlExplainFormat)SqlExplainFormat.TEXT, (SqlExplainLevel)SqlExplainLevel.EXPPLAN_ATTRIBUTES));
            }
            RelNode relNode = (RelNode)trimResult.left;
            return relNode;
        }
        finally {
            REL_BUILDER.remove();
        }
    }

    protected TrimResult trimChild(RelNode rel, RelNode input, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        final ImmutableBitSet.Builder fieldsUsedBuilder = fieldsUsed.rebuild();
        RelMetadataQuery mq = rel.getCluster().getMetadataQuery();
        ImmutableList collations = mq.collations(input);
        for (RelCollation collation : collations) {
            for (RelFieldCollation fieldCollation : collation.getFieldCollations()) {
                fieldsUsedBuilder.set(fieldCollation.getFieldIndex());
            }
        }
        for (final CorrelationId correlation : rel.getVariablesSet()) {
            rel.accept((RelShuttle)new CorrelationReferenceFinder(){

                protected RexNode handle(RexFieldAccess fieldAccess) {
                    RexCorrelVariable v = (RexCorrelVariable)fieldAccess.getReferenceExpr();
                    if (v.id.equals((Object)correlation)) {
                        fieldsUsedBuilder.set(fieldAccess.getField().getIndex());
                    }
                    return fieldAccess;
                }
            });
        }
        return this.dispatchTrimFields(input, fieldsUsedBuilder.build(), extraFields);
    }

    protected TrimResult trimChildRestore(RelNode rel, RelNode input, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        TrimResult trimResult = this.trimChild(rel, input, fieldsUsed, extraFields);
        if (((Mapping)trimResult.right).isIdentity()) {
            return trimResult;
        }
        RelDataType rowType = input.getRowType();
        List fieldList = rowType.getFieldList();
        ArrayList<RexNode> exprList = new ArrayList<RexNode>();
        List nameList = rowType.getFieldNames();
        RexBuilder rexBuilder = rel.getCluster().getRexBuilder();
        assert (((Mapping)trimResult.right).getSourceCount() == fieldList.size());
        for (int i = 0; i < fieldList.size(); ++i) {
            int source = ((Mapping)trimResult.right).getTargetOpt(i);
            RelDataTypeField field = (RelDataTypeField)fieldList.get(i);
            exprList.add((RexNode)(source < 0 ? rexBuilder.makeZeroLiteral(field.getType()) : rexBuilder.makeInputRef(field.getType(), source)));
        }
        RelBuilder relBuilder = REL_BUILDER.get();
        relBuilder.push((RelNode)trimResult.left).project(exprList, (Iterable)nameList);
        return this.result(relBuilder.build(), (Mapping)Mappings.createIdentity((int)fieldList.size()));
    }

    protected final TrimResult dispatchTrimFields(RelNode rel, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        TrimResult trimResult = (TrimResult)((Object)this.trimFieldsDispatcher.invoke(new Object[]{rel, fieldsUsed, extraFields}));
        RelNode newRel = (RelNode)trimResult.left;
        Mapping mapping = (Mapping)trimResult.right;
        int fieldCount = rel.getRowType().getFieldCount();
        assert (mapping.getSourceCount() == fieldCount) : "source: " + mapping.getSourceCount() + " != " + fieldCount;
        int newFieldCount = newRel.getRowType().getFieldCount();
        assert (mapping.getTargetCount() + extraFields.size() == newFieldCount) : "target: " + mapping.getTargetCount() + " + " + extraFields.size() + " != " + newFieldCount;
        if (newRel.equals(rel)) {
            return this.result(rel, mapping);
        }
        return trimResult;
    }

    protected TrimResult result(RelNode r, final Mapping mapping) {
        final RelBuilder relBuilder = REL_BUILDER.get();
        final RexBuilder rexBuilder = relBuilder.getRexBuilder();
        for (final CorrelationId correlation : r.getVariablesSet()) {
            r = r.accept((RelShuttle)new CorrelationReferenceFinder(){

                protected RexNode handle(RexFieldAccess fieldAccess) {
                    RexCorrelVariable v = (RexCorrelVariable)fieldAccess.getReferenceExpr();
                    if (v.id.equals((Object)correlation) && v.getType().getFieldCount() == mapping.getSourceCount()) {
                        int old = fieldAccess.getField().getIndex();
                        int new_ = mapping.getTarget(old);
                        RelDataTypeFactory.FieldInfoBuilder typeBuilder = relBuilder.getTypeFactory().builder();
                        Iterator iterator = Util.range((int)mapping.getTargetCount()).iterator();
                        while (iterator.hasNext()) {
                            int target = (Integer)iterator.next();
                            typeBuilder.add((RelDataTypeField)v.getType().getFieldList().get(mapping.getSource(target)));
                        }
                        RexNode newV = rexBuilder.makeCorrel(typeBuilder.build(), v.id);
                        if (old != new_) {
                            return rexBuilder.makeFieldAccess(newV, new_);
                        }
                    }
                    return fieldAccess;
                }
            });
        }
        return new TrimResult(r, mapping);
    }

    public TrimResult trimFields(RelNode rel, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        Util.discard((Object)fieldsUsed);
        return this.result(rel, (Mapping)Mappings.createIdentity((int)rel.getRowType().getFieldCount()));
    }

    public TrimResult trimFields(Project project, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = project.getRowType();
        int fieldCount = rowType.getFieldCount();
        RelNode input = project.getInput();
        LinkedHashSet<RelDataTypeField> inputExtraFields = new LinkedHashSet<RelDataTypeField>(extraFields);
        RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(inputExtraFields);
        for (Ord ord : Ord.zip((List)project.getProjects())) {
            if (!fieldsUsed.get(ord.i)) continue;
            ((RexNode)ord.e).accept((RexVisitor)inputFinder);
        }
        ImmutableBitSet inputFieldsUsed = inputFinder.inputBitSet.build();
        TrimResult trimResult = this.trimChild((RelNode)project, input, inputFieldsUsed, inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newInput == input && fieldsUsed.cardinality() == fieldCount) {
            return this.result((RelNode)project, (Mapping)Mappings.createIdentity((int)fieldCount));
        }
        if (fieldsUsed.cardinality() == 0) {
            return this.dummyProject(fieldCount, newInput);
        }
        ArrayList<RexNode> newProjects = new ArrayList<RexNode>();
        RexPermuteInputsShuttle shuttle = new RexPermuteInputsShuttle((Mappings.TargetMapping)inputMapping, new RelNode[]{newInput});
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_SURJECTION, (int)fieldCount, (int)fieldsUsed.cardinality());
        for (Ord ord : Ord.zip((List)project.getProjects())) {
            if (!fieldsUsed.get(ord.i)) continue;
            mapping.set(ord.i, newProjects.size());
            RexNode newProjectExpr = (RexNode)((RexNode)ord.e).accept((RexVisitor)shuttle);
            newProjects.add(newProjectExpr);
        }
        RelDataType newRowType = RelOptUtil.permute((RelDataTypeFactory)project.getCluster().getTypeFactory(), (RelDataType)rowType, (Mapping)mapping);
        RelBuilder relBuilder = REL_BUILDER.get();
        relBuilder.push(newInput);
        relBuilder.project(newProjects, (Iterable)newRowType.getFieldNames());
        return this.result(relBuilder.build(), mapping);
    }

    protected TrimResult dummyProject(int fieldCount, RelNode input) {
        RelOptCluster cluster = input.getCluster();
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_SURJECTION, (int)fieldCount, (int)1);
        if (input.getRowType().getFieldCount() == 1) {
            return this.result(input, mapping);
        }
        RexLiteral expr = cluster.getRexBuilder().makeExactLiteral(BigDecimal.ZERO);
        RelBuilder relBuilder = REL_BUILDER.get();
        relBuilder.push(input);
        relBuilder.project((Iterable)ImmutableList.of((Object)expr), (Iterable)ImmutableList.of((Object)"DUMMY"));
        return this.result(relBuilder.build(), mapping);
    }

    public TrimResult trimFields(Filter filter, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = filter.getRowType();
        int fieldCount = rowType.getFieldCount();
        RexNode conditionExpr = filter.getCondition();
        RelNode input = filter.getInput();
        LinkedHashSet<RelDataTypeField> inputExtraFields = new LinkedHashSet<RelDataTypeField>(extraFields);
        RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(inputExtraFields);
        inputFinder.inputBitSet.addAll(fieldsUsed);
        conditionExpr.accept((RexVisitor)inputFinder);
        ImmutableBitSet inputFieldsUsed = inputFinder.inputBitSet.build();
        TrimResult trimResult = this.trimChild((RelNode)filter, input, inputFieldsUsed, inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newInput == input && fieldsUsed.cardinality() == fieldCount) {
            return this.result((RelNode)filter, (Mapping)Mappings.createIdentity((int)fieldCount));
        }
        RexPermuteInputsShuttle shuttle = new RexPermuteInputsShuttle((Mappings.TargetMapping)inputMapping, new RelNode[]{newInput});
        RexNode newConditionExpr = (RexNode)conditionExpr.accept((RexVisitor)shuttle);
        RelBuilder relBuilder = REL_BUILDER.get();
        relBuilder.push(newInput).filter((Iterable)filter.getVariablesSet(), new RexNode[]{newConditionExpr});
        return this.result(relBuilder.build(), inputMapping);
    }

    public TrimResult trimFields(Sort sort, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = sort.getRowType();
        int fieldCount = rowType.getFieldCount();
        RelCollation collation = sort.getCollation();
        RelNode input = sort.getInput();
        ImmutableBitSet.Builder inputFieldsUsed = fieldsUsed.rebuild();
        for (RelFieldCollation field : collation.getFieldCollations()) {
            inputFieldsUsed.set(field.getFieldIndex());
        }
        Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
        TrimResult trimResult = this.trimChild((RelNode)sort, input, inputFieldsUsed.build(), inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (newInput == input && inputMapping.isIdentity() && fieldsUsed.cardinality() == fieldCount) {
            return this.result((RelNode)sort, (Mapping)Mappings.createIdentity((int)fieldCount));
        }
        if (sort.offset instanceof RexDynamicParam || sort.fetch instanceof RexDynamicParam) {
            return this.result((RelNode)sort, inputMapping);
        }
        RelBuilder relBuilder = REL_BUILDER.get();
        relBuilder.push(newInput);
        int offset = sort.offset == null ? 0 : RexLiteral.intValue((RexNode)sort.offset);
        int fetch = sort.fetch == null ? -1 : RexLiteral.intValue((RexNode)sort.fetch);
        ImmutableList fields = relBuilder.fields(RexUtil.apply((Mappings.TargetMapping)inputMapping, (RelCollation)collation));
        relBuilder.sortLimit(offset, fetch, (Iterable)fields);
        return this.result(relBuilder.build(), inputMapping);
    }

    public TrimResult trimFields(Join join, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        int fieldCount = join.getSystemFieldList().size() + join.getLeft().getRowType().getFieldCount() + join.getRight().getRowType().getFieldCount();
        RexNode conditionExpr = join.getCondition();
        int systemFieldCount = join.getSystemFieldList().size();
        LinkedHashSet<RelDataTypeField> combinedInputExtraFields = new LinkedHashSet<RelDataTypeField>(extraFields);
        RelOptUtil.InputFinder inputFinder = new RelOptUtil.InputFinder(combinedInputExtraFields);
        inputFinder.inputBitSet.addAll(fieldsUsed);
        conditionExpr.accept((RexVisitor)inputFinder);
        ImmutableBitSet fieldsUsedPlus = inputFinder.inputBitSet.build();
        int systemFieldUsedCount = 0;
        for (int i = 0; i < systemFieldCount; ++i) {
            if (!fieldsUsed.get(i)) continue;
            ++systemFieldUsedCount;
        }
        int newSystemFieldCount = systemFieldUsedCount == 0 ? 0 : systemFieldCount;
        int offset = systemFieldCount;
        int changeCount = 0;
        int newFieldCount = newSystemFieldCount;
        ArrayList<Object> newInputs = new ArrayList<Object>(2);
        ArrayList<Mapping> inputMappings = new ArrayList<Mapping>();
        ArrayList<Integer> inputExtraFieldCounts = new ArrayList<Integer>();
        for (RelNode input : join.getInputs()) {
            RelDataType inputRowType = input.getRowType();
            int inputFieldCount = inputRowType.getFieldCount();
            ImmutableBitSet.Builder inputFieldsUsed = ImmutableBitSet.builder();
            Iterator iterator = fieldsUsedPlus.iterator();
            while (iterator.hasNext()) {
                int bit = (Integer)iterator.next();
                if (bit < offset || bit >= offset + inputFieldCount) continue;
                inputFieldsUsed.set(bit - offset);
            }
            inputFieldsUsed.set(0, newSystemFieldCount);
            Set<RelDataTypeField> inputExtraFields = RelDataTypeImpl.extra((RelDataType)inputRowType) == null ? Collections.emptySet() : combinedInputExtraFields;
            inputExtraFieldCounts.add(inputExtraFields.size());
            TrimResult trimResult = this.trimChild((RelNode)join, input, inputFieldsUsed.build(), inputExtraFields);
            newInputs.add(trimResult.left);
            if (trimResult.left != input) {
                ++changeCount;
            }
            Mapping inputMapping = (Mapping)trimResult.right;
            inputMappings.add(inputMapping);
            offset += inputFieldCount;
            newFieldCount += inputMapping.getTargetCount() + inputExtraFields.size();
        }
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_SURJECTION, (int)fieldCount, (int)newFieldCount);
        for (int i = 0; i < newSystemFieldCount; ++i) {
            mapping.set(i, i);
        }
        offset = systemFieldCount;
        int newOffset = newSystemFieldCount;
        for (int i = 0; i < inputMappings.size(); ++i) {
            Mapping inputMapping = (Mapping)inputMappings.get(i);
            for (IntPair pair : inputMapping) {
                mapping.set(pair.source + offset, pair.target + newOffset);
            }
            offset += inputMapping.getSourceCount();
            newOffset += inputMapping.getTargetCount() + (Integer)inputExtraFieldCounts.get(i);
        }
        if (changeCount == 0 && mapping.isIdentity()) {
            return this.result((RelNode)join, (Mapping)Mappings.createIdentity((int)fieldCount));
        }
        RexPermuteInputsShuttle shuttle = new RexPermuteInputsShuttle((Mappings.TargetMapping)mapping, new RelNode[]{(RelNode)newInputs.get(0), (RelNode)newInputs.get(1)});
        RexNode newConditionExpr = (RexNode)conditionExpr.accept((RexVisitor)shuttle);
        RelBuilder relBuilder = REL_BUILDER.get();
        relBuilder.push((RelNode)newInputs.get(0));
        relBuilder.push((RelNode)newInputs.get(1));
        switch (join.getJoinType()) {
            case SEMI: 
            case ANTI: {
                if (join.getJoinType() == JoinRelType.SEMI) {
                    relBuilder.semiJoin(new RexNode[]{newConditionExpr});
                } else {
                    relBuilder.antiJoin(new RexNode[]{newConditionExpr});
                }
                Mapping inputMapping = (Mapping)inputMappings.get(0);
                mapping = Mappings.create((MappingType)MappingType.INVERSE_SURJECTION, (int)join.getRowType().getFieldCount(), (int)(newSystemFieldCount + inputMapping.getTargetCount()));
                for (int i = 0; i < newSystemFieldCount; ++i) {
                    mapping.set(i, i);
                }
                offset = systemFieldCount;
                newOffset = newSystemFieldCount;
                for (IntPair pair : inputMapping) {
                    mapping.set(pair.source + offset, pair.target + newOffset);
                }
                break;
            }
            default: {
                relBuilder.join(join.getJoinType(), newConditionExpr);
            }
        }
        return this.result(relBuilder.build(), mapping);
    }

    public TrimResult trimFields(SetOp setOp, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = setOp.getRowType();
        int fieldCount = rowType.getFieldCount();
        int changeCount = 0;
        if (fieldsUsed.isEmpty()) {
            fieldsUsed = ImmutableBitSet.of((int[])new int[]{rowType.getFieldCount() - 1});
        }
        Mapping mapping = this.createMapping(fieldsUsed, fieldCount);
        for (RelNode input : setOp.getInputs()) {
            TrimResult trimResult = this.trimChild((RelNode)setOp, input, fieldsUsed, extraFields);
            Mapping remaining = Mappings.divide((Mapping)mapping, (Mapping)((Mapping)trimResult.right));
            RelBuilder relBuilder = REL_BUILDER.get();
            relBuilder.push((RelNode)trimResult.left);
            relBuilder.permute(remaining);
            if (input == relBuilder.peek()) continue;
            ++changeCount;
        }
        RelBuilder relBuilder = REL_BUILDER.get();
        if (changeCount == 0 && mapping.isIdentity()) {
            for (RelNode input : setOp.getInputs()) {
                relBuilder.build();
            }
            return this.result((RelNode)setOp, mapping);
        }
        switch (setOp.kind) {
            case UNION: {
                relBuilder.union(setOp.all, setOp.getInputs().size());
                break;
            }
            case INTERSECT: {
                relBuilder.intersect(setOp.all, setOp.getInputs().size());
                break;
            }
            case EXCEPT: {
                assert (setOp.getInputs().size() == 2);
                relBuilder.minus(setOp.all);
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown setOp " + setOp));
            }
        }
        return this.result(relBuilder.build(), mapping);
    }

    public TrimResult trimFields(Aggregate aggregate, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = aggregate.getRowType();
        ImmutableBitSet.Builder inputFieldsUsed = aggregate.getGroupSet().rebuild();
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            inputFieldsUsed.addAll((Iterable)aggCall.getArgList());
            if (aggCall.filterArg >= 0) {
                inputFieldsUsed.set(aggCall.filterArg);
            }
            inputFieldsUsed.addAll((Iterable)RelCollations.ordinals((RelCollation)aggCall.collation));
        }
        RelNode input = aggregate.getInput();
        Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
        TrimResult trimResult = this.trimChild((RelNode)aggregate, input, inputFieldsUsed.build(), inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        int groupCount = aggregate.getGroupSet().cardinality();
        fieldsUsed = fieldsUsed.union(ImmutableBitSet.range((int)groupCount));
        if (input == newInput && fieldsUsed.equals((Object)ImmutableBitSet.range((int)rowType.getFieldCount()))) {
            return this.result((RelNode)aggregate, (Mapping)Mappings.createIdentity((int)rowType.getFieldCount()));
        }
        int j = groupCount;
        int usedAggCallCount = 0;
        for (int i = 0; i < aggregate.getAggCallList().size(); ++i) {
            if (!fieldsUsed.get(j++)) continue;
            ++usedAggCallCount;
        }
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_SURJECTION, (int)rowType.getFieldCount(), (int)(groupCount + usedAggCallCount));
        ImmutableBitSet newGroupSet = Mappings.apply((Mapping)inputMapping, (ImmutableBitSet)aggregate.getGroupSet());
        ImmutableList newGroupSets = ImmutableList.copyOf((Iterable)Iterables.transform((Iterable)aggregate.getGroupSets(), input1 -> Mappings.apply((Mapping)inputMapping, (ImmutableBitSet)input1)));
        for (j = 0; j < groupCount; ++j) {
            mapping.set(j, j);
        }
        RelBuilder relBuilder = REL_BUILDER.get();
        relBuilder.push(newInput);
        ArrayList<RelBuilder.AggCall> newAggCallList = new ArrayList<RelBuilder.AggCall>();
        j = groupCount;
        for (AggregateCall aggCall : aggregate.getAggCallList()) {
            if (fieldsUsed.get(j)) {
                ImmutableList args = relBuilder.fields(Mappings.apply2((Mapping)inputMapping, (List)aggCall.getArgList()));
                RexInputRef filterArg = aggCall.filterArg < 0 ? null : relBuilder.field(Mappings.apply((Mappings.TargetMapping)inputMapping, (int)aggCall.filterArg));
                RelBuilder.AggCall newAggCall = relBuilder.aggregateCall(aggCall.getAggregation(), (Iterable)args).distinct(aggCall.isDistinct()).filter((RexNode)filterArg).approximate(aggCall.isApproximate()).sort((Iterable)relBuilder.fields(aggCall.collation)).as(aggCall.name);
                mapping.set(j, groupCount + newAggCallList.size());
                newAggCallList.add(newAggCall);
            }
            ++j;
        }
        RelBuilder.GroupKey groupKey = relBuilder.groupKey(newGroupSet, newGroupSets);
        relBuilder.aggregate(groupKey, newAggCallList);
        return this.result(relBuilder.build(), mapping);
    }

    public TrimResult trimFields(LogicalTableModify modifier, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        Util.discard((Object)fieldsUsed);
        RelDataType rowType = modifier.getRowType();
        int fieldCount = rowType.getFieldCount();
        RelNode input = modifier.getInput();
        int inputFieldCount = input.getRowType().getFieldCount();
        ImmutableBitSet inputFieldsUsed = ImmutableBitSet.range((int)inputFieldCount);
        Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
        TrimResult trimResult = this.trimChild((RelNode)modifier, input, inputFieldsUsed, inputExtraFields);
        RelNode newInput = (RelNode)trimResult.left;
        Mapping inputMapping = (Mapping)trimResult.right;
        if (!inputMapping.isIdentity()) {
            throw new AssertionError((Object)("Expected identity mapping, got " + inputMapping));
        }
        LogicalTableModify newModifier = modifier;
        if (newInput != input) {
            newModifier = modifier.copy(modifier.getTraitSet(), Collections.singletonList(newInput));
        }
        assert (newModifier.getClass() == modifier.getClass());
        Mappings.IdentityMapping mapping = Mappings.createIdentity((int)fieldCount);
        return this.result((RelNode)newModifier, (Mapping)mapping);
    }

    public TrimResult trimFields(LogicalTableFunctionScan tabFun, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = tabFun.getRowType();
        int fieldCount = rowType.getFieldCount();
        ArrayList<Object> newInputs = new ArrayList<Object>();
        for (RelNode input : tabFun.getInputs()) {
            int inputFieldCount = input.getRowType().getFieldCount();
            ImmutableBitSet inputFieldsUsed = ImmutableBitSet.range((int)inputFieldCount);
            Set<RelDataTypeField> inputExtraFields = Collections.emptySet();
            TrimResult trimResult = this.trimChildRestore((RelNode)tabFun, input, inputFieldsUsed, inputExtraFields);
            assert (((Mapping)trimResult.right).isIdentity());
            newInputs.add(trimResult.left);
        }
        LogicalTableFunctionScan newTabFun = tabFun;
        if (!tabFun.getInputs().equals(newInputs)) {
            newTabFun = tabFun.copy(tabFun.getTraitSet(), newInputs, tabFun.getCall(), tabFun.getElementType(), tabFun.getRowType(), tabFun.getColumnMappings());
        }
        assert (newTabFun.getClass() == tabFun.getClass());
        Mappings.IdentityMapping mapping = Mappings.createIdentity((int)fieldCount);
        return this.result((RelNode)newTabFun, (Mapping)mapping);
    }

    public TrimResult trimFields(LogicalValues values, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        RelDataType rowType = values.getRowType();
        int fieldCount = rowType.getFieldCount();
        if (fieldsUsed.isEmpty()) {
            fieldsUsed = ImmutableBitSet.range((int)(fieldCount - 1), (int)fieldCount);
        }
        if (fieldsUsed.equals((Object)ImmutableBitSet.range((int)fieldCount))) {
            Mappings.IdentityMapping mapping = Mappings.createIdentity((int)fieldCount);
            return this.result((RelNode)values, (Mapping)mapping);
        }
        ImmutableList.Builder newTuples = ImmutableList.builder();
        for (ImmutableList tuple : values.getTuples()) {
            ImmutableList.Builder newTuple = ImmutableList.builder();
            Iterator iterator = fieldsUsed.iterator();
            while (iterator.hasNext()) {
                int field = (Integer)iterator.next();
                newTuple.add(tuple.get(field));
            }
            newTuples.add((Object)newTuple.build());
        }
        Mapping mapping = this.createMapping(fieldsUsed, fieldCount);
        RelDataType newRowType = RelOptUtil.permute((RelDataTypeFactory)values.getCluster().getTypeFactory(), (RelDataType)rowType, (Mapping)mapping);
        LogicalValues newValues = LogicalValues.create((RelOptCluster)values.getCluster(), (RelDataType)newRowType, (ImmutableList)newTuples.build());
        return this.result((RelNode)newValues, mapping);
    }

    protected Mapping createMapping(ImmutableBitSet fieldsUsed, int fieldCount) {
        Mapping mapping = Mappings.create((MappingType)MappingType.INVERSE_SURJECTION, (int)fieldCount, (int)fieldsUsed.cardinality());
        int i = 0;
        Iterator iterator = fieldsUsed.iterator();
        while (iterator.hasNext()) {
            int field = (Integer)iterator.next();
            mapping.set(field, i++);
        }
        return mapping;
    }

    public TrimResult trimFields(TableScan tableAccessRel, ImmutableBitSet fieldsUsed, Set<RelDataTypeField> extraFields) {
        int fieldCount = tableAccessRel.getRowType().getFieldCount();
        if (fieldsUsed.equals((Object)ImmutableBitSet.range((int)fieldCount)) && extraFields.isEmpty()) {
            return this.trimFields((RelNode)tableAccessRel, fieldsUsed, extraFields);
        }
        RelNode newTableAccessRel = tableAccessRel.project(fieldsUsed, extraFields, REL_BUILDER.get());
        if (fieldsUsed.cardinality() == 0) {
            Project project;
            RelNode input = newTableAccessRel;
            if (input instanceof Project && (project = (Project)input).getRowType().getFieldCount() == 0) {
                input = project.getInput();
            }
            return this.dummyProject(fieldCount, input);
        }
        Mapping mapping = this.createMapping(fieldsUsed, fieldCount);
        return this.result(newTableAccessRel, mapping);
    }

    protected static class TrimResult
    extends Pair<RelNode, Mapping> {
        public TrimResult(RelNode left, Mapping right) {
            super((Object)left, (Object)right);
            assert (right.getTargetCount() == left.getRowType().getFieldCount()) : "rowType: " + left.getRowType() + ", mapping: " + right;
        }
    }
}

