/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexFieldCollation;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexWindow;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlKind;
import org.apache.commons.collections.CollectionUtils;
import org.apache.hadoop.hive.ql.optimizer.calcite.translator.SqlFunctionConverter;

public class HiveWindowingLastValueRewrite
extends RelOptRule {
    public static final HiveWindowingLastValueRewrite INSTANCE = new HiveWindowingLastValueRewrite();
    private static final String FIRST_VALUE_FUNC = "first_value";
    private static final String LAST_VALUE_FUNC = "last_value";

    private HiveWindowingLastValueRewrite() {
        super(HiveWindowingLastValueRewrite.operand(Project.class, (RelOptRuleOperandChildren)HiveWindowingLastValueRewrite.any()));
    }

    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        ArrayList<RexNode> newExprs = new ArrayList<RexNode>();
        LastValueRewriteRexShuttle lastValueRewrite = new LastValueRewriteRexShuttle(project.getCluster().getRexBuilder());
        boolean modified = false;
        for (RexNode expr : project.getChildExps()) {
            RexNode newExpr = lastValueRewrite.apply(expr);
            newExprs.add(newExpr);
            modified |= newExpr != expr;
        }
        if (modified) {
            Project newProject = project.copy(project.getTraitSet(), project.getInput(), newExprs, project.getRowType());
            call.transformTo((RelNode)newProject);
        }
    }

    private static class LastValueRewriteRexShuttle
    extends RexShuttle {
        private final RexBuilder rexBuilder;

        private LastValueRewriteRexShuttle(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public RexNode visitOver(RexOver over) {
            if (over.op.getName().equals(HiveWindowingLastValueRewrite.LAST_VALUE_FUNC) && over.getWindow().getLowerBound().isUnbounded() && over.getWindow().getUpperBound().isUnbounded()) {
                ImmutableList orderKeys = over.getWindow().orderKeys;
                if (CollectionUtils.isEmpty((Collection)orderKeys)) {
                    return over;
                }
                ImmutableList.Builder newOrderKeys = ImmutableList.builder();
                for (RexFieldCollation orderKey : orderKeys) {
                    HashSet<SqlKind> flags = new HashSet<SqlKind>();
                    if (orderKey.getDirection() == RelFieldCollation.Direction.ASCENDING) {
                        flags.add(SqlKind.DESCENDING);
                    }
                    if (((ImmutableSet)orderKey.right).contains((Object)SqlKind.NULLS_FIRST)) {
                        flags.add(SqlKind.NULLS_LAST);
                    } else {
                        flags.add(SqlKind.NULLS_FIRST);
                    }
                    newOrderKeys.add((Object)new RexFieldCollation((RexNode)orderKey.left, flags));
                }
                SqlAggFunction s = (SqlAggFunction)over.op;
                SqlFunctionConverter.CalciteUDAF newSqlAggFunction = new SqlFunctionConverter.CalciteUDAF(over.isDistinct(), HiveWindowingLastValueRewrite.FIRST_VALUE_FUNC, s.getReturnTypeInference(), s.getOperandTypeInference(), s.getOperandTypeChecker());
                List clonedOperands = this.visitList((List)over.operands, new boolean[]{false});
                RexWindow window = this.visitWindow(over.getWindow());
                return this.rexBuilder.makeOver(over.type, (SqlAggFunction)newSqlAggFunction, clonedOperands, (List)window.partitionKeys, newOrderKeys.build(), window.getLowerBound(), window.getUpperBound(), window.isRows(), true, false, over.isDistinct(), over.ignoreNulls());
            }
            return over;
        }
    }
}

