/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveRemoveGBYSemiJoinRule
extends RelOptRule {
    protected static final Logger LOG = LoggerFactory.getLogger(HiveRemoveGBYSemiJoinRule.class);
    public static final HiveRemoveGBYSemiJoinRule INSTANCE = new HiveRemoveGBYSemiJoinRule();

    public HiveRemoveGBYSemiJoinRule() {
        super(HiveRemoveGBYSemiJoinRule.operand(Join.class, (RelOptRuleOperandChildren)HiveRemoveGBYSemiJoinRule.some((RelOptRuleOperand)HiveRemoveGBYSemiJoinRule.operand(RelNode.class, (RelOptRuleOperandChildren)HiveRemoveGBYSemiJoinRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[]{HiveRemoveGBYSemiJoinRule.operand(Aggregate.class, (RelOptRuleOperandChildren)HiveRemoveGBYSemiJoinRule.any())})), HiveRelFactories.HIVE_BUILDER, "HiveRemoveGBYSemiJoinRule");
    }

    public void onMatch(RelOptRuleCall call) {
        HiveCalciteUtil.JoinPredicateInfo joinPredInfo;
        Join join = (Join)call.rel(0);
        if (join.getJoinType() != JoinRelType.SEMI && join.getJoinType() != JoinRelType.ANTI) {
            return;
        }
        RelNode left = call.rel(1);
        Aggregate rightAggregate = (Aggregate)call.rel(2);
        if (rightAggregate.getGroupType() != Aggregate.Group.SIMPLE) {
            return;
        }
        rightAggregate.getClass();
        if (!rightAggregate.getAggCallList().isEmpty()) {
            return;
        }
        try {
            joinPredInfo = HiveCalciteUtil.JoinPredicateInfo.constructJoinPredicateInfo(join);
        }
        catch (CalciteSemanticException e) {
            LOG.warn("Exception while extracting predicate info from {}", (Object)join);
            return;
        }
        if (!joinPredInfo.getNonEquiJoinPredicateElements().isEmpty()) {
            return;
        }
        ImmutableBitSet.Builder rightKeys = ImmutableBitSet.builder();
        for (HiveCalciteUtil.JoinLeafPredicateInfo leftPredInfo : joinPredInfo.getEquiJoinPredicateElements()) {
            rightKeys.addAll(leftPredInfo.getProjsFromRightPartOfJoinKeysInChildSchema());
        }
        boolean shouldTransform = rightKeys.build().equals((Object)ImmutableBitSet.range((int)rightAggregate.getGroupCount()));
        if (shouldTransform) {
            RelBuilder relBuilder = call.builder();
            RelNode newRightInput = relBuilder.project((Iterable)relBuilder.push(rightAggregate.getInput()).fields(rightAggregate.getGroupSet().asList())).build();
            RelNode newJoin = join.getJoinType() == JoinRelType.SEMI ? call.builder().push(left).push(newRightInput).semiJoin(new RexNode[]{join.getCondition()}).build() : call.builder().push(left).push(newRightInput).antiJoin(new RexNode[]{join.getCondition()}).build();
            call.transformTo(newJoin);
        }
    }
}

