/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollationImpl;
import org.apache.calcite.rel.RelCollationTraitDef;
import org.apache.calcite.rel.RelDistribution;
import org.apache.calcite.rel.RelDistributionTraitDef;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.SortExchange;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelDistribution;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelOptUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.TraitsUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveProject;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSortExchange;

public final class HiveProjectSortExchangeTransposeRule
extends RelOptRule {
    public static final HiveProjectSortExchangeTransposeRule INSTANCE = new HiveProjectSortExchangeTransposeRule();

    private HiveProjectSortExchangeTransposeRule() {
        super(HiveProjectSortExchangeTransposeRule.operand(HiveProject.class, (RelOptRuleOperand)HiveProjectSortExchangeTransposeRule.operand(HiveSortExchange.class, (RelOptRuleOperandChildren)HiveProjectSortExchangeTransposeRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]));
    }

    protected HiveProjectSortExchangeTransposeRule(RelOptRuleOperand operand) {
        super(operand);
    }

    public void onMatch(RelOptRuleCall call) {
        HiveProject project = (HiveProject)call.rel(0);
        HiveSortExchange sortExchange = (HiveSortExchange)call.rel(1);
        RelOptCluster cluster = project.getCluster();
        List<RelFieldCollation> fieldCollations = HiveRelOptUtil.getNewRelFieldCollations(project, sortExchange.getCollation(), cluster);
        if (fieldCollations == null) {
            return;
        }
        RelCollation newCollation = (RelCollation)RelCollationTraitDef.INSTANCE.canonize((RelTrait)RelCollationImpl.of(fieldCollations));
        List<Integer> newDistributionKeys = HiveRelOptUtil.getNewRelDistributionKeys(project, sortExchange.getDistribution());
        RelDistribution newDistribution = (RelDistribution)RelDistributionTraitDef.INSTANCE.canonize((RelTrait)new HiveRelDistribution(sortExchange.getDistribution().getType(), newDistributionKeys));
        RelTraitSet newTraitSet = TraitsUtil.getDefaultTraitSet(sortExchange.getCluster()).replace((RelTrait)newCollation).replace((RelTrait)newDistribution);
        RelNode newProject = project.copy(sortExchange.getInput().getTraitSet(), (List)ImmutableList.of((Object)sortExchange.getInput()));
        SortExchange newSort = sortExchange.copy(newTraitSet, newProject, newDistribution, newCollation);
        call.transformTo((RelNode)newSort);
    }
}

