/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.rules.ProjectMergeRule;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexOver;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;

public class HiveProjectMergeRule
extends ProjectMergeRule {
    public static final HiveProjectMergeRule INSTANCE = new HiveProjectMergeRule(true, HiveRelFactories.HIVE_BUILDER);
    public static final HiveProjectMergeRule INSTANCE_NO_FORCE = new HiveProjectMergeRule(false, HiveRelFactories.HIVE_BUILDER);

    private HiveProjectMergeRule(boolean force, RelBuilderFactory relBuilderFactory) {
        super(force, relBuilderFactory);
    }

    public boolean matches(RelOptRuleCall call) {
        Project topProject = (Project)call.rel(0);
        Project bottomProject = (Project)call.rel(1);
        for (RexNode expr : topProject.getChildExps()) {
            if (!(expr instanceof RexOver)) continue;
            Set<Integer> positions = HiveCalciteUtil.getInputRefs(expr);
            for (int pos : positions) {
                if (!(bottomProject.getChildExps().get(pos) instanceof RexOver)) continue;
                return false;
            }
        }
        return super.matches(call);
    }

    public void onMatch(RelOptRuleCall call) {
        Project topProject = (Project)call.rel(0);
        Project bottomProject = (Project)call.rel(1);
        ImmutableBitSet topRefs = RelOptUtil.InputFinder.bits((List)topProject.getChildExps(), null);
        if (topRefs.isEmpty()) {
            RelBuilder relBuilder = call.builder();
            relBuilder.push(bottomProject.getInput());
            relBuilder.project((Iterable)topProject.getChildExps());
            call.transformTo(relBuilder.build());
            return;
        }
        super.onMatch(call);
    }
}

