/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAntiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveSemiJoin;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRulesRegistry;

public final class HiveJoinAddNotNullRule
extends RelOptRule {
    public static final HiveJoinAddNotNullRule INSTANCE_JOIN = new HiveJoinAddNotNullRule(HiveJoin.class, HiveRelFactories.HIVE_FILTER_FACTORY);
    public static final HiveJoinAddNotNullRule INSTANCE_SEMIJOIN = new HiveJoinAddNotNullRule(HiveSemiJoin.class, HiveRelFactories.HIVE_FILTER_FACTORY);
    public static final HiveJoinAddNotNullRule INSTANCE_ANTIJOIN = new HiveJoinAddNotNullRule(HiveAntiJoin.class, HiveRelFactories.HIVE_FILTER_FACTORY);
    private final RelFactories.FilterFactory filterFactory;

    public HiveJoinAddNotNullRule(Class<? extends Join> clazz, RelFactories.FilterFactory filterFactory) {
        super(HiveJoinAddNotNullRule.operand(clazz, (RelOptRuleOperandChildren)HiveJoinAddNotNullRule.any()));
        this.filterFactory = filterFactory;
    }

    public void onMatch(RelOptRuleCall call) {
        HiveCalciteUtil.JoinPredicateInfo joinPredInfo;
        Join join = (Join)call.rel(0);
        if (join.getJoinType() == JoinRelType.FULL || join.getJoinType() != JoinRelType.ANTI && join.getCondition().isAlwaysTrue()) {
            return;
        }
        try {
            joinPredInfo = HiveCalciteUtil.JoinPredicateInfo.constructJoinPredicateInfo(join);
        }
        catch (CalciteSemanticException e) {
            return;
        }
        HiveRulesRegistry registry = (HiveRulesRegistry)call.getPlanner().getContext().unwrap(HiveRulesRegistry.class);
        assert (registry != null);
        HashSet leftPushedPredicates = Sets.newHashSet(registry.getPushedPredicates((RelNode)join, 0));
        HashSet rightPushedPredicates = Sets.newHashSet(registry.getPushedPredicates((RelNode)join, 1));
        boolean genPredOnLeft = join.getJoinType() == JoinRelType.RIGHT || join.getJoinType() == JoinRelType.INNER || join.isSemiJoin();
        boolean genPredOnRight = join.getJoinType() == JoinRelType.LEFT || join.getJoinType() == JoinRelType.INNER || join.isSemiJoin() || join.getJoinType() == JoinRelType.ANTI;
        RexNode newLeftPredicate = this.getNewPredicate(join, registry, joinPredInfo, leftPushedPredicates, genPredOnLeft, 0);
        RexNode newRightPredicate = this.getNewPredicate(join, registry, joinPredInfo, rightPushedPredicates, genPredOnRight, 1);
        if (newLeftPredicate.isAlwaysTrue() && newRightPredicate.isAlwaysTrue()) {
            return;
        }
        RelNode lChild = this.getNewChild(call, join, join.getLeft(), newLeftPredicate);
        RelNode rChild = this.getNewChild(call, join, join.getRight(), newRightPredicate);
        Join newJoin = join.copy(join.getTraitSet(), join.getCondition(), lChild, rChild, join.getJoinType(), join.isSemiJoinDone());
        call.getPlanner().onCopy((RelNode)join, (RelNode)newJoin);
        registry.getPushedPredicates((RelNode)newJoin, 0).addAll(leftPushedPredicates);
        registry.getPushedPredicates((RelNode)newJoin, 1).addAll(rightPushedPredicates);
        call.transformTo((RelNode)newJoin);
    }

    private RexNode getNewPredicate(Join join, HiveRulesRegistry registry, HiveCalciteUtil.JoinPredicateInfo joinPredInfo, Set<String> pushedPredicates, boolean genPred, int pos) {
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        if (genPred) {
            ArrayList<RexNode> joinExprsList = new ArrayList<RexNode>();
            for (HiveCalciteUtil.JoinLeafPredicateInfo joinLeafPredicateInfo : joinPredInfo.getEquiJoinPredicateElements()) {
                joinExprsList.addAll(joinLeafPredicateInfo.getJoinExprs(pos));
            }
            for (HiveCalciteUtil.JoinLeafPredicateInfo joinLeafPredicateInfo : joinPredInfo.getNonEquiJoinPredicateElements()) {
                if (!SqlKind.COMPARISON.contains(joinLeafPredicateInfo.getComparisonType())) continue;
                joinExprsList.addAll(joinLeafPredicateInfo.getJoinExprs(pos));
            }
            List<RexNode> newConditions = HiveJoinAddNotNullRule.getNotNullConditions(rexBuilder, joinExprsList, pushedPredicates);
            return RexUtil.composeConjunction((RexBuilder)rexBuilder, newConditions, (boolean)false);
        }
        return rexBuilder.makeLiteral(true);
    }

    private static List<RexNode> getNotNullConditions(RexBuilder rexBuilder, List<RexNode> inputJoinExprs, Set<String> pushedPredicates) {
        ArrayList newConditions = Lists.newArrayList();
        for (RexNode rexNode : inputJoinExprs) {
            RexNode cond = rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{rexNode});
            String digest = cond.toString();
            if (!pushedPredicates.add(digest)) continue;
            newConditions.add(cond);
        }
        return newConditions;
    }

    private RelNode getNewChild(RelOptRuleCall call, Join join, RelNode child, RexNode newPredicate) {
        if (!newPredicate.isAlwaysTrue()) {
            RelNode newChild = this.filterFactory.createFilter(child, newPredicate);
            call.getPlanner().onCopy(child, newChild);
            return newChild;
        }
        return child;
    }
}

