/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.core.Union;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.rules.FilterSetOpTransposeRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexExecutor;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSimplify;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.Util;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;

public class HiveFilterSetOpTransposeRule
extends FilterSetOpTransposeRule {
    public static final HiveFilterSetOpTransposeRule INSTANCE = new HiveFilterSetOpTransposeRule(HiveRelFactories.HIVE_BUILDER);

    private HiveFilterSetOpTransposeRule(RelBuilderFactory relBuilderFactory) {
        super(relBuilderFactory);
    }

    public boolean matches(RelOptRuleCall call) {
        Filter filterRel = (Filter)call.rel(0);
        RexNode condition = filterRel.getCondition();
        if (!HiveCalciteUtil.isDeterministic(condition)) {
            return false;
        }
        return super.matches(call);
    }

    public void onMatch(RelOptRuleCall call) {
        Filter filterRel = (Filter)call.rel(0);
        SetOp setOp = (SetOp)call.rel(1);
        RexNode condition = filterRel.getCondition();
        RexBuilder rexBuilder = filterRel.getCluster().getRexBuilder();
        RelBuilder relBuilder = call.builder();
        List origFields = setOp.getRowType().getFieldList();
        int[] adjustments = new int[origFields.size()];
        ArrayList<RelNode> newSetOpInputs = new ArrayList<RelNode>();
        RelNode lastInput = null;
        for (int index = 0; index < setOp.getInputs().size(); ++index) {
            RelMetadataQuery mq;
            RelOptPredicateList predicates;
            RelNode input = setOp.getInput(index);
            RexNode newCondition = (RexNode)condition.accept((RexVisitor)new RelOptUtil.RexInputConverter(rexBuilder, origFields, input.getRowType().getFieldList(), adjustments));
            if (setOp instanceof Union && setOp.all && (predicates = (mq = call.getMetadataQuery()).getPulledUpPredicates(input)) != null) {
                ImmutableList.Builder listBuilder = ImmutableList.builder();
                listBuilder.addAll((Iterable)predicates.pulledUpPredicates);
                listBuilder.add((Object)newCondition);
                RexExecutor executor = (RexExecutor)Util.first((Object)filterRel.getCluster().getPlanner().getExecutor(), (Object)RexUtil.EXECUTOR);
                RexSimplify simplify = new RexSimplify(rexBuilder, RelOptPredicateList.EMPTY, executor);
                RexNode cond = RexUtil.composeConjunction((RexBuilder)rexBuilder, (Iterable)listBuilder.build());
                RexNode x = simplify.simplifyUnknownAs(cond, RexUnknownAs.FALSE);
                if (x.isAlwaysFalse()) {
                    if (index != setOp.getInputs().size() - 1) continue;
                    lastInput = relBuilder.push(input).filter(new RexNode[]{newCondition}).build();
                    continue;
                }
            }
            newSetOpInputs.add(relBuilder.push(input).filter(new RexNode[]{newCondition}).build());
        }
        if (newSetOpInputs.size() > 1) {
            SetOp newSetOp = setOp.copy(setOp.getTraitSet(), newSetOpInputs);
            call.transformTo((RelNode)newSetOp);
        } else {
            RelNode result = newSetOpInputs.size() == 1 ? (RelNode)newSetOpInputs.get(0) : lastInput;
            call.transformTo(relBuilder.push(result).convert(filterRel.getRowType(), false).build());
        }
    }
}

