/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.rules.FilterJoinRule;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveCalciteUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelOptUtil;

public abstract class HiveFilterJoinRule
extends FilterJoinRule {
    public static final HiveFilterJoinRule FILTER_ON_NON_FILTERING_JOIN = new HiveFilterNonFilteringJoinMergeRule();
    public static final HiveFilterJoinRule FILTER_ON_JOIN = new HiveFilterJoinMergeRule();
    public static final HiveFilterJoinRule JOIN = new HiveFilterJoinTransposeRule();

    protected HiveFilterJoinRule(RelOptRuleOperand operand, String id, boolean smart, RelBuilderFactory relBuilderFactory) {
        super(operand, id, smart, relBuilderFactory, TRUE_PREDICATE);
    }

    protected void perform(RelOptRuleCall call, Filter filter, Join join) {
        List joinFilters = RelOptUtil.conjunctions((RexNode)join.getCondition());
        ImmutableList origJoinFilters = ImmutableList.copyOf((Collection)joinFilters);
        if (filter == null && joinFilters.isEmpty()) {
            return;
        }
        ArrayList<RexNode> aboveFilters = filter != null ? this.getConjunctions(filter) : new ArrayList();
        ImmutableList origAboveFilters = ImmutableList.copyOf(aboveFilters);
        JoinRelType joinType = join.getJoinType();
        if (!origAboveFilters.isEmpty() && join.getJoinType() != JoinRelType.INNER) {
            joinType = RelOptUtil.simplifyJoin((RelNode)join, (ImmutableList)origAboveFilters, (JoinRelType)joinType);
        }
        ArrayList<RexNode> leftFilters = new ArrayList<RexNode>();
        ArrayList<RexNode> rightFilters = new ArrayList<RexNode>();
        boolean filterPushed = HiveFilterJoinRule.classifyFilters((RelNode)join, aboveFilters, joinType == JoinRelType.INNER || joinType == JoinRelType.SEMI, joinType == JoinRelType.INNER || joinType == JoinRelType.LEFT || joinType == JoinRelType.SEMI || joinType == JoinRelType.ANTI, joinType == JoinRelType.INNER || joinType == JoinRelType.RIGHT, joinFilters, leftFilters, rightFilters);
        this.validateJoinFilters(aboveFilters, joinFilters, join, joinType);
        if (leftFilters.isEmpty() && rightFilters.isEmpty() && joinFilters.size() == origJoinFilters.size() && Sets.newHashSet((Iterable)joinFilters).equals(Sets.newHashSet((Iterable)origJoinFilters))) {
            filterPushed = false;
        }
        if (joinType != JoinRelType.ANTI && HiveFilterJoinRule.classifyFilters((RelNode)join, joinFilters, false, joinType == JoinRelType.INNER || joinType == JoinRelType.RIGHT || joinType == JoinRelType.SEMI, joinType == JoinRelType.INNER || joinType == JoinRelType.LEFT || joinType == JoinRelType.SEMI, joinFilters, leftFilters, rightFilters)) {
            filterPushed = true;
        }
        if (!filterPushed && joinType == join.getJoinType() || joinFilters.isEmpty() && leftFilters.isEmpty() && rightFilters.isEmpty()) {
            return;
        }
        RexBuilder rexBuilder = join.getCluster().getRexBuilder();
        RelBuilder relBuilder = call.builder();
        RelNode leftRel = relBuilder.push(join.getLeft()).filter(leftFilters).build();
        RelNode rightRel = relBuilder.push(join.getRight()).filter(rightFilters).build();
        ImmutableList fieldTypes = ImmutableList.builder().addAll((Iterable)RelOptUtil.getFieldTypeList((RelDataType)leftRel.getRowType())).addAll((Iterable)RelOptUtil.getFieldTypeList((RelDataType)rightRel.getRowType())).build();
        RexNode joinFilter = RexUtil.composeConjunction((RexBuilder)rexBuilder, (Iterable)RexUtil.fixUp((RexBuilder)rexBuilder, (List)joinFilters, (List)fieldTypes));
        if (joinFilter.isAlwaysTrue() && leftFilters.isEmpty() && rightFilters.isEmpty() && joinType == join.getJoinType()) {
            return;
        }
        Join newJoinRel = join.copy(join.getTraitSet(), joinFilter, leftRel, rightRel, joinType, join.isSemiJoinDone());
        call.getPlanner().onCopy((RelNode)join, (RelNode)newJoinRel);
        if (!leftFilters.isEmpty()) {
            call.getPlanner().onCopy((RelNode)filter, leftRel);
        }
        if (!rightFilters.isEmpty()) {
            call.getPlanner().onCopy((RelNode)filter, rightRel);
        }
        relBuilder.push((RelNode)newJoinRel);
        relBuilder.convert(join.getRowType(), false);
        relBuilder.filter((Iterable)RexUtil.fixUp((RexBuilder)rexBuilder, aboveFilters, (List)RelOptUtil.getFieldTypeList((RelDataType)relBuilder.peek().getRowType())));
        call.transformTo(relBuilder.build());
    }

    private List<RexNode> getConjunctions(Filter filter) {
        List conjunctions = RelOptUtil.conjunctions((RexNode)filter.getCondition());
        RexBuilder rexBuilder = filter.getCluster().getRexBuilder();
        for (int i = 0; i < conjunctions.size(); ++i) {
            RexNode node = (RexNode)conjunctions.get(i);
            if (!(node instanceof RexCall)) continue;
            conjunctions.set(i, RelOptUtil.collapseExpandedIsNotDistinctFromExpr((RexCall)((RexCall)node), (RexBuilder)rexBuilder));
        }
        return conjunctions;
    }

    private static boolean classifyFilters(RelNode joinRel, List<RexNode> filters, boolean pushInto, boolean pushLeft, boolean pushRight, List<RexNode> joinFilters, List<RexNode> leftFilters, List<RexNode> rightFilters) {
        RexBuilder rexBuilder = joinRel.getCluster().getRexBuilder();
        List joinFields = joinRel.getRowType().getFieldList();
        boolean nSysFields = false;
        List leftFields = ((RelNode)joinRel.getInputs().get(0)).getRowType().getFieldList();
        int nFieldsLeft = leftFields.size();
        List rightFields = ((RelNode)joinRel.getInputs().get(1)).getRowType().getFieldList();
        int nFieldsRight = rightFields.size();
        int nTotalFields = nFieldsLeft + nFieldsRight;
        ImmutableBitSet leftBitmap = ImmutableBitSet.range((int)0, (int)(0 + nFieldsLeft));
        ImmutableBitSet rightBitmap = ImmutableBitSet.range((int)(0 + nFieldsLeft), (int)nTotalFields);
        ArrayList<RexNode> filtersToRemove = new ArrayList<RexNode>();
        for (RexNode filter : filters) {
            RexNode shiftedFilter;
            RelOptUtil.InputFinder inputFinder = RelOptUtil.InputFinder.analyze((RexNode)filter);
            ImmutableBitSet inputBits = inputFinder.inputBitSet.build();
            if (pushLeft && leftBitmap.contains(inputBits)) {
                if (!filter.isAlwaysTrue()) {
                    shiftedFilter = HiveFilterJoinRule.shiftFilter(0, 0 + nFieldsLeft, 0, rexBuilder, joinFields, nTotalFields, leftFields, filter);
                    leftFilters.add(shiftedFilter);
                }
                filtersToRemove.add(filter);
                continue;
            }
            if (pushRight && rightBitmap.contains(inputBits)) {
                if (!filter.isAlwaysTrue()) {
                    shiftedFilter = HiveFilterJoinRule.shiftFilter(0 + nFieldsLeft, nTotalFields, -(0 + nFieldsLeft), rexBuilder, joinFields, nTotalFields, rightFields, filter);
                    rightFilters.add(shiftedFilter);
                }
                filtersToRemove.add(filter);
                continue;
            }
            if (!pushInto) continue;
            if (!joinFilters.contains(filter)) {
                joinFilters.add(filter);
            }
            filtersToRemove.add(filter);
        }
        if (!filtersToRemove.isEmpty()) {
            filters.removeAll(filtersToRemove);
        }
        return !filtersToRemove.isEmpty();
    }

    private static RexNode shiftFilter(int start, int end, int offset, RexBuilder rexBuilder, List<RelDataTypeField> joinFields, int nTotalFields, List<RelDataTypeField> rightFields, RexNode filter) {
        int[] adjustments = new int[nTotalFields];
        for (int i = start; i < end; ++i) {
            adjustments[i] = offset;
        }
        return (RexNode)filter.accept((RexVisitor)new RelOptUtil.RexInputConverter(rexBuilder, joinFields, rightFields, adjustments));
    }

    public static class HiveFilterJoinTransposeRule
    extends HiveFilterJoinRule {
        public HiveFilterJoinTransposeRule() {
            super(RelOptRule.operand(Join.class, (RelOptRuleOperandChildren)RelOptRule.any()), "HiveFilterJoinRule:no-filter", true, HiveRelFactories.HIVE_BUILDER);
        }

        public boolean matches(RelOptRuleCall call) {
            Join join = (Join)call.rel(0);
            List joinConds = RelOptUtil.conjunctions((RexNode)join.getCondition());
            for (RexNode joinCnd : joinConds) {
                if (HiveCalciteUtil.isDeterministic(joinCnd)) continue;
                return false;
            }
            return true;
        }

        public void onMatch(RelOptRuleCall call) {
            Join join = (Join)call.rel(0);
            super.perform(call, null, join);
        }
    }

    public static class HiveFilterJoinMergeRule
    extends HiveFilterJoinRule {
        public HiveFilterJoinMergeRule() {
            super(HiveFilterJoinMergeRule.operand(Filter.class, (RelOptRuleOperand)HiveFilterJoinMergeRule.operand(Join.class, (RelOptRuleOperandChildren)HiveFilterJoinMergeRule.any()), (RelOptRuleOperand[])new RelOptRuleOperand[0]), null, true, HiveRelFactories.HIVE_BUILDER);
        }

        public boolean matches(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            return HiveCalciteUtil.isDeterministic(filter.getCondition());
        }

        public void onMatch(RelOptRuleCall call) {
            Filter filter = (Filter)call.rel(0);
            Join join = (Join)call.rel(1);
            super.perform(call, filter, join);
        }
    }

    public static class HiveFilterNonFilteringJoinMergeRule
    extends HiveFilterJoinMergeRule {
        @Override
        public boolean matches(RelOptRuleCall call) {
            Join join = (Join)call.rel(1);
            HiveRelOptUtil.RewritablePKFKJoinInfo joinInfo = HiveRelOptUtil.isRewritablePKFKJoin(join, join.getLeft(), join.getRight(), call.getMetadataQuery());
            if (!joinInfo.rewritable) {
                return false;
            }
            return super.matches(call);
        }
    }
}

