/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.hep.HepPlanner;
import org.apache.calcite.plan.hep.HepProgram;
import org.apache.calcite.plan.hep.HepProgramBuilder;
import org.apache.calcite.plan.hep.HepRelVertex;
import org.apache.calcite.rel.RelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRelFieldTrimmer;

public class HiveFieldTrimmerRule
extends RelOptRule {
    private static final HepProgram PROGRAM = new HepProgramBuilder().addRuleInstance((RelOptRule)HiveHepExtractRelNodeRule.access$000()).build();
    private final boolean fetchStats;
    private boolean triggered;

    public HiveFieldTrimmerRule(boolean fetchStats) {
        this(fetchStats, "HiveFieldTrimmerRule");
    }

    protected HiveFieldTrimmerRule(boolean fetchStats, String description) {
        super(HiveFieldTrimmerRule.operand(RelNode.class, (RelOptRuleOperandChildren)HiveFieldTrimmerRule.any()), HiveRelFactories.HIVE_BUILDER, description);
        this.fetchStats = fetchStats;
        this.triggered = false;
    }

    public void onMatch(RelOptRuleCall call) {
        if (this.triggered) {
            return;
        }
        RelNode node = call.rel(0);
        HepRelVertex root = (HepRelVertex)call.getPlanner().getRoot();
        if (root.getCurrentRel() != node) {
            return;
        }
        HepPlanner tmpPlanner = new HepPlanner(PROGRAM);
        tmpPlanner.setRoot(node);
        node = tmpPlanner.findBestExp();
        call.transformTo(this.trim(call, node));
        this.triggered = true;
    }

    protected RelNode trim(RelOptRuleCall call, RelNode node) {
        return HiveRelFieldTrimmer.get(this.fetchStats).trim(call.builder(), node);
    }

    private static class HiveHepExtractRelNodeRule
    extends RelOptRule {
        private static final HiveHepExtractRelNodeRule INSTANCE = new HiveHepExtractRelNodeRule();

        private HiveHepExtractRelNodeRule() {
            super(HiveHepExtractRelNodeRule.operand(HepRelVertex.class, (RelOptRuleOperandChildren)HiveHepExtractRelNodeRule.any()));
        }

        public void onMatch(RelOptRuleCall call) {
            HepRelVertex rel = (HepRelVertex)call.rel(0);
            call.transformTo(rel.getCurrentRel());
        }

        static /* synthetic */ HiveHepExtractRelNodeRule access$000() {
            return INSTANCE;
        }
    }
}

