/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.rules;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.tools.RelBuilder;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelFactories;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveAggregate;

public class HiveAggregateReduceRule
extends RelOptRule {
    public static final HiveAggregateReduceRule INSTANCE = new HiveAggregateReduceRule();

    private HiveAggregateReduceRule() {
        super(HiveAggregateReduceRule.operand(HiveAggregate.class, (RelOptRuleOperandChildren)HiveAggregateReduceRule.any()), HiveRelFactories.HIVE_BUILDER, null);
    }

    public void onMatch(RelOptRuleCall call) {
        RelBuilder relBuilder = call.builder();
        Aggregate aggRel = (Aggregate)call.rel(0);
        RexBuilder rexBuilder = aggRel.getCluster().getRexBuilder();
        boolean rewrite = false;
        boolean identity = true;
        HashMap<AggregateCall, Integer> mapping = new HashMap<AggregateCall, Integer>();
        ArrayList<Integer> indexes = new ArrayList<Integer>();
        List aggCalls = aggRel.getAggCallList();
        ArrayList<AggregateCall> newAggCalls = new ArrayList<AggregateCall>(aggCalls.size());
        int nextIdx = aggRel.getGroupCount() + aggRel.getIndicatorCount();
        for (int i = 0; i < aggCalls.size(); ++i) {
            Integer idx;
            AggregateCall aggCall = (AggregateCall)aggCalls.get(i);
            if (aggCall.getAggregation().getKind() == SqlKind.COUNT && !aggCall.isDistinct()) {
                List args = aggCall.getArgList();
                ArrayList<Integer> nullableArgs = new ArrayList<Integer>(args.size());
                Iterator iterator = args.iterator();
                while (iterator.hasNext()) {
                    int arg = (Integer)iterator.next();
                    if (!((RelDataTypeField)aggRel.getInput().getRowType().getFieldList().get(arg)).getType().isNullable()) continue;
                    nullableArgs.add(arg);
                }
                if (nullableArgs.size() != args.size()) {
                    aggCall = aggCall.copy(nullableArgs, aggCall.filterArg);
                    rewrite = true;
                }
            }
            if ((idx = (Integer)mapping.get(aggCall)) == null) {
                newAggCalls.add(aggCall);
                idx = nextIdx++;
                mapping.put(aggCall, idx);
            } else {
                rewrite = true;
                identity = false;
            }
            indexes.add(idx);
        }
        if (rewrite) {
            RelTraitSet relTraitSet = aggRel.getTraitSet();
            RelNode relNode = aggRel.getInput();
            aggRel.getClass();
            Aggregate newAggregate = aggRel.copy(relTraitSet, relNode, false, aggRel.getGroupSet(), (List)aggRel.getGroupSets(), newAggCalls);
            if (identity) {
                call.transformTo((RelNode)newAggregate);
            } else {
                int i;
                int offset = aggRel.getGroupCount() + aggRel.getIndicatorCount();
                ArrayList projList = Lists.newArrayList();
                for (i = 0; i < offset; ++i) {
                    projList.add(rexBuilder.makeInputRef(((RelDataTypeField)aggRel.getRowType().getFieldList().get(i)).getType(), i));
                }
                for (i = offset; i < aggRel.getRowType().getFieldCount(); ++i) {
                    projList.add(rexBuilder.makeInputRef(((RelDataTypeField)aggRel.getRowType().getFieldList().get(i)).getType(), ((Integer)indexes.get(i - offset)).intValue()));
                }
                call.transformTo(relBuilder.push((RelNode)newAggregate).project((Iterable)projList).build());
            }
        }
    }
}

