/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer.calcite.reloperators;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.InvalidRelException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinInfo;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.CalciteSemanticException;
import org.apache.hadoop.hive.ql.optimizer.calcite.HiveRelOptUtil;
import org.apache.hadoop.hive.ql.optimizer.calcite.reloperators.HiveRelNode;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.HiveRulesRegistry;

public class HiveSemiJoin
extends Join
implements HiveRelNode {
    private final RexNode joinFilter;

    public static HiveSemiJoin getSemiJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition) {
        try {
            HiveSemiJoin semiJoin = new HiveSemiJoin(cluster, traitSet, left, right, condition);
            return semiJoin;
        }
        catch (InvalidRelException | CalciteSemanticException e) {
            throw new RuntimeException((Throwable)e);
        }
    }

    protected HiveSemiJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition) throws InvalidRelException, CalciteSemanticException {
        super(cluster, traitSet, left, right, condition, JoinRelType.SEMI, (Set)Sets.newHashSet());
        ImmutableList systemFieldList = ImmutableList.of();
        ArrayList<List<RexNode>> joinKeyExprs = new ArrayList<List<RexNode>>();
        ArrayList<Integer> filterNulls = new ArrayList<Integer>();
        for (int i = 0; i < this.getInputs().size(); ++i) {
            joinKeyExprs.add(new ArrayList());
        }
        this.joinFilter = HiveRelOptUtil.splitHiveJoinCondition((List<RelDataTypeField>)systemFieldList, this.getInputs(), this.getCondition(), joinKeyExprs, filterNulls, null);
    }

    public RexNode getJoinFilter() {
        return this.joinFilter;
    }

    public HiveSemiJoin copy(RelTraitSet traitSet, RexNode condition, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        try {
            JoinInfo joinInfo = JoinInfo.of((RelNode)left, (RelNode)right, (RexNode)condition);
            HiveSemiJoin semijoin = new HiveSemiJoin(this.getCluster(), traitSet, left, right, condition);
            HiveRulesRegistry registry = (HiveRulesRegistry)semijoin.getCluster().getPlanner().getContext().unwrap(HiveRulesRegistry.class);
            if (registry != null) {
                registry.copyPushedPredicates(this, semijoin);
            }
            return semijoin;
        }
        catch (InvalidRelException | CalciteSemanticException e) {
            throw new AssertionError(e);
        }
    }

    @Override
    public void implement(HiveRelNode.Implementor implementor) {
    }
}

