/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.type.HiveDecimal;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.TaskFactory;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.lockmgr.LockException;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.FetchWork;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.stats.StatsUtils;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCount;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMax;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFMin;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFSum;
import org.apache.hadoop.hive.serde.serdeConstants;
import org.apache.hadoop.hive.serde2.io.DateWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatsOptimizer
extends Transform {
    private static final Logger Logger = LoggerFactory.getLogger(StatsOptimizer.class);

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        if (pctx.getFetchTask() != null || !pctx.getQueryProperties().isQuery() || pctx.getQueryProperties().isAnalyzeRewrite() || pctx.getQueryProperties().isCTAS() || pctx.getLoadFileWork().size() > 1 || !pctx.getLoadTableWork().isEmpty() || !pctx.getNameToSplitSample().isEmpty()) {
            return pctx;
        }
        String TS = TableScanOperator.getOperatorName() + "%";
        String GBY = GroupByOperator.getOperatorName() + "%";
        String RS = ReduceSinkOperator.getOperatorName() + "%";
        String SEL = SelectOperator.getOperatorName() + "%";
        String FS = FileSinkOperator.getOperatorName() + "%";
        LinkedHashMap<SemanticRule, SemanticNodeProcessor> opRules = new LinkedHashMap<SemanticRule, SemanticNodeProcessor>();
        opRules.put(new RuleRegExp("R1", TS + SEL + GBY + RS + GBY + SEL + FS), new MetaDataProcessor(pctx));
        opRules.put(new RuleRegExp("R2", TS + SEL + GBY + RS + GBY + FS), new MetaDataProcessor(pctx));
        StatsOptimizerProcContext soProcCtx = new StatsOptimizerProcContext();
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, soProcCtx);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    private static class MetaDataProcessor
    implements SemanticNodeProcessor {
        private final ParseContext pctx;

        public MetaDataProcessor(ParseContext pctx) {
            this.pctx = pctx;
        }

        private StatType getType(String origType) {
            if (serdeConstants.IntegralTypes.contains(origType)) {
                return StatType.Integer;
            }
            if (origType.equals("double") || origType.equals("float")) {
                return StatType.Double;
            }
            if (origType.equals("binary")) {
                return StatType.Binary;
            }
            if (origType.equals("boolean")) {
                return StatType.Boolean;
            }
            if (origType.equals("string")) {
                return StatType.String;
            }
            if (origType.equals("date")) {
                return StatType.Date;
            }
            return StatType.Unsupported;
        }

        private Long getNullcountFor(StatType type, ColumnStatisticsData statData) {
            switch (type) {
                case Integer: {
                    return statData.getLongStats().getNumNulls();
                }
                case Double: {
                    return statData.getDoubleStats().getNumNulls();
                }
                case String: {
                    return statData.getStringStats().getNumNulls();
                }
                case Boolean: {
                    return statData.getBooleanStats().getNumNulls();
                }
                case Binary: {
                    return statData.getBinaryStats().getNumNulls();
                }
                case Date: {
                    return statData.getDateStats().getNumNulls();
                }
            }
            return null;
        }

        private GbyKeyType getGbyKeyType(GroupByOperator gbyOp) {
            int aggCols;
            GroupByDesc gbyDesc = (GroupByDesc)gbyOp.getConf();
            int numCols = gbyDesc.getOutputColumnNames().size();
            if (numCols == (aggCols = gbyDesc.getAggregators().size())) {
                return GbyKeyType.NULL;
            }
            List<String> dpCols = gbyOp.getSchema().getColumnNames().subList(0, numCols - aggCols);
            for (String dpCol : dpCols) {
                ExprNodeDesc end = ExprNodeDescUtils.findConstantExprOrigin(dpCol, gbyOp);
                if (end instanceof ExprNodeConstantDesc) continue;
                return GbyKeyType.OTHER;
            }
            return GbyKeyType.CONSTANT;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            StatsOptimizerProcContext soProcCtx = (StatsOptimizerProcContext)procCtx;
            if (soProcCtx.stopProcess) {
                return null;
            }
            boolean isOptimized = false;
            try {
                Object var28_50;
                ExprNodeDesc end;
                TableScanOperator tsOp = (TableScanOperator)stack.get(0);
                if (tsOp.getNumParent() > 0) {
                    Object var8_9 = null;
                    return var8_9;
                }
                if (((TableScanDesc)tsOp.getConf()).getRowLimit() != -1) {
                    Object var8_10 = null;
                    return var8_10;
                }
                Hive hive = Hive.get(this.pctx.getConf());
                Table tbl = ((TableScanDesc)tsOp.getConf()).getTableMetadata();
                boolean isTransactionalTable = AcidUtils.isTransactionalTable(tbl);
                if (isTransactionalTable) {
                    tbl = hive.getTable(tbl.getDbName(), tbl.getTableName(), true, true);
                }
                if (MetaStoreUtils.isExternalTable((org.apache.hadoop.hive.metastore.api.Table)tbl.getTTable())) {
                    Logger.info("Table " + tbl.getTableName() + " is external. Skip StatsOptimizer.");
                    Object var11_14 = null;
                    return var11_14;
                }
                if (MetaStoreUtils.isNonNativeTable((org.apache.hadoop.hive.metastore.api.Table)tbl.getTTable())) {
                    Logger.info("Table " + tbl.getTableName() + " is non Native table. Skip StatsOptimizer.");
                    Object var11_15 = null;
                    return var11_15;
                }
                Long rowCnt = this.getRowCnt(this.pctx, tsOp, tbl);
                if (rowCnt == null) {
                    Object var12_17 = null;
                    return var12_17;
                }
                SelectOperator pselOp = (SelectOperator)stack.get(1);
                for (ExprNodeDesc desc : ((SelectDesc)pselOp.getConf()).getColList()) {
                    if (desc instanceof ExprNodeColumnDesc || desc instanceof ExprNodeConstantDesc) continue;
                    Object var15_21 = null;
                    return var15_21;
                }
                Map<String, ExprNodeDesc> exprMap = pselOp.getColumnExprMap();
                GroupByOperator pgbyOp = (GroupByOperator)stack.get(2);
                if (this.getGbyKeyType(pgbyOp) == GbyKeyType.OTHER) {
                    Object var15_22 = null;
                    return var15_22;
                }
                if (this.getGbyKeyType(pgbyOp) == GbyKeyType.CONSTANT && rowCnt == 0L) {
                    Object var15_23 = null;
                    return var15_23;
                }
                ReduceSinkOperator rsOp = (ReduceSinkOperator)stack.get(3);
                if (((ReduceSinkDesc)rsOp.getConf()).getDistinctColumnIndices().size() > 0) {
                    Object var16_25 = null;
                    return var16_25;
                }
                GroupByOperator cgbyOp = (GroupByOperator)stack.get(4);
                if (this.getGbyKeyType(cgbyOp) == GbyKeyType.OTHER) {
                    Object var17_27 = null;
                    return var17_27;
                }
                if (this.getGbyKeyType(cgbyOp) == GbyKeyType.CONSTANT && rowCnt == 0L) {
                    Object var17_28 = null;
                    return var17_28;
                }
                Operator last = (Operator)stack.get(5);
                SelectOperator cselOp = null;
                LinkedHashMap<Integer, Object> posToConstant = new LinkedHashMap<Integer, Object>();
                if (last instanceof SelectOperator) {
                    cselOp = (SelectOperator)last;
                    if (!cselOp.isIdentitySelect()) {
                        for (int pos = 0; pos < ((SelectDesc)cselOp.getConf()).getColList().size(); ++pos) {
                            ExprNodeDesc desc = ((SelectDesc)cselOp.getConf()).getColList().get(pos);
                            if (desc instanceof ExprNodeConstantDesc) {
                                posToConstant.put(pos, ((ExprNodeConstantDesc)desc).getValue());
                                continue;
                            }
                            if (desc instanceof ExprNodeColumnDesc) continue;
                            Object var22_39 = null;
                            return var22_39;
                        }
                    }
                    last = (Operator)stack.get(6);
                } else {
                    GroupByDesc gbyDesc = (GroupByDesc)cgbyOp.getConf();
                    int numCols = gbyDesc.getOutputColumnNames().size();
                    int aggCols = gbyDesc.getAggregators().size();
                    List<String> dpCols = cgbyOp.getSchema().getColumnNames().subList(0, numCols - aggCols);
                    for (int i = 0; i < dpCols.size(); ++i) {
                        end = ExprNodeDescUtils.findConstantExprOrigin(dpCols.get(i), cgbyOp);
                        assert (end instanceof ExprNodeConstantDesc);
                        posToConstant.put(i, ((ExprNodeConstantDesc)end).getValue());
                    }
                }
                FileSinkOperator fsOp = (FileSinkOperator)last;
                if (fsOp.getNumChild() > 0) {
                    Object numCols = null;
                    return numCols;
                }
                ArrayList<Object> oneRow = new ArrayList<Object>();
                AcidUtils.TableSnapshot tableSnapshot = AcidUtils.getTableSnapshot((Configuration)this.pctx.getConf(), tbl);
                for (AggregationDesc aggr : ((GroupByDesc)pgbyOp.getConf()).getAggregators()) {
                    DateColumnStatsData dstats;
                    Collection<List<ColumnStatisticsObj>> result;
                    ColumnStatisticsData statData;
                    Collection<List<ColumnStatisticsObj>> result2;
                    long curVal;
                    String name;
                    ExprNodeColumnDesc colDesc;
                    Collection<List<ColumnStatisticsObj>> result3;
                    Set<Partition> parts;
                    List stats;
                    StatType type;
                    Object colName;
                    Object var29_51;
                    ExprNodeDesc desc;
                    if (aggr.getDistinct()) {
                        end = null;
                        return end;
                    }
                    GenericUDAFResolver udaf = FunctionRegistry.getGenericUDAFResolver(aggr.getGenericUDAFName());
                    if (udaf instanceof GenericUDAFSum) {
                        String constant;
                        desc = aggr.getParameters().get(0);
                        PrimitiveObjectInspector.PrimitiveCategory category = GenericUDAFSum.getReturnType(desc.getTypeInfo());
                        if (category == null) {
                            var28_50 = null;
                            return var28_50;
                        }
                        if (desc instanceof ExprNodeConstantDesc) {
                            constant = ((ExprNodeConstantDesc)desc).getValue().toString();
                        } else if (desc instanceof ExprNodeColumnDesc && exprMap.get(((ExprNodeColumnDesc)desc).getColumn()) instanceof ExprNodeConstantDesc) {
                            constant = ((ExprNodeConstantDesc)exprMap.get(((ExprNodeColumnDesc)desc).getColumn())).getValue().toString();
                        } else {
                            var29_51 = null;
                            return var29_51;
                        }
                        switch (category) {
                            case LONG: {
                                oneRow.add(Long.parseLong(constant) * rowCnt);
                                break;
                            }
                            case DOUBLE: {
                                oneRow.add(Double.parseDouble(constant) * (double)rowCnt.longValue());
                                break;
                            }
                            case DECIMAL: {
                                oneRow.add(HiveDecimal.create((String)constant).multiply(HiveDecimal.create((long)rowCnt)));
                                break;
                            }
                            default: {
                                throw new IllegalStateException("never");
                            }
                        }
                        continue;
                    }
                    if (udaf instanceof GenericUDAFCount) {
                        rowCnt = 0L;
                        if (aggr.getParameters().isEmpty()) {
                            rowCnt = this.getRowCnt(this.pctx, tsOp, tbl);
                            if (rowCnt == null) {
                                desc = null;
                                return desc;
                            }
                        } else if (aggr.getParameters().get(0) instanceof ExprNodeConstantDesc) {
                            if (((ExprNodeConstantDesc)aggr.getParameters().get(0)).getValue() != null && (rowCnt = this.getRowCnt(this.pctx, tsOp, tbl)) == null) {
                                desc = null;
                                return desc;
                            }
                        } else if (aggr.getParameters().get(0) instanceof ExprNodeColumnDesc && exprMap.get(((ExprNodeColumnDesc)aggr.getParameters().get(0)).getColumn()) instanceof ExprNodeConstantDesc) {
                            if (((ExprNodeConstantDesc)exprMap.get(((ExprNodeColumnDesc)aggr.getParameters().get(0)).getColumn())).getValue() != null && (rowCnt = this.getRowCnt(this.pctx, tsOp, tbl)) == null) {
                                desc = null;
                                return desc;
                            }
                        } else {
                            desc = (ExprNodeColumnDesc)exprMap.get(((ExprNodeColumnDesc)aggr.getParameters().get(0)).getColumn());
                            colName = ((ExprNodeColumnDesc)desc).getColumn();
                            type = this.getType(desc.getTypeString());
                            if (!tbl.isPartitioned()) {
                                if (!StatsUtils.areBasicStatsUptoDateForQueryAnswering(tbl, tbl.getParameters())) {
                                    Logger.debug("Stats for table : " + tbl.getTableName() + " are not up to date.");
                                    var29_51 = null;
                                    return var29_51;
                                }
                                rowCnt = Long.valueOf(tbl.getProperty("numRows"));
                                if (!StatsUtils.areColumnStatsUptoDateForQueryAnswering(tbl, tbl.getParameters(), (String)colName)) {
                                    Logger.debug("Stats for table : " + tbl.getTableName() + " column " + (String)colName + " are not up to date.");
                                    var29_51 = null;
                                    return var29_51;
                                }
                                stats = hive.getMSC().getTableColumnStatistics(tbl.getDbName(), tbl.getTableName(), (List)Lists.newArrayList((Object[])new String[]{colName}), "hive", tableSnapshot != null ? tableSnapshot.getValidWriteIdList() : null);
                                if (stats.isEmpty()) {
                                    Logger.debug("No stats for " + tbl.getTableName() + " column " + (String)colName);
                                    Object var30_54 = null;
                                    return var30_54;
                                }
                                Long nullCnt2 = this.getNullcountFor(type, ((ColumnStatisticsObj)stats.get(0)).getStatsData());
                                if (null == nullCnt2) {
                                    Logger.debug("Unsupported type: " + desc.getTypeString() + " encountered in metadata optimizer for column : " + (String)colName);
                                    Object var31_57 = null;
                                    return var31_57;
                                }
                                rowCnt = rowCnt - nullCnt2;
                            } else {
                                parts = this.pctx.getPrunedPartitions(((TableScanDesc)tsOp.getConf()).getAlias(), tsOp).getPartitions();
                                for (Partition partition : parts) {
                                    if (!StatsUtils.areBasicStatsUptoDateForQueryAnswering(partition.getTable(), partition.getParameters())) {
                                        Logger.debug("Stats for part : " + partition.getSpec() + " are not up to date.");
                                        Object var32_86 = null;
                                        return var32_86;
                                    }
                                    long partRowCnt = Long.parseLong(partition.getParameters().get("numRows"));
                                    rowCnt = rowCnt + partRowCnt;
                                }
                                result3 = this.verifyAndGetPartColumnStats(hive, tbl, (String)colName, parts);
                                if (result3 == null) {
                                    Object var31_60 = null;
                                    return var31_60;
                                }
                                for (List<ColumnStatisticsObj> statObj : result3) {
                                    ColumnStatisticsData statData3 = this.validateSingleColStat(statObj);
                                    if (statData3 == null) {
                                        Object var34_93 = null;
                                        return var34_93;
                                    }
                                    Long l = this.getNullcountFor(type, statData3);
                                    if (l == null) {
                                        Logger.debug("Unsupported type: " + desc.getTypeString() + " encountered in metadata optimizer for column : " + (String)colName);
                                        Object var35_106 = null;
                                        return var35_106;
                                    }
                                    rowCnt = rowCnt - l;
                                }
                            }
                        }
                        oneRow.add(rowCnt);
                        continue;
                    }
                    if (udaf instanceof GenericUDAFMax) {
                        colDesc = (ExprNodeColumnDesc)exprMap.get(((ExprNodeColumnDesc)aggr.getParameters().get(0)).getColumn());
                        colName = colDesc.getColumn();
                        type = this.getType(colDesc.getTypeString());
                        if (!tbl.isPartitioned()) {
                            if (!StatsUtils.areColumnStatsUptoDateForQueryAnswering(tbl, tbl.getParameters(), (String)colName)) {
                                Logger.debug("Stats for table : " + tbl.getTableName() + " column " + (String)colName + " are not up to date.");
                                parts = null;
                                return parts;
                            }
                            stats = hive.getMSC().getTableColumnStatistics(tbl.getDbName(), tbl.getTableName(), (List)Lists.newArrayList((Object[])new String[]{colName}), "hive", tableSnapshot != null ? tableSnapshot.getValidWriteIdList() : null);
                            if (stats.isEmpty()) {
                                Logger.debug("No stats for " + tbl.getTableName() + " column " + (String)colName);
                                result3 = null;
                                return result3;
                            }
                            ColumnStatisticsData statData4 = ((ColumnStatisticsObj)stats.get(0)).getStatsData();
                            String string = colDesc.getTypeString().toUpperCase();
                            switch (type) {
                                case Integer: {
                                    LongSubType subType2 = LongSubType.valueOf(string);
                                    LongColumnStatsData lstats = statData4.getLongStats();
                                    if (lstats.isSetHighValue()) {
                                        oneRow.add(subType2.cast(lstats.getHighValue()));
                                        break;
                                    }
                                    oneRow.add(null);
                                    break;
                                }
                                case Double: {
                                    DoubleSubType subType = DoubleSubType.valueOf(string);
                                    DoubleColumnStatsData dstats3 = statData4.getDoubleStats();
                                    if (dstats3.isSetHighValue()) {
                                        oneRow.add(subType.cast(dstats3.getHighValue()));
                                        break;
                                    }
                                    oneRow.add(null);
                                    break;
                                }
                                case Date: {
                                    DateColumnStatsData dstats22 = statData4.getDateStats();
                                    if (dstats22.isSetHighValue()) {
                                        oneRow.add(DateSubType.DAYS.cast(dstats22.getHighValue().getDaysSinceEpoch()));
                                        break;
                                    }
                                    oneRow.add(null);
                                    break;
                                }
                                default: {
                                    Logger.debug("Unsupported type: " + colDesc.getTypeString() + " encountered in metadata optimizer for column : " + (String)colName);
                                    Object dstats22 = null;
                                    return dstats22;
                                }
                            }
                            continue;
                        }
                        parts = this.pctx.getPrunedPartitions(((TableScanDesc)tsOp.getConf()).getAlias(), tsOp).getPartitions();
                        name = colDesc.getTypeString().toUpperCase();
                        switch (type) {
                            case Integer: {
                                LongSubType longSubType = LongSubType.valueOf(name);
                                Number maxVal = null;
                                Collection<List<ColumnStatisticsObj>> result22 = this.verifyAndGetPartColumnStats(hive, tbl, (String)colName, parts);
                                if (result22 == null) {
                                    Object var34_95 = null;
                                    return var34_95;
                                }
                                for (List<ColumnStatisticsObj> list : result22) {
                                    ColumnStatisticsData statData2 = this.validateSingleColStat(list);
                                    if (statData2 == null) {
                                        Object var37_114 = null;
                                        return var37_114;
                                    }
                                    LongColumnStatsData lstats = statData2.getLongStats();
                                    if (!lstats.isSetHighValue()) continue;
                                    curVal = lstats.getHighValue();
                                    maxVal = maxVal == null ? curVal : Math.max(maxVal, curVal);
                                }
                                if (maxVal != null) {
                                    oneRow.add(longSubType.cast((long)maxVal));
                                    break;
                                }
                                oneRow.add(maxVal);
                                break;
                            }
                            case Double: {
                                DoubleSubType doubleSubType = DoubleSubType.valueOf(name);
                                Number maxVal = null;
                                result2 = this.verifyAndGetPartColumnStats(hive, tbl, (String)colName, parts);
                                if (result2 == null) {
                                    Object var34_97 = null;
                                    return var34_97;
                                }
                                for (List<ColumnStatisticsObj> list : result2) {
                                    statData = this.validateSingleColStat(list);
                                    if (statData == null) {
                                        Object lstats = null;
                                        return lstats;
                                    }
                                    DoubleColumnStatsData dstats4 = statData.getDoubleStats();
                                    if (!dstats4.isSetHighValue()) continue;
                                    double curVal2 = statData.getDoubleStats().getHighValue();
                                    maxVal = maxVal == null ? curVal2 : Math.max((Double)maxVal, curVal2);
                                }
                                if (maxVal != null) {
                                    oneRow.add(doubleSubType.cast((Double)maxVal));
                                    break;
                                }
                                oneRow.add(null);
                                break;
                            }
                            case Date: {
                                void var31_66;
                                Object var31_65 = null;
                                result = this.verifyAndGetPartColumnStats(hive, tbl, (String)colName, parts);
                                if (result == null) {
                                    result2 = null;
                                    return result2;
                                }
                                for (List list : result) {
                                    ColumnStatisticsData columnStatisticsData = this.validateSingleColStat(list);
                                    if (columnStatisticsData == null) {
                                        statData = null;
                                        return statData;
                                    }
                                    dstats = columnStatisticsData.getDateStats();
                                    if (!dstats.isSetHighValue()) continue;
                                    long curVal3 = dstats.getHighValue().getDaysSinceEpoch();
                                    Long l = var31_66 == null ? curVal3 : Math.max(var31_66.longValue(), curVal3);
                                }
                                if (var31_66 != null) {
                                    oneRow.add(DateSubType.DAYS.cast(var31_66.longValue()));
                                    break;
                                }
                                oneRow.add(null);
                                break;
                            }
                            default: {
                                Logger.debug("Unsupported type: " + colDesc.getTypeString() + " encountered in metadata optimizer for column : " + (String)colName);
                                Object var31_68 = null;
                                return var31_68;
                            }
                        }
                        continue;
                    }
                    if (udaf instanceof GenericUDAFMin) {
                        colDesc = (ExprNodeColumnDesc)exprMap.get(((ExprNodeColumnDesc)aggr.getParameters().get(0)).getColumn());
                        colName = colDesc.getColumn();
                        type = this.getType(colDesc.getTypeString());
                        if (!tbl.isPartitioned()) {
                            if (!StatsUtils.areColumnStatsUptoDateForQueryAnswering(tbl, tbl.getParameters(), (String)colName)) {
                                Logger.debug("Stats for table : " + tbl.getTableName() + " column " + (String)colName + " are not up to date.");
                                parts = null;
                                return parts;
                            }
                            ColumnStatisticsData statData5 = ((ColumnStatisticsObj)hive.getMSC().getTableColumnStatistics(tbl.getDbName(), tbl.getTableName(), (List)Lists.newArrayList((Object[])new String[]{colName}), "hive", tableSnapshot != null ? tableSnapshot.getValidWriteIdList() : null).get(0)).getStatsData();
                            name = colDesc.getTypeString().toUpperCase();
                            switch (type) {
                                case Integer: {
                                    LongSubType longSubType = LongSubType.valueOf(name);
                                    LongColumnStatsData lstats = statData5.getLongStats();
                                    if (lstats.isSetLowValue()) {
                                        oneRow.add(longSubType.cast(lstats.getLowValue()));
                                        break;
                                    }
                                    oneRow.add(null);
                                    break;
                                }
                                case Double: {
                                    DoubleSubType doubleSubType = DoubleSubType.valueOf(name);
                                    DoubleColumnStatsData dstats2 = statData5.getDoubleStats();
                                    if (dstats2.isSetLowValue()) {
                                        oneRow.add(doubleSubType.cast(dstats2.getLowValue()));
                                        break;
                                    }
                                    oneRow.add(null);
                                    break;
                                }
                                case Date: {
                                    DateColumnStatsData dateColumnStatsData = statData5.getDateStats();
                                    if (dateColumnStatsData.isSetLowValue()) {
                                        oneRow.add(DateSubType.DAYS.cast(dateColumnStatsData.getLowValue().getDaysSinceEpoch()));
                                        break;
                                    }
                                    oneRow.add(null);
                                    break;
                                }
                                default: {
                                    Logger.debug("Unsupported type: " + colDesc.getTypeString() + " encountered in metadata optimizer for column : " + (String)colName);
                                    Object var31_73 = null;
                                    return var31_73;
                                }
                            }
                            continue;
                        }
                        parts = this.pctx.getPrunedPartitions(((TableScanDesc)tsOp.getConf()).getAlias(), tsOp).getPartitions();
                        name = colDesc.getTypeString().toUpperCase();
                        switch (type) {
                            case Integer: {
                                LongSubType longSubType = LongSubType.valueOf(name);
                                Number minVal = null;
                                result2 = this.verifyAndGetPartColumnStats(hive, tbl, (String)colName, parts);
                                if (result2 == null) {
                                    Object var34_100 = null;
                                    return var34_100;
                                }
                                for (List<ColumnStatisticsObj> list : result2) {
                                    statData = this.validateSingleColStat(list);
                                    if (statData == null) {
                                        Object curVal3 = null;
                                        return curVal3;
                                    }
                                    LongColumnStatsData lstats = statData.getLongStats();
                                    if (!lstats.isSetLowValue()) continue;
                                    curVal = lstats.getLowValue();
                                    minVal = minVal == null ? curVal : Math.min(minVal, curVal);
                                }
                                if (minVal != null) {
                                    oneRow.add(longSubType.cast((long)minVal));
                                    break;
                                }
                                oneRow.add(minVal);
                                break;
                            }
                            case Double: {
                                DoubleSubType doubleSubType = DoubleSubType.valueOf(name);
                                Number minVal = null;
                                result2 = this.verifyAndGetPartColumnStats(hive, tbl, (String)colName, parts);
                                if (result2 == null) {
                                    Object var34_102 = null;
                                    return var34_102;
                                }
                                for (List<ColumnStatisticsObj> list : result2) {
                                    statData = this.validateSingleColStat(list);
                                    if (statData == null) {
                                        Object lstats = null;
                                        return lstats;
                                    }
                                    DoubleColumnStatsData dstats6 = statData.getDoubleStats();
                                    if (!dstats6.isSetLowValue()) continue;
                                    double curVal4 = statData.getDoubleStats().getLowValue();
                                    minVal = minVal == null ? curVal4 : Math.min((Double)minVal, curVal4);
                                }
                                if (minVal != null) {
                                    oneRow.add(doubleSubType.cast((Double)minVal));
                                    break;
                                }
                                oneRow.add(minVal);
                                break;
                            }
                            case Date: {
                                void var31_78;
                                Object var31_77 = null;
                                result = this.verifyAndGetPartColumnStats(hive, tbl, (String)colName, parts);
                                if (result == null) {
                                    Iterator<List<ColumnStatisticsObj>> iterator = null;
                                    return iterator;
                                }
                                for (List<ColumnStatisticsObj> list : result) {
                                    ColumnStatisticsData columnStatisticsData = this.validateSingleColStat(list);
                                    if (columnStatisticsData == null) {
                                        statData = null;
                                        return statData;
                                    }
                                    dstats = columnStatisticsData.getDateStats();
                                    if (!dstats.isSetLowValue()) continue;
                                    long curVal5 = dstats.getLowValue().getDaysSinceEpoch();
                                    Long l = var31_78 == null ? curVal5 : Math.min(var31_78.longValue(), curVal5);
                                }
                                if (var31_78 != null) {
                                    oneRow.add(DateSubType.DAYS.cast(var31_78.longValue()));
                                    break;
                                }
                                oneRow.add(null);
                                break;
                            }
                            default: {
                                Logger.debug("Unsupported type: " + colDesc.getTypeString() + " encountered in metadata optimizer for column : " + (String)colName);
                                Object var31_80 = null;
                                return var31_80;
                            }
                        }
                        continue;
                    }
                    Logger.debug("Unsupported aggregation for metadata optimizer: " + aggr.getGenericUDAFName());
                    colDesc = null;
                    return colDesc;
                }
                ArrayList<List<Object>> allRows = new ArrayList<List<Object>>();
                ArrayList<String> colNames = new ArrayList<String>();
                ArrayList<ObjectInspector> ois = new ArrayList<ObjectInspector>();
                if (cselOp == null) {
                    ArrayList<Object> oneRowWithConstant = new ArrayList<Object>();
                    oneRowWithConstant.addAll(posToConstant.values());
                    oneRowWithConstant.addAll(oneRow);
                    allRows.add(oneRowWithConstant);
                    for (ColumnInfo colInfo : cgbyOp.getSchema().getSignature()) {
                        colNames.add(colInfo.getInternalName());
                        ois.add(TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)colInfo.getType()));
                    }
                } else {
                    HashMap<String, Integer> nameToIndex = new HashMap<String, Integer>();
                    for (int index = 0; index < ((GroupByDesc)cgbyOp.getConf()).getOutputColumnNames().size(); ++index) {
                        nameToIndex.put(((GroupByDesc)cgbyOp.getConf()).getOutputColumnNames().get(index), index);
                    }
                    List<String> outputColumnNames = ((SelectDesc)cselOp.getConf()).getOutputColumnNames();
                    HashMap cselOpTocgbyOp = new HashMap();
                    for (int index = 0; index < outputColumnNames.size(); ++index) {
                        if (posToConstant.containsKey(index)) continue;
                        String outputColumnName = outputColumnNames.get(index);
                        ExprNodeColumnDesc exprNodeColumnDesc = (ExprNodeColumnDesc)cselOp.getColumnExprMap().get(outputColumnName);
                        cselOpTocgbyOp.put(index, nameToIndex.get(exprNodeColumnDesc.getColumn()));
                    }
                    ArrayList<Object> oneRowWithConstant = new ArrayList<Object>();
                    for (int pos = 0; pos < cselOp.getSchema().getSignature().size(); ++pos) {
                        if (posToConstant.containsKey(pos)) {
                            oneRowWithConstant.add(posToConstant.get(pos));
                        } else {
                            oneRowWithConstant.add(oneRow.get((Integer)cselOpTocgbyOp.get(pos) - ((GroupByDesc)cgbyOp.getConf()).getKeys().size()));
                        }
                        ColumnInfo columnInfo = cselOp.getSchema().getSignature().get(pos);
                        colNames.add(columnInfo.getInternalName());
                        ois.add(TypeInfoUtils.getStandardJavaObjectInspectorFromTypeInfo((TypeInfo)columnInfo.getType()));
                    }
                    allRows.add(oneRowWithConstant);
                }
                FetchWork fWork = null;
                FetchTask fTask = this.pctx.getFetchTask();
                if (fTask != null) {
                    fWork = (FetchWork)fTask.getWork();
                    fWork.getRowsComputedUsingStats().addAll(allRows);
                } else {
                    StandardStructObjectInspector sOI = ObjectInspectorFactory.getStandardStructObjectInspector(colNames, ois);
                    fWork = new FetchWork(allRows, (StructObjectInspector)sOI);
                    fTask = (FetchTask)TaskFactory.get(fWork);
                    this.pctx.setFetchTask(fTask);
                }
                fWork.setLimit(fWork.getRowsComputedUsingStats().size());
                isOptimized = true;
                var28_50 = null;
                return var28_50;
            }
            catch (Exception e) {
                Logger.debug("Failed to optimize using metadata optimizer", (Throwable)e);
                Object var8_11 = null;
                return var8_11;
            }
            finally {
                if (!isOptimized) {
                    soProcCtx.stopProcess = true;
                    this.pctx.setFetchTask(null);
                }
            }
        }

        private ColumnStatisticsData validateSingleColStat(List<ColumnStatisticsObj> statObj) {
            if (statObj.size() > 1) {
                Logger.error("More than one stat for a single column!");
                return null;
            }
            if (statObj.isEmpty()) {
                Logger.debug("No stats for some partition and column");
                return null;
            }
            return statObj.get(0).getStatsData();
        }

        private Collection<List<ColumnStatisticsObj>> verifyAndGetPartColumnStats(Hive hive, Table tbl, String colName, Set<Partition> parts) throws TException, LockException {
            ArrayList<String> partNames = new ArrayList<String>(parts.size());
            for (Partition part : parts) {
                if (!StatsUtils.areColumnStatsUptoDateForQueryAnswering(part.getTable(), part.getParameters(), colName)) {
                    Logger.debug("Stats for part : " + part.getSpec() + " column " + colName + " are not up to date.");
                    return null;
                }
                partNames.add(part.getName());
            }
            AcidUtils.TableSnapshot tableSnapshot = AcidUtils.getTableSnapshot((Configuration)hive.getConf(), tbl);
            Map result = hive.getMSC().getPartitionColumnStatistics(tbl.getDbName(), tbl.getTableName(), partNames, (List)Lists.newArrayList((Object[])new String[]{colName}), "hive", tableSnapshot != null ? tableSnapshot.getValidWriteIdList() : null);
            if (result.size() != parts.size()) {
                Logger.debug("Received " + result.size() + " stats for " + parts.size() + " partitions");
                return null;
            }
            return result.values();
        }

        private Long getRowCnt(ParseContext pCtx, TableScanOperator tsOp, Table tbl) throws HiveException {
            Long rowCnt = 0L;
            if (tbl.isPartitioned()) {
                for (Partition part : this.pctx.getPrunedPartitions(((TableScanDesc)tsOp.getConf()).getAlias(), tsOp).getPartitions()) {
                    if (!StatsUtils.areBasicStatsUptoDateForQueryAnswering(part.getTable(), part.getParameters())) {
                        return null;
                    }
                    long partRowCnt = Long.parseLong(part.getParameters().get("numRows"));
                    rowCnt = rowCnt + partRowCnt;
                }
            } else {
                if (!StatsUtils.areBasicStatsUptoDateForQueryAnswering(tbl, tbl.getParameters())) {
                    return null;
                }
                rowCnt = Long.valueOf(tbl.getProperty("numRows"));
            }
            return rowCnt;
        }

        static enum GbyKeyType {
            NULL,
            CONSTANT,
            OTHER;

        }

        static enum DateSubType {
            DAYS{

                @Override
                Object cast(long longValue) {
                    return new DateWritableV2((int)longValue).get();
                }
            };


            abstract Object cast(long var1);
        }

        static enum DoubleSubType {
            DOUBLE{

                @Override
                Object cast(double doubleValue) {
                    return doubleValue;
                }
            }
            ,
            FLOAT{

                @Override
                Object cast(double doubleValue) {
                    return Float.valueOf((float)doubleValue);
                }
            };


            abstract Object cast(double var1);
        }

        static enum LongSubType {
            BIGINT{

                @Override
                Object cast(long longValue) {
                    return longValue;
                }
            }
            ,
            INT{

                @Override
                Object cast(long longValue) {
                    return (int)longValue;
                }
            }
            ,
            SMALLINT{

                @Override
                Object cast(long longValue) {
                    return (short)longValue;
                }
            }
            ,
            TINYINT{

                @Override
                Object cast(long longValue) {
                    return (byte)longValue;
                }
            };


            abstract Object cast(long var1);
        }

        static enum StatType {
            Integer,
            Double,
            String,
            Boolean,
            Binary,
            Date,
            Unsupported;

        }
    }

    private static class StatsOptimizerProcContext
    implements NodeProcessorCtx {
        boolean stopProcess = false;

        private StatsOptimizerProcContext() {
        }
    }
}

