/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorDay;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorHour;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorMinute;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorMonth;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorSecond;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorWeek;
import org.apache.hadoop.hive.ql.udf.UDFDateFloorYear;
import org.apache.hadoop.hive.ql.udf.UDFRand;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFEpochMilli;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFFloor;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPDivide;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPMod;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFTimestamp;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.parquet.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortedDynPartitionTimeGranularityOptimizer
extends Transform {
    @Override
    public ParseContext transform(ParseContext pCtx) throws SemanticException {
        LinkedHashMap<SemanticRule, SemanticNodeProcessor> opRules = new LinkedHashMap<SemanticRule, SemanticNodeProcessor>();
        String FS = FileSinkOperator.getOperatorName() + "%";
        opRules.put(new RuleRegExp("Sorted Dynamic Partition Time Granularity", FS), this.getSortDynPartProc(pCtx));
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, null);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pCtx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pCtx;
    }

    private SemanticNodeProcessor getSortDynPartProc(ParseContext pCtx) {
        return new SortedDynamicPartitionProc(pCtx);
    }

    class SortedDynamicPartitionProc
    implements SemanticNodeProcessor {
        private final Logger LOG = LoggerFactory.getLogger(SortedDynPartitionTimeGranularityOptimizer.class);
        protected ParseContext parseCtx;
        private int targetShardsPerGranularity = 0;
        private int granularityKeyPos = -1;
        private int partitionKeyPos = -1;

        public SortedDynamicPartitionProc(ParseContext pCtx) {
            this.parseCtx = pCtx;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ArrayList sortNullOrder;
            ArrayList sortOrder;
            ArrayList keyPositions;
            String targetShardsProperty;
            String segmentGranularity;
            FileSinkOperator fsOp = (FileSinkOperator)nd;
            String sh = ((FileSinkDesc)fsOp.getConf()).getTableInfo().getOutputFileFormatClassName();
            if (this.parseCtx.getQueryProperties().isQuery() || sh == null || !sh.equals("org.apache.hadoop.hive.druid.io.DruidOutputFormat")) {
                return null;
            }
            Table table = ((FileSinkDesc)fsOp.getConf()).getTable();
            if (table != null) {
                segmentGranularity = table.getParameters().get("druid.segment.granularity");
                targetShardsProperty = table.getParameters().getOrDefault("druid.segment.targetShardsPerGranularity", "0");
            } else if (this.parseCtx.getCreateViewDesc() != null) {
                segmentGranularity = this.parseCtx.getCreateViewDesc().getTblProps().get("druid.segment.granularity");
                targetShardsProperty = this.parseCtx.getCreateViewDesc().getTblProps().getOrDefault("druid.segment.targetShardsPerGranularity", "0");
            } else if (this.parseCtx.getCreateTable() != null) {
                segmentGranularity = this.parseCtx.getCreateTable().getTblProps().get("druid.segment.granularity");
                targetShardsProperty = this.parseCtx.getCreateTable().getTblProps().getOrDefault("druid.segment.targetShardsPerGranularity", "0");
            } else {
                throw new SemanticException("Druid storage handler used but not an INSERT, CMVAS or CTAS statement");
            }
            segmentGranularity = Strings.isNullOrEmpty((String)segmentGranularity) ? HiveConf.getVar((Configuration)this.parseCtx.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_DRUID_INDEXING_GRANULARITY) : segmentGranularity;
            this.targetShardsPerGranularity = Integer.parseInt(targetShardsProperty);
            this.LOG.info("Sorted dynamic partitioning on time granularity optimization kicked in...");
            Operator<OperatorDesc> fsParent = fsOp.getParentOperators().get(0);
            fsParent.getChildOperators().clear();
            if (this.targetShardsPerGranularity > 0) {
                this.partitionKeyPos = fsParent.getSchema().getSignature().size() + 1;
            }
            this.granularityKeyPos = fsParent.getSchema().getSignature().size();
            Operator<? extends OperatorDesc> granularitySelOp = this.getGranularitySelOp(fsParent, segmentGranularity);
            ArrayList parentCols = Lists.newArrayList(granularitySelOp.getSchema().getSignature());
            ArrayList allRSCols = Lists.newArrayList();
            for (ColumnInfo ci : parentCols) {
                allRSCols.add(new ExprNodeColumnDesc(ci));
            }
            if (this.targetShardsPerGranularity > 0) {
                keyPositions = Lists.newArrayList((Object[])new Integer[]{this.granularityKeyPos, this.partitionKeyPos});
                sortOrder = Lists.newArrayList((Object[])new Integer[]{1, 1});
                sortNullOrder = Lists.newArrayList((Object[])new Integer[]{0, 0});
            } else {
                keyPositions = Lists.newArrayList((Object[])new Integer[]{this.granularityKeyPos});
                sortOrder = Lists.newArrayList((Object[])new Integer[]{1});
                sortNullOrder = Lists.newArrayList((Object[])new Integer[]{0});
            }
            ReduceSinkOperator rsOp = this.getReduceSinkOp(keyPositions, sortOrder, sortNullOrder, allRSCols, granularitySelOp, ((FileSinkDesc)fsOp.getConf()).getWriteType());
            ((ReduceSinkDesc)rsOp.getConf()).setBucketingVersion(((FileSinkDesc)fsOp.getConf()).getBucketingVersion());
            ArrayList<ExprNodeDesc> descs = new ArrayList<ExprNodeDesc>(allRSCols.size());
            ArrayList<String> colNames = new ArrayList<String>();
            for (int i = 0; i < allRSCols.size(); ++i) {
                ExprNodeDesc col = (ExprNodeDesc)allRSCols.get(i);
                String colName = col.getExprString();
                colNames.add(colName);
                if (keyPositions.contains(i)) {
                    descs.add(new ExprNodeColumnDesc(col.getTypeInfo(), Utilities.ReduceField.KEY.toString() + "." + colName, null, false));
                    continue;
                }
                descs.add(new ExprNodeColumnDesc(col.getTypeInfo(), Utilities.ReduceField.VALUE.toString() + "." + colName, null, false));
            }
            RowSchema selRS = new RowSchema(granularitySelOp.getSchema());
            SelectDesc selConf = new SelectDesc(descs, colNames);
            SelectOperator backtrackSelOp = (SelectOperator)OperatorFactory.getAndMakeChild(selConf, selRS, (Operator)rsOp, new Operator[0]);
            fsOp.getParentOperators().clear();
            fsOp.getParentOperators().add(backtrackSelOp);
            backtrackSelOp.getChildOperators().add(fsOp);
            ((FileSinkDesc)fsOp.getConf()).setDpSortState(FileSinkDesc.DPSortState.PARTITION_SORTED);
            ((FileSinkDesc)fsOp.getConf()).setPartitionCols(((ReduceSinkDesc)rsOp.getConf()).getPartitionCols());
            ColumnInfo granularityColumnInfo = new ColumnInfo(granularitySelOp.getSchema().getSignature().get(this.granularityKeyPos));
            fsOp.getSchema().getSignature().add(granularityColumnInfo);
            if (this.targetShardsPerGranularity > 0) {
                ColumnInfo partitionKeyColumnInfo = new ColumnInfo(granularitySelOp.getSchema().getSignature().get(this.partitionKeyPos));
                fsOp.getSchema().getSignature().add(partitionKeyColumnInfo);
            }
            this.LOG.info("Inserted " + granularitySelOp.getOperatorId() + ", " + rsOp.getOperatorId() + " and " + backtrackSelOp.getOperatorId() + " as parent of " + fsOp.getOperatorId() + " and child of " + fsParent.getOperatorId());
            this.parseCtx.setReduceSinkAddedBySortedDynPartition(true);
            return null;
        }

        private Operator<? extends OperatorDesc> getGranularitySelOp(Operator<? extends OperatorDesc> fsParent, String segmentGranularity) throws SemanticException {
            Class udfClass;
            String udfName;
            ArrayList parentCols = Lists.newArrayList(fsParent.getSchema().getSignature());
            ArrayList descs = Lists.newArrayList();
            ArrayList colNames = Lists.newArrayList();
            PrimitiveObjectInspector.PrimitiveCategory timestampType = null;
            int timestampPos = -1;
            for (int i = 0; i < parentCols.size(); ++i) {
                ColumnInfo ci = (ColumnInfo)parentCols.get(i);
                ExprNodeColumnDesc columnDesc = new ExprNodeColumnDesc(ci);
                descs.add(columnDesc);
                colNames.add(columnDesc.getExprString());
                if (columnDesc.getTypeInfo().getCategory() != ObjectInspector.Category.PRIMITIVE || ((PrimitiveTypeInfo)columnDesc.getTypeInfo()).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMP && ((PrimitiveTypeInfo)columnDesc.getTypeInfo()).getPrimitiveCategory() != PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMPLOCALTZ) continue;
                if (timestampPos != -1) {
                    throw new SemanticException("Multiple columns with timestamp/timestamp with local time-zone type on query result; could not resolve which one is the right column");
                }
                timestampType = ((PrimitiveTypeInfo)columnDesc.getTypeInfo()).getPrimitiveCategory();
                timestampPos = i;
            }
            if (timestampPos == -1) {
                throw new SemanticException("No column with timestamp with local time-zone type on query result; one column should be of timestamp with local time-zone type");
            }
            RowSchema selRS = new RowSchema(fsParent.getSchema());
            switch (segmentGranularity) {
                case "YEAR": {
                    udfName = "floor_year";
                    udfClass = UDFDateFloorYear.class;
                    break;
                }
                case "MONTH": {
                    udfName = "floor_month";
                    udfClass = UDFDateFloorMonth.class;
                    break;
                }
                case "WEEK": {
                    udfName = "floor_week";
                    udfClass = UDFDateFloorWeek.class;
                    break;
                }
                case "DAY": {
                    udfName = "floor_day";
                    udfClass = UDFDateFloorDay.class;
                    break;
                }
                case "HOUR": {
                    udfName = "floor_hour";
                    udfClass = UDFDateFloorHour.class;
                    break;
                }
                case "MINUTE": {
                    udfName = "floor_minute";
                    udfClass = UDFDateFloorMinute.class;
                    break;
                }
                case "SECOND": {
                    udfName = "floor_second";
                    udfClass = UDFDateFloorSecond.class;
                    break;
                }
                default: {
                    throw new SemanticException(String.format(Locale.ENGLISH, "Unknown Druid Granularity [%s], Accepted values are [YEAR, MONTH, WEEK, DAY, HOUR, MINUTE, SECOND]", segmentGranularity));
                }
            }
            ExprNodeDesc expr = new ExprNodeColumnDesc((ColumnInfo)parentCols.get(timestampPos));
            if (timestampType == PrimitiveObjectInspector.PrimitiveCategory.TIMESTAMPLOCALTZ) {
                expr = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.longTypeInfo, (GenericUDF)new GenericUDFEpochMilli(), (List<ExprNodeDesc>)Lists.newArrayList((Object[])new ExprNodeDesc[]{expr}));
                expr = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.timestampTypeInfo, (GenericUDF)new GenericUDFTimestamp(), (List<ExprNodeDesc>)Lists.newArrayList((Object[])new ExprNodeDesc[]{expr}));
            }
            expr = new ExprNodeGenericFuncDesc((TypeInfo)TypeInfoFactory.timestampTypeInfo, (GenericUDF)new GenericUDFBridge(udfName, false, udfClass.getName()), (List<ExprNodeDesc>)Lists.newArrayList((Object[])new ExprNodeDesc[]{expr}));
            descs.add(expr);
            colNames.add("__time_granularity");
            ColumnInfo ci = new ColumnInfo("__time_granularity", (TypeInfo)TypeInfoFactory.timestampTypeInfo, selRS.getSignature().get(0).getTabAlias(), false, false);
            selRS.getSignature().add(ci);
            if (this.targetShardsPerGranularity > 0) {
                ColumnInfo partitionKeyCi = new ColumnInfo("__druid_extra_partition_key", (TypeInfo)TypeInfoFactory.longTypeInfo, selRS.getSignature().get(0).getTabAlias(), false, false);
                ExprNodeConstantDesc targetNumShardDescNode = new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.intTypeInfo, this.targetShardsPerGranularity);
                ExprNodeGenericFuncDesc randomFn = ExprNodeGenericFuncDesc.newInstance(new GenericUDFBridge("rand", false, UDFRand.class.getName()), Lists.newArrayList());
                ExprNodeGenericFuncDesc random = ExprNodeGenericFuncDesc.newInstance(new GenericUDFFloor(), Lists.newArrayList((Object[])new ExprNodeDesc[]{ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPDivide(), Lists.newArrayList((Object[])new ExprNodeDesc[]{new ExprNodeConstantDesc((TypeInfo)TypeInfoFactory.doubleTypeInfo, 1.0), randomFn}))}));
                ExprNodeGenericFuncDesc randModMax = ExprNodeGenericFuncDesc.newInstance(new GenericUDFOPMod(), Lists.newArrayList((Object[])new ExprNodeDesc[]{random, targetNumShardDescNode}));
                descs.add(randModMax);
                colNames.add("__druid_extra_partition_key");
                selRS.getSignature().add(partitionKeyCi);
            }
            SelectDesc selConf = new SelectDesc(descs, colNames);
            SelectOperator selOp = (SelectOperator)OperatorFactory.getAndMakeChild(selConf, selRS, fsParent, new Operator[0]);
            return selOp;
        }

        private ReduceSinkOperator getReduceSinkOp(List<Integer> keyPositions, List<Integer> sortOrder, List<Integer> sortNullOrder, ArrayList<ExprNodeDesc> allCols, Operator<? extends OperatorDesc> parent, AcidUtils.Operation writeType) {
            ArrayList keyCols = keyPositions.stream().map(id -> ((ExprNodeDesc)allCols.get((int)id)).clone()).collect(Collectors.toCollection(ArrayList::new));
            ArrayList valCols = Lists.newArrayList();
            for (int i = 0; i < allCols.size(); ++i) {
                if (i == this.granularityKeyPos || i == this.partitionKeyPos) continue;
                valCols.add(allCols.get(i).clone());
            }
            ArrayList partCols = keyPositions.stream().map(id -> ((ExprNodeDesc)allCols.get((int)id)).clone()).collect(Collectors.toCollection(ArrayList::new));
            HashMap colExprMap = Maps.newHashMap();
            HashMap nameMapping = new HashMap();
            ArrayList keyColNames = Lists.newArrayList();
            ArrayList valColNames = Lists.newArrayList();
            keyCols.stream().forEach(exprNodeDesc -> {
                keyColNames.add(exprNodeDesc.getExprString());
                colExprMap.put((Object)((Object)Utilities.ReduceField.KEY) + "." + exprNodeDesc.getExprString(), exprNodeDesc);
                nameMapping.put(exprNodeDesc.getExprString(), (Object)((Object)Utilities.ReduceField.KEY) + "." + exprNodeDesc.getName());
            });
            valCols.stream().forEach(exprNodeDesc -> {
                valColNames.add(exprNodeDesc.getExprString());
                colExprMap.put((Object)((Object)Utilities.ReduceField.VALUE) + "." + exprNodeDesc.getExprString(), exprNodeDesc);
                nameMapping.put(exprNodeDesc.getExprString(), (Object)((Object)Utilities.ReduceField.VALUE) + "." + exprNodeDesc.getName());
            });
            String orderStr = StringUtils.repeat((String)"+", (int)sortOrder.size());
            String nullOrderStr = StringUtils.repeat((String)"a", (int)sortNullOrder.size());
            List<FieldSchema> fields = PlanUtils.getFieldSchemasFromColumnList(keyCols, keyColNames, 0, "");
            TableDesc keyTable = PlanUtils.getReduceKeyTableDesc(fields, orderStr, nullOrderStr);
            List<FieldSchema> valFields = PlanUtils.getFieldSchemasFromColumnList(valCols, valColNames, 0, "");
            TableDesc valueTable = PlanUtils.getReduceValueTableDesc(valFields);
            ArrayList distinctColumnIndices = Lists.newArrayList();
            ReduceSinkDesc rsConf = new ReduceSinkDesc(keyCols, keyCols.size(), valCols, keyColNames, distinctColumnIndices, valColNames, -1, partCols, -1, keyTable, valueTable, writeType);
            ArrayList signature = parent.getSchema().getSignature().stream().map(e -> new ColumnInfo((ColumnInfo)e)).map(columnInfo -> {
                columnInfo.setInternalName((String)nameMapping.get(columnInfo.getInternalName()));
                return columnInfo;
            }).collect(Collectors.toCollection(ArrayList::new));
            ReduceSinkOperator op = (ReduceSinkOperator)OperatorFactory.getAndMakeChild(rsConf, new RowSchema(signature), parent, new Operator[0]);
            op.setColumnExprMap(colExprMap);
            return op;
        }
    }
}

