/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDescUtils;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;

public class LimitPushdownOptimizer
extends Transform {
    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        LinkedHashMap<SemanticRule, SemanticNodeProcessor> opRules = new LinkedHashMap<SemanticRule, SemanticNodeProcessor>();
        opRules.put(new RuleRegExp("R1", ReduceSinkOperator.getOperatorName() + "%.*" + LimitOperator.getOperatorName() + "%"), new TopNReducer());
        opRules.put(new RuleRegExp("R2", ReduceSinkOperator.getOperatorName() + "%.*" + ReduceSinkOperator.getOperatorName() + "%"), new TopNPropagator());
        LimitPushdownContext context = new LimitPushdownContext(pctx.getConf());
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(null, opRules, context);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>(pctx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    private static class LimitPushdownContext
    implements NodeProcessorCtx {
        private final float threshold;

        public LimitPushdownContext(HiveConf conf) throws SemanticException {
            this.threshold = conf.getFloatVar(HiveConf.ConfVars.HIVELIMITPUSHDOWNMEMORYUSAGE);
            if (this.threshold <= 0.0f || this.threshold >= 1.0f) {
                throw new SemanticException("Invalid memory usage value " + this.threshold + " for " + HiveConf.ConfVars.HIVELIMITPUSHDOWNMEMORYUSAGE);
            }
        }
    }

    private static class TopNPropagator
    implements SemanticNodeProcessor {
        private TopNPropagator() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            ReduceSinkOperator cRS = (ReduceSinkOperator)nd;
            if (((ReduceSinkDesc)cRS.getConf()).getTopN() == -1) {
                return false;
            }
            if (((ReduceSinkDesc)cRS.getConf()).isPTFReduceSink()) {
                return false;
            }
            Operator<OperatorDesc> pRS = null;
            for (int i = stack.size() - 2; i >= 0; --i) {
                Operator operator = (Operator)stack.get(i);
                if (operator.getNumChild() != 1) {
                    return false;
                }
                if (operator instanceof ReduceSinkOperator) {
                    pRS = (ReduceSinkOperator)operator;
                    break;
                }
                if (operator.acceptLimitPushdown()) continue;
                return false;
            }
            if (pRS != null) {
                StringBuilder orderNull;
                StringBuilder order;
                Operator<OperatorDesc> currentOp = pRS;
                boolean foundGroupByOperator = false;
                while (currentOp != nd) {
                    if (currentOp instanceof GroupByOperator) {
                        if (foundGroupByOperator) {
                            return false;
                        }
                        foundGroupByOperator = true;
                    }
                    currentOp = currentOp.getChildOperators().get(0);
                }
                List<ExprNodeDesc> cKeys = ((ReduceSinkDesc)cRS.getConf()).getKeyCols();
                List<ExprNodeDesc> pKeys = ((ReduceSinkDesc)pRS.getConf()).getKeyCols();
                if (pRS.getChildren().get(0) instanceof GroupByOperator && pRS.getChildren().get(0).getChildren().get(0) == cRS) {
                    GroupByOperator gBy = (GroupByOperator)pRS.getChildren().get(0);
                    List<ExprNodeDesc> gKeys = ((GroupByDesc)gBy.getConf()).getKeys();
                    if (!(ExprNodeDescUtils.checkPrefixKeysUpstream(cKeys, pKeys, cRS, pRS) || ExprNodeDescUtils.checkPrefixKeys(cKeys, gKeys, cRS, gBy) && ExprNodeDescUtils.checkPrefixKeys(gKeys, pKeys, gBy, pRS))) {
                        return false;
                    }
                } else if (!ExprNodeDescUtils.checkPrefixKeysUpstream(cKeys, pKeys, cRS, pRS)) {
                    return false;
                }
                if (((ReduceSinkDesc)pRS.getConf()).getOrder().length() > ((ReduceSinkDesc)cRS.getConf()).getOrder().length()) {
                    order = new StringBuilder(((ReduceSinkDesc)cRS.getConf()).getOrder());
                    orderNull = new StringBuilder(((ReduceSinkDesc)cRS.getConf()).getNullOrder());
                    order.append(((ReduceSinkDesc)pRS.getConf()).getOrder().substring(order.length()));
                    orderNull.append(((ReduceSinkDesc)pRS.getConf()).getNullOrder().substring(orderNull.length()));
                } else {
                    order = new StringBuilder(((ReduceSinkDesc)cRS.getConf()).getOrder().substring(0, ((ReduceSinkDesc)pRS.getConf()).getOrder().length()));
                    orderNull = new StringBuilder(((ReduceSinkDesc)cRS.getConf()).getNullOrder().substring(0, ((ReduceSinkDesc)pRS.getConf()).getNullOrder().length()));
                }
                ((ReduceSinkDesc)pRS.getConf()).setOrder(order.toString());
                ((ReduceSinkDesc)pRS.getConf()).setNullOrder(orderNull.toString());
                ((ReduceSinkDesc)pRS.getConf()).setTopN(((ReduceSinkDesc)cRS.getConf()).getTopN());
                ((ReduceSinkDesc)pRS.getConf()).setTopNMemoryUsage(((ReduceSinkDesc)cRS.getConf()).getTopNMemoryUsage());
                if (pRS.getNumChild() == 1 && pRS.getChildren().get(0) instanceof GroupByOperator) {
                    ((ReduceSinkDesc)pRS.getConf()).setMapGroupBy(true);
                }
            }
            return true;
        }
    }

    private static class TopNReducer
    implements SemanticNodeProcessor {
        private TopNReducer() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Operator<OperatorDesc> rs = null;
            for (int i = stack.size() - 2; i >= 0; --i) {
                Operator operator = (Operator)stack.get(i);
                if (operator.getNumChild() != 1) {
                    return false;
                }
                if (operator instanceof ReduceSinkOperator) {
                    rs = (ReduceSinkOperator)operator;
                    break;
                }
                if (operator.acceptLimitPushdown()) continue;
                return false;
            }
            if (rs != null) {
                Operator<OperatorDesc> currentOp = rs;
                boolean foundGroupByOperator = false;
                while (currentOp != nd) {
                    if (currentOp instanceof GroupByOperator) {
                        if (foundGroupByOperator) {
                            return false;
                        }
                        foundGroupByOperator = true;
                    }
                    currentOp = currentOp.getChildOperators().get(0);
                }
                LimitOperator limit = (LimitOperator)nd;
                LimitDesc limitDesc = (LimitDesc)limit.getConf();
                Integer offset = limitDesc.getOffset();
                ((ReduceSinkDesc)rs.getConf()).setTopN(limitDesc.getLimit() + (offset == null ? 0 : offset));
                ((ReduceSinkDesc)rs.getConf()).setTopNMemoryUsage(((LimitPushdownContext)procCtx).threshold);
                if (rs.getNumChild() == 1 && rs.getChildren().get(0) instanceof GroupByOperator) {
                    ((ReduceSinkDesc)rs.getConf()).setMapGroupBy(true);
                }
            }
            return true;
        }
    }
}

