/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeConstantDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByOptimizer
extends Transform {
    private static final Logger LOG = LoggerFactory.getLogger((String)GroupByOptimizer.class.getName());

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        LinkedHashMap<SemanticRule, SemanticNodeProcessor> opRules = new LinkedHashMap<SemanticRule, SemanticNodeProcessor>();
        HiveConf conf = pctx.getConf();
        if (!HiveConf.getBoolVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEGROUPBYSKEW)) {
            opRules.put(new RuleRegExp("R1", GroupByOperator.getOperatorName() + "%" + ReduceSinkOperator.getOperatorName() + "%" + GroupByOperator.getOperatorName() + "%"), this.getMapSortedGroupbyProc(pctx));
        } else {
            opRules.put(new RuleRegExp("R2", GroupByOperator.getOperatorName() + "%" + ReduceSinkOperator.getOperatorName() + "%" + GroupByOperator.getOperatorName() + "%" + ReduceSinkOperator.getOperatorName() + "%" + GroupByOperator.getOperatorName() + "%"), this.getMapSortedGroupbySkewProc(pctx));
        }
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(this.getDefaultProc(), opRules, new GroupByOptimizerContext(conf));
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    private SemanticNodeProcessor getDefaultProc() {
        return new SemanticNodeProcessor(){

            @Override
            public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
                return null;
            }
        };
    }

    private SemanticNodeProcessor getMapSortedGroupbyProc(ParseContext pctx) {
        return new SortGroupByProcessor(pctx);
    }

    private SemanticNodeProcessor getMapSortedGroupbySkewProc(ParseContext pctx) {
        return new SortGroupBySkewProcessor(pctx);
    }

    public class GroupByOptimizerContext
    implements NodeProcessorCtx {
        List<GroupByOperator> listGroupByOperatorsProcessed;
        HiveConf conf;

        public GroupByOptimizerContext(HiveConf conf) {
            this.conf = conf;
            this.listGroupByOperatorsProcessed = new ArrayList<GroupByOperator>();
        }

        public List<GroupByOperator> getListGroupByOperatorsProcessed() {
            return this.listGroupByOperatorsProcessed;
        }

        public void setListGroupByOperatorsProcessed(List<GroupByOperator> listGroupByOperatorsProcessed) {
            this.listGroupByOperatorsProcessed = listGroupByOperatorsProcessed;
        }

        public HiveConf getConf() {
            return this.conf;
        }

        public void setConf(HiveConf conf) {
            this.conf = conf;
        }
    }

    public class SortGroupBySkewProcessor
    extends SortGroupByProcessor {
        public SortGroupBySkewProcessor(ParseContext pGraphContext) {
            super(pGraphContext);
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            GroupByOptimizerContext ctx = (GroupByOptimizerContext)procCtx;
            GroupByOperator groupByOp = (GroupByOperator)stack.get(stack.size() - 5);
            if (!this.checkGroupByOperatorProcessed(ctx, groupByOp)) {
                this.processGroupBy(ctx, stack, groupByOp, 4);
            }
            return null;
        }
    }

    public class SortGroupByProcessor
    implements SemanticNodeProcessor {
        protected ParseContext pGraphContext;

        public SortGroupByProcessor(ParseContext pGraphContext) {
            this.pGraphContext = pGraphContext;
        }

        protected boolean checkGroupByOperatorProcessed(GroupByOptimizerContext groupBySortOptimizerContext, GroupByOperator groupByOp) {
            if (groupBySortOptimizerContext.getListGroupByOperatorsProcessed().contains(groupByOp)) {
                return true;
            }
            groupBySortOptimizerContext.getListGroupByOperatorsProcessed().add(groupByOp);
            return false;
        }

        protected void processGroupBy(GroupByOptimizerContext ctx, Stack<Node> stack, GroupByOperator groupByOp, int depth) throws SemanticException {
            HiveConf hiveConf = ctx.getConf();
            GroupByOptimizerSortMatch match = this.checkSortGroupBy(stack, groupByOp);
            boolean useMapperSort = HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_MAP_GROUPBY_SORT);
            GroupByDesc groupByOpDesc = (GroupByDesc)groupByOp.getConf();
            boolean removeReduceSink = false;
            boolean optimizeDistincts = false;
            boolean setBucketGroup = false;
            if (useMapperSort && match == GroupByOptimizerSortMatch.COMPLETE_MATCH) {
                List<ExprNodeDesc> keys;
                if (!groupByOpDesc.isDistinct()) {
                    removeReduceSink = true;
                } else if (!HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVEGROUPBYSKEW) && ((keys = ((GroupByDesc)((GroupByOperator)groupByOp.getChildOperators().get(0).getChildOperators().get(0)).getConf()).getKeys()) == null || keys.isEmpty())) {
                    optimizeDistincts = true;
                }
            }
            if (match == GroupByOptimizerSortMatch.PARTIAL_MATCH || match == GroupByOptimizerSortMatch.COMPLETE_MATCH) {
                setBucketGroup = true;
            }
            if (removeReduceSink) {
                this.convertGroupByMapSideSortedGroupBy(hiveConf, groupByOp, depth);
            } else if (optimizeDistincts && !HiveConf.getBoolVar((Configuration)hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_VECTORIZATION_ENABLED)) {
                this.pGraphContext.getQueryProperties().setHasMapGroupBy(true);
                ReduceSinkOperator reduceSinkOp = (ReduceSinkOperator)groupByOp.getChildOperators().get(0);
                GroupByDesc childGroupByDesc = (GroupByDesc)((GroupByOperator)reduceSinkOp.getChildOperators().get(0)).getConf();
                for (int pos = 0; pos < childGroupByDesc.getAggregators().size(); ++pos) {
                    AggregationDesc aggr = childGroupByDesc.getAggregators().get(pos);
                    if (!aggr.getDistinct()) continue;
                    ArrayList<ExprNodeDesc> parameters = new ArrayList<ExprNodeDesc>();
                    ExprNodeDesc param = aggr.getParameters().get(0);
                    assert (param instanceof ExprNodeColumnDesc);
                    ExprNodeColumnDesc paramC = (ExprNodeColumnDesc)param;
                    paramC.setIsPartitionColOrVirtualCol(false);
                    paramC.setColumn("VALUE._col" + pos);
                    parameters.add(paramC);
                    aggr.setParameters(parameters);
                    aggr.setDistinct(false);
                    aggr.setMode(GenericUDAFEvaluator.Mode.FINAL);
                }
                childGroupByDesc.setDistinct(false);
                groupByOpDesc.setDontResetAggrsDistinct(true);
                groupByOpDesc.setBucketGroup(true);
                groupByOp.setUseBucketizedHiveInputFormat(true);
                ((ReduceSinkDesc)reduceSinkOp.getConf()).setDistinctColumnIndices(new ArrayList<List<Integer>>());
            } else if (setBucketGroup) {
                groupByOpDesc.setBucketGroup(true);
            }
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            GroupByOptimizerContext ctx = (GroupByOptimizerContext)procCtx;
            GroupByOperator groupByOp = (GroupByOperator)stack.get(stack.size() - 3);
            if (!this.checkGroupByOperatorProcessed(ctx, groupByOp)) {
                this.processGroupBy(ctx, stack, groupByOp, 2);
            }
            return null;
        }

        protected GroupByOptimizerSortMatch checkSortGroupBy(Stack<Node> stack, GroupByOperator groupByOp) throws SemanticException {
            if (((GroupByDesc)groupByOp.getConf()).getMode() != GroupByDesc.Mode.HASH) {
                return GroupByOptimizerSortMatch.NO_MATCH;
            }
            Operator currOp = groupByOp;
            currOp = currOp.getParentOperators().get(0);
            while (currOp.getParentOperators() != null && !currOp.getParentOperators().isEmpty()) {
                if (currOp.getParentOperators().size() > 1 || !currOp.columnNamesRowResolvedCanBeObtained()) {
                    return GroupByOptimizerSortMatch.NO_MATCH;
                }
                currOp = currOp.getParentOperators().get(0);
            }
            TableScanOperator tableScanOp = (TableScanOperator)currOp;
            int stackPos = 0;
            assert (stack.get(0) == tableScanOp);
            HashMap<String, String> tableColsMapping = new HashMap<String, String>();
            Object constantCols = new HashSet();
            Table table = ((TableScanDesc)tableScanOp.getConf()).getTableMetadata();
            for (FieldSchema col : table.getAllCols()) {
                tableColsMapping.put(col.getName(), col.getName());
            }
            while (currOp != groupByOp) {
                SelectOperator selectOp;
                SelectDesc selectDesc;
                Operator processOp = currOp;
                HashSet newConstantCols = new HashSet();
                currOp = (Operator)stack.get(++stackPos);
                if (!(processOp instanceof SelectOperator) || (selectDesc = (SelectDesc)(selectOp = (SelectOperator)processOp).getConf()).isSelStarNoCompute()) continue;
                for (int pos = 0; pos < selectDesc.getColList().size(); ++pos) {
                    String outputColumnName = selectDesc.getOutputColumnNames().get(pos);
                    if (constantCols.contains(outputColumnName)) {
                        tableColsMapping.remove(outputColumnName);
                        newConstantCols.add(outputColumnName);
                        continue;
                    }
                    ExprNodeDesc selectCol = selectDesc.getColList().get(pos);
                    if (selectCol instanceof ExprNodeColumnDesc) {
                        String newValue = (String)tableColsMapping.get(((ExprNodeColumnDesc)selectCol).getColumn());
                        tableColsMapping.put(outputColumnName, newValue);
                        continue;
                    }
                    tableColsMapping.remove(outputColumnName);
                    if (!(selectCol instanceof ExprNodeConstantDesc)) continue;
                    String origCol = ((ExprNodeConstantDesc)selectCol).getFoldedFromCol();
                    if (origCol != null) {
                        tableColsMapping.put(outputColumnName, origCol);
                        continue;
                    }
                    newConstantCols.add(outputColumnName);
                }
                constantCols = newConstantCols;
            }
            ArrayList<String> groupByCols = new ArrayList<String>();
            for (ExprNodeDesc expr : ((GroupByDesc)groupByOp.getConf()).getKeys()) {
                if (expr instanceof ExprNodeColumnDesc) {
                    String groupByKeyColumn = ((ExprNodeColumnDesc)expr).getColumn();
                    if (constantCols.contains(groupByKeyColumn)) continue;
                    if (tableColsMapping.containsKey(groupByKeyColumn)) {
                        groupByCols.add((String)tableColsMapping.get(groupByKeyColumn));
                        continue;
                    }
                    return GroupByOptimizerSortMatch.NO_MATCH;
                }
                if (expr instanceof ExprNodeConstantDesc) continue;
                return GroupByOptimizerSortMatch.NO_MATCH;
            }
            if (!table.isPartitioned()) {
                List<String> sortCols = Utilities.getColumnNamesFromSortCols(table.getSortCols());
                List<String> bucketCols = table.getBucketCols();
                return this.matchBucketSortCols(groupByCols, bucketCols, sortCols);
            }
            PrunedPartitionList partsList = this.pGraphContext.getPrunedPartitions(table.getTableName(), tableScanOp);
            List<Partition> notDeniedPartns = partsList.getNotDeniedPartns();
            GroupByOptimizerSortMatch currentMatch = notDeniedPartns.isEmpty() ? GroupByOptimizerSortMatch.NO_MATCH : (notDeniedPartns.size() > 1 ? GroupByOptimizerSortMatch.PARTIAL_MATCH : GroupByOptimizerSortMatch.COMPLETE_MATCH);
            for (Partition part : notDeniedPartns) {
                List<String> sortCols = part.getSortColNames();
                List<String> bucketCols = part.getBucketCols();
                GroupByOptimizerSortMatch match = this.matchBucketSortCols(groupByCols, bucketCols, sortCols);
                if (match == GroupByOptimizerSortMatch.NO_MATCH) {
                    return match;
                }
                if (match != GroupByOptimizerSortMatch.PARTIAL_MATCH) continue;
                currentMatch = match;
            }
            return currentMatch;
        }

        private ColumnOrderMatch matchColumnOrder(List<String> cols1, List<String> cols2) {
            int numCols2;
            int numCols1 = cols1 == null ? 0 : cols1.size();
            int n = numCols2 = cols2 == null ? 0 : cols2.size();
            if (numCols1 == 0 || numCols2 == 0) {
                return ColumnOrderMatch.NO_MATCH;
            }
            for (int pos = 0; pos < Math.min(numCols1, numCols2); ++pos) {
                if (cols1.get(pos).equals(cols2.get(pos))) continue;
                return ColumnOrderMatch.NO_MATCH;
            }
            return numCols1 == numCols2 ? ColumnOrderMatch.COMPLETE_MATCH : (numCols1 < numCols2 ? ColumnOrderMatch.PREFIX_COL1_MATCH : ColumnOrderMatch.PREFIX_COL2_MATCH);
        }

        private GroupByOptimizerSortMatch matchBucketSortCols(List<String> groupByCols, List<String> bucketCols, List<String> sortCols) throws SemanticException {
            ColumnOrderMatch bucketSortColsMatch = this.matchColumnOrder(bucketCols, sortCols);
            ColumnOrderMatch sortGroupByColsMatch = this.matchColumnOrder(sortCols, groupByCols);
            switch (sortGroupByColsMatch) {
                case NO_MATCH: {
                    return GroupByOptimizerSortMatch.NO_MATCH;
                }
                case COMPLETE_MATCH: {
                    return bucketCols != null && !bucketCols.isEmpty() && sortCols.containsAll(bucketCols) ? GroupByOptimizerSortMatch.COMPLETE_MATCH : GroupByOptimizerSortMatch.PARTIAL_MATCH;
                }
                case PREFIX_COL1_MATCH: {
                    return GroupByOptimizerSortMatch.NO_MATCH;
                }
                case PREFIX_COL2_MATCH: {
                    return bucketSortColsMatch == ColumnOrderMatch.NO_MATCH || bucketCols.size() > groupByCols.size() ? GroupByOptimizerSortMatch.PARTIAL_MATCH : GroupByOptimizerSortMatch.COMPLETE_MATCH;
                }
            }
            return GroupByOptimizerSortMatch.NO_MATCH;
        }

        protected void convertGroupByMapSideSortedGroupBy(HiveConf conf, GroupByOperator groupByOp, int depth) {
            this.pGraphContext.getQueryProperties().setHasMapGroupBy(true);
            if (this.removeChildren(groupByOp, depth)) {
                groupByOp.setUseBucketizedHiveInputFormat(true);
                ((GroupByDesc)groupByOp.getConf()).setMode(GroupByDesc.Mode.FINAL);
            }
        }

        public boolean removeChildren(Operator<? extends OperatorDesc> currOp, int depth) {
            Operator<? extends OperatorDesc> inputOp = currOp;
            for (int i = 0; i < depth; ++i) {
                if (currOp.getChildOperators() == null || currOp.getChildOperators().isEmpty() || currOp.getChildOperators().size() > 1) {
                    return false;
                }
                currOp = currOp.getChildOperators().get(0);
            }
            for (Operator<OperatorDesc> op : inputOp.getChildOperators()) {
                op.getParentOperators().clear();
            }
            inputOp.getChildOperators().clear();
            Operator<? extends OperatorDesc> selOp = this.genOutputSelectForGroupBy(inputOp, currOp);
            selOp.setChildOperators(currOp.getChildOperators());
            for (Operator<OperatorDesc> op : currOp.getChildOperators()) {
                op.replaceParent(currOp, selOp);
            }
            return true;
        }

        private Operator<? extends OperatorDesc> genOutputSelectForGroupBy(Operator<? extends OperatorDesc> parentOp, Operator<? extends OperatorDesc> currOp) {
            assert (parentOp.getSchema().getSignature().size() == currOp.getSchema().getSignature().size());
            Iterator<ColumnInfo> pIter = parentOp.getSchema().getSignature().iterator();
            Iterator<ColumnInfo> cIter = currOp.getSchema().getSignature().iterator();
            ArrayList<ExprNodeDesc> columns = new ArrayList<ExprNodeDesc>();
            ArrayList<String> colName = new ArrayList<String>();
            HashMap<String, ExprNodeDesc> columnExprMap = new HashMap<String, ExprNodeDesc>();
            while (pIter.hasNext()) {
                ColumnInfo pInfo = pIter.next();
                ColumnInfo cInfo = cIter.next();
                ExprNodeColumnDesc column = new ExprNodeColumnDesc(pInfo.getType(), pInfo.getInternalName(), pInfo.getTabAlias(), pInfo.getIsVirtualCol(), pInfo.isSkewedCol());
                columns.add(column);
                colName.add(cInfo.getInternalName());
                columnExprMap.put(cInfo.getInternalName(), column);
            }
            return OperatorFactory.getAndMakeChild(new SelectDesc(columns, colName), new RowSchema(currOp.getSchema().getSignature()), columnExprMap, parentOp, new Operator[0]);
        }
    }

    private static enum ColumnOrderMatch {
        NO_MATCH,
        PREFIX_COL1_MATCH,
        PREFIX_COL2_MATCH,
        COMPLETE_MATCH;

    }

    public static enum GroupByOptimizerSortMatch {
        NO_MATCH,
        PARTIAL_MATCH,
        COMPLETE_MATCH;

    }
}

