/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Stack;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.ColumnInfo;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.RuleRegExp;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.optimizer.Transform;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.SemanticAnalyzer;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.AggregationDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeColumnDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.PlanUtils;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.util.NullOrdering;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CountDistinctRewriteProc
extends Transform {
    private static final Logger LOG = LoggerFactory.getLogger((String)CountDistinctRewriteProc.class.getName());

    @Override
    public ParseContext transform(ParseContext pctx) throws SemanticException {
        LinkedHashMap<SemanticRule, SemanticNodeProcessor> opRules = new LinkedHashMap<SemanticRule, SemanticNodeProcessor>();
        opRules.put(new RuleRegExp("R1", GroupByOperator.getOperatorName() + "%" + ReduceSinkOperator.getOperatorName() + "%" + GroupByOperator.getOperatorName() + "%"), this.getCountDistinctProc(pctx));
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(this.getDefaultProc(), opRules, null);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        ArrayList<Node> topNodes = new ArrayList<Node>();
        topNodes.addAll(pctx.getTopOps().values());
        ogw.startWalking(topNodes, null);
        return pctx;
    }

    private SemanticNodeProcessor getDefaultProc() {
        return new SemanticNodeProcessor(){

            @Override
            public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
                return null;
            }
        };
    }

    private SemanticNodeProcessor getCountDistinctProc(ParseContext pctx) {
        return new CountDistinctProcessor(pctx);
    }

    public class CountDistinctProcessor
    implements SemanticNodeProcessor {
        protected ParseContext pGraphContext;

        public CountDistinctProcessor(ParseContext pGraphContext) {
            this.pGraphContext = pGraphContext;
        }

        protected int checkCountDistinct(GroupByOperator mGby, ReduceSinkOperator rs, GroupByOperator rGby) {
            int indexOfDist = -1;
            List<ExprNodeDesc> keys = ((GroupByDesc)mGby.getConf()).getKeys();
            if (((GroupByDesc)mGby.getConf()).getMode() != GroupByDesc.Mode.HASH || ((GroupByDesc)mGby.getConf()).isGroupingSetsPresent() || ((ReduceSinkDesc)rs.getConf()).getKeyCols().size() != 1 || ((ReduceSinkDesc)rs.getConf()).getPartitionCols().size() != 0 || ((ReduceSinkDesc)rs.getConf()).getDistinctColumnIndices().size() != 1 || ((GroupByDesc)rGby.getConf()).getMode() != GroupByDesc.Mode.MERGEPARTIAL || keys.size() != 1 || ((GroupByDesc)rGby.getConf()).getKeys().size() != 0 || ((GroupByDesc)mGby.getConf()).getOutputColumnNames().size() != ((GroupByDesc)mGby.getConf()).getAggregators().size() + 1) {
                return -1;
            }
            for (int pos = 0; pos < ((GroupByDesc)mGby.getConf()).getAggregators().size(); ++pos) {
                ExprNodeColumnDesc key;
                AggregationDesc aggr = ((GroupByDesc)mGby.getConf()).getAggregators().get(pos);
                if (!aggr.getDistinct()) continue;
                if (indexOfDist != -1 || !aggr.getGenericUDAFName().equalsIgnoreCase("count")) {
                    return -1;
                }
                indexOfDist = pos;
                if (aggr.getParameters().size() != 1 || !(aggr.getParameters().get(0) instanceof ExprNodeColumnDesc) || !(((GroupByDesc)mGby.getConf()).getKeys().get(0) instanceof ExprNodeColumnDesc)) {
                    return -1;
                }
                ExprNodeColumnDesc agg = (ExprNodeColumnDesc)aggr.getParameters().get(0);
                if (agg.isSame(key = (ExprNodeColumnDesc)((GroupByDesc)mGby.getConf()).getKeys().get(0))) continue;
                return -1;
            }
            if (indexOfDist == -1) {
                return -1;
            }
            if (this.pGraphContext.getConf().getBoolVar(HiveConf.ConfVars.HIVEMETADATAONLYQUERIES)) {
                for (TableScanOperator tsOp : this.pGraphContext.getTopOps().values()) {
                    List<Integer> colIDs = tsOp.getNeededColumnIDs();
                    TableScanDesc desc = (TableScanDesc)tsOp.getConf();
                    boolean noColNeeded = colIDs == null || colIDs.isEmpty();
                    boolean noVCneeded = desc == null || desc.getVirtualCols() == null || desc.getVirtualCols().isEmpty();
                    boolean isSkipHF = desc.isNeedSkipHeaderFooters();
                    if (!noColNeeded || !noVCneeded || isSkipHF) continue;
                    return -1;
                }
            }
            return indexOfDist;
        }

        protected void processGroupBy(GroupByOperator mGby, ReduceSinkOperator rs, GroupByOperator rGby, int indexOfDist) throws SemanticException, CloneNotSupportedException {
            List<Operator<OperatorDesc>> parents = mGby.getParentOperators();
            List<Operator<OperatorDesc>> children = rGby.getChildOperators();
            mGby.removeParents();
            rs.removeParents();
            rGby.removeParents();
            GroupByOperator mGby1 = this.genMapGroupby1(mGby, indexOfDist);
            ReduceSinkOperator rs1 = this.genReducesink1(mGby1, rs, indexOfDist);
            GroupByOperator mGby2 = this.genMapGroupby2(rs1, mGby, indexOfDist);
            GroupByOperator mGby3 = this.genMapGroupby3(mGby2, mGby, indexOfDist);
            ReduceSinkOperator rs2 = this.genReducesink2(mGby3, rs);
            GroupByOperator rGby1 = this.genReduceGroupby(rs2, rGby, indexOfDist);
            for (Operator<OperatorDesc> parent : parents) {
                OperatorFactory.makeChild(parent, mGby1);
            }
            OperatorFactory.makeChild(mGby1, rs1);
            OperatorFactory.makeChild(rs1, mGby2);
            OperatorFactory.makeChild(mGby2, mGby3);
            OperatorFactory.makeChild(mGby3, rs2);
            OperatorFactory.makeChild(rs2, rGby1);
            for (Operator<OperatorDesc> child : children) {
                child.removeParents();
                OperatorFactory.makeChild(rGby1, child);
            }
        }

        private GroupByOperator genMapGroupby1(Operator<? extends OperatorDesc> mGby, int indexOfDist) throws CloneNotSupportedException {
            GroupByOperator mGby1 = (GroupByOperator)mGby.clone();
            String fieldString = ((GroupByDesc)mGby1.getConf()).getOutputColumnNames().get(indexOfDist + 1);
            mGby1.getColumnExprMap().remove(fieldString);
            ((GroupByDesc)mGby1.getConf()).getOutputColumnNames().remove(indexOfDist + 1);
            ((GroupByDesc)mGby1.getConf()).getAggregators().remove(indexOfDist);
            ((GroupByDesc)mGby1.getConf()).setDistinct(false);
            mGby1.getSchema().getColumnNames().remove(indexOfDist + 1);
            mGby1.getSchema().getSignature().remove(indexOfDist + 1);
            return mGby1;
        }

        private ReduceSinkOperator genReducesink1(GroupByOperator mGby1, Operator<? extends OperatorDesc> rs, int indexOfDist) throws CloneNotSupportedException, SemanticException {
            ReduceSinkOperator rs1 = (ReduceSinkOperator)rs.clone();
            HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
            ArrayList<String> outputKeyColumnNames = new ArrayList<String>();
            ArrayList<String> outputValueColumnNames = new ArrayList<String>();
            ArrayList<ExprNodeDesc> reduceKeys = new ArrayList<ExprNodeDesc>();
            ArrayList<ExprNodeDesc> reduceValues = new ArrayList<ExprNodeDesc>();
            ArrayList<ColumnInfo> rowSchema = new ArrayList<ColumnInfo>();
            ArrayList<String> internalNames = new ArrayList<String>();
            for (int index = 0; index < mGby1.getSchema().getSignature().size(); ++index) {
                String internalName;
                String outputColName;
                ColumnInfo paraExprInfo = mGby1.getSchema().getSignature().get(index);
                String paraExpression = paraExprInfo.getInternalName();
                assert (paraExpression != null);
                ExprNodeColumnDesc exprDesc = new ExprNodeColumnDesc(paraExprInfo.getType(), paraExpression, paraExprInfo.getTabAlias(), paraExprInfo.getIsVirtualCol());
                if (index == 0) {
                    reduceKeys.add(exprDesc);
                    outputColName = SemanticAnalyzer.getColumnInternalName(index);
                    outputKeyColumnNames.add(outputColName);
                    internalName = Utilities.ReduceField.KEY.toString() + "." + outputColName;
                    colExprMap.put(internalName, exprDesc);
                    internalNames.add(internalName);
                    rowSchema.add(new ColumnInfo(internalName, mGby1.getSchema().getSignature().get(index).getType(), "", false));
                    continue;
                }
                reduceValues.add(exprDesc);
                outputColName = SemanticAnalyzer.getColumnInternalName(index - 1);
                outputValueColumnNames.add(outputColName);
                internalName = Utilities.ReduceField.VALUE.toString() + "." + outputColName;
                colExprMap.put(internalName, exprDesc);
                internalNames.add(internalName);
                rowSchema.add(new ColumnInfo(internalName, mGby1.getSchema().getSignature().get(index).getType(), "", false));
            }
            ArrayList<List<Integer>> distinctColIndices = new ArrayList<List<Integer>>();
            rs1.setConf(PlanUtils.getReduceSinkDesc(reduceKeys, 1, reduceValues, distinctColIndices, outputKeyColumnNames, outputValueColumnNames, true, -1, 1, -1, AcidUtils.Operation.NOT_ACID, NullOrdering.defaultNullOrder((Configuration)this.pGraphContext.getConf())));
            rs1.setColumnExprMap(colExprMap);
            rs1.setSchema(new RowSchema(rowSchema));
            return rs1;
        }

        private GroupByOperator genMapGroupby2(ReduceSinkOperator rs1, Operator<? extends OperatorDesc> mGby, int indexOfDist) throws CloneNotSupportedException, SemanticException {
            GroupByOperator mGby2 = (GroupByOperator)mGby.clone();
            ArrayList<ColumnInfo> rowSchema = new ArrayList<ColumnInfo>();
            ArrayList<ExprNodeColumnDesc> groupByKeys = new ArrayList<ExprNodeColumnDesc>();
            ArrayList<String> outputColumnNames = new ArrayList<String>();
            HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
            ColumnInfo exprInfo = rs1.getSchema().getSignature().get(0);
            ExprNodeColumnDesc key = new ExprNodeColumnDesc(exprInfo);
            groupByKeys.add(key);
            String field = SemanticAnalyzer.getColumnInternalName(0);
            outputColumnNames.add(field);
            ColumnInfo oColInfo = new ColumnInfo(field, exprInfo.getType(), "", false);
            colExprMap.put(field, key);
            rowSchema.add(oColInfo);
            ArrayList<AggregationDesc> aggregations = new ArrayList<AggregationDesc>();
            for (int index = 0; index < ((GroupByDesc)mGby2.getConf()).getAggregators().size(); ++index) {
                ArrayList<ExprNodeDesc> aggParameters = new ArrayList<ExprNodeDesc>();
                if (index == indexOfDist) continue;
                AggregationDesc desc = ((GroupByDesc)mGby2.getConf()).getAggregators().get(index);
                ColumnInfo paraExprInfo = null;
                paraExprInfo = index < indexOfDist ? rs1.getSchema().getSignature().get(index + 1) : rs1.getSchema().getSignature().get(index);
                String paraExpression = paraExprInfo.getInternalName();
                assert (paraExpression != null);
                aggParameters.add(new ExprNodeColumnDesc(paraExprInfo.getType(), paraExpression, paraExprInfo.getTabAlias(), paraExprInfo.getIsVirtualCol()));
                GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(GroupByDesc.Mode.PARTIAL2, false);
                GenericUDAFEvaluator genericUDAFEvaluator = desc.getGenericUDAFEvaluator();
                SemanticAnalyzer.GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
                aggregations.add(new AggregationDesc(desc.getGenericUDAFName(), udaf.genericUDAFEvaluator, udaf.convertedParameters, false, amode));
                String f = SemanticAnalyzer.getColumnInternalName(aggregations.size());
                outputColumnNames.add(f);
                rowSchema.add(new ColumnInfo(f, udaf.returnType, "", false));
            }
            ((GroupByDesc)mGby2.getConf()).setMode(GroupByDesc.Mode.PARTIAL2);
            ((GroupByDesc)mGby2.getConf()).setOutputColumnNames(outputColumnNames);
            ((GroupByDesc)mGby2.getConf()).getKeys().clear();
            ((GroupByDesc)mGby2.getConf()).getKeys().addAll(groupByKeys);
            ((GroupByDesc)mGby2.getConf()).getAggregators().clear();
            ((GroupByDesc)mGby2.getConf()).getAggregators().addAll(aggregations);
            ((GroupByDesc)mGby2.getConf()).setDistinct(false);
            mGby2.setSchema(new RowSchema(rowSchema));
            mGby2.setColumnExprMap(colExprMap);
            return mGby2;
        }

        private GroupByOperator genMapGroupby3(GroupByOperator mGby2, Operator<? extends OperatorDesc> mGby, int indexOfDist) throws CloneNotSupportedException, SemanticException {
            GroupByOperator mGby3 = (GroupByOperator)mGby.clone();
            ArrayList<ColumnInfo> rowSchema = new ArrayList<ColumnInfo>();
            ArrayList<String> outputColumnNames = new ArrayList<String>();
            HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
            ArrayList<AggregationDesc> aggregations = new ArrayList<AggregationDesc>();
            for (int index = 0; index <= ((GroupByDesc)mGby2.getConf()).getAggregators().size(); ++index) {
                String f;
                ArrayList<ExprNodeDesc> aggParameters;
                if (index == indexOfDist) {
                    aggParameters = new ArrayList<ExprNodeDesc>();
                    ColumnInfo paraExprInfo = mGby2.getSchema().getSignature().get(0);
                    String paraExpression = paraExprInfo.getInternalName();
                    assert (paraExpression != null);
                    aggParameters.add(new ExprNodeColumnDesc(paraExprInfo.getType(), paraExpression, paraExprInfo.getTabAlias(), paraExprInfo.getIsVirtualCol()));
                    GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(GroupByDesc.Mode.HASH, false);
                    GenericUDAFEvaluator genericUDAFEvaluator = SemanticAnalyzer.getGenericUDAFEvaluator("count", aggParameters, null, false, false);
                    assert (genericUDAFEvaluator != null);
                    SemanticAnalyzer.GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
                    AggregationDesc newDesc = new AggregationDesc("count", udaf.genericUDAFEvaluator, udaf.convertedParameters, false, amode);
                    f = SemanticAnalyzer.getColumnInternalName(aggregations.size());
                    aggregations.add(newDesc);
                    outputColumnNames.add(f);
                    rowSchema.add(new ColumnInfo(f, udaf.returnType, "", false));
                }
                if (index == ((GroupByDesc)mGby2.getConf()).getAggregators().size()) break;
                aggParameters = new ArrayList();
                AggregationDesc desc = ((GroupByDesc)mGby2.getConf()).getAggregators().get(index);
                ColumnInfo paraExprInfo = null;
                paraExprInfo = mGby2.getSchema().getSignature().get(index + 1);
                String paraExpression = paraExprInfo.getInternalName();
                assert (paraExpression != null);
                aggParameters.add(new ExprNodeColumnDesc(paraExprInfo.getType(), paraExpression, paraExprInfo.getTabAlias(), paraExprInfo.getIsVirtualCol()));
                GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(GroupByDesc.Mode.PARTIAL2, false);
                GenericUDAFEvaluator genericUDAFEvaluator = desc.getGenericUDAFEvaluator();
                SemanticAnalyzer.GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
                f = SemanticAnalyzer.getColumnInternalName(aggregations.size());
                aggregations.add(new AggregationDesc(desc.getGenericUDAFName(), udaf.genericUDAFEvaluator, udaf.convertedParameters, false, amode));
                outputColumnNames.add(f);
                rowSchema.add(new ColumnInfo(f, udaf.returnType, "", false));
            }
            ((GroupByDesc)mGby3.getConf()).setMode(GroupByDesc.Mode.PARTIAL2);
            ((GroupByDesc)mGby3.getConf()).setOutputColumnNames(outputColumnNames);
            ((GroupByDesc)mGby3.getConf()).getKeys().clear();
            ((GroupByDesc)mGby3.getConf()).getAggregators().clear();
            ((GroupByDesc)mGby3.getConf()).getAggregators().addAll(aggregations);
            ((GroupByDesc)mGby3.getConf()).setDistinct(false);
            mGby3.setSchema(new RowSchema(rowSchema));
            mGby3.setColumnExprMap(colExprMap);
            return mGby3;
        }

        private ReduceSinkOperator genReducesink2(GroupByOperator mGby2, Operator<? extends OperatorDesc> rs) throws SemanticException, CloneNotSupportedException {
            ReduceSinkOperator rs2 = (ReduceSinkOperator)rs.clone();
            HashMap<String, ExprNodeDesc> colExprMap = new HashMap<String, ExprNodeDesc>();
            ArrayList<String> outputKeyColumnNames = new ArrayList<String>();
            ArrayList<String> outputValueColumnNames = new ArrayList<String>();
            ArrayList<ExprNodeDesc> reduceValues = new ArrayList<ExprNodeDesc>();
            ArrayList<ColumnInfo> rowSchema = new ArrayList<ColumnInfo>();
            for (int index = 0; index < mGby2.getSchema().getSignature().size(); ++index) {
                ColumnInfo paraExprInfo = mGby2.getSchema().getSignature().get(index);
                String paraExpression = paraExprInfo.getInternalName();
                assert (paraExpression != null);
                ExprNodeColumnDesc exprDesc = new ExprNodeColumnDesc(paraExprInfo.getType(), paraExpression, paraExprInfo.getTabAlias(), paraExprInfo.getIsVirtualCol());
                reduceValues.add(exprDesc);
                String outputColName = SemanticAnalyzer.getColumnInternalName(index);
                outputValueColumnNames.add(outputColName);
                String internalName = Utilities.ReduceField.VALUE.toString() + "." + outputColName;
                colExprMap.put(internalName, exprDesc);
                rowSchema.add(new ColumnInfo(internalName, paraExprInfo.getType(), "", false));
            }
            ArrayList<List<Integer>> distinctColIndices = new ArrayList<List<Integer>>();
            ArrayList<ExprNodeDesc> reduceKeys = new ArrayList<ExprNodeDesc>();
            rs2.setConf(PlanUtils.getReduceSinkDesc(reduceKeys, 0, reduceValues, distinctColIndices, outputKeyColumnNames, outputValueColumnNames, false, -1, 0, 1, AcidUtils.Operation.NOT_ACID, NullOrdering.defaultNullOrder((Configuration)this.pGraphContext.getConf())));
            rs2.setColumnExprMap(colExprMap);
            rs2.setSchema(new RowSchema(rowSchema));
            return rs2;
        }

        private GroupByOperator genReduceGroupby(ReduceSinkOperator rs2, Operator<? extends OperatorDesc> rGby, int indexOfDist) throws SemanticException, CloneNotSupportedException {
            GroupByOperator rGby1 = (GroupByOperator)rGby.clone();
            ColumnInfo paraExprInfo = rs2.getSchema().getSignature().get(indexOfDist);
            String paraExpression = paraExprInfo.getInternalName();
            assert (paraExpression != null);
            ArrayList<ExprNodeDesc> aggParameters = new ArrayList<ExprNodeDesc>();
            aggParameters.add(new ExprNodeColumnDesc(paraExprInfo.getType(), paraExpression, paraExprInfo.getTabAlias(), paraExprInfo.getIsVirtualCol()));
            GenericUDAFEvaluator genericUDAFEvaluator = SemanticAnalyzer.getGenericUDAFEvaluator("count", aggParameters, null, false, false);
            assert (genericUDAFEvaluator != null);
            GenericUDAFEvaluator.Mode amode = SemanticAnalyzer.groupByDescModeToUDAFMode(GroupByDesc.Mode.MERGEPARTIAL, false);
            SemanticAnalyzer.GenericUDAFInfo udaf = SemanticAnalyzer.getGenericUDAFInfo(genericUDAFEvaluator, amode, aggParameters);
            AggregationDesc newDesc = new AggregationDesc("count", udaf.genericUDAFEvaluator, udaf.convertedParameters, false, amode);
            ((GroupByDesc)rGby1.getConf()).getAggregators().set(indexOfDist, newDesc);
            ((GroupByDesc)rGby1.getConf()).setDistinct(false);
            return rGby1;
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            GroupByOperator rGby;
            ReduceSinkOperator rs;
            GroupByOperator mGby = (GroupByOperator)stack.get(stack.size() - 3);
            int applicableDistPos = this.checkCountDistinct(mGby, rs = (ReduceSinkOperator)stack.get(stack.size() - 2), rGby = (GroupByOperator)stack.get(stack.size() - 1));
            if (applicableDistPos != -1) {
                LOG.info("trigger count distinct rewrite");
                try {
                    this.processGroupBy(mGby, rs, rGby, applicableDistPos);
                }
                catch (CloneNotSupportedException e) {
                    throw new SemanticException(e.getMessage());
                }
            }
            return null;
        }
    }
}

