/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.optimizer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.apache.hadoop.hive.ql.exec.DummyStoreOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.OperatorFactory;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.AbstractBucketJoinProc;
import org.apache.hadoop.hive.ql.optimizer.BigTableSelectorForAutoSMJ;
import org.apache.hadoop.hive.ql.optimizer.MapJoinProcessor;
import org.apache.hadoop.hive.ql.optimizer.SortBucketJoinProcCtx;
import org.apache.hadoop.hive.ql.parse.ParseContext;
import org.apache.hadoop.hive.ql.parse.PrunedPartitionList;
import org.apache.hadoop.hive.ql.parse.QB;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.parse.TableAccessAnalyzer;
import org.apache.hadoop.hive.ql.plan.DummyStoreDesc;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.JoinCondDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.util.ReflectionUtils;

public abstract class AbstractSMBJoinProc
extends AbstractBucketJoinProc
implements SemanticNodeProcessor {
    public AbstractSMBJoinProc(ParseContext pctx) {
        super(pctx);
    }

    public AbstractSMBJoinProc() {
    }

    @Override
    public abstract Object process(Node var1, Stack<Node> var2, NodeProcessorCtx var3, Object ... var4) throws SemanticException;

    protected boolean canConvertBucketMapJoinToSMBJoin(MapJoinOperator mapJoinOp, Stack<Node> stack, SortBucketJoinProcCtx smbJoinContext, Object ... nodeOutputs) throws SemanticException {
        if (((MapJoinDesc)mapJoinOp.getConf()).getAliasBucketFileNameMapping() == null || ((MapJoinDesc)mapJoinOp.getConf()).getAliasBucketFileNameMapping().size() == 0) {
            return false;
        }
        if (!this.pGraphContext.getMapJoinOps().contains(mapJoinOp)) {
            return false;
        }
        String[] srcs = ((MapJoinDesc)mapJoinOp.getConf()).getBaseSrc();
        for (int srcPos = 0; srcPos < srcs.length; ++srcPos) {
            srcs[srcPos] = QB.getAppendedAliasFromId(((MapJoinDesc)mapJoinOp.getConf()).getId(), srcs[srcPos]);
        }
        boolean tableEligibleForBucketedSortMergeJoin = true;
        ArrayList<Order> sortColumnsFirstTable = new ArrayList<Order>();
        for (int pos = 0; pos < srcs.length; ++pos) {
            tableEligibleForBucketedSortMergeJoin = tableEligibleForBucketedSortMergeJoin && this.isEligibleForBucketSortMergeJoin(smbJoinContext, ((MapJoinDesc)mapJoinOp.getConf()).getKeys().get((byte)pos), ((MapJoinDesc)mapJoinOp.getConf()).getAliasToOpInfo(), srcs, pos, sortColumnsFirstTable);
        }
        if (!tableEligibleForBucketedSortMergeJoin) {
            if (MapJoinProcessor.checkMapJoin(((MapJoinDesc)mapJoinOp.getConf()).getPosBigTable(), ((MapJoinDesc)mapJoinOp.getConf()).getConds()) < 0) {
                throw new SemanticException(ErrorMsg.INVALID_BIGTABLE_MAPJOIN.format(((MapJoinDesc)mapJoinOp.getConf()).getBigTableAlias()));
            }
            return false;
        }
        smbJoinContext.setSrcs(srcs);
        return true;
    }

    protected SMBMapJoinOperator convertBucketMapJoinToSMBJoin(MapJoinOperator mapJoinOp, SortBucketJoinProcCtx smbJoinContext) {
        String[] srcs = smbJoinContext.getSrcs();
        SMBMapJoinOperator smbJop = new SMBMapJoinOperator(mapJoinOp);
        SMBJoinDesc smbJoinDesc = new SMBJoinDesc((MapJoinDesc)mapJoinOp.getConf());
        smbJop.setConf(smbJoinDesc);
        HashMap<Byte, String> tagToAlias = new HashMap<Byte, String>();
        for (int i = 0; i < srcs.length; ++i) {
            tagToAlias.put((byte)i, srcs[i]);
        }
        smbJoinDesc.setTagToAlias(tagToAlias);
        int indexInListMapJoinNoReducer = this.pGraphContext.getListMapJoinOpsNoReducer().indexOf(mapJoinOp);
        if (indexInListMapJoinNoReducer >= 0) {
            this.pGraphContext.getListMapJoinOpsNoReducer().remove(indexInListMapJoinNoReducer);
            this.pGraphContext.getListMapJoinOpsNoReducer().add(indexInListMapJoinNoReducer, smbJop);
        }
        HashMap<String, DummyStoreOperator> aliasToSink = new HashMap<String, DummyStoreOperator>();
        List<Operator<OperatorDesc>> parentOperators = mapJoinOp.getParentOperators();
        for (int i = 0; i < parentOperators.size(); ++i) {
            Operator<OperatorDesc> par = parentOperators.get(i);
            int index = par.getChildOperators().indexOf(mapJoinOp);
            par.getChildOperators().remove(index);
            if (i == smbJoinDesc.getPosBigTable()) {
                par.getChildOperators().add(index, smbJop);
                continue;
            }
            DummyStoreOperator dummyStoreOp = (DummyStoreOperator)OperatorFactory.get(par.getCompilationOpContext(), new DummyStoreDesc());
            par.getChildOperators().add(index, dummyStoreOp);
            ArrayList<Operator<? extends OperatorDesc>> childrenOps = new ArrayList<Operator<? extends OperatorDesc>>();
            childrenOps.add(smbJop);
            dummyStoreOp.setChildOperators(childrenOps);
            ArrayList<Operator<? extends OperatorDesc>> parentOps = new ArrayList<Operator<? extends OperatorDesc>>();
            parentOps.add(par);
            dummyStoreOp.setParentOperators(parentOps);
            aliasToSink.put(srcs[i], dummyStoreOp);
            smbJop.getParentOperators().remove(i);
            smbJop.getParentOperators().add(i, dummyStoreOp);
        }
        smbJoinDesc.setAliasToSink(aliasToSink);
        List<Operator<OperatorDesc>> childOps = mapJoinOp.getChildOperators();
        for (int i = 0; i < childOps.size(); ++i) {
            Operator<OperatorDesc> child = childOps.get(i);
            int index = child.getParentOperators().indexOf(mapJoinOp);
            child.getParentOperators().remove(index);
            child.getParentOperators().add(index, smbJop);
        }
        ((SMBJoinDesc)smbJop.getConf()).setQBJoinTreeProps((JoinDesc)mapJoinOp.getConf());
        this.pGraphContext.getSmbMapJoinOps().add(smbJop);
        this.pGraphContext.getMapJoinOps().remove(mapJoinOp);
        return smbJop;
    }

    private boolean isEligibleForBucketSortMergeJoin(SortBucketJoinProcCtx smbJoinContext, List<ExprNodeDesc> keys, Map<String, Operator<? extends OperatorDesc>> aliasToOpInfo, String[] aliases, int pos, List<Order> sortColumnsFirstTable) throws SemanticException {
        String alias = aliases[pos];
        Operator<? extends OperatorDesc> topOp = aliasToOpInfo.get(alias);
        if (topOp == null) {
            return false;
        }
        List<String> joinCols = AbstractSMBJoinProc.toColumns(keys);
        if (joinCols == null || joinCols.isEmpty()) {
            return false;
        }
        TableScanOperator tso = TableAccessAnalyzer.genRootTableScan(topOp, joinCols);
        if (tso == null) {
            return false;
        }
        if (this.pGraphContext.getTopOps().containsValue(tso)) {
            for (Map.Entry<String, TableScanOperator> topOpEntry : this.pGraphContext.getTopOps().entrySet()) {
                if (topOpEntry.getValue() != tso) continue;
                aliases[pos] = alias = topOpEntry.getKey();
                break;
            }
        } else {
            return false;
        }
        Table tbl = ((TableScanDesc)tso.getConf()).getTableMetadata();
        if (tbl.isPartitioned()) {
            PrunedPartitionList prunedParts = this.pGraphContext.getPrunedPartitions(alias, tso);
            List<Partition> partitions = prunedParts.getNotDeniedPartns();
            if (pos == 0 && partitions != null && !partitions.isEmpty()) {
                Partition firstPartition = partitions.get(0);
                sortColumnsFirstTable.addAll(firstPartition.getSortCols());
            }
            for (Partition partition : prunedParts.getNotDeniedPartns()) {
                if (this.checkSortColsAndJoinCols(partition.getSortCols(), joinCols, sortColumnsFirstTable)) continue;
                return false;
            }
            return true;
        }
        if (pos == 0) {
            sortColumnsFirstTable.addAll(tbl.getSortCols());
        }
        return this.checkSortColsAndJoinCols(tbl.getSortCols(), joinCols, sortColumnsFirstTable);
    }

    private boolean checkSortColsAndJoinCols(List<Order> sortCols, List<String> joinCols, List<Order> sortColumnsFirstPartition) {
        if (sortCols == null || sortCols.size() < joinCols.size()) {
            return false;
        }
        ArrayList<String> sortColNames = new ArrayList<String>();
        for (int pos = 0; pos < sortCols.size(); ++pos) {
            Order o = sortCols.get(pos);
            if (pos < sortColumnsFirstPartition.size() && o.getOrder() != sortColumnsFirstPartition.get(pos).getOrder()) {
                return false;
            }
            sortColNames.add(o.getCol());
        }
        return sortColNames.subList(0, joinCols.size()).containsAll(joinCols);
    }

    protected boolean checkConvertJoinToSMBJoin(JoinOperator joinOperator, SortBucketJoinProcCtx smbJoinContext) throws SemanticException {
        if (!this.pGraphContext.getJoinOps().contains(joinOperator)) {
            return false;
        }
        String[] srcs = ((JoinDesc)joinOperator.getConf()).getBaseSrc();
        ArrayList<Order> sortColumnsFirstTable = new ArrayList<Order>();
        for (int pos = 0; pos < srcs.length; ++pos) {
            if (this.isEligibleForBucketSortMergeJoin(smbJoinContext, smbJoinContext.getKeyExprMap().get((byte)pos), ((JoinDesc)joinOperator.getConf()).getAliasToOpInfo(), srcs, pos, sortColumnsFirstTable)) continue;
            return false;
        }
        smbJoinContext.setSrcs(srcs);
        return true;
    }

    protected boolean canConvertJoinToSMBJoin(JoinOperator joinOperator, SortBucketJoinProcCtx smbJoinContext) throws SemanticException {
        boolean canConvert = this.canConvertJoinToBucketMapJoin(joinOperator, smbJoinContext);
        if (!canConvert) {
            return false;
        }
        return this.checkConvertJoinToSMBJoin(joinOperator, smbJoinContext);
    }

    protected boolean canConvertJoinToBucketMapJoin(JoinOperator joinOp, SortBucketJoinProcCtx context) throws SemanticException {
        if (context.getRejectedJoinOps().contains(joinOp)) {
            return false;
        }
        if (!this.pGraphContext.getJoinOps().contains(joinOp)) {
            return false;
        }
        Class bigTableMatcherClass = null;
        try {
            String selector = HiveConf.getVar((Configuration)this.pGraphContext.getConf(), (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_AUTO_SORTMERGE_JOIN_BIGTABLE_SELECTOR);
            bigTableMatcherClass = JavaUtils.loadClass((String)selector);
        }
        catch (ClassNotFoundException e) {
            throw new SemanticException(e.getMessage());
        }
        BigTableSelectorForAutoSMJ bigTableMatcher = (BigTableSelectorForAutoSMJ)ReflectionUtils.newInstance((Class)bigTableMatcherClass, null);
        JoinDesc joinDesc = (JoinDesc)joinOp.getConf();
        JoinCondDesc[] joinCondns = joinDesc.getConds();
        Set<Integer> joinCandidates = MapJoinProcessor.getBigTableCandidates(joinCondns);
        if (joinCandidates.isEmpty()) {
            return false;
        }
        int bigTablePosition = bigTableMatcher.getBigTablePosition(this.pGraphContext, joinOp, joinCandidates);
        if (bigTablePosition < 0) {
            return false;
        }
        context.setBigTablePosition(bigTablePosition);
        String joinAlias = bigTablePosition == 0 ? ((JoinDesc)joinOp.getConf()).getLeftAlias() : ((JoinDesc)joinOp.getConf()).getRightAliases()[bigTablePosition - 1];
        joinAlias = QB.getAppendedAliasFromId(((JoinDesc)joinOp.getConf()).getId(), joinAlias);
        HashMap<Byte, List<ExprNodeDesc>> keyExprMap = new HashMap<Byte, List<ExprNodeDesc>>();
        List<Operator<OperatorDesc>> parentOps = joinOp.getParentOperators();
        for (Operator<OperatorDesc> parentOp : parentOps) {
            ReduceSinkDesc rsconf = (ReduceSinkDesc)((ReduceSinkOperator)parentOp).getConf();
            Byte tag = (byte)rsconf.getTag();
            List<ExprNodeDesc> keys = rsconf.getKeyCols();
            keyExprMap.put(tag, keys);
        }
        context.setKeyExprMap(keyExprMap);
        String[] joinSrcs = ((JoinDesc)joinOp.getConf()).getBaseSrc();
        String[] srcs = new String[joinSrcs.length];
        for (int srcPos = 0; srcPos < joinSrcs.length; ++srcPos) {
            joinSrcs[srcPos] = QB.getAppendedAliasFromId(((JoinDesc)joinOp.getConf()).getId(), joinSrcs[srcPos]);
            srcs[srcPos] = new String(joinSrcs[srcPos]);
        }
        return this.checkConvertBucketMapJoin(context, ((JoinDesc)joinOp.getConf()).getAliasToOpInfo(), keyExprMap, joinAlias, Arrays.asList(srcs));
    }

    protected MapJoinOperator convertJoinToBucketMapJoin(JoinOperator joinOp, SortBucketJoinProcCtx joinContext) throws SemanticException {
        MapJoinOperator mapJoinOp = new MapJoinProcessor().convertMapJoin(this.pGraphContext.getConf(), joinOp, ((JoinDesc)joinOp.getConf()).isLeftInputJoin(), ((JoinDesc)joinOp.getConf()).getBaseSrc(), ((JoinDesc)joinOp.getConf()).getMapAliases(), joinContext.getBigTablePosition(), false, false);
        if (mapJoinOp == null) {
            return null;
        }
        ((MapJoinDesc)mapJoinOp.getConf()).setQBJoinTreeProps((JoinDesc)joinOp.getConf());
        this.pGraphContext.getMapJoinOps().add(mapJoinOp);
        this.pGraphContext.getJoinOps().remove(joinOp);
        this.convertMapJoinToBucketMapJoin(mapJoinOp, joinContext);
        return mapJoinOp;
    }

    protected void convertJoinToSMBJoin(JoinOperator joinOp, SortBucketJoinProcCtx smbJoinContext) throws SemanticException {
        MapJoinOperator mapJoinOp = this.convertJoinToBucketMapJoin(joinOp, smbJoinContext);
        SMBMapJoinOperator smbMapJoinOp = this.convertBucketMapJoinToSMBJoin(mapJoinOp, smbJoinContext);
        smbMapJoinOp.setConvertedAutomaticallySMBJoin(true);
    }
}

