/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.hadoop.hive.ql.metadata.HiveRelOptMaterialization;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.optimizer.calcite.rules.views.HiveMaterializedViewUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MaterializedViewsCache {
    private static final Logger LOG = LoggerFactory.getLogger(MaterializedViewsCache.class);
    private final ConcurrentMap<String, ConcurrentMap<String, HiveRelOptMaterialization>> materializedViews = new ConcurrentHashMap<String, ConcurrentMap<String, HiveRelOptMaterialization>>();
    private final Map<String, List<HiveRelOptMaterialization>> sqlToMaterializedView = new ConcurrentHashMap<String, List<HiveRelOptMaterialization>>();

    public void putIfAbsent(Table materializedViewTable, HiveRelOptMaterialization materialization) {
        ConcurrentMap<String, HiveRelOptMaterialization> dbMap = this.ensureDbMap(materializedViewTable);
        dbMap.compute(materializedViewTable.getTableName(), (mvTableName, aMaterialization) -> {
            List materializationList = this.sqlToMaterializedView.computeIfAbsent(materializedViewTable.getViewExpandedText(), s -> new ArrayList());
            materializationList.add(materialization);
            return materialization;
        });
        LOG.debug("Materialized view {}.{} added to registry", (Object)materializedViewTable.getDbName(), (Object)materializedViewTable.getTableName());
    }

    private ConcurrentMap<String, HiveRelOptMaterialization> ensureDbMap(Table materializedViewTable) {
        ConcurrentMap<String, HiveRelOptMaterialization> dbMap = new ConcurrentHashMap<String, HiveRelOptMaterialization>();
        ConcurrentMap prevDbMap = this.materializedViews.putIfAbsent(materializedViewTable.getDbName(), dbMap);
        if (prevDbMap != null) {
            dbMap = prevDbMap;
        }
        return dbMap;
    }

    public void refresh(Table oldMaterializedViewTable, Table materializedViewTable, HiveRelOptMaterialization newMaterialization) {
        ConcurrentMap<String, HiveRelOptMaterialization> dbMap = this.ensureDbMap(materializedViewTable);
        dbMap.compute(materializedViewTable.getTableName(), (mvTableName, existingMaterialization) -> {
            List optMaterializationList = this.sqlToMaterializedView.computeIfAbsent(materializedViewTable.getViewExpandedText(), s -> new ArrayList());
            if (existingMaterialization == null) {
                optMaterializationList.add(newMaterialization);
                return newMaterialization;
            }
            Table existingMaterializedViewTable = HiveMaterializedViewUtils.extractTable(existingMaterialization);
            if (existingMaterializedViewTable.equals(oldMaterializedViewTable)) {
                optMaterializationList.remove(existingMaterialization);
                optMaterializationList.add(newMaterialization);
                return newMaterialization;
            }
            return existingMaterialization;
        });
        LOG.debug("Refreshed materialized view {}.{} -> {}.{}", new Object[]{oldMaterializedViewTable.getDbName(), oldMaterializedViewTable.getTableName(), materializedViewTable.getDbName(), materializedViewTable.getTableName()});
    }

    public void remove(Table materializedViewTable) {
        ConcurrentMap dbMap = (ConcurrentMap)this.materializedViews.get(materializedViewTable.getDbName());
        if (dbMap != null) {
            dbMap.computeIfPresent(materializedViewTable.getTableName(), (mvTableName, oldMaterialization) -> {
                if (HiveMaterializedViewUtils.extractTable(oldMaterialization).equals(materializedViewTable)) {
                    List<HiveRelOptMaterialization> materializationList = this.sqlToMaterializedView.get(materializedViewTable.getViewExpandedText());
                    materializationList.remove(oldMaterialization);
                    return null;
                }
                return oldMaterialization;
            });
        }
        LOG.debug("Materialized view {}.{} removed from registry", (Object)materializedViewTable.getDbName(), (Object)materializedViewTable.getTableName());
    }

    public void remove(String dbName, String tableName) {
        ConcurrentMap dbMap = (ConcurrentMap)this.materializedViews.get(dbName);
        if (dbMap != null) {
            dbMap.computeIfPresent(tableName, (mvTableName, materialization) -> {
                String queryText = HiveMaterializedViewUtils.extractTable(materialization).getViewExpandedText();
                List<HiveRelOptMaterialization> materializationList = this.sqlToMaterializedView.get(queryText);
                materializationList.remove(materialization);
                return null;
            });
            LOG.debug("Materialized view {}.{} removed from registry", (Object)dbName, (Object)tableName);
        }
    }

    public List<HiveRelOptMaterialization> values() {
        ArrayList result = new ArrayList();
        this.materializedViews.forEach((dbName, mvs) -> result.addAll(mvs.values()));
        return Collections.unmodifiableList(result);
    }

    HiveRelOptMaterialization get(String dbName, String viewName) {
        if (this.materializedViews.get(dbName) != null) {
            LOG.debug("Found materialized view {}.{} in registry", (Object)dbName, (Object)viewName);
            return (HiveRelOptMaterialization)((Object)((ConcurrentMap)this.materializedViews.get(dbName)).get(viewName));
        }
        LOG.debug("Materialized view {}.{} not found in registry", (Object)dbName, (Object)viewName);
        return null;
    }

    public List<HiveRelOptMaterialization> get(String querySql) {
        List<HiveRelOptMaterialization> relOptMaterializationList = this.sqlToMaterializedView.get(querySql);
        if (relOptMaterializationList == null) {
            LOG.trace("No materialized view with query text '{}' found in registry.", (Object)querySql);
            LOG.debug("No materialized view with similar query text found in registry.");
            return Collections.emptyList();
        }
        LOG.trace("{} materialized view(s) found with query text '{}' in registry", (Object)relOptMaterializationList.size(), (Object)querySql);
        LOG.debug("{} materialized view(s) found with similar query text found in registry", (Object)relOptMaterializationList.size());
        return Collections.unmodifiableList(relOptMaterializationList);
    }
}

