/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.lock;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import org.apache.hadoop.hive.ql.ErrorMsg;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CompileLock
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(CompileLock.class);
    private static final String LOCK_ACQUIRED_MSG = "Acquired the compile lock.";
    private static final String WAIT_LOCK_ACQUIRE_MSG = "Waiting to acquire compile lock: ";
    private final Lock underlying;
    private final long defaultTimeout;
    private final String command;
    private boolean isLocked = false;

    CompileLock(Lock underlying, long timeout, String command) {
        this.underlying = underlying;
        this.command = command;
        this.defaultTimeout = timeout;
    }

    public boolean tryAcquire() {
        return this.tryAcquire(this.defaultTimeout, TimeUnit.SECONDS);
    }

    private boolean tryAcquire(long timeout, TimeUnit unit) {
        block10: {
            try {
                if (this.underlying.tryLock(0L, unit)) {
                    LOG.debug(LOCK_ACQUIRED_MSG);
                    return this.aquired();
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Interrupted Exception ignored", (Throwable)e);
                }
                return this.failedToAquire();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug(WAIT_LOCK_ACQUIRE_MSG + this.command);
            }
            if (timeout > 0L) {
                try {
                    if (!this.underlying.tryLock(timeout, unit)) {
                        LOG.error(ErrorMsg.COMPILE_LOCK_TIMED_OUT.getErrorCodedMsg() + ": " + this.command);
                        return this.failedToAquire();
                    }
                    break block10;
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Interrupted Exception ignored", (Throwable)e);
                    }
                    return this.failedToAquire();
                }
            }
            this.underlying.lock();
        }
        LOG.debug(LOCK_ACQUIRED_MSG);
        return this.aquired();
    }

    private boolean aquired() {
        return this.locked(true);
    }

    private boolean failedToAquire() {
        return this.locked(false);
    }

    private boolean locked(boolean isLocked) {
        this.isLocked = isLocked;
        return isLocked;
    }

    public void release() {
        this.underlying.unlock();
        this.isLocked = false;
    }

    @Override
    public void close() {
        if (this.isLocked) {
            this.release();
        }
    }
}

