/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.parquet.serde.primitive;

import java.nio.charset.CharacterCodingException;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.hive.serde2.io.DoubleWritable;
import org.apache.hadoop.hive.serde2.io.HiveDecimalWritable;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.JavaStringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableStringObjectInspector;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;

public class ParquetStringInspector
extends JavaStringObjectInspector
implements SettableStringObjectInspector {
    ParquetStringInspector() {
    }

    public Text getPrimitiveWritableObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BytesWritable) {
            return new Text(((BytesWritable)o).getBytes());
        }
        if (o instanceof Text) {
            return (Text)o;
        }
        if (o instanceof String) {
            return new Text((String)o);
        }
        if (o instanceof TimestampWritableV2 || o instanceof HiveDecimalWritable || o instanceof DoubleWritable || o instanceof FloatWritable || o instanceof LongWritable || o instanceof IntWritable || o instanceof BooleanWritable) {
            return new Text(o.toString());
        }
        throw new UnsupportedOperationException("Cannot inspect " + o.getClass().getCanonicalName());
    }

    public String getPrimitiveJavaObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof BytesWritable) {
            try {
                return Text.decode((byte[])((BytesWritable)o).getBytes());
            }
            catch (CharacterCodingException e) {
                throw new RuntimeException("Failed to decode string", e);
            }
        }
        if (o instanceof Text) {
            return ((Text)o).toString();
        }
        if (o instanceof String) {
            return (String)o;
        }
        if (o instanceof TimestampWritableV2 || o instanceof HiveDecimalWritable || o instanceof DoubleWritable || o instanceof FloatWritable || o instanceof LongWritable || o instanceof IntWritable || o instanceof BooleanWritable) {
            return o.toString();
        }
        throw new UnsupportedOperationException("Cannot inspect " + o.getClass().getCanonicalName());
    }

    public Object set(Object o, Text text) {
        return new BytesWritable(text == null ? null : text.getBytes());
    }

    public Object set(Object o, String string) {
        return new BytesWritable(string == null ? null : string.getBytes(StandardCharsets.UTF_8));
    }

    public Object create(Text text) {
        if (text == null) {
            return null;
        }
        return text.toString();
    }

    public Object create(String string) {
        return string;
    }
}

