/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.orc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.io.orc.OrcStruct;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeSpec;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.Writable;

@SerDeSpec(schemaProps={"columns", "columns.types", "orc.compress"})
public class OrcSerde
extends AbstractSerDe {
    private final OrcSerdeRow row = new OrcSerdeRow();
    private ObjectInspector inspector = null;
    static final String COMPRESSION = "orc.compress";

    public void initialize(Configuration configuration, Properties tableProperties, Properties partitionProperties) throws SerDeException {
        super.initialize(configuration, tableProperties, partitionProperties);
        StructTypeInfo rootType = new StructTypeInfo();
        rootType.setAllStructFieldNames(this.getColumnNames());
        rootType.setAllStructFieldTypeInfos(this.getColumnTypes());
        this.inspector = OrcStruct.createObjectInspector((TypeInfo)rootType);
    }

    protected List<TypeInfo> parseColumnTypes() {
        List fieldTypes = super.parseColumnTypes();
        if (fieldTypes.isEmpty()) {
            return Collections.nCopies(this.getColumnNames().size(), TypeInfoFactory.stringTypeInfo);
        }
        return fieldTypes;
    }

    public Class<? extends Writable> getSerializedClass() {
        return OrcSerdeRow.class;
    }

    public Writable serialize(Object realRow, ObjectInspector inspector) {
        this.row.realRow = realRow;
        this.row.inspector = inspector;
        return this.row;
    }

    public Object deserialize(Writable writable) throws SerDeException {
        return writable;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.inspector;
    }

    final class OrcSerdeRow
    implements Writable {
        Object realRow;
        ObjectInspector inspector;

        OrcSerdeRow() {
        }

        public void write(DataOutput dataOutput) throws IOException {
            throw new UnsupportedOperationException("can't write the bundle");
        }

        public void readFields(DataInput dataInput) throws IOException {
            throw new UnsupportedOperationException("can't read the bundle");
        }

        ObjectInspector getInspector() {
            return this.inspector;
        }

        Object getRow() {
            return this.realRow;
        }
    }
}

