/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io.arrow;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.vector.types.TimeUnit;
import org.apache.arrow.vector.types.Types;
import org.apache.arrow.vector.types.pojo.ArrowType;
import org.apache.arrow.vector.types.pojo.Field;
import org.apache.arrow.vector.types.pojo.FieldType;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ListColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.MapColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.StructColumnVector;
import org.apache.hadoop.hive.ql.io.arrow.ArrowWrapperWritable;
import org.apache.hadoop.hive.ql.io.arrow.Deserializer;
import org.apache.hadoop.hive.ql.io.arrow.RootAllocatorFactory;
import org.apache.hadoop.hive.ql.io.arrow.Serializer;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.DecimalTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TimestampLocalTZTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.hive.serde2.typeinfo.UnionTypeInfo;
import org.apache.hadoop.io.Writable;

public class ArrowColumnarBatchSerDe
extends AbstractSerDe {
    private static final String DEFAULT_ARROW_FIELD_NAME = "[DEFAULT]";
    static final int MILLIS_PER_SECOND = 1000;
    static final int MICROS_PER_SECOND = 1000000;
    static final int NS_PER_SECOND = 1000000000;
    static final int NS_PER_MILLIS = 1000000;
    static final int NS_PER_MICROS = 1000;
    static final int MICROS_PER_MILLIS = 1000;
    static final int SECOND_PER_DAY = 86400;
    BufferAllocator rootAllocator;
    StructTypeInfo rowTypeInfo;
    StructObjectInspector rowObjectInspector;
    @VisibleForTesting
    Serializer serializer;
    private Deserializer deserializer;

    public void initialize(Configuration configuration, Properties tableProperties, Properties partitionProperties) throws SerDeException {
        super.initialize(configuration, tableProperties, partitionProperties);
        this.rowTypeInfo = (StructTypeInfo)TypeInfoFactory.getStructTypeInfo((List)this.getColumnNames(), (List)this.getColumnTypes());
        this.rowObjectInspector = (StructObjectInspector)TypeInfoUtils.getStandardWritableObjectInspectorFromTypeInfo((TypeInfo)this.rowTypeInfo);
        ArrayList<Field> fields = new ArrayList<Field>();
        int size = this.getColumnNames().size();
        for (int i = 0; i < size; ++i) {
            fields.add(ArrowColumnarBatchSerDe.toField((String)this.getColumnNames().get(i), (TypeInfo)this.getColumnTypes().get(i)));
        }
    }

    private static Field toField(String name, TypeInfo typeInfo) {
        switch (typeInfo.getCategory()) {
            case PRIMITIVE: {
                PrimitiveTypeInfo primitiveTypeInfo = (PrimitiveTypeInfo)typeInfo;
                switch (primitiveTypeInfo.getPrimitiveCategory()) {
                    case BOOLEAN: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.BIT.getType());
                    }
                    case BYTE: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.TINYINT.getType());
                    }
                    case SHORT: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.SMALLINT.getType());
                    }
                    case INT: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.INT.getType());
                    }
                    case LONG: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.BIGINT.getType());
                    }
                    case FLOAT: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.FLOAT4.getType());
                    }
                    case DOUBLE: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.FLOAT8.getType());
                    }
                    case STRING: 
                    case VARCHAR: 
                    case CHAR: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.VARCHAR.getType());
                    }
                    case DATE: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.DATEDAY.getType());
                    }
                    case TIMESTAMP: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.TIMESTAMPMILLI.getType());
                    }
                    case TIMESTAMPLOCALTZ: {
                        TimestampLocalTZTypeInfo timestampLocalTZTypeInfo = (TimestampLocalTZTypeInfo)typeInfo;
                        String timeZone = timestampLocalTZTypeInfo.getTimeZone().toString();
                        return Field.nullable((String)name, (ArrowType)new ArrowType.Timestamp(TimeUnit.MILLISECOND, timeZone));
                    }
                    case BINARY: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.VARBINARY.getType());
                    }
                    case DECIMAL: {
                        DecimalTypeInfo decimalTypeInfo = (DecimalTypeInfo)typeInfo;
                        int precision = decimalTypeInfo.precision();
                        int scale = decimalTypeInfo.scale();
                        return Field.nullable((String)name, (ArrowType)new ArrowType.Decimal(precision, scale));
                    }
                    case INTERVAL_YEAR_MONTH: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.INTERVALYEAR.getType());
                    }
                    case INTERVAL_DAY_TIME: {
                        return Field.nullable((String)name, (ArrowType)Types.MinorType.INTERVALDAY.getType());
                    }
                }
                throw new IllegalArgumentException();
            }
            case LIST: {
                ListTypeInfo listTypeInfo = (ListTypeInfo)typeInfo;
                TypeInfo elementTypeInfo = listTypeInfo.getListElementTypeInfo();
                return new Field(name, FieldType.nullable((ArrowType)Types.MinorType.LIST.getType()), (List)Lists.newArrayList((Object[])new Field[]{ArrowColumnarBatchSerDe.toField(DEFAULT_ARROW_FIELD_NAME, elementTypeInfo)}));
            }
            case STRUCT: {
                StructTypeInfo structTypeInfo = (StructTypeInfo)typeInfo;
                List fieldTypeInfos = structTypeInfo.getAllStructFieldTypeInfos();
                List fieldNames = structTypeInfo.getAllStructFieldNames();
                ArrayList structFields = Lists.newArrayList();
                int structSize = fieldNames.size();
                for (int i = 0; i < structSize; ++i) {
                    structFields.add(ArrowColumnarBatchSerDe.toField((String)fieldNames.get(i), (TypeInfo)fieldTypeInfos.get(i)));
                }
                return new Field(name, FieldType.nullable((ArrowType)Types.MinorType.STRUCT.getType()), (List)structFields);
            }
            case UNION: {
                UnionTypeInfo unionTypeInfo = (UnionTypeInfo)typeInfo;
                List objectTypeInfos = unionTypeInfo.getAllUnionObjectTypeInfos();
                ArrayList unionFields = Lists.newArrayList();
                int unionSize = unionFields.size();
                for (int i = 0; i < unionSize; ++i) {
                    unionFields.add(ArrowColumnarBatchSerDe.toField(DEFAULT_ARROW_FIELD_NAME, (TypeInfo)objectTypeInfos.get(i)));
                }
                return new Field(name, FieldType.nullable((ArrowType)Types.MinorType.UNION.getType()), (List)unionFields);
            }
            case MAP: {
                MapTypeInfo mapTypeInfo = (MapTypeInfo)typeInfo;
                TypeInfo keyTypeInfo = mapTypeInfo.getMapKeyTypeInfo();
                TypeInfo valueTypeInfo = mapTypeInfo.getMapValueTypeInfo();
                StructTypeInfo mapStructTypeInfo = new StructTypeInfo();
                mapStructTypeInfo.setAllStructFieldNames((List)Lists.newArrayList((Object[])new String[]{"keys", "values"}));
                mapStructTypeInfo.setAllStructFieldTypeInfos((List)Lists.newArrayList((Object[])new TypeInfo[]{keyTypeInfo, valueTypeInfo}));
                ListTypeInfo mapListStructTypeInfo = new ListTypeInfo();
                mapListStructTypeInfo.setListElementTypeInfo((TypeInfo)mapStructTypeInfo);
                return ArrowColumnarBatchSerDe.toField(name, (TypeInfo)mapListStructTypeInfo);
            }
        }
        throw new IllegalArgumentException();
    }

    static ListTypeInfo toStructListTypeInfo(MapTypeInfo mapTypeInfo) {
        StructTypeInfo structTypeInfo = new StructTypeInfo();
        structTypeInfo.setAllStructFieldNames((List)Lists.newArrayList((Object[])new String[]{"keys", "values"}));
        structTypeInfo.setAllStructFieldTypeInfos((List)Lists.newArrayList((Object[])new TypeInfo[]{mapTypeInfo.getMapKeyTypeInfo(), mapTypeInfo.getMapValueTypeInfo()}));
        ListTypeInfo structListTypeInfo = new ListTypeInfo();
        structListTypeInfo.setListElementTypeInfo((TypeInfo)structTypeInfo);
        return structListTypeInfo;
    }

    static ListColumnVector toStructListVector(MapColumnVector mapVector) {
        StructColumnVector structVector = new StructColumnVector();
        structVector.fields = new ColumnVector[]{mapVector.keys, mapVector.values};
        ListColumnVector structListVector = new ListColumnVector();
        structListVector.child = structVector;
        structListVector.childCount = mapVector.childCount;
        structListVector.isRepeating = mapVector.isRepeating;
        structListVector.noNulls = mapVector.noNulls;
        System.arraycopy(mapVector.offsets, 0, structListVector.offsets, 0, mapVector.childCount);
        System.arraycopy(mapVector.lengths, 0, structListVector.lengths, 0, mapVector.childCount);
        return structListVector;
    }

    public Class<? extends Writable> getSerializedClass() {
        return ArrowWrapperWritable.class;
    }

    public ArrowWrapperWritable serialize(Object obj, ObjectInspector objInspector) {
        if (this.serializer == null) {
            try {
                this.rootAllocator = RootAllocatorFactory.INSTANCE.getRootAllocator((Configuration)this.configuration.get());
                this.serializer = new Serializer(this);
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to initialize serializer for ArrowColumnarBatchSerDe", e);
            }
        }
        return this.serializer.serialize(obj, objInspector);
    }

    public Object deserialize(Writable writable) {
        if (this.deserializer == null) {
            try {
                this.rootAllocator = RootAllocatorFactory.INSTANCE.getRootAllocator((Configuration)this.configuration.get());
                this.deserializer = new Deserializer(this);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return this.deserializer.deserialize(writable);
    }

    public ObjectInspector getObjectInspector() {
        return this.rowObjectInspector;
    }
}

