/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveInputFormat;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.LineRecordReader;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RecordReaderWrapper
extends LineRecordReader {
    private static final Method isCompressedMethod;
    private transient boolean initialized = false;
    protected final JobConf jobConf;
    protected final int skipHeaderCnt;
    protected final int skipFooterCnt;
    private List<Pair<WritableComparable, Writable>> footerBuffer;
    private int cur;
    private static final Logger LOG;

    static RecordReader create(InputFormat inputFormat, HiveInputFormat.HiveInputSplit split, TableDesc tableDesc, JobConf jobConf, Reporter reporter) throws IOException {
        int headerCount = Utilities.getHeaderCount(tableDesc);
        int footerCount = Utilities.getFooterCount(tableDesc, jobConf);
        RecordReader innerReader = inputFormat.getRecordReader(split.getInputSplit(), jobConf, reporter);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Using {} to read data with skip.header.line.count {} and skip.footer.line.count {}", new Object[]{innerReader.getClass().getSimpleName(), headerCount, footerCount});
        }
        if (innerReader instanceof LineRecordReader) {
            if (isCompressedMethod == null) {
                return innerReader;
            }
            Boolean isCompressed = null;
            try {
                isCompressed = (Boolean)isCompressedMethod.invoke((Object)innerReader, new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                LOG.error("Cannot check the reader for compression; offsets not supported", (Throwable)e);
                return innerReader;
            }
            if (isCompressed.booleanValue() && (headerCount > 0 || footerCount > 0)) {
                LOG.info("Reader is compressed; offsets not supported");
                return new RecordReaderWrapper(split, jobConf, headerCount, footerCount);
            }
        }
        return innerReader;
    }

    private RecordReaderWrapper(FileSplit split, JobConf jobConf, int headerCnt, int footerCnt) throws IOException {
        super((Configuration)jobConf, split);
        this.jobConf = jobConf;
        this.skipHeaderCnt = headerCnt;
        this.skipFooterCnt = footerCnt;
    }

    public synchronized boolean next(LongWritable key, Text value) throws IOException {
        try {
            boolean opNotEOF = true;
            if (!this.initialized) {
                opNotEOF = this.skipHeader(this.skipHeaderCnt, key, value);
                if (opNotEOF && this.skipFooterCnt > 0) {
                    opNotEOF = this.initializeBuffer(this.jobConf, this.skipFooterCnt, key, value);
                }
                this.initialized = true;
            }
            if (opNotEOF && this.footerBuffer == null) {
                opNotEOF = super.next(key, value);
            }
            if (opNotEOF && this.footerBuffer != null) {
                opNotEOF = this.updateBuffer(this.jobConf, (WritableComparable)key, (Writable)value);
            }
            return opNotEOF;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    private boolean skipHeader(int headerCount, LongWritable key, Text value) throws IOException {
        while (headerCount > 0) {
            if (!super.next(key, value)) {
                return false;
            }
            --headerCount;
        }
        return true;
    }

    public boolean initializeBuffer(JobConf job, int footerCount, LongWritable key, Text value) throws IOException {
        this.footerBuffer = new ArrayList<Pair<WritableComparable, Writable>>();
        while (this.footerBuffer.size() < footerCount) {
            boolean notEOF = super.next(key, value);
            if (!notEOF) {
                return false;
            }
            WritableComparable left = (WritableComparable)ReflectionUtils.copy((Configuration)job, (Object)key, null);
            Writable right = (Writable)ReflectionUtils.copy((Configuration)job, (Object)value, null);
            Pair tem = Pair.of((Object)left, (Object)right);
            this.footerBuffer.add((Pair<WritableComparable, Writable>)tem);
        }
        this.cur = 0;
        return true;
    }

    public boolean updateBuffer(JobConf job, WritableComparable key, Writable value) throws IOException {
        key = (WritableComparable)ReflectionUtils.copy((Configuration)job, (Object)this.footerBuffer.get(this.cur).getKey(), (Object)key);
        value = (Writable)ReflectionUtils.copy((Configuration)job, (Object)this.footerBuffer.get(this.cur).getValue(), (Object)value);
        boolean notEOF = super.next((LongWritable)this.footerBuffer.get(this.cur).getKey(), (Text)this.footerBuffer.get(this.cur).getValue());
        if (notEOF) {
            ++this.cur;
            this.cur %= this.footerBuffer.size();
        }
        return notEOF;
    }

    static {
        Method isCompressedMethodTmp;
        LOG = LoggerFactory.getLogger((String)RecordReaderWrapper.class.getName());
        try {
            isCompressedMethodTmp = LineRecordReader.class.getDeclaredMethod("isCompressedInput", new Class[0]);
            isCompressedMethodTmp.setAccessible(true);
        }
        catch (Throwable t) {
            isCompressedMethodTmp = null;
            LOG.warn("Cannot get LineRecordReader isCompressedInput method", t);
        }
        isCompressedMethod = isCompressedMethodTmp;
    }
}

