/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.SequenceFileInputFormat;

public class HiveSequenceFileInputFormat<K extends LongWritable, V extends BytesRefArrayWritable>
extends SequenceFileInputFormat<K, V> {
    private Set<FileStatus> fileStatuses = null;

    public HiveSequenceFileInputFormat() {
        this.setMinSplitSize(102400L);
    }

    public void setFiles(Set<FileStatus> fileStatuses) {
        this.fileStatuses = fileStatuses;
    }

    protected FileStatus[] listStatus(JobConf job) throws IOException {
        if (this.fileStatuses == null || this.fileStatuses.isEmpty()) {
            return super.listStatus(job);
        }
        FileStatus[] fsStatusArray = new FileStatus[this.fileStatuses.size()];
        return this.fileStatuses.toArray(fsStatusArray);
    }
}

