/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hadoop.hive.metastore.utils.FileUtils;
import org.apache.hadoop.hive.ql.io.AcidUtils;
import org.apache.hadoop.hive.ql.io.SyntheticFileId;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hive.common.util.Ref;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsUtils {
    private static final HadoopShims SHIMS = ShimLoader.getHadoopShims();
    private static final Logger LOG = LoggerFactory.getLogger(HdfsUtils.class);
    private static String HDFS_ID_PATH_PREFIX = "/.reserved/.inodes/";

    public static Object getFileId(FileSystem fileSystem, Path path, boolean allowSynthetic, boolean checkDefaultFs, boolean forceSyntheticIds) throws IOException {
        if (!forceSyntheticIds && fileSystem instanceof DistributedFileSystem) {
            Long result;
            DistributedFileSystem dfs = (DistributedFileSystem)fileSystem;
            if ((!checkDefaultFs || HdfsUtils.isDefaultFs(dfs)) && (result = Long.valueOf(SHIMS.getFileId((FileSystem)dfs, path.toUri().getPath()))) != null) {
                return result;
            }
        }
        if (!allowSynthetic) {
            LOG.warn("Cannot get unique file ID from " + fileSystem.getClass().getSimpleName() + "; returning null");
            return null;
        }
        FileStatus fs = fileSystem.getFileStatus(path);
        return new SyntheticFileId(path, fs.getLen(), fs.getModificationTime());
    }

    @VisibleForTesting
    public static long createTestFileId(String pathStr, FileStatus fs, boolean doLog, String fsName) {
        int nameHash = pathStr.hashCode();
        long fileSize = fs.getLen();
        long modTime = fs.getModificationTime();
        int fileSizeHash = (int)(fileSize ^ fileSize >>> 32);
        int modTimeHash = (int)(modTime ^ modTime >>> 32);
        int combinedHash = modTimeHash ^ fileSizeHash;
        long id = ((long)nameHash & 0xFFFFFFFFL) << 32 | (long)combinedHash & 0xFFFFFFFFL;
        if (doLog) {
            LOG.warn("Cannot get unique file ID from " + fsName + "; using " + id + " (" + pathStr + "," + nameHash + "," + fileSize + ")");
        }
        return id;
    }

    public static List<FileStatus> listLocatedFileStatus(FileSystem fs, Path path, PathFilter filter, boolean recursive) throws IOException {
        RemoteIterator itr = fs.listFiles(path, recursive);
        ArrayList<FileStatus> result = new ArrayList<FileStatus>();
        while (itr.hasNext()) {
            Path relativePath;
            FileStatus stat = (FileStatus)itr.next();
            if (!stat.getPath().toString().equals(path.toString()) && !FileUtils.RemoteIteratorWithFilter.HIDDEN_FILES_FULL_PATH_FILTER.accept(relativePath = new Path(stat.getPath().toString().replace(path.toString(), ""))) || filter != null && !filter.accept(stat.getPath())) continue;
            result.add(stat);
        }
        return result;
    }

    public static List<Path> listPath(FileSystem fs, Path path, PathFilter filter, boolean recursive) throws IOException {
        return HdfsUtils.listLocatedFileStatus(fs, path, filter, recursive).stream().map(FileStatus::getPath).collect(Collectors.toList());
    }

    public static Path getFileIdPath(Path path, long fileId) {
        return fileId > 0L ? new Path(HDFS_ID_PATH_PREFIX + fileId) : path;
    }

    public static boolean isDefaultFs(DistributedFileSystem fs) {
        URI uri = fs.getUri();
        String scheme = uri.getScheme();
        if (scheme == null) {
            return true;
        }
        URI defaultUri = FileSystem.getDefaultUri((Configuration)fs.getConf());
        if (!defaultUri.getScheme().equalsIgnoreCase(scheme)) {
            return false;
        }
        String defaultAuthority = defaultUri.getAuthority();
        String authority = uri.getAuthority();
        if (authority == null) {
            return true;
        }
        if (defaultAuthority == null) {
            return false;
        }
        if (!defaultUri.getHost().equalsIgnoreCase(uri.getHost())) {
            return false;
        }
        int defaultPort = defaultUri.getPort();
        int port = uri.getPort();
        if (port == -1) {
            return true;
        }
        return defaultPort == -1 ? port == 8020 : port == defaultPort;
    }

    public static boolean pathExists(Path p, Configuration conf) throws HiveException {
        try {
            FileSystem fs = p.getFileSystem(conf);
            return fs.exists(p);
        }
        catch (IOException e) {
            throw new HiveException((Throwable)e);
        }
    }

    public static List<HadoopShims.HdfsFileStatusWithId> listFileStatusWithId(FileSystem fs, Path dir, Ref<Boolean> useFileIds, boolean recursive, PathFilter filter) throws IOException {
        List<Object> originals = new ArrayList<HadoopShims.HdfsFileStatusWithId>();
        List<HadoopShims.HdfsFileStatusWithId> childrenWithId = HdfsUtils.tryListLocatedHdfsStatus(useFileIds, fs, dir, filter);
        if (childrenWithId != null) {
            for (HadoopShims.HdfsFileStatusWithId child : childrenWithId) {
                if (child.getFileStatus().isDirectory()) {
                    if (!recursive) continue;
                    originals.addAll(HdfsUtils.listFileStatusWithId(fs, child.getFileStatus().getPath(), useFileIds, true, filter));
                    continue;
                }
                if (child.getFileStatus().getLen() <= 0L) continue;
                originals.add(child);
            }
        } else {
            List<FileStatus> children = HdfsUtils.listLocatedFileStatus(fs, dir, filter, recursive);
            originals = children.stream().map(HdfsFileStatusWithoutId::new).collect(Collectors.toList());
        }
        return originals;
    }

    public static List<HadoopShims.HdfsFileStatusWithId> tryListLocatedHdfsStatus(Ref<Boolean> useFileIds, FileSystem fs, Path directory, PathFilter filter) {
        if (useFileIds == null) {
            return null;
        }
        if (filter == null) {
            filter = AcidUtils.hiddenFileFilter;
        }
        List childrenWithId = null;
        Boolean val = (Boolean)useFileIds.value;
        if (val == null || val.booleanValue()) {
            try {
                childrenWithId = SHIMS.listLocatedHdfsStatus(fs, directory, filter);
                if (val == null) {
                    useFileIds.value = true;
                }
            }
            catch (UnsupportedOperationException uoe) {
                LOG.info("Failed to get files with ID; using regular API: " + uoe.getMessage());
                if (val == null) {
                    useFileIds.value = false;
                }
            }
            catch (IOException ioe) {
                LOG.info("Failed to get files with ID; using regular API: " + ioe.getMessage());
                LOG.debug("Failed to get files with ID", (Throwable)ioe);
            }
        }
        return childrenWithId;
    }

    public static class HdfsFileStatusWithoutId
    implements HadoopShims.HdfsFileStatusWithId {
        private final FileStatus fs;

        public HdfsFileStatusWithoutId(FileStatus fs) {
            this.fs = fs;
        }

        public FileStatus getFileStatus() {
            return this.fs;
        }

        public Long getFileId() {
            return null;
        }
    }
}

