/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.lib.DefaultGraphWalker;
import org.apache.hadoop.hive.ql.lib.DefaultRuleDispatcher;
import org.apache.hadoop.hive.ql.lib.Node;
import org.apache.hadoop.hive.ql.lib.NodeProcessorCtx;
import org.apache.hadoop.hive.ql.lib.SemanticNodeProcessor;
import org.apache.hadoop.hive.ql.lib.SemanticRule;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.BaseWork;
import org.apache.hadoop.hive.ql.plan.MapWork;
import org.apache.hadoop.hive.ql.plan.MapredWork;
import org.apache.hadoop.hive.ql.plan.ReduceWork;
import org.apache.hadoop.hive.ql.plan.TezWork;

public class NoOperatorReuseCheckerHook
implements ExecuteWithHookContext {
    @Override
    public void run(HookContext hookContext) throws Exception {
        ArrayList rootOps = Lists.newArrayList();
        List<Task<?>> roots = hookContext.getQueryPlan().getRootTasks();
        for (Task<?> task : roots) {
            Object work = task.getWork();
            if (work instanceof MapredWork) {
                ReduceWork reduceWork;
                MapredWork mapredWork = (MapredWork)work;
                MapWork mapWork = mapredWork.getMapWork();
                if (mapWork != null) {
                    rootOps.addAll(mapWork.getAllRootOperators());
                }
                if ((reduceWork = mapredWork.getReduceWork()) != null) {
                    rootOps.addAll(reduceWork.getAllRootOperators());
                }
            }
            if (!(work instanceof TezWork)) continue;
            for (BaseWork bw : ((TezWork)work).getAllWorkUnsorted()) {
                rootOps.addAll(bw.getAllRootOperators());
            }
        }
        if (rootOps.isEmpty()) {
            return;
        }
        DefaultRuleDispatcher disp = new DefaultRuleDispatcher(new UniqueOpIdChecker(), new HashMap<SemanticRule, SemanticNodeProcessor>(), null);
        DefaultGraphWalker ogw = new DefaultGraphWalker(disp);
        HashMap<Node, Object> nodeOutput = new HashMap<Node, Object>();
        ogw.startWalking(rootOps, nodeOutput);
    }

    static class UniqueOpIdChecker
    implements SemanticNodeProcessor {
        Map<String, Operator<?>> opMap = new HashMap();

        UniqueOpIdChecker() {
        }

        @Override
        public Object process(Node nd, Stack<Node> stack, NodeProcessorCtx procCtx, Object ... nodeOutputs) throws SemanticException {
            Operator op = (Operator)nd;
            String opKey = op.getOperatorId();
            Operator<?> found = this.opMap.get(opKey);
            if (found != null) {
                throw new RuntimeException("operator id reuse found: " + opKey);
            }
            this.opMap.put(opKey, op);
            return null;
        }
    }
}

