/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.hooks;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.llap.registry.impl.LlapRegistryService;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.mr.ExecDriver;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.hooks.Entity;
import org.apache.hadoop.hive.ql.hooks.ExecuteWithHookContext;
import org.apache.hadoop.hive.ql.hooks.HiveHookEventProtoPartialBuilder;
import org.apache.hadoop.hive.ql.hooks.HookContext;
import org.apache.hadoop.hive.ql.hooks.proto.HiveHookEvents;
import org.apache.hadoop.hive.ql.parse.ExplainConfiguration;
import org.apache.hadoop.hive.ql.plan.ExplainWork;
import org.apache.hadoop.hive.ql.plan.HiveOperation;
import org.apache.hadoop.hive.ql.plan.TezWork;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.util.Clock;
import org.apache.hadoop.yarn.util.SystemClock;
import org.apache.hive.common.util.ShutdownHookManager;
import org.apache.tez.dag.history.logging.proto.DatePartitionedLogger;
import org.apache.tez.dag.history.logging.proto.ProtoMessageWriter;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveProtoLoggingHook
implements ExecuteWithHookContext {
    private static final Logger LOG = LoggerFactory.getLogger((String)HiveProtoLoggingHook.class.getName());
    private static final Set<String> includedOperationSet = Arrays.stream(new HiveOperation[]{HiveOperation.LOAD, HiveOperation.EXPORT, HiveOperation.IMPORT, HiveOperation.CREATEDATABASE, HiveOperation.DROPDATABASE, HiveOperation.DROPTABLE, HiveOperation.MSCK, HiveOperation.ALTERTABLE_ADDCOLS, HiveOperation.ALTERTABLE_REPLACECOLS, HiveOperation.ALTERTABLE_RENAMECOL, HiveOperation.ALTERTABLE_RENAMEPART, HiveOperation.ALTERTABLE_UPDATEPARTSTATS, HiveOperation.ALTERTABLE_UPDATETABLESTATS, HiveOperation.ALTERTABLE_RENAME, HiveOperation.ALTERTABLE_DROPPARTS, HiveOperation.ALTERTABLE_ADDPARTS, HiveOperation.ALTERTABLE_TOUCH, HiveOperation.ALTERTABLE_ARCHIVE, HiveOperation.ALTERTABLE_UNARCHIVE, HiveOperation.ALTERTABLE_PROPERTIES, HiveOperation.ALTERTABLE_SERIALIZER, HiveOperation.ALTERPARTITION_SERIALIZER, HiveOperation.ALTERTABLE_SERDEPROPERTIES, HiveOperation.ALTERPARTITION_SERDEPROPERTIES, HiveOperation.ALTERTABLE_CLUSTER_SORT, HiveOperation.ANALYZE_TABLE, HiveOperation.CACHE_METADATA, HiveOperation.ALTERTABLE_BUCKETNUM, HiveOperation.ALTERPARTITION_BUCKETNUM, HiveOperation.CREATEFUNCTION, HiveOperation.DROPFUNCTION, HiveOperation.RELOADFUNCTION, HiveOperation.CREATEMACRO, HiveOperation.DROPMACRO, HiveOperation.CREATEVIEW, HiveOperation.DROPVIEW, HiveOperation.ALTERVIEW_PROPERTIES, HiveOperation.LOCKTABLE, HiveOperation.UNLOCKTABLE, HiveOperation.CREATEROLE, HiveOperation.DROPROLE, HiveOperation.ALTERTABLE_FILEFORMAT, HiveOperation.ALTERPARTITION_FILEFORMAT, HiveOperation.ALTERTABLE_LOCATION, HiveOperation.ALTERPARTITION_LOCATION, HiveOperation.CREATETABLE, HiveOperation.TRUNCATETABLE, HiveOperation.CREATETABLE_AS_SELECT, HiveOperation.QUERY, HiveOperation.ALTERDATABASE, HiveOperation.ALTERDATABASE_OWNER, HiveOperation.ALTERTABLE_MERGEFILES, HiveOperation.ALTERPARTITION_MERGEFILES, HiveOperation.ALTERTABLE_SKEWED, HiveOperation.ALTERTBLPART_SKEWED_LOCATION, HiveOperation.ALTERTABLE_PARTCOLTYPE, HiveOperation.ALTERTABLE_EXCHANGEPARTITION, HiveOperation.ALTERTABLE_DROPCONSTRAINT, HiveOperation.ALTERTABLE_ADDCONSTRAINT, HiveOperation.ALTERVIEW_RENAME, HiveOperation.ALTERVIEW_AS, HiveOperation.ALTERTABLE_COMPACT, HiveOperation.KILL_QUERY}).map(HiveOperation::getOperationName).collect(Collectors.toSet());
    private static final int VERSION = 1;
    private static final int WAIT_TIME = 5;

    @Override
    public void run(HookContext hookContext) throws Exception {
        try {
            EventLogger logger = EventLogger.getInstance(hookContext.getConf());
            logger.handle(hookContext);
        }
        catch (Exception e) {
            LOG.error("Got exceptoin while processing event: ", (Throwable)e);
        }
    }

    static class EventLogger {
        private final Clock clock;
        private final String logFileName;
        private final DatePartitionedLogger<HiveHookEvents.HiveHookEventProto> logger;
        private final ScheduledThreadPoolExecutor logWriter;
        private final int queueCapacity;
        private int logFileCount = 0;
        private ProtoMessageWriter<HiveHookEvents.HiveHookEventProto> writer;
        private LocalDate writerDate;
        private boolean eventPerFile;
        private static final int MAX_RETRIES = 2;
        private static volatile EventLogger instance;

        EventLogger(HiveConf conf, Clock clock) {
            this.clock = clock;
            this.logFileName = "hive_" + UUID.randomUUID().toString();
            this.queueCapacity = conf.getInt(HiveConf.ConfVars.HIVE_PROTO_EVENTS_QUEUE_CAPACITY.varname, HiveConf.ConfVars.HIVE_PROTO_EVENTS_QUEUE_CAPACITY.defaultIntVal);
            String baseDir = conf.getVar(HiveConf.ConfVars.HIVE_PROTO_EVENTS_BASE_PATH);
            if (StringUtils.isBlank((CharSequence)baseDir)) {
                baseDir = null;
                LOG.error(HiveConf.ConfVars.HIVE_PROTO_EVENTS_BASE_PATH.varname + " is not set, logging disabled.");
            }
            this.eventPerFile = conf.getBoolVar(HiveConf.ConfVars.HIVE_PROTO_FILE_PER_EVENT);
            LOG.info("Event per file enabled: {}", (Object)this.eventPerFile);
            DatePartitionedLogger<HiveHookEvents.HiveHookEventProto> tmpLogger = null;
            try {
                if (baseDir != null) {
                    tmpLogger = new DatePartitionedLogger<HiveHookEvents.HiveHookEventProto>(HiveHookEvents.HiveHookEventProto.PARSER, new Path(baseDir), (Configuration)conf, clock);
                }
            }
            catch (IOException e) {
                LOG.error("Unable to intialize logger, logging disabled.", (Throwable)e);
            }
            this.logger = tmpLogger;
            if (this.logger == null) {
                this.logWriter = null;
                return;
            }
            ThreadFactory threadFactory = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("Hive Hook Proto Log Writer %d").build();
            this.logWriter = new ScheduledThreadPoolExecutor(1, threadFactory);
            long rolloverInterval = conf.getTimeVar(HiveConf.ConfVars.HIVE_PROTO_EVENTS_ROLLOVER_CHECK_INTERVAL, TimeUnit.MICROSECONDS);
            this.logWriter.scheduleWithFixedDelay(() -> this.handleTick(), rolloverInterval, rolloverInterval, TimeUnit.MICROSECONDS);
        }

        void shutdown() {
            if (this.logWriter != null) {
                this.logWriter.shutdown();
                try {
                    this.logWriter.awaitTermination(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    LOG.warn("Got interrupted exception while waiting for events to be flushed", (Throwable)e);
                }
            }
            IOUtils.closeQuietly(this.writer);
        }

        void handle(HookContext hookContext) {
            HiveHookEventProtoPartialBuilder event;
            if (this.logger == null) {
                return;
            }
            QueryPlan plan = hookContext.getQueryPlan();
            if (plan == null) {
                LOG.debug("Received null query plan.");
                return;
            }
            if (!includedOperationSet.contains(plan.getOperationName())) {
                LOG.debug("Not logging events of operation type : {}", (Object)plan.getOperationName());
                return;
            }
            switch (hookContext.getHookType()) {
                case PRE_EXEC_HOOK: {
                    event = this.getPreHookEvent(hookContext);
                    break;
                }
                case POST_EXEC_HOOK: {
                    event = this.getPostHookEvent(hookContext, true);
                    break;
                }
                case ON_FAILURE_HOOK: {
                    event = this.getPostHookEvent(hookContext, false);
                    break;
                }
                default: {
                    LOG.warn("Ignoring event of type: {}", (Object)hookContext.getHookType());
                    event = null;
                }
            }
            if (event != null) {
                try {
                    if (this.logWriter.getQueue().size() < this.queueCapacity) {
                        this.logWriter.execute(() -> this.writeEvent(event));
                    } else {
                        LOG.warn("Writer queue full ignoring event {} for query {}", (Object)hookContext.getHookType(), (Object)plan.getQueryId());
                    }
                }
                catch (RejectedExecutionException e) {
                    LOG.warn("Writer queue full ignoring event {} for query {}", (Object)hookContext.getHookType(), (Object)plan.getQueryId());
                }
            }
        }

        private void handleTick() {
            try {
                this.maybeRolloverWriterForDay();
            }
            catch (IOException e) {
                LOG.error("Got IOException while trying to rollover: ", (Throwable)e);
            }
        }

        private boolean maybeRolloverWriterForDay() throws IOException {
            if (this.writer == null || !this.logger.getNow().toLocalDate().equals(this.writerDate)) {
                if (this.writer != null) {
                    this.logFileCount = 0;
                    IOUtils.closeQuietly(this.writer);
                    this.writer = null;
                }
                this.writer = this.logger.getWriter(this.logFileName + "_" + ++this.logFileCount);
                this.writerDate = this.logger.getDateFromDir(this.writer.getPath().getParent().getName());
                return true;
            }
            return false;
        }

        private void writeEvent(HiveHookEventProtoPartialBuilder builder) {
            HiveHookEvents.HiveHookEventProto event = builder.build();
            for (int retryCount = 0; retryCount <= 2; ++retryCount) {
                try {
                    if (this.eventPerFile) {
                        if (!this.maybeRolloverWriterForDay()) {
                            this.writer = this.logger.getWriter(this.logFileName + "_" + ++this.logFileCount);
                        }
                        LOG.debug("Event per file enabled. New proto event file: {}", (Object)this.writer.getPath());
                        this.writer.writeProto(event);
                        IOUtils.closeQuietly(this.writer);
                        this.writer = null;
                    } else {
                        this.maybeRolloverWriterForDay();
                        this.writer.writeProto(event);
                        this.writer.hflush();
                    }
                    return;
                }
                catch (IOException e) {
                    IOUtils.closeQuietly(this.writer);
                    this.writer = null;
                    if (retryCount < 2) {
                        LOG.warn("Error writing proto message for query {}, eventType: {}, retryCount: {}, error: {} ", new Object[]{event.getHiveQueryId(), event.getEventType(), retryCount, e.getMessage()});
                        LOG.trace("Exception", (Throwable)e);
                    } else {
                        LOG.error("Error writing proto message for query {}, eventType: {}: ", new Object[]{event.getHiveQueryId(), event.getEventType(), e});
                    }
                    try {
                        Thread.sleep(1000 * retryCount * retryCount);
                    }
                    catch (InterruptedException e1) {
                        LOG.warn("Got interrupted in retry sleep.", (Throwable)e1);
                    }
                    continue;
                }
            }
        }

        private HiveHookEventProtoPartialBuilder getPreHookEvent(HookContext hookContext) {
            QueryPlan plan = hookContext.getQueryPlan();
            LOG.info("Received pre-hook notification for: " + plan.getQueryId());
            HiveConf conf = new HiveConf(hookContext.getConf());
            List<ExecDriver> mrTasks = Utilities.getMRTasks(plan.getRootTasks());
            List<TezTask> tezTasks = Utilities.getTezTasks(plan.getRootTasks());
            ExecutionMode executionMode = this.getExecutionMode(plan, mrTasks, tezTasks);
            HashMap<OtherInfoType, JSONObject> otherInfo = new HashMap<OtherInfoType, JSONObject>();
            HiveHookEvents.HiveHookEventProto.Builder builder = HiveHookEvents.HiveHookEventProto.newBuilder();
            builder.setEventType(EventType.QUERY_SUBMITTED.name());
            builder.setTimestamp(plan.getQueryStartTime());
            builder.setHiveQueryId(plan.getQueryId());
            builder.setUser(this.getUser(hookContext));
            builder.setRequestUser(this.getRequestUser(hookContext));
            String queueName = this.getQueueName(executionMode, conf);
            if (queueName != null) {
                builder.setQueue(queueName);
            }
            builder.setExecutionMode(executionMode.name());
            builder.addAllTablesRead(this.getTablesFromEntitySet(hookContext.getInputs()));
            builder.addAllTablesWritten(this.getTablesFromEntitySet(hookContext.getOutputs()));
            if (hookContext.getOperationId() != null) {
                builder.setOperationId(hookContext.getOperationId());
            }
            EventLogger.addMapEntry(builder, OtherInfoType.TEZ, Boolean.toString(tezTasks.size() > 0));
            EventLogger.addMapEntry(builder, OtherInfoType.MAPRED, Boolean.toString(mrTasks.size() > 0));
            EventLogger.addMapEntry(builder, OtherInfoType.SESSION_ID, hookContext.getSessionId());
            String logID = conf.getLogIdVar(hookContext.getSessionId());
            EventLogger.addMapEntry(builder, OtherInfoType.INVOKER_INFO, logID);
            EventLogger.addMapEntry(builder, OtherInfoType.THREAD_NAME, hookContext.getThreadId());
            EventLogger.addMapEntry(builder, OtherInfoType.VERSION, Integer.toString(1));
            EventLogger.addMapEntry(builder, OtherInfoType.CLIENT_IP_ADDRESS, hookContext.getIpAddress());
            String hiveInstanceAddress = hookContext.getHiveInstanceAddress();
            if (hiveInstanceAddress == null) {
                try {
                    hiveInstanceAddress = InetAddress.getLocalHost().getHostAddress();
                }
                catch (UnknownHostException e) {
                    LOG.error("Error tyring to get localhost address: ", (Throwable)e);
                }
            }
            EventLogger.addMapEntry(builder, OtherInfoType.HIVE_ADDRESS, hiveInstanceAddress);
            String hiveInstanceType = hookContext.isHiveServerQuery() ? "HS2" : "CLI";
            EventLogger.addMapEntry(builder, OtherInfoType.HIVE_INSTANCE_TYPE, hiveInstanceType);
            ApplicationId llapId = this.determineLlapId(conf, executionMode);
            if (llapId != null) {
                EventLogger.addMapEntry(builder, OtherInfoType.LLAP_APP_ID, llapId.toString());
            }
            conf.stripHiddenConfigurations((Configuration)conf);
            JSONObject confObj = new JSONObject();
            for (Map.Entry setting : conf) {
                confObj.put((String)setting.getKey(), setting.getValue());
            }
            otherInfo.put(OtherInfoType.CONF, confObj);
            ExplainConfiguration explainConfig = new ExplainConfiguration();
            explainConfig.setFormatted(true);
            ExplainWork explainWork = new ExplainWork(null, null, plan.getRootTasks(), plan.getFetchTask(), null, null, explainConfig, plan.getCboInfo(), plan.getOptimizedQueryString(), plan.getOptimizedCBOPlan());
            return new HiveHookEventProtoPartialBuilder(builder, explainWork, otherInfo, plan.getQueryStr(), conf.getVar(HiveConf.ConfVars.HIVESTAGEIDREARRANGE));
        }

        private HiveHookEventProtoPartialBuilder getPostHookEvent(HookContext hookContext, boolean success) {
            QueryPlan plan = hookContext.getQueryPlan();
            LOG.info("Received post-hook notification for: " + plan.getQueryId());
            HashMap<OtherInfoType, JSONObject> other = new HashMap<OtherInfoType, JSONObject>();
            HiveHookEvents.HiveHookEventProto.Builder builder = HiveHookEvents.HiveHookEventProto.newBuilder();
            builder.setEventType(EventType.QUERY_COMPLETED.name());
            builder.setTimestamp(this.clock.getTime());
            builder.setHiveQueryId(plan.getQueryId());
            builder.setUser(this.getUser(hookContext));
            builder.setRequestUser(this.getRequestUser(hookContext));
            if (hookContext.getOperationId() != null) {
                builder.setOperationId(hookContext.getOperationId());
            }
            EventLogger.addMapEntry(builder, OtherInfoType.STATUS, Boolean.toString(success));
            EventLogger.addMapEntry(builder, OtherInfoType.ERROR_MESSAGE, hookContext.getErrorMessage());
            JSONObject perfObj = new JSONObject();
            for (String key : hookContext.getPerfLogger().getEndTimes().keySet()) {
                perfObj.put(key, (Object)hookContext.getPerfLogger().getDuration(key));
            }
            other.put(OtherInfoType.PERF, perfObj);
            return new HiveHookEventProtoPartialBuilder(builder, null, other, plan.getQueryStr(), null);
        }

        public static void addMapEntry(HiveHookEvents.HiveHookEventProto.Builder builder, OtherInfoType key, String value) {
            if (value != null) {
                builder.addOtherInfo(HiveHookEvents.MapFieldEntry.newBuilder().setKey(key.name()).setValue(value).build());
            }
        }

        private String getUser(HookContext hookContext) {
            return hookContext.getUgi().getShortUserName();
        }

        private String getRequestUser(HookContext hookContext) {
            String requestuser = hookContext.getUserName();
            if (requestuser == null) {
                requestuser = hookContext.getUgi().getUserName();
            }
            return requestuser;
        }

        private String getQueueName(ExecutionMode mode, HiveConf conf) {
            switch (mode) {
                case LLAP: {
                    return conf.get(HiveConf.ConfVars.LLAP_DAEMON_QUEUE_NAME.varname);
                }
                case MR: {
                    return conf.get("mapreduce.job.queuename");
                }
                case TEZ: {
                    return conf.get("tez.queue.name");
                }
            }
            return null;
        }

        private List<String> getTablesFromEntitySet(Set<? extends Entity> entities) {
            ArrayList<String> tableNames = new ArrayList<String>();
            for (Entity entity : entities) {
                if (entity.getType() != Entity.Type.TABLE) continue;
                tableNames.add(entity.getTable().getDbName() + "." + entity.getTable().getTableName());
            }
            return tableNames;
        }

        private ExecutionMode getExecutionMode(QueryPlan plan, List<ExecDriver> mrTasks, List<TezTask> tezTasks) {
            if (tezTasks.size() > 0) {
                for (TezTask tezTask : tezTasks) {
                    if (!((TezWork)tezTask.getWork()).getLlapMode()) continue;
                    return ExecutionMode.LLAP;
                }
                return ExecutionMode.TEZ;
            }
            if (mrTasks.size() > 0) {
                return ExecutionMode.MR;
            }
            if (Utilities.getSparkTasks(plan.getRootTasks()).size() > 0) {
                return ExecutionMode.SPARK;
            }
            return ExecutionMode.NONE;
        }

        private ApplicationId determineLlapId(HiveConf conf, ExecutionMode mode) {
            if (mode == ExecutionMode.LLAP) {
                String hosts = HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.LLAP_DAEMON_SERVICE_HOSTS);
                if (hosts != null && !hosts.isEmpty()) {
                    try {
                        return LlapRegistryService.getClient((Configuration)conf).getApplicationId();
                    }
                    catch (IOException e) {
                        LOG.error("Error trying to get llap instance", (Throwable)e);
                    }
                } else {
                    LOG.info("Cannot determine LLAP instance on client - service hosts are not set");
                    return null;
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        static EventLogger getInstance(HiveConf conf) {
            if (instance != null) return instance;
            Class<EventLogger> clazz = EventLogger.class;
            synchronized (EventLogger.class) {
                if (instance != null) return instance;
                instance = new EventLogger(conf, (Clock)SystemClock.getInstance());
                ShutdownHookManager.addShutdownHook(instance::shutdown);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return instance;
            }
        }
    }

    public static enum ExecutionMode {
        MR,
        TEZ,
        LLAP,
        SPARK,
        NONE;

    }

    public static enum OtherInfoType {
        QUERY,
        STATUS,
        TEZ,
        MAPRED,
        INVOKER_INFO,
        SESSION_ID,
        THREAD_NAME,
        VERSION,
        CLIENT_IP_ADDRESS,
        HIVE_ADDRESS,
        HIVE_INSTANCE_TYPE,
        CONF,
        PERF,
        LLAP_APP_ID,
        ERROR_MESSAGE;

    }

    public static enum EventType {
        QUERY_SUBMITTED,
        QUERY_COMPLETED;

    }
}

