/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.history;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.mapred.Counters;

public interface HiveHistory {
    public String getHistFileName();

    public void startQuery(String var1, String var2);

    public void setQueryProperty(String var1, Keys var2, String var3);

    public void setTaskProperty(String var1, String var2, Keys var3, String var4);

    public void setTaskCounters(String var1, String var2, Counters var3);

    public void printRowCount(String var1);

    public void endQuery(String var1);

    public void startTask(String var1, Task<?> var2, String var3);

    public void endTask(String var1, Task<?> var2);

    public void progressTask(String var1, Task<?> var2);

    public void logPlanProgress(QueryPlan var1) throws IOException;

    public void setIdToTableMap(Map<String, String> var1);

    public void closeStream();

    public static class TaskInfo
    extends Info {
        public Map<String, String> hm = new HashMap<String, String>();
    }

    public static class QueryInfo
    extends Info {
        public Map<String, String> hm = new HashMap<String, String>();
        public Map<String, Long> rowCountMap = new HashMap<String, Long>();
    }

    public static class SessionInfo
    extends Info {
        public String sessionId;
    }

    public static class Info {
    }

    public static interface Listener {
        public void handle(RecordTypes var1, Map<String, String> var2) throws IOException;
    }

    public static enum Keys {
        SESSION_ID,
        QUERY_ID,
        TASK_ID,
        QUERY_RET_CODE,
        QUERY_NUM_TASKS,
        QUERY_STRING,
        TIME,
        TASK_RET_CODE,
        TASK_NAME,
        TASK_HADOOP_ID,
        TASK_HADOOP_PROGRESS,
        TASK_COUNTERS,
        TASK_NUM_MAPPERS,
        TASK_NUM_REDUCERS,
        ROWS_INSERTED,
        SPARK_JOB_HANDLE_ID,
        SPARK_JOB_ID;

    }

    public static enum RecordTypes {
        QueryStart,
        QueryEnd,
        TaskStart,
        TaskEnd,
        TaskProgress,
        SessionStart,
        SessionEnd,
        Counters;

    }
}

