/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.wrapper;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.expressions.StringExpr;
import org.apache.hadoop.hive.ql.exec.vector.wrapper.VectorHashKeyWrapperBase;
import org.apache.hadoop.hive.ql.util.NullOrdering;

public class VectorHashKeyWrapperGeneralComparator
implements Comparator<VectorHashKeyWrapperBase>,
Serializable {
    private final VectorHashKeyWrapperBaseComparator[] comparators;

    public VectorHashKeyWrapperGeneralComparator(int numberOfColumns) {
        this.comparators = new VectorHashKeyWrapperBaseComparator[numberOfColumns];
    }

    public void addColumnComparator(int keyIndex, int columnTypeSpecificIndex, ColumnVector.Type columnVectorType, char sortOrder, char nullOrder) {
        Comparator<VectorHashKeyWrapperBase> comparator;
        switch (columnVectorType) {
            case LONG: 
            case DECIMAL_64: {
                comparator = (o1, o2) -> Long.compare(o1.getLongValue(columnTypeSpecificIndex), o2.getLongValue(columnTypeSpecificIndex));
                break;
            }
            case DOUBLE: {
                comparator = (o1, o2) -> Double.compare(o1.getDoubleValue(columnTypeSpecificIndex), o2.getDoubleValue(columnTypeSpecificIndex));
                break;
            }
            case BYTES: {
                comparator = (o1, o2) -> StringExpr.compare((byte[])o1.getBytes(columnTypeSpecificIndex), (int)o1.getByteStart(columnTypeSpecificIndex), (int)o1.getByteLength(columnTypeSpecificIndex), (byte[])o2.getBytes(columnTypeSpecificIndex), (int)o2.getByteStart(columnTypeSpecificIndex), (int)o2.getByteLength(columnTypeSpecificIndex));
                break;
            }
            case DECIMAL: {
                comparator = (o1, o2) -> o1.getDecimal(columnTypeSpecificIndex).compareTo(o2.getDecimal(columnTypeSpecificIndex));
                break;
            }
            case TIMESTAMP: {
                comparator = (o1, o2) -> o1.getTimestamp(columnTypeSpecificIndex).compareTo(o2.getTimestamp(columnTypeSpecificIndex));
                break;
            }
            case INTERVAL_DAY_TIME: {
                comparator = (o1, o2) -> o1.getIntervalDayTime(columnTypeSpecificIndex).compareTo(o2.getIntervalDayTime(columnTypeSpecificIndex));
                break;
            }
            default: {
                throw new RuntimeException("Unexpected column vector columnVectorType " + columnVectorType);
            }
        }
        this.comparators[keyIndex] = new VectorHashKeyWrapperBaseComparator(keyIndex, sortOrder == '-' ? comparator.reversed() : comparator, nullOrder);
    }

    @Override
    public int compare(VectorHashKeyWrapperBase o1, VectorHashKeyWrapperBase o2) {
        for (VectorHashKeyWrapperBaseComparator comparator : this.comparators) {
            int c = comparator.compare(o1, o2);
            if (c == 0) continue;
            return c;
        }
        return 0;
    }

    public VectorHashKeyWrapperBaseComparator[] getComparators() {
        return this.comparators;
    }

    static class VectorHashKeyWrapperBaseComparator
    implements Comparator<VectorHashKeyWrapperBase>,
    Serializable {
        private final int keyIndex;
        private final Comparator<VectorHashKeyWrapperBase> comparator;
        private final int nullResult;

        VectorHashKeyWrapperBaseComparator(int keyIndex, Comparator<VectorHashKeyWrapperBase> comparator, char nullOrder) {
            this.keyIndex = keyIndex;
            this.comparator = comparator;
            switch (NullOrdering.fromSign(nullOrder)) {
                case NULLS_FIRST: {
                    this.nullResult = 1;
                    break;
                }
                default: {
                    this.nullResult = -1;
                }
            }
        }

        @Override
        public int compare(VectorHashKeyWrapperBase o1, VectorHashKeyWrapperBase o2) {
            boolean isNull1 = o1.isNull(this.keyIndex);
            boolean isNull2 = o2.isNull(this.keyIndex);
            if (isNull1 && isNull2) {
                return 0;
            }
            if (isNull1) {
                return -this.nullResult;
            }
            if (isNull2) {
                return this.nullResult;
            }
            return this.comparator.compare(o1, o2);
        }
    }
}

