/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;

public class VectorPTFEvaluatorRank
extends VectorPTFEvaluatorBase {
    private int rank;
    private int groupCount;

    public VectorPTFEvaluatorRank(WindowFrameDef windowFrameDef, int outputColumnNum) {
        super(windowFrameDef, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
        LongColumnVector longColVector = (LongColumnVector)batch.cols[this.outputColumnNum];
        longColVector.isRepeating = true;
        longColVector.isNull[0] = false;
        longColVector.vector[0] = this.rank;
        this.groupCount += batch.size;
    }

    @Override
    public void doLastBatchWork() {
        this.rank += this.groupCount;
        this.groupCount = 0;
    }

    @Override
    public boolean streamsResult() {
        return true;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.LONG;
    }

    @Override
    public void resetEvaluator() {
        this.rank = 1;
        this.groupCount = 0;
    }
}

