/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;

public class VectorPTFEvaluatorLongAvg
extends VectorPTFEvaluatorBase {
    protected boolean isGroupResultNull;
    protected long sum;
    private int nonNullGroupCount;
    private double avg;

    public VectorPTFEvaluatorLongAvg(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState((!batch.selectedInUse ? 1 : 0) != 0);
        int size = batch.size;
        if (size == 0) {
            return;
        }
        LongColumnVector longColVector = (LongColumnVector)batch.cols[this.inputColumnNum];
        if (longColVector.isRepeating) {
            if (longColVector.noNulls || !longColVector.isNull[0]) {
                if (this.isGroupResultNull) {
                    this.sum = longColVector.vector[0] * (long)batch.size;
                    this.isGroupResultNull = false;
                } else {
                    this.sum += longColVector.vector[0] * (long)batch.size;
                }
                this.nonNullGroupCount += size;
            }
        } else if (longColVector.noNulls) {
            long[] vector = longColVector.vector;
            long varSum = vector[0];
            for (int i = 1; i < size; ++i) {
                varSum += vector[i];
            }
            this.nonNullGroupCount += size;
            if (this.isGroupResultNull) {
                this.sum = varSum;
                this.isGroupResultNull = false;
            } else {
                this.sum += varSum;
            }
        } else {
            boolean[] batchIsNull = longColVector.isNull;
            int i = 0;
            while (batchIsNull[i]) {
                if (++i < size) continue;
                return;
            }
            long[] vector = longColVector.vector;
            long varSum = vector[i++];
            ++this.nonNullGroupCount;
            while (i < size) {
                if (!batchIsNull[i]) {
                    varSum += vector[i];
                    ++this.nonNullGroupCount;
                }
                ++i;
            }
            if (this.isGroupResultNull) {
                this.sum = varSum;
                this.isGroupResultNull = false;
            } else {
                this.sum += varSum;
            }
        }
    }

    @Override
    public void doLastBatchWork() {
        if (!this.isGroupResultNull) {
            this.avg = (double)this.sum / (double)this.nonNullGroupCount;
        }
    }

    @Override
    public boolean streamsResult() {
        return false;
    }

    @Override
    public boolean isGroupResultNull() {
        return this.isGroupResultNull;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.DOUBLE;
    }

    @Override
    public double getDoubleGroupResult() {
        return this.avg;
    }

    @Override
    public void resetEvaluator() {
        this.isGroupResultNull = true;
        this.sum = 0L;
        this.nonNullGroupCount = 0;
        this.avg = 0.0;
    }
}

