/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;

public class VectorPTFEvaluatorDoubleSum
extends VectorPTFEvaluatorBase {
    protected boolean isGroupResultNull;
    protected double sum;

    public VectorPTFEvaluatorDoubleSum(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState((!batch.selectedInUse ? 1 : 0) != 0);
        int size = batch.size;
        if (size == 0) {
            return;
        }
        DoubleColumnVector doubleColVector = (DoubleColumnVector)batch.cols[this.inputColumnNum];
        if (doubleColVector.isRepeating) {
            if (doubleColVector.noNulls || !doubleColVector.isNull[0]) {
                if (this.isGroupResultNull) {
                    this.sum = doubleColVector.vector[0] * (double)batch.size;
                    this.isGroupResultNull = false;
                } else {
                    this.sum += doubleColVector.vector[0] * (double)batch.size;
                }
            }
        } else if (doubleColVector.noNulls) {
            double[] vector = doubleColVector.vector;
            double varSum = vector[0];
            for (int i = 1; i < size; ++i) {
                varSum += vector[i];
            }
            if (this.isGroupResultNull) {
                this.sum = varSum;
                this.isGroupResultNull = false;
            } else {
                this.sum += varSum;
            }
        } else {
            boolean[] batchIsNull = doubleColVector.isNull;
            int i = 0;
            while (batchIsNull[i]) {
                if (++i < size) continue;
                return;
            }
            double[] vector = doubleColVector.vector;
            double varSum = vector[i++];
            while (i < size) {
                if (!batchIsNull[i]) {
                    varSum += vector[i];
                }
                ++i;
            }
            if (this.isGroupResultNull) {
                this.sum = varSum;
                this.isGroupResultNull = false;
            } else {
                this.sum += varSum;
            }
        }
    }

    @Override
    public boolean streamsResult() {
        return false;
    }

    @Override
    public boolean isGroupResultNull() {
        return this.isGroupResultNull;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.DOUBLE;
    }

    @Override
    public double getDoubleGroupResult() {
        return this.sum;
    }

    @Override
    public void resetEvaluator() {
        this.isGroupResultNull = true;
        this.sum = 0.0;
    }
}

