/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.ptf;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.DoubleColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.ptf.VectorPTFEvaluatorBase;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ptf.WindowFrameDef;

public class VectorPTFEvaluatorDoubleFirstValue
extends VectorPTFEvaluatorBase {
    protected boolean haveFirstValue;
    protected boolean isGroupResultNull;
    protected double firstValue;

    public VectorPTFEvaluatorDoubleFirstValue(WindowFrameDef windowFrameDef, VectorExpression inputVecExpr, int outputColumnNum) {
        super(windowFrameDef, inputVecExpr, outputColumnNum);
        this.resetEvaluator();
    }

    @Override
    public void evaluateGroupBatch(VectorizedRowBatch batch) throws HiveException {
        this.evaluateInputExpr(batch);
        Preconditions.checkState((!batch.selectedInUse ? 1 : 0) != 0);
        if (!this.haveFirstValue) {
            int size = batch.size;
            if (size == 0) {
                return;
            }
            DoubleColumnVector doubleColVector = (DoubleColumnVector)batch.cols[this.inputColumnNum];
            if (doubleColVector.isRepeating) {
                if (doubleColVector.noNulls || !doubleColVector.isNull[0]) {
                    this.firstValue = doubleColVector.vector[0];
                    this.isGroupResultNull = false;
                }
            } else if (doubleColVector.noNulls) {
                this.firstValue = doubleColVector.vector[0];
                this.isGroupResultNull = false;
            } else if (!doubleColVector.isNull[0]) {
                this.firstValue = doubleColVector.vector[0];
                this.isGroupResultNull = false;
            }
            this.haveFirstValue = true;
        }
        DoubleColumnVector outputColVector = (DoubleColumnVector)batch.cols[this.outputColumnNum];
        outputColVector.isRepeating = true;
        if (this.isGroupResultNull) {
            outputColVector.noNulls = false;
            outputColVector.isNull[0] = true;
        } else {
            outputColVector.isNull[0] = false;
            outputColVector.vector[0] = this.firstValue;
        }
    }

    @Override
    public boolean streamsResult() {
        return true;
    }

    @Override
    public ColumnVector.Type getResultColumnVectorType() {
        return ColumnVector.Type.DOUBLE;
    }

    @Override
    public void resetEvaluator() {
        this.haveFirstValue = false;
        this.isGroupResultNull = true;
        this.firstValue = 0.0;
    }
}

