/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.persistence.MatchTracker;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinLongHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinNonMatchedIterator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedLongCommon;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.optimized.VectorMapJoinOptimizedNonMatchedIterator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.hive.serde2.WriteBuffers;
import org.apache.hadoop.hive.serde2.binarysortable.fast.BinarySortableDeserializeRead;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;

public class VectorMapJoinOptimizedLongHashMap
extends VectorMapJoinOptimizedHashMap
implements VectorMapJoinLongHashMap {
    private VectorMapJoinDesc.HashTableKeyType hashTableKeyType;
    private VectorMapJoinOptimizedLongCommon longCommon;

    @Override
    public boolean useMinMax() {
        return this.longCommon.useMinMax();
    }

    @Override
    public long min() {
        return this.longCommon.min();
    }

    @Override
    public long max() {
        return this.longCommon.max();
    }

    @Override
    public VectorMapJoinNonMatchedIterator createNonMatchedIterator(MatchTracker matchTracker) {
        return new NonMatchedLongHashMapIterator(matchTracker, this);
    }

    @Override
    public JoinUtil.JoinResult lookup(long key, VectorMapJoinHashMapResult hashMapResult) throws IOException {
        VectorMapJoinOptimizedHashTable.SerializedBytes serializedBytes = this.longCommon.serialize(key);
        return super.lookup(serializedBytes.bytes, serializedBytes.offset, serializedBytes.length, hashMapResult);
    }

    @Override
    public JoinUtil.JoinResult lookup(long key, VectorMapJoinHashMapResult hashMapResult, MatchTracker matchTracker) throws IOException {
        VectorMapJoinOptimizedHashTable.SerializedBytes serializedBytes = this.longCommon.serialize(key);
        return super.lookup(serializedBytes.bytes, serializedBytes.offset, serializedBytes.length, hashMapResult, matchTracker);
    }

    public VectorMapJoinOptimizedLongHashMap(boolean minMaxEnabled, boolean isOuterJoin, VectorMapJoinDesc.HashTableKeyType hashTableKeyType, MapJoinTableContainer originalTableContainer, MapJoinTableContainer.ReusableGetAdaptor hashMapRowGetter, TableDesc tableDesc) {
        super(originalTableContainer, hashMapRowGetter);
        this.hashTableKeyType = hashTableKeyType;
        this.longCommon = new VectorMapJoinOptimizedLongCommon(minMaxEnabled, isOuterJoin, hashTableKeyType, tableDesc);
    }

    private static class NonMatchedLongHashMapIterator
    extends VectorMapJoinOptimizedNonMatchedIterator {
        private VectorMapJoinOptimizedLongHashMap hashMap;
        private BinarySortableDeserializeRead keyBinarySortableDeserializeRead;
        private long longValue;

        NonMatchedLongHashMapIterator(MatchTracker matchTracker, VectorMapJoinOptimizedLongHashMap hashMap) {
            super(matchTracker);
            this.hashMap = hashMap;
        }

        @Override
        public void init() {
            PrimitiveTypeInfo integerTypeInfo;
            super.init();
            this.nonMatchedIterator = this.hashMap.originalTableContainer.createNonMatchedSmallTableIterator(this.matchTracker);
            switch (this.hashMap.hashTableKeyType) {
                case BOOLEAN: {
                    integerTypeInfo = TypeInfoFactory.booleanTypeInfo;
                    break;
                }
                case BYTE: {
                    integerTypeInfo = TypeInfoFactory.byteTypeInfo;
                    break;
                }
                case SHORT: {
                    integerTypeInfo = TypeInfoFactory.shortTypeInfo;
                    break;
                }
                case INT: {
                    integerTypeInfo = TypeInfoFactory.intTypeInfo;
                    break;
                }
                case LONG: {
                    integerTypeInfo = TypeInfoFactory.longTypeInfo;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected key type " + (Object)((Object)this.hashMap.hashTableKeyType));
                }
            }
            this.keyBinarySortableDeserializeRead = BinarySortableDeserializeRead.with((TypeInfo[])new TypeInfo[]{integerTypeInfo}, (boolean)false, (Properties)this.hashMap.longCommon.getTableDesc().getProperties());
        }

        private boolean readNonMatchedLongKey(WriteBuffers.ByteSegmentRef keyRef) throws HiveException {
            try {
                byte[] keyBytes = keyRef.getBytes();
                int keyOffset = (int)keyRef.getOffset();
                int keyLength = keyRef.getLength();
                this.keyBinarySortableDeserializeRead.set(keyBytes, keyOffset, keyLength);
                if (!this.keyBinarySortableDeserializeRead.readNextField()) {
                    return false;
                }
                switch (this.hashMap.hashTableKeyType) {
                    case BOOLEAN: {
                        this.longValue = this.keyBinarySortableDeserializeRead.currentBoolean ? 1L : 0L;
                        break;
                    }
                    case BYTE: {
                        this.longValue = this.keyBinarySortableDeserializeRead.currentByte;
                        break;
                    }
                    case SHORT: {
                        this.longValue = this.keyBinarySortableDeserializeRead.currentShort;
                        break;
                    }
                    case INT: {
                        this.longValue = this.keyBinarySortableDeserializeRead.currentInt;
                        break;
                    }
                    case LONG: {
                        this.longValue = this.keyBinarySortableDeserializeRead.currentLong;
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unexpected key type " + (Object)((Object)this.hashMap.hashTableKeyType));
                    }
                }
            }
            catch (IOException e) {
                throw new HiveException((Throwable)e);
            }
            return true;
        }

        @Override
        public boolean readNonMatchedLongKey() throws HiveException {
            return this.readNonMatchedLongKey(this.nonMatchedIterator.getCurrentKeyAsRef());
        }

        @Override
        public long getNonMatchedLongKey() throws HiveException {
            return this.longValue;
        }
    }
}

