/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashKeyRef;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashTable;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.util.JavaDataModel;
import org.apache.hadoop.hive.serde2.WriteBuffers;
import org.apache.hadoop.io.BytesWritable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VectorMapJoinFastBytesHashTable
extends VectorMapJoinFastHashTable
implements VectorMapJoinBytesHashTable {
    private static final Logger LOG = LoggerFactory.getLogger(VectorMapJoinFastBytesHashTable.class);
    protected WriteBuffers writeBuffers;
    protected WriteBuffers.Position unsafeReadPos = new WriteBuffers.Position();
    protected BytesWritable testKeyBytesWritable;
    protected long[] slots;

    @Override
    public void putRow(BytesWritable currentKey, BytesWritable currentValue) throws HiveException, IOException {
        byte[] keyBytes = currentKey.getBytes();
        int keyLength = currentKey.getLength();
        this.add(keyBytes, 0, keyLength, currentValue);
    }

    @Override
    public boolean containsLongKey(long currentKey) {
        throw new RuntimeException("Not supported yet!");
    }

    public abstract void add(byte[] var1, int var2, int var3, BytesWritable var4);

    protected void expandAndRehash() {
        if (this.logicalHashBucketCount > 0x40000000) {
            this.throwExpandError(0x40000000, "Bytes");
        }
        int newLogicalHashBucketCount = Math.max(0x100000, this.logicalHashBucketCount * 2);
        int newLogicalHashBucketMask = newLogicalHashBucketCount - 1;
        int newMetricPutConflict = 0;
        int newLargestNumberOfSteps = 0;
        long[] newSlots = new long[newLogicalHashBucketCount];
        for (int slot = 0; slot < this.logicalHashBucketCount; ++slot) {
            long refWord = this.slots[slot];
            if (refWord == 0L) continue;
            long hashCode = VectorMapJoinFastBytesHashKeyRef.calculateHashCode(refWord, this.writeBuffers, this.unsafeReadPos);
            int intHashCode = (int)hashCode;
            int newSlot = intHashCode & newLogicalHashBucketMask;
            long newProbeSlot = newSlot;
            int i = 0;
            while (newSlots[newSlot] != 0L) {
                ++newMetricPutConflict;
                newSlot = (int)((newProbeSlot += (long)(++i)) & (long)newLogicalHashBucketMask);
            }
            if (newLargestNumberOfSteps < i) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Probed " + i + " slots (the longest so far) to find space");
                }
                newLargestNumberOfSteps = i;
            }
            newSlots[newSlot] = refWord;
        }
        this.slots = newSlots;
        this.logicalHashBucketCount = newLogicalHashBucketCount;
        this.logicalHashBucketMask = newLogicalHashBucketMask;
        this.metricPutConflict = newMetricPutConflict;
        this.largestNumberOfSteps = newLargestNumberOfSteps;
        this.resizeThreshold = (int)((float)this.logicalHashBucketCount * this.loadFactor);
        ++this.metricExpands;
    }

    private void allocateBucketArray() {
        if (this.logicalHashBucketCount > 0x40000000) {
            this.throwExpandError(0x40000000, "Bytes");
        }
        this.slots = new long[this.logicalHashBucketCount];
    }

    public VectorMapJoinFastBytesHashTable(boolean isFullOuter, int initialCapacity, float loadFactor, int writeBuffersSize, long estimatedKeyCount) {
        super(isFullOuter, initialCapacity, loadFactor, writeBuffersSize, estimatedKeyCount);
        this.allocateBucketArray();
    }

    @Override
    public long getEstimatedMemorySize() {
        long size = 0L;
        size += super.getEstimatedMemorySize();
        size += this.unsafeReadPos == null ? 0L : this.unsafeReadPos.getEstimatedMemorySize();
        return size += JavaDataModel.get().lengthForLongArrayOfSize((long)this.slots.length);
    }
}

