/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.persistence.MatchTracker;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashKeyRef;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashMapStore;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastBytesHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastNonMatchedIterator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinNonMatchedIterator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.serde2.WriteBuffers;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.common.util.HashCodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VectorMapJoinFastBytesHashMap
extends VectorMapJoinFastBytesHashTable
implements VectorMapJoinBytesHashMap {
    private static final Logger LOG = LoggerFactory.getLogger(VectorMapJoinFastBytesHashMap.class);
    private VectorMapJoinFastBytesHashMapStore hashMapStore;
    protected BytesWritable testValueBytesWritable;
    private long fullOuterNullKeyRefWord = 0L;
    private static final byte[] EMPTY_BYTES = new byte[0];

    @Override
    public VectorMapJoinHashMapResult createHashMapResult() {
        return new VectorMapJoinFastBytesHashMapStore.HashMapResult();
    }

    @Override
    public VectorMapJoinNonMatchedIterator createNonMatchedIterator(MatchTracker matchTracker) {
        return new NonMatchedBytesHashMapIterator(matchTracker, this);
    }

    @Override
    public void add(byte[] keyBytes, int keyStart, int keyLength, BytesWritable currentValue) {
        boolean isNewKey;
        long refWord;
        if (this.checkResize()) {
            this.expandAndRehash();
        }
        long hashCode = HashCodeUtil.murmurHash((byte[])keyBytes, (int)keyStart, (int)keyLength);
        int intHashCode = (int)hashCode;
        int slot = intHashCode & this.logicalHashBucketMask;
        long probeSlot = slot;
        int i = 0;
        long partialHashCode = VectorMapJoinFastBytesHashKeyRef.extractPartialHashCode(hashCode);
        while (true) {
            if ((refWord = this.slots[slot]) == 0L) {
                isNewKey = true;
                break;
            }
            if (VectorMapJoinFastBytesHashKeyRef.getPartialHashCodeFromRefWord(refWord) == partialHashCode && VectorMapJoinFastBytesHashKeyRef.equalKey(refWord, keyBytes, keyStart, keyLength, this.writeBuffers, this.unsafeReadPos)) {
                isNewKey = false;
                break;
            }
            ++this.metricPutConflict;
            slot = (int)((probeSlot += (long)(++i)) & (long)this.logicalHashBucketMask);
        }
        if (this.largestNumberOfSteps < i) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Probed " + i + " slots (the longest so far) to find space");
            }
            this.largestNumberOfSteps = i;
        }
        byte[] valueBytes = currentValue.getBytes();
        int valueLength = currentValue.getLength();
        if (isNewKey) {
            this.slots[slot] = this.hashMapStore.addFirst(partialHashCode, keyBytes, keyStart, keyLength, valueBytes, 0, valueLength);
            ++this.keysAssigned;
        } else {
            long newRefWord = this.hashMapStore.addMore(refWord, valueBytes, 0, valueLength, this.unsafeReadPos);
            if (newRefWord != refWord) {
                this.slots[slot] = newRefWord;
            }
        }
    }

    @Override
    public JoinUtil.JoinResult lookup(byte[] keyBytes, int keyStart, int keyLength, VectorMapJoinHashMapResult hashMapResult) {
        VectorMapJoinFastBytesHashMapStore.HashMapResult fastHashMapResult = (VectorMapJoinFastBytesHashMapStore.HashMapResult)hashMapResult;
        fastHashMapResult.forget();
        long hashCode = HashCodeUtil.murmurHash((byte[])keyBytes, (int)keyStart, (int)keyLength);
        this.doHashMapMatch(keyBytes, keyStart, keyLength, hashCode, fastHashMapResult);
        return fastHashMapResult.joinResult();
    }

    @Override
    public JoinUtil.JoinResult lookup(byte[] keyBytes, int keyStart, int keyLength, VectorMapJoinHashMapResult hashMapResult, MatchTracker matchTracker) {
        VectorMapJoinFastBytesHashMapStore.HashMapResult fastHashMapResult = (VectorMapJoinFastBytesHashMapStore.HashMapResult)hashMapResult;
        fastHashMapResult.forget();
        long hashCode = HashCodeUtil.murmurHash((byte[])keyBytes, (int)keyStart, (int)keyLength);
        int slot = this.doHashMapMatch(keyBytes, keyStart, keyLength, hashCode, fastHashMapResult);
        if (slot != -1 && matchTracker != null) {
            matchTracker.trackMatch(slot);
        }
        return fastHashMapResult.joinResult();
    }

    protected final int doHashMapMatch(byte[] keyBytes, int keyStart, int keyLength, long hashCode, VectorMapJoinFastBytesHashMapStore.HashMapResult fastHashMapResult) {
        int intHashCode = (int)hashCode;
        int slot = intHashCode & this.logicalHashBucketMask;
        long probeSlot = slot;
        int i = 0;
        long partialHashCode = VectorMapJoinFastBytesHashKeyRef.extractPartialHashCode(hashCode);
        long refWord;
        while ((refWord = this.slots[slot]) != 0L) {
            if (VectorMapJoinFastBytesHashKeyRef.getPartialHashCodeFromRefWord(refWord) == partialHashCode) {
                fastHashMapResult.setKey(this.hashMapStore, refWord);
                if (fastHashMapResult.equalKey(keyBytes, keyStart, keyLength)) {
                    fastHashMapResult.setMatch();
                    return slot;
                }
            }
            probeSlot += (long)(++i);
            if (i > this.largestNumberOfSteps) {
                return -1;
            }
            slot = (int)(probeSlot & (long)this.logicalHashBucketMask);
        }
        return -1;
    }

    public void addFullOuterNullKeyValue(BytesWritable currentValue) {
        byte[] valueBytes = currentValue.getBytes();
        int valueLength = currentValue.getLength();
        this.fullOuterNullKeyRefWord = this.fullOuterNullKeyRefWord == 0L ? this.hashMapStore.addFirst(0L, EMPTY_BYTES, 0, 0, valueBytes, 0, valueLength) : this.hashMapStore.addMore(this.fullOuterNullKeyRefWord, valueBytes, 0, valueLength, this.unsafeReadPos);
    }

    public VectorMapJoinFastBytesHashMap(boolean isFullOuter, int initialCapacity, float loadFactor, int writeBuffersSize, long estimatedKeyCount) {
        super(isFullOuter, initialCapacity, loadFactor, writeBuffersSize, estimatedKeyCount);
        this.hashMapStore = new VectorMapJoinFastBytesHashMapStore(writeBuffersSize);
        this.writeBuffers = this.hashMapStore.getWriteBuffers();
    }

    @Override
    public long getEstimatedMemorySize() {
        long size = super.getEstimatedMemorySize();
        return size += this.hashMapStore.getEstimatedMemorySize();
    }

    private static class NonMatchedBytesHashMapIterator
    extends VectorMapJoinFastNonMatchedIterator {
        private VectorMapJoinFastBytesHashMap hashMap;
        private boolean noMore;
        private boolean keyIsNull;
        private WriteBuffers.Position nonMatchedReadPos;
        private WriteBuffers.ByteSegmentRef nonMatchedKeyByteSegmentRef;
        private VectorMapJoinFastBytesHashMapStore.HashMapResult nonMatchedHashMapResult;

        NonMatchedBytesHashMapIterator(MatchTracker matchTracker, VectorMapJoinFastBytesHashMap hashMap) {
            super(matchTracker);
            this.hashMap = hashMap;
        }

        @Override
        public void init() {
            super.init();
            this.noMore = false;
            this.keyIsNull = false;
            this.nonMatchedReadPos = new WriteBuffers.Position();
            this.nonMatchedKeyByteSegmentRef = new WriteBuffers.ByteSegmentRef();
            this.nonMatchedHashMapResult = new VectorMapJoinFastBytesHashMapStore.HashMapResult();
        }

        @Override
        public boolean findNextNonMatched() {
            block3: {
                long refWord;
                if (this.noMore) {
                    return false;
                }
                do {
                    ++this.nonMatchedLogicalSlotNum;
                    if (this.nonMatchedLogicalSlotNum >= this.hashMap.logicalHashBucketCount) break block3;
                } while ((refWord = this.hashMap.slots[this.nonMatchedLogicalSlotNum]) == 0L || this.matchTracker.wasMatched(this.nonMatchedLogicalSlotNum));
                this.nonMatchedHashMapResult.set(this.hashMap.hashMapStore, refWord);
                this.keyIsNull = false;
                return true;
            }
            if (this.hashMap.fullOuterNullKeyRefWord == 0L) {
                return false;
            }
            this.nonMatchedHashMapResult.set(this.hashMap.hashMapStore, this.hashMap.fullOuterNullKeyRefWord);
            this.noMore = true;
            this.keyIsNull = true;
            return true;
        }

        @Override
        public boolean readNonMatchedBytesKey() throws HiveException {
            if (this.keyIsNull) {
                return false;
            }
            this.hashMap.hashMapStore.getKey(this.hashMap.slots[this.nonMatchedLogicalSlotNum], this.nonMatchedKeyByteSegmentRef, this.nonMatchedReadPos);
            return true;
        }

        @Override
        public byte[] getNonMatchedBytes() {
            return this.nonMatchedKeyByteSegmentRef.getBytes();
        }

        @Override
        public int getNonMatchedBytesOffset() {
            return (int)this.nonMatchedKeyByteSegmentRef.getOffset();
        }

        @Override
        public int getNonMatchedBytesLength() {
            return this.nonMatchedKeyByteSegmentRef.getLength();
        }

        @Override
        public VectorMapJoinHashMapResult getNonMatchedHashMapResult() {
            return this.nonMatchedHashMapResult;
        }
    }
}

