/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin;

import java.io.IOException;
import org.apache.hadoop.hive.ql.CompilationOpContext;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.persistence.MapJoinTableContainer;
import org.apache.hadoop.hive.ql.exec.vector.BytesColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.ColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.LongColumnVector;
import org.apache.hadoop.hive.ql.exec.vector.VectorizationContext;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.VectorMapJoinGenerateResultOperator;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinBytesHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMapResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinLongHashMap;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinNonMatchedIterator;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.OperatorDesc;
import org.apache.hadoop.hive.ql.plan.VectorDesc;
import org.apache.hadoop.hive.serde2.WriteBuffers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VectorMapJoinOuterGenerateResultOperator
extends VectorMapJoinGenerateResultOperator {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger((String)VectorMapJoinOuterGenerateResultOperator.class.getName());
    protected transient VectorMapJoinHashMapResult[] hashMapResults;
    protected transient int[] inputSelected;
    protected transient int[] allMatchs;
    protected transient int[] equalKeySeriesHashMapResultIndices;
    protected transient int[] equalKeySeriesAllMatchIndices;
    protected transient boolean[] equalKeySeriesIsSingleValue;
    protected transient int[] equalKeySeriesDuplicateCounts;
    protected transient int[] spills;
    protected transient int[] spillHashMapResultIndices;
    protected transient int[] nonSpills;
    protected transient int[] noMatchs;
    protected transient int[] merged;

    protected VectorMapJoinOuterGenerateResultOperator() {
    }

    public VectorMapJoinOuterGenerateResultOperator(CompilationOpContext ctx) {
        super(ctx);
    }

    public VectorMapJoinOuterGenerateResultOperator(CompilationOpContext ctx, OperatorDesc conf, VectorizationContext vContext, VectorDesc vectorDesc) throws HiveException {
        super(ctx, conf, vContext, vectorDesc);
    }

    @Override
    protected void commonSetup() throws HiveException {
        super.commonSetup();
        VectorMapJoinHashMap baseHashMap = (VectorMapJoinHashMap)this.vectorMapJoinHashTable;
        this.hashMapResults = new VectorMapJoinHashMapResult[1024];
        for (int i = 0; i < this.hashMapResults.length; ++i) {
            this.hashMapResults[i] = baseHashMap.createHashMapResult();
        }
        this.inputSelected = new int[1024];
        this.allMatchs = new int[1024];
        this.equalKeySeriesHashMapResultIndices = new int[1024];
        this.equalKeySeriesAllMatchIndices = new int[1024];
        this.equalKeySeriesIsSingleValue = new boolean[1024];
        this.equalKeySeriesDuplicateCounts = new int[1024];
        this.spills = new int[1024];
        this.spillHashMapResultIndices = new int[1024];
        this.nonSpills = new int[1024];
        this.noMatchs = new int[1024];
        this.merged = new int[1024];
        this.matchTracker = null;
    }

    protected void outerPerBatchSetup(VectorizedRowBatch batch) {
        for (int column : this.outerSmallTableKeyColumnMap) {
            ColumnVector bigTableOuterKeyColumn = batch.cols[column];
            bigTableOuterKeyColumn.reset();
        }
        for (int column : this.smallTableValueColumnMap) {
            ColumnVector smallTableColumn = batch.cols[column];
            smallTableColumn.reset();
        }
    }

    private void doValueExprOnInputSelected(VectorizedRowBatch batch, boolean inputSelectedInUse, int inputLogicalSize) throws HiveException {
        int saveBatchSize = batch.size;
        int[] saveSelected = batch.selected;
        boolean saveSelectedInUse = batch.selectedInUse;
        batch.size = inputLogicalSize;
        batch.selected = this.inputSelected;
        batch.selectedInUse = inputSelectedInUse;
        if (this.bigTableValueExpressions != null) {
            for (VectorExpression ve : this.bigTableValueExpressions) {
                ve.evaluate(batch);
            }
        }
        batch.size = saveBatchSize;
        batch.selected = saveSelected;
        batch.selectedInUse = saveSelectedInUse;
    }

    private void doValueExpr(VectorizedRowBatch batch, int[] selected, int size) throws HiveException {
        int saveBatchSize = batch.size;
        int[] saveSelected = batch.selected;
        boolean saveSelectedInUse = batch.selectedInUse;
        batch.size = size;
        batch.selected = selected;
        batch.selectedInUse = true;
        if (this.bigTableValueExpressions != null) {
            for (VectorExpression ve : this.bigTableValueExpressions) {
                ve.evaluate(batch);
            }
        }
        batch.size = saveBatchSize;
        batch.selected = saveSelected;
        batch.selectedInUse = saveSelectedInUse;
    }

    private int subtractFromInputSelected(boolean inputSelectedInUse, int inputLogicalSize, int[] remove, int removeSize, int[] difference) throws HiveException {
        int differenceCount = 0;
        int removeIndex = 0;
        if (inputSelectedInUse) {
            for (int i = 0; i < inputLogicalSize; ++i) {
                int candidateIndex = this.inputSelected[i];
                if (removeIndex < removeSize && candidateIndex == remove[removeIndex]) {
                    ++removeIndex;
                    continue;
                }
                difference[differenceCount++] = candidateIndex;
            }
        } else {
            for (int candidateIndex = 0; candidateIndex < inputLogicalSize; ++candidateIndex) {
                if (removeIndex < removeSize && candidateIndex == remove[removeIndex]) {
                    ++removeIndex;
                    continue;
                }
                difference[differenceCount++] = candidateIndex;
            }
        }
        if (removeIndex != removeSize) {
            throw new HiveException("Not all batch indices removed");
        }
        return differenceCount;
    }

    private int subtract(int[] all, int allSize, int[] remove, int removeSize, int[] difference) throws HiveException {
        int differenceCount = 0;
        int removeIndex = 0;
        for (int i = 0; i < allSize; ++i) {
            int candidateIndex = all[i];
            if (removeIndex < removeSize && candidateIndex == remove[removeIndex]) {
                ++removeIndex;
                continue;
            }
            difference[differenceCount++] = candidateIndex;
        }
        if (removeIndex != removeSize) {
            throw new HiveException("Not all batch indices removed");
        }
        return differenceCount;
    }

    private int sortMerge(int[] selected1, int selected1Count, int[] selected2, int selected2Count, int[] sortMerged) throws HiveException {
        int sortMergeCount = 0;
        int selected1Index = 0;
        int selected2Index = 0;
        for (int i = 0; i < selected1Count + selected2Count; ++i) {
            if (selected1Index < selected1Count && selected2Index < selected2Count) {
                if (selected1[selected1Index] < selected2[selected2Index]) {
                    sortMerged[sortMergeCount++] = selected1[selected1Index++];
                    continue;
                }
                sortMerged[sortMergeCount++] = selected2[selected2Index++];
                continue;
            }
            sortMerged[sortMergeCount++] = selected1Index < selected1Count ? selected1[selected1Index++] : selected2[selected2Index++];
        }
        return sortMergeCount;
    }

    public void finishOuter(VectorizedRowBatch batch, int allMatchCount, int equalKeySeriesCount, boolean atLeastOneNonMatch, boolean inputSelectedInUse, int inputLogicalSize, int spillCount, int hashMapResultCount) throws IOException, HiveException {
        if (spillCount > 0) {
            this.spillHashMapBatch(batch, this.hashMapResults, this.spills, this.spillHashMapResultIndices, spillCount);
        }
        int noMatchCount = 0;
        if (spillCount > 0) {
            int nonSpillCount = this.subtractFromInputSelected(inputSelectedInUse, inputLogicalSize, this.spills, spillCount, this.nonSpills);
            if (LOG.isDebugEnabled()) {
                LOG.debug("finishOuter spillCount > 0 nonSpills " + VectorMapJoinOuterGenerateResultOperator.intArrayToRangesString(this.nonSpills, nonSpillCount));
            }
            if (this.bigTableValueExpressions != null) {
                this.doValueExpr(batch, this.nonSpills, nonSpillCount);
            }
            if (atLeastOneNonMatch) {
                noMatchCount = this.subtract(this.nonSpills, nonSpillCount, this.allMatchs, allMatchCount, this.noMatchs);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("finishOuter spillCount > 0 noMatchs " + VectorMapJoinOuterGenerateResultOperator.intArrayToRangesString(this.noMatchs, noMatchCount));
                }
            }
        } else {
            this.doValueExprOnInputSelected(batch, inputSelectedInUse, inputLogicalSize);
            if (atLeastOneNonMatch) {
                noMatchCount = this.subtractFromInputSelected(inputSelectedInUse, inputLogicalSize, this.allMatchs, allMatchCount, this.noMatchs);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("finishOuter spillCount == 0 noMatchs " + VectorMapJoinOuterGenerateResultOperator.intArrayToRangesString(this.noMatchs, noMatchCount));
                }
            }
        }
        if (allMatchCount > 0) {
            int numSel = 0;
            for (int i = 0; i < equalKeySeriesCount; ++i) {
                int hashMapResultIndex = this.equalKeySeriesHashMapResultIndices[i];
                VectorMapJoinHashMapResult hashMapResult = this.hashMapResults[hashMapResultIndex];
                int allMatchesIndex = this.equalKeySeriesAllMatchIndices[i];
                boolean isSingleValue = this.equalKeySeriesIsSingleValue[i];
                int duplicateCount = this.equalKeySeriesDuplicateCounts[i];
                if (isSingleValue) {
                    numSel = this.generateHashMapResultSingleValue(batch, hashMapResult, this.allMatchs, allMatchesIndex, duplicateCount, numSel);
                    continue;
                }
                this.generateHashMapResultMultiValue(batch, hashMapResult, this.allMatchs, allMatchesIndex, duplicateCount);
            }
            batch.size = numSel;
            batch.selectedInUse = true;
            if (LOG.isDebugEnabled()) {
                LOG.debug("finishOuter allMatchCount > 0 batch.selected " + VectorMapJoinOuterGenerateResultOperator.intArrayToRangesString(batch.selected, batch.size));
            }
        } else {
            batch.size = 0;
        }
        if (noMatchCount > 0) {
            if (batch.size > 0) {
                this.generateOuterNulls(batch, this.noMatchs, noMatchCount);
                int mergeCount = this.sortMerge(this.noMatchs, noMatchCount, batch.selected, batch.size, this.merged);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("finishOuter noMatchCount > 0 && batch.size > 0 merged " + VectorMapJoinOuterGenerateResultOperator.intArrayToRangesString(this.merged, mergeCount));
                }
                System.arraycopy(this.merged, 0, batch.selected, 0, mergeCount);
                batch.size = mergeCount;
                batch.selectedInUse = true;
            } else {
                this.generateOuterNullsRepeatedAll(batch);
                System.arraycopy(this.noMatchs, 0, batch.selected, 0, noMatchCount);
                batch.size = noMatchCount;
                batch.selectedInUse = true;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("finishOuter noMatchCount > 0 && batch.size == 0 batch.selected " + VectorMapJoinOuterGenerateResultOperator.intArrayToRangesString(batch.selected, batch.size));
                }
            }
        }
    }

    protected void generateOuterNulls(VectorizedRowBatch batch, int[] noMatchs, int noMatchSize) throws IOException, HiveException {
        for (int i = 0; i < noMatchSize; ++i) {
            ColumnVector colVector;
            int batchIndex = noMatchs[i];
            for (int column : this.outerSmallTableKeyColumnMap) {
                colVector = batch.cols[column];
                colVector.noNulls = false;
                colVector.isNull[batchIndex] = true;
            }
            for (int column : this.smallTableValueColumnMap) {
                colVector = batch.cols[column];
                colVector.noNulls = false;
                colVector.isNull[batchIndex] = true;
            }
        }
    }

    public void finishOuterRepeated(VectorizedRowBatch batch, JoinUtil.JoinResult joinResult, VectorMapJoinHashMapResult hashMapResult, boolean someRowsFilteredOut, boolean inputSelectedInUse, int inputLogicalSize) throws IOException, HiveException {
        switch (joinResult) {
            case MATCH: {
                if (someRowsFilteredOut) {
                    this.doValueExprOnInputSelected(batch, inputSelectedInUse, inputLogicalSize);
                    int noMatchCount = this.subtractFromInputSelected(inputSelectedInUse, inputLogicalSize, batch.selected, batch.size, this.noMatchs);
                    this.generateOuterNulls(batch, this.noMatchs, noMatchCount);
                    this.generateHashMapResultRepeatedAll(batch, hashMapResult);
                    int mergeCount = this.sortMerge(this.noMatchs, noMatchCount, batch.selected, batch.size, this.merged);
                    System.arraycopy(this.merged, 0, batch.selected, 0, mergeCount);
                    batch.size = mergeCount;
                    batch.selectedInUse = true;
                    break;
                }
                if (this.bigTableValueExpressions != null) {
                    for (VectorExpression ve : this.bigTableValueExpressions) {
                        ve.evaluate(batch);
                    }
                }
                this.generateHashMapResultRepeatedAll(batch, hashMapResult);
                break;
            }
            case SPILL: {
                this.spillBatchRepeated(batch, hashMapResult);
                if (someRowsFilteredOut) {
                    int noMatchCount = this.subtractFromInputSelected(inputSelectedInUse, inputLogicalSize, batch.selected, batch.size, this.noMatchs);
                    System.arraycopy(this.noMatchs, 0, batch.selected, 0, noMatchCount);
                    batch.size = noMatchCount;
                    batch.selectedInUse = true;
                    this.generateOuterNullsRepeatedAll(batch);
                    break;
                }
                batch.size = 0;
                break;
            }
            case NOMATCH: {
                if (someRowsFilteredOut) {
                    if (inputSelectedInUse) {
                        System.arraycopy(this.inputSelected, 0, batch.selected, 0, inputLogicalSize);
                    }
                    batch.selectedInUse = inputSelectedInUse;
                    batch.size = inputLogicalSize;
                }
                if (this.bigTableValueExpressions != null) {
                    for (VectorExpression ve : this.bigTableValueExpressions) {
                        ve.evaluate(batch);
                    }
                }
                this.generateOuterNullsRepeatedAll(batch);
            }
        }
    }

    protected void generateOuterNullsRepeatedAll(VectorizedRowBatch batch) throws HiveException {
        ColumnVector colVector;
        for (int column : this.outerSmallTableKeyColumnMap) {
            colVector = batch.cols[column];
            colVector.noNulls = false;
            colVector.isNull[0] = true;
            colVector.isRepeating = true;
        }
        for (int column : this.smallTableValueColumnMap) {
            colVector = batch.cols[column];
            colVector.noNulls = false;
            colVector.isNull[0] = true;
            colVector.isRepeating = true;
        }
    }

    private void markBigTableColumnsAsNullRepeating() {
        for (int column : this.bigTableRetainColumnMap) {
            ColumnVector colVector = this.overflowBatch.cols[column];
            colVector.isRepeating = true;
            colVector.noNulls = false;
            colVector.isNull[0] = true;
        }
    }

    @Override
    protected void generateFullOuterSmallTableNoMatches(byte smallTablePos, MapJoinTableContainer substituteSmallTable) throws HiveException {
        if (this.needCommonSetup) {
            this.commonSetup();
            this.needCommonSetup = false;
        }
        if (this.needHashTableSetup) {
            this.hashTableSetup();
            this.needHashTableSetup = false;
        }
        if (this.overflowBatch.size > 0) {
            this.forwardOverflow();
        }
        this.markBigTableColumnsAsNullRepeating();
        switch (this.hashTableKeyType) {
            case BOOLEAN: 
            case BYTE: 
            case SHORT: 
            case INT: 
            case LONG: {
                this.generateFullOuterLongKeySmallTableNoMatches();
                break;
            }
            case STRING: {
                this.generateFullOuterStringKeySmallTableNoMatches();
                break;
            }
            case MULTI_KEY: {
                this.generateFullOuterMultiKeySmallTableNoMatches();
                break;
            }
            default: {
                throw new RuntimeException("Unexpected hash table key type " + (Object)((Object)this.hashTableKeyType));
            }
        }
    }

    protected void generateFullOuterLongKeySmallTableNoMatches() throws HiveException {
        LongColumnVector singleSmallTableKeyOutputColumnVector = this.allSmallTableKeyColumnIncluded[0] ? (LongColumnVector)this.overflowBatch.cols[this.allSmallTableKeyColumnNums[0]] : null;
        VectorMapJoinLongHashMap hashMap = (VectorMapJoinLongHashMap)this.vectorMapJoinHashTable;
        VectorMapJoinNonMatchedIterator nonMatchedIterator = hashMap.createNonMatchedIterator(this.matchTracker);
        nonMatchedIterator.init();
        while (nonMatchedIterator.findNextNonMatched()) {
            boolean isKeyNull = !nonMatchedIterator.readNonMatchedLongKey();
            long longKey = !isKeyNull ? nonMatchedIterator.getNonMatchedLongKey() : 0L;
            VectorMapJoinHashMapResult hashMapResult = nonMatchedIterator.getNonMatchedHashMapResult();
            WriteBuffers.ByteSegmentRef byteSegmentRef = hashMapResult.first();
            while (byteSegmentRef != null) {
                if (singleSmallTableKeyOutputColumnVector != null) {
                    if (isKeyNull) {
                        singleSmallTableKeyOutputColumnVector.isNull[this.overflowBatch.size] = true;
                        singleSmallTableKeyOutputColumnVector.noNulls = false;
                    } else {
                        singleSmallTableKeyOutputColumnVector.vector[this.overflowBatch.size] = longKey;
                        singleSmallTableKeyOutputColumnVector.isNull[this.overflowBatch.size] = false;
                    }
                }
                if (this.smallTableValueVectorDeserializeRow != null) {
                    this.doSmallTableValueDeserializeRow(this.overflowBatch, this.overflowBatch.size, byteSegmentRef, hashMapResult);
                }
                ++this.overflowBatch.size;
                if (this.overflowBatch.size == 1024) {
                    this.forwardOverflow();
                    this.markBigTableColumnsAsNullRepeating();
                }
                byteSegmentRef = hashMapResult.next();
            }
        }
    }

    private void doSmallTableKeyDeserializeRow(VectorizedRowBatch batch, int batchIndex, byte[] keyBytes, int keyOffset, int keyLength) throws HiveException {
        this.smallTableKeyOuterVectorDeserializeRow.setBytes(keyBytes, keyOffset, keyLength);
        try {
            this.smallTableKeyOuterVectorDeserializeRow.deserializeByRef(batch, batchIndex);
        }
        catch (Exception e) {
            throw new HiveException("\nDeserializeRead detail: " + this.smallTableKeyOuterVectorDeserializeRow.getDetailedReadPositionString(), (Throwable)e);
        }
    }

    protected void generateFullOuterMultiKeySmallTableNoMatches() throws HiveException {
        VectorMapJoinBytesHashMap hashMap = (VectorMapJoinBytesHashMap)this.vectorMapJoinHashTable;
        VectorMapJoinNonMatchedIterator nonMatchedIterator = hashMap.createNonMatchedIterator(this.matchTracker);
        nonMatchedIterator.init();
        while (nonMatchedIterator.findNextNonMatched()) {
            nonMatchedIterator.readNonMatchedBytesKey();
            byte[] keyBytes = nonMatchedIterator.getNonMatchedBytes();
            int keyOffset = nonMatchedIterator.getNonMatchedBytesOffset();
            int keyLength = nonMatchedIterator.getNonMatchedBytesLength();
            VectorMapJoinHashMapResult hashMapResult = nonMatchedIterator.getNonMatchedHashMapResult();
            WriteBuffers.ByteSegmentRef byteSegmentRef = hashMapResult.first();
            while (byteSegmentRef != null) {
                if (this.smallTableKeyOuterVectorDeserializeRow != null) {
                    this.doSmallTableKeyDeserializeRow(this.overflowBatch, this.overflowBatch.size, keyBytes, keyOffset, keyLength);
                }
                if (this.smallTableValueVectorDeserializeRow != null) {
                    this.doSmallTableValueDeserializeRow(this.overflowBatch, this.overflowBatch.size, byteSegmentRef, hashMapResult);
                }
                ++this.overflowBatch.size;
                if (this.overflowBatch.size == 1024) {
                    this.forwardOverflow();
                    this.markBigTableColumnsAsNullRepeating();
                }
                byteSegmentRef = hashMapResult.next();
            }
        }
    }

    protected void generateFullOuterStringKeySmallTableNoMatches() throws HiveException {
        BytesColumnVector singleSmallTableKeyOutputColumnVector = this.allSmallTableKeyColumnIncluded[0] ? (BytesColumnVector)this.overflowBatch.cols[this.allSmallTableKeyColumnNums[0]] : null;
        VectorMapJoinBytesHashMap hashMap = (VectorMapJoinBytesHashMap)this.vectorMapJoinHashTable;
        VectorMapJoinNonMatchedIterator nonMatchedIterator = hashMap.createNonMatchedIterator(this.matchTracker);
        nonMatchedIterator.init();
        while (nonMatchedIterator.findNextNonMatched()) {
            int keyLength;
            int keyOffset;
            byte[] keyBytes;
            boolean isKeyNull;
            boolean bl = isKeyNull = !nonMatchedIterator.readNonMatchedBytesKey();
            if (!isKeyNull) {
                keyBytes = nonMatchedIterator.getNonMatchedBytes();
                keyOffset = nonMatchedIterator.getNonMatchedBytesOffset();
                keyLength = nonMatchedIterator.getNonMatchedBytesLength();
            } else {
                keyBytes = null;
                keyOffset = 0;
                keyLength = 0;
            }
            VectorMapJoinHashMapResult hashMapResult = nonMatchedIterator.getNonMatchedHashMapResult();
            WriteBuffers.ByteSegmentRef byteSegmentRef = hashMapResult.first();
            while (byteSegmentRef != null) {
                if (singleSmallTableKeyOutputColumnVector != null) {
                    if (isKeyNull) {
                        singleSmallTableKeyOutputColumnVector.isNull[this.overflowBatch.size] = true;
                        singleSmallTableKeyOutputColumnVector.noNulls = false;
                    } else {
                        singleSmallTableKeyOutputColumnVector.setVal(this.overflowBatch.size, keyBytes, keyOffset, keyLength);
                        singleSmallTableKeyOutputColumnVector.isNull[this.overflowBatch.size] = false;
                    }
                }
                if (this.smallTableValueVectorDeserializeRow != null) {
                    this.doSmallTableValueDeserializeRow(this.overflowBatch, this.overflowBatch.size, byteSegmentRef, hashMapResult);
                }
                ++this.overflowBatch.size;
                if (this.overflowBatch.size == 1024) {
                    this.forwardOverflow();
                    this.markBigTableColumnsAsNullRepeating();
                }
                byteSegmentRef = hashMapResult.next();
            }
        }
    }

    protected void fullOuterHashTableSetup() {
        this.matchTracker = this.vectorMapJoinHashTable.createMatchTracker();
    }

    protected void fullOuterIntersectHashTableSetup() {
        this.matchTracker = this.vectorMapJoinHashTable.createMatchTracker();
    }
}

